/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.io.FileNotFoundException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.maven.internal.IMapEntry;
import org.eclipse.buckminster.maven.internal.LocalCache;
import org.eclipse.buckminster.maven.internal.Maven2ReaderType;
import org.eclipse.buckminster.maven.internal.MavenComponentType;
import org.eclipse.buckminster.maven.internal.MavenReaderType;
import org.eclipse.buckminster.maven.internal.MavenVersionFinder;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.w3c.dom.Document;

public class Maven2VersionFinder
extends MavenVersionFinder {
    public static IPath getDefaultLocalRepoPath() {
        return new Path(System.getProperty("user.home")).append(".m2").append("repository");
    }

    public Maven2VersionFinder(MavenReaderType readerType, Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(readerType, provider, ctype, query);
    }

    @Override
    List<VersionMatch> getComponentVersions(IProgressMonitor monitor) throws CoreException {
        NodeQuery query = this.getQuery();
        VersionRange range = query.getVersionRange();
        if (range != null && range.getFormat().equals(VersionHelper.getOSGiFormat())) {
            range = VersionHelper.createRange((IVersionFormat)MavenComponentType.getTripletFormat(), (String)range.toString());
        }
        ArrayList<VersionMatch> versions = new ArrayList<VersionMatch>();
        Maven2ReaderType readerType = (Maven2ReaderType)this.getReaderType();
        IMapEntry mapEntry = this.getMapEntry();
        URI uri = this.getURI();
        StringBuilder pbld = new StringBuilder();
        readerType.appendFolder(pbld, uri.getPath());
        readerType.appendEntryFolder(pbld, this.getMapEntry());
        String rootPath = pbld.toString();
        LocalCache lc = this.getReaderType().getLocalCache();
        monitor.beginTask(null, 2000);
        try {
            DocumentBuilder docBld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = Maven2ReaderType.getMetadataDocument(docBld, MavenReaderType.createURL(uri, String.valueOf(rootPath) + "maven-metadata.xml"), lc, this.getConnectContext(), monitor);
            for (String versionStr : Maven2ReaderType.getVersions(doc)) {
                VersionMatch vm = readerType.createVersionMatch(docBld, this, mapEntry, range, versionStr);
                if (vm == null) continue;
                versions.add(vm);
            }
            ArrayList<VersionMatch> arrayList = versions;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }
}

