/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.ILogReceiver;
import org.eclipse.buckminster.runtime.MultiTeeOutputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class Logger {
    public static final int SILENT = 8;
    public static final int DEBUG = 0;
    public static final int ERROR = 4;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    private static final int MAGIC = 293;
    private static Logger defaultLogger;
    private static int consoleThreshold;
    private static int eclipseLoggerThreshold;
    private static ILogListener eclipseLogListener;
    private static PrintStream errStream;
    private static PrintStream outStream;
    private final ILog log;
    public static final String BUILDER_LOG_RECEIVER_POINT = "org.eclipse.buckminster.runtime.logReceivers";

    static {
        consoleThreshold = 1;
        eclipseLoggerThreshold = 2;
        Logger.setOutStream(Logger.getLoggerStream(false));
        Logger.setErrStream(Logger.getLoggerStream(true));
    }

    public static Logger getDefault() {
        return defaultLogger;
    }

    public static PrintStream getErrStream() {
        return errStream;
    }

    public static PrintStream getOutStream() {
        return outStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStatus(IStatus status, PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            Logger.printStatus(status, out, 0);
            out.flush();
        }
    }

    public static void setConsoleLevelThreshold(int threshold) {
        consoleThreshold = threshold;
    }

    public static void setEclipseLoggerLevelThreshold(int threshold) {
        eclipseLoggerThreshold = threshold;
    }

    public static synchronized void setEclipseLoggerToConsole(boolean flag) {
        if (flag) {
            if (eclipseLogListener == null) {
                eclipseLogListener = new EclipseLogListener();
                Platform.addLogListener((ILogListener)eclipseLogListener);
            }
        } else if (eclipseLogListener != null) {
            Platform.removeLogListener((ILogListener)eclipseLogListener);
            eclipseLogListener = null;
        }
    }

    public static void setErrStream(PrintStream err) {
        errStream = err;
    }

    public static void setOutStream(PrintStream out) {
        outStream = out;
    }

    static void setDefaultLogger(Bundle bundle) {
        defaultLogger = new Logger(bundle);
    }

    private static PrintStream getLoggerStream(boolean errorStream) {
        PrintStream sysStream;
        PrintStream printStream = sysStream = errorStream ? System.err : System.out;
        if (Buckminster.isHeadless()) {
            return sysStream;
        }
        IExtensionRegistry ier = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = ier.getConfigurationElementsFor(BUILDER_LOG_RECEIVER_POINT);
        int idx = elems.length;
        if (idx == 0) {
            return sysStream;
        }
        try {
            OutputStream[] streams = new OutputStream[idx + 1];
            streams[idx] = sysStream;
            while (--idx >= 0) {
                ILogReceiver receiver = (ILogReceiver)elems[idx].createExecutableExtension("class");
                streams[idx] = receiver.start("Buckminster log", "org.eclipse.ui.MessageConsole", true, errorStream);
            }
            return new PrintStream(new MultiTeeOutputStream(streams), true);
        }
        catch (Exception t) {
            return sysStream;
        }
    }

    private static void printStatus(IStatus status, PrintStream out, int indent) {
        boolean hasSeverityPrefix = false;
        String msg = status.getMessage();
        if (msg != null) {
            hasSeverityPrefix = msg.startsWith("ERROR") || msg.startsWith("WARN") || msg.startsWith("INFO");
        }
        int idx = 0;
        while (idx < indent) {
            out.print(' ');
            ++idx;
        }
        if (!hasSeverityPrefix) {
            switch (status.getSeverity()) {
                case 8: {
                    return;
                }
                case 4: {
                    out.print("ERROR: ");
                    break;
                }
                case 1: {
                    out.print("INFO:  ");
                    break;
                }
                case 2: {
                    out.print("WARN:  ");
                }
            }
        }
        out.println(msg);
        Throwable t = status.getException();
        if (t != null) {
            t.printStackTrace(out);
        }
        indent += 2;
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            Logger.printStatus(child, out, indent);
            ++n2;
        }
    }

    public Logger(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("The bundle for a logger cannot be null");
        }
        this.log = Platform.getLog((Bundle)bundle);
    }

    public Logger(ILog log) {
        this.log = log;
    }

    public Logger(String bundleId) {
        this(Platform.getBundle((String)bundleId));
    }

    public void debug(String msg, Object ... args) {
        this.log(0, msg, args);
    }

    public void debug(Throwable t, String msg, Object ... args) {
        this.log(0, t, msg, args);
    }

    public void error(String msg, Object ... args) {
        this.log(4, msg, args);
    }

    public void error(Throwable t, String msg, Object ... args) {
        this.log(4, t, msg, args);
    }

    public void info(String msg, Object ... args) {
        this.log(1, msg, args);
    }

    public void info(Throwable t, String msg, Object ... args) {
        this.log(1, t, msg, args);
    }

    public boolean isDebugEnabled() {
        return consoleThreshold <= 0 || eclipseLoggerThreshold <= 0;
    }

    public boolean isErrorEnabled() {
        return consoleThreshold <= 4 || eclipseLoggerThreshold <= 4;
    }

    public boolean isInfoEnabled() {
        return consoleThreshold <= 1 || eclipseLoggerThreshold <= 1;
    }

    public boolean isWarningEnabled() {
        return consoleThreshold <= 2 || eclipseLoggerThreshold <= 2;
    }

    public void log(int level, String msg, Object ... args) {
        this.log(level, null, msg, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, Throwable t, String msg, Object ... args) {
        if (level >= consoleThreshold && (eclipseLogListener == null || level < eclipseLoggerThreshold)) {
            PrintStream logStream;
            PrintStream printStream = logStream = level == 2 || level == 4 ? errStream : outStream;
            synchronized (printStream) {
                if (args == null || args.length == 0) {
                    logStream.print(msg);
                } else {
                    logStream.format(msg, args);
                }
                logStream.println();
                if (t != null && consoleThreshold == 0) {
                    t.printStackTrace(logStream);
                }
                logStream.flush();
            }
        }
        if (level >= eclipseLoggerThreshold) {
            this.log.log((IStatus)new Status(level, this.log.getBundle().getSymbolicName(), 293, args == null || args.length == 0 ? msg : String.format(msg, args), t));
        }
    }

    public void warning(String msg, Object ... args) {
        this.log(2, msg, args);
    }

    public void warning(Throwable t, String msg, Object ... args) {
        this.log(2, t, msg, args);
    }

    private static class EclipseLogListener
    implements ILogListener {
        private EclipseLogListener() {
        }

        public void logging(IStatus status, String plugin) {
            int severity = status.getSeverity();
            if (severity >= consoleThreshold) {
                PrintStream out;
                switch (severity) {
                    case 2: 
                    case 4: {
                        out = System.err;
                        break;
                    }
                    default: {
                        out = System.out;
                    }
                }
                Logger.printStatus(status, out);
            }
        }
    }
}

