/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.sax;

import java.util.Stack;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.UnrecognizedElementException;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class TopHandler
extends AbstractHandler {
    private Locator documentLocator;
    private XMLReader reader;
    private final Stack<ContentHandler> handlerStack = new Stack();

    protected TopHandler(XMLReader parent) {
        this.reader = parent;
        parent.setContentHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.popHandler();
    }

    public final AbstractHandler getCurrentHandler() {
        return (AbstractHandler)this.reader.getContentHandler();
    }

    public String getEncoding() {
        return Utils.getEncoding(this.documentLocator);
    }

    @Override
    public String getTAG() {
        return "root";
    }

    @Override
    public final TopHandler getTopHandler() {
        return this;
    }

    public void popFilter() {
        if (this.reader instanceof XMLFilterImpl) {
            XMLFilterImpl filter = (XMLFilterImpl)this.reader;
            this.reader = filter.getParent();
            this.reader.setContentHandler(filter.getContentHandler());
            filter.setParent(null);
            filter.setContentHandler(null);
        }
    }

    public void pushFilter(XMLFilterImpl filter) {
        filter.setContentHandler(this.reader.getContentHandler());
        this.reader.setContentHandler(filter);
        filter.setParent(this.reader);
        this.reader = filter;
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
        this.documentLocator = locator;
    }

    public final void setEntityResolver(EntityResolver resolver) {
        this.reader.setEntityResolver(resolver);
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.reader.setErrorHandler(errorHandler);
    }

    public final void setNamespaceAware(boolean flag) {
        try {
            this.reader.setFeature("http://xml.org/sax/features/namespaces", flag);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        throw new UnrecognizedElementException("root", qName, this.getDocumentLocator());
    }

    @Override
    protected final Locator getDocumentLocator() {
        return this.documentLocator;
    }

    protected final XMLReader getXMLReader() {
        return this.reader;
    }

    protected final void popHandler() {
        this.setHandler(this.handlerStack.pop());
    }

    protected final void pushHandler(ChildHandler handler, Attributes attrs) throws SAXException {
        this.handlerStack.push(this.reader.getContentHandler());
        this.setHandler(handler);
        handler.handleAttributes(attrs);
    }

    private void setHandler(ContentHandler handler) {
        this.reader.setContentHandler(handler);
        if (handler instanceof LexicalHandler) {
            try {
                this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    protected class SAXParserWrapper
    implements ContentHandler {
        protected SAXParserWrapper() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            TopHandler.this.reader.getContentHandler().characters(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            TopHandler.this.reader.getContentHandler().endDocument();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            TopHandler.this.reader.getContentHandler().endElement(uri, localName, qName);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            TopHandler.this.reader.getContentHandler().endPrefixMapping(prefix);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            TopHandler.this.reader.getContentHandler().ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            TopHandler.this.reader.getContentHandler().processingInstruction(target, data);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            TopHandler.this.reader.getContentHandler().setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            TopHandler.this.reader.getContentHandler().skippedEntity(name);
        }

        @Override
        public void startDocument() throws SAXException {
            TopHandler.this.reader.getContentHandler().startDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            TopHandler.this.reader.getContentHandler().startElement(uri, localName, qName, atts);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            TopHandler.this.reader.getContentHandler().startPrefixMapping(prefix, uri);
        }
    }
}

