/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subclipse.internal;

import java.io.File;
import java.util.Date;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.subclipse.internal.SvnRemoteFileReader;
import org.eclipse.buckminster.subclipse.internal.SvnSession;
import org.eclipse.buckminster.subclipse.internal.VersionFinder;
import org.eclipse.buckminster.subversion.GenericReaderType;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SvnReaderType
extends GenericReaderType<ISVNRepositoryLocation, ISVNDirEntry, SVNRevision> {
    public Date getLastModification(File workingCopy, IProgressMonitor monitor) throws CoreException {
        return (Date)new SafeExecute<Date>(this){

            @Override
            protected Date compute(ISVNInfo info) {
                return info.getLastChangedDate();
            }
        }.execute(workingCopy, monitor);
    }

    public long getLastRevision(File workingCopy, IProgressMonitor monitor) throws CoreException {
        return (Long)new SafeExecute<Long>(this, new Long(-1L)){

            @Override
            protected Long compute(ISVNInfo info) {
                SVNRevision.Number lastRev = info.getLastChangedRevision();
                if (lastRev != null) {
                    return new Long(lastRev.getNumber());
                }
                return (Long)this.failValue;
            }
        }.execute(workingCopy, monitor);
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        return new SvnRemoteFileReader((IReaderType)this, providerMatch, monitor);
    }

    public String getRemoteLocation(File workingCopy, IProgressMonitor monitor) throws CoreException {
        return (String)new SafeExecute<String>(this){

            @Override
            protected String compute(ISVNInfo info) {
                return info.getUrl().toString();
            }
        }.execute(workingCopy, monitor);
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new VersionFinder(provider, ctype, nodeQuery);
    }

    protected ISVNRepositoryLocation[] getKnownRepositories(IProgressMonitor monitor) throws CoreException {
        return SVNProviderPlugin.getPlugin().getRepositories().getKnownRepositories(monitor);
    }

    protected ISubversionSession<ISVNDirEntry, SVNRevision> getSession(String repositoryURI, VersionSelector branchOrTag, long revision, Date timestamp, RMContext context) throws CoreException {
        return new SvnSession(repositoryURI, branchOrTag, revision, timestamp, context);
    }

    protected void updateRepositoryMap(IProject project, ISubversionSession<ISVNDirEntry, SVNRevision> session) throws TeamException {
        RepositoryProvider.map((IProject)project, (String)"org.tigris.subversion.subclipse.core.svnnature");
    }

    private ISVNInfo getInfoFromWorkingCopy(File workingCopy) throws SVNClientException, SVNException {
        return SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient().getInfoFromWorkingCopy(workingCopy);
    }

    private abstract class SafeExecute<RETURN_TYPE> {
        protected final RETURN_TYPE failValue;

        public SafeExecute() {
            this.failValue = null;
        }

        public SafeExecute(RETURN_TYPE val) {
            this.failValue = val;
        }

        public RETURN_TYPE execute(File workingCopy, IProgressMonitor monitor) throws CoreException {
            monitor.beginTask(null, 1);
            try {
                ISVNInfo info = SvnReaderType.this.getInfoFromWorkingCopy(workingCopy);
                if (info == null) {
                    RETURN_TYPE RETURN_TYPE = this.failValue;
                    return RETURN_TYPE;
                }
                RETURN_TYPE RETURN_TYPE = this.compute(info);
                return RETURN_TYPE;
            }
            catch (SVNClientException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
            finally {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                monitor.done();
            }
        }

        protected abstract RETURN_TYPE compute(ISVNInfo var1);
    }
}

