/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.team;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.team.core.RepositoryProvider;

class ProviderResources {
    private RepositoryProvider provider;
    private List<IResource> files = new ArrayList<IResource>();
    private List<IResource> zeroFolders = new ArrayList<IResource>();
    private List<IResource> shallowFolders = new ArrayList<IResource>();
    private List<IResource> deepFolders = new ArrayList<IResource>();

    public ProviderResources(RepositoryProvider provider) {
        this.provider = provider;
    }

    public void add(ResourceTraversal traversal) {
        IResource[] iResourceArray = traversal.getResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getProject().equals((Object)this.provider.getProject())) {
                if (resource.getType() == 1) {
                    this.files.add(resource);
                } else {
                    switch (traversal.getDepth()) {
                        case 0: {
                            this.zeroFolders.add(resource);
                            break;
                        }
                        case 1: {
                            this.shallowFolders.add(resource);
                            break;
                        }
                        case 2: {
                            this.deepFolders.add(resource);
                            break;
                        }
                        default: {
                            this.deepFolders.add(resource);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public void add(ResourceTraversal[] traversals) {
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            this.add(traversal);
            ++n2;
        }
    }

    public IResource[] getDeepResources() {
        if (this.deepFolders.isEmpty()) {
            return new IResource[0];
        }
        if (!this.shallowFolders.isEmpty()) {
            return this.deepFolders.toArray(new IResource[this.deepFolders.size()]);
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        result.addAll(this.deepFolders);
        result.addAll(this.files);
        return result.toArray(new IResource[result.size()]);
    }

    public IResource[] getNontraversedFolders() {
        return this.zeroFolders.toArray(new IResource[this.zeroFolders.size()]);
    }

    public RepositoryProvider getProvider() {
        return this.provider;
    }

    public IResource[] getShallowResources() {
        if (this.shallowFolders.isEmpty() && this.deepFolders.isEmpty() && !this.files.isEmpty()) {
            return this.files.toArray(new IResource[this.files.size()]);
        }
        if (!this.shallowFolders.isEmpty()) {
            if (this.files.isEmpty()) {
                return this.shallowFolders.toArray(new IResource[this.shallowFolders.size()]);
            }
            ArrayList<IResource> result = new ArrayList<IResource>();
            result.addAll(this.shallowFolders);
            result.addAll(this.files);
            return result.toArray(new IResource[result.size()]);
        }
        return new IResource[0];
    }
}

