/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.team;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.reader.ITeamReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.team.AbstractTeamActor;
import org.eclipse.buckminster.team.Messages;
import org.eclipse.buckminster.team.TeamPerformContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

public class TagTeamActor
extends AbstractTeamActor<TagContext> {
    public static final String TAG_PROPERTY_NAME = "tag";
    public static final String INCLUDE_PROPERTY_PREFIX = "include.";
    public static final String EXCLUDE_PROPERTY_PREFIX = "exclude.";

    @Override
    public String getActionName(IActionContext actionContext) {
        return NLS.bind((String)Messages.workspace_resolution_tagging_of_0, (Object)actionContext.getAction().getCSpec().getComponentIdentifier().toString());
    }

    @Override
    protected TagContext createTeamPerformContext(IActionContext actionContext) throws CoreException {
        return new TagContext(actionContext);
    }

    @Override
    protected String getTaskName(RepositoryProvider provider) {
        return NLS.bind((String)Messages.tagging_project_0, (Object)provider.getProject().getName());
    }

    @Override
    protected void processResources(TagContext tagContext, RepositoryProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CoreException, InterruptedException {
        String tag;
        ITeamReaderType readerType = tagContext.getCachedReaderTypeForRepositoryProvider(provider.getID());
        IStatus status = readerType.tag(provider, resources, tag = tagContext.getTag(), recurse, monitor);
        if (status.matches(3)) {
            PrintStream outputPrintStream = tagContext.getActionContext().getOutputStream();
            BuckminsterException.deeplyPrint((Throwable)new CoreException(status), (PrintStream)outputPrintStream, (boolean)false);
        } else {
            tagContext.collectStatus(status);
        }
    }

    @Override
    protected boolean shouldExclude(TagContext tagContext, IResource resource) {
        return tagContext.shouldExclude(resource.getName());
    }

    protected static class TagContext
    extends TeamPerformContext {
        private String tag;
        private Pattern[] includes;
        private Pattern[] excludes;

        public TagContext(IActionContext actionContext) throws CoreException {
            super(actionContext);
            TreeMap sortedIncludes = new TreeMap();
            TreeMap sortedExcludes = new TreeMap();
            StringBuilder message = null;
            for (Map.Entry property : actionContext.getAction().getActorProperties().entrySet()) {
                String name;
                block25: {
                    name = (String)property.getKey();
                    if (name.startsWith(TagTeamActor.EXCLUDE_PROPERTY_PREFIX)) {
                        try {
                            int key = Integer.parseInt(name.substring(TagTeamActor.EXCLUDE_PROPERTY_PREFIX.length()));
                            if (key >= 0) {
                                sortedExcludes.put(key, property);
                                continue;
                            }
                            break block25;
                        }
                        catch (NumberFormatException key) {
                            break block25;
                        }
                    }
                    if (name.startsWith(TagTeamActor.INCLUDE_PROPERTY_PREFIX)) {
                        try {
                            int key = Integer.parseInt(name.substring(TagTeamActor.INCLUDE_PROPERTY_PREFIX.length()));
                            if (key >= 0) {
                                sortedIncludes.put(key, property);
                                continue;
                            }
                            break block25;
                        }
                        catch (NumberFormatException key) {
                            break block25;
                        }
                    }
                    if (name.equals(TagTeamActor.TAG_PROPERTY_NAME)) {
                        this.tag = (String)ExpandingProperties.expand((Map)actionContext.getProperties(), (Object)((String)property.getValue()), (int)0);
                        continue;
                    }
                }
                if (message == null) {
                    message = new StringBuilder();
                } else {
                    message.append(Messages.list_separator);
                }
                message.append(name);
            }
            if (this.tag == null || this.tag.length() == 0) {
                throw new CoreException(TagTeamActor.createStatus(NLS.bind((String)Messages.required_properties_not_supplied_0, (Object)TagTeamActor.TAG_PROPERTY_NAME)));
            }
            if (message != null) {
                throw new CoreException(TagTeamActor.createStatus(String.valueOf(NLS.bind((String)Messages.unrecognized_properties_supplied_0, (Object)message.toString())) + '\n' + NLS.bind((String)Messages.recognized_properties_0, (Object)(TagTeamActor.TAG_PROPERTY_NAME + Messages.list_separator + TagTeamActor.INCLUDE_PROPERTY_PREFIX + "<n>" + Messages.list_separator + TagTeamActor.EXCLUDE_PROPERTY_PREFIX + "<n>"))));
            }
            ArrayList<Pattern> patternList = new ArrayList<Pattern>(Math.max(sortedIncludes.size(), sortedExcludes.size()));
            for (Map.Entry include : sortedIncludes.values()) {
                Pattern includePattern;
                String includeString = (String)ExpandingProperties.expand((Map)actionContext.getProperties(), (Object)((String)include.getValue()), (int)0);
                try {
                    includePattern = Pattern.compile(includeString);
                }
                catch (PatternSyntaxException e) {
                    if (message == null) {
                        message = new StringBuilder();
                    } else {
                        message.append('\n');
                    }
                    message.append(NLS.bind((String)Messages._0_entry_1_invalid_2, (Object[])new Object[]{Messages.include_label, include.getKey(), NLS.bind((String)Messages.specified_pattern_is_invalid_0, (Object)e.getMessage())}));
                    continue;
                }
                patternList.add(includePattern);
            }
            this.includes = patternList.toArray(new Pattern[patternList.size()]);
            patternList.clear();
            for (Map.Entry exclude : sortedExcludes.values()) {
                Pattern excludePattern;
                String excludeString = (String)ExpandingProperties.expand((Map)actionContext.getProperties(), (Object)((String)exclude.getValue()), (int)0);
                try {
                    excludePattern = Pattern.compile(excludeString);
                }
                catch (PatternSyntaxException e) {
                    if (message == null) {
                        message = new StringBuilder();
                    } else {
                        message.append('\n');
                    }
                    message.append(NLS.bind((String)Messages._0_entry_1_invalid_2, (Object[])new Object[]{Messages.exclude_label, exclude.getKey(), NLS.bind((String)Messages.specified_pattern_is_invalid_0, (Object)e.getMessage())}));
                    continue;
                }
                patternList.add(excludePattern);
            }
            if (message != null) {
                throw new CoreException(TagTeamActor.createStatus(NLS.bind((String)Messages.property_settings_problems_0, (Object)message.toString())));
            }
            this.excludes = patternList.toArray(new Pattern[patternList.size()]);
        }

        public String getTag() {
            return this.tag;
        }

        public boolean shouldExclude(String name) {
            Pattern[] patternArray = this.includes;
            int n = this.includes.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern include = patternArray[n2];
                if (include.matcher(name).find()) {
                    return false;
                }
                ++n2;
            }
            patternArray = this.excludes;
            n = this.excludes.length;
            n2 = 0;
            while (n2 < n) {
                Pattern exclude = patternArray[n2];
                if (exclude.matcher(name).find()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

