/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.ui.AbstractCSpecAction;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.internal.CSpecEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewCSpecAction
extends AbstractCSpecAction {
    @Override
    protected void run(CSpec cspec, Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow wbWin = workbench.getActiveWorkbenchWindow();
        if (wbWin == null) {
            return;
        }
        IWorkbenchPage page = wbWin.getActivePage();
        if (page == null) {
            return;
        }
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        CSpecEditorInput input = new CSpecEditorInput(cspec);
        IEditorDescriptor ed = editorRegistry.getDefaultEditor(input.getName(), input.getContentDescription().getContentType());
        try {
            page.openEditor((IEditorInput)input, ed.getId());
        }
        catch (PartInitException e) {
            UiUtils.openError(page.getWorkbenchWindow().getShell(), Messages.unable_to_open_editor, e);
        }
    }

    @Override
    protected void run(Shell shell) {
        CSpec cspec = this.fetchCSpec((IProgressMonitor)new NullProgressMonitor());
        if (cspec == null) {
            super.run(shell);
        } else {
            this.run(cspec, shell);
        }
    }
}

