/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.actions;

import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.actions.AbstractChosenCSpecAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class DisconnectChosenCSpecAction
extends AbstractChosenCSpecAction {
    @Override
    protected void run(CSpec cspec, IWorkbenchWindow wbWin) {
        IWorkbenchPage page = wbWin.getActivePage();
        if (page == null) {
            return;
        }
        try {
            ComponentIdentifier wanted = cspec.getComponentIdentifier();
            for (Resolution res : WorkspaceInfo.getAllResolutions()) {
                ComponentIdentifier cid = res.getCSpec().getComponentIdentifier();
                if (!wanted.matches(cid)) continue;
                res.remove(StorageManager.getDefault());
            }
        }
        catch (CoreException e) {
            UiUtils.openError(page.getWorkbenchWindow().getShell(), Messages.unable_to_open_editor, e);
        }
    }
}

