/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionType;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.ChangeAdapter;
import org.eclipse.buckminster.ui.editor.VersionDesignatorEvent;
import org.eclipse.buckminster.ui.editor.VersionDesignatorListener;
import org.eclipse.buckminster.ui.general.editor.simple.Widgetin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VersionDesignator
extends Widgetin {
    ChangeAdapter notifier = new ChangeAdapter(){

        @Override
        protected void onChange(TypedEvent te) {
            VersionDesignatorEvent e = new VersionDesignatorEvent(VersionDesignator.this, te.widget, te.data);
            for (VersionDesignatorListener listener : VersionDesignator.this.listeners) {
                listener.modifyVersionDesignator(e);
            }
        }
    };
    private final Composite parentComposite;
    private final Label versionDsTypeLabel;
    private final Combo versionDsType;
    private final Label rangeLabel;
    private final Text fromVersion;
    private final Composite toComposite;
    private final StackLayout toStackLayout;
    private final Label toEmptyLabel;
    private final Text toVersion;
    private final Combo versionType;
    private final ArrayList<VersionDesignatorListener> listeners = new ArrayList();

    public VersionDesignator(Composite parent) {
        this(parent, false);
    }

    public VersionDesignator(Composite parent, boolean readOnly) {
        this.parentComposite = parent;
        this.versionDsTypeLabel = UiUtils.createGridLabel(this.parentComposite, Messages.designator_with_colon, 1, 0, 0);
        SelectionAdapter versionDSListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionDesignator.this.dsTypeIndexChanged(((Combo)e.getSource()).getSelectionIndex());
            }
        };
        this.versionDsType = UiUtils.createGridEnumCombo(this.parentComposite, 1, 0, DesignatorType.values(), readOnly, (SelectionListener)(readOnly ? null : versionDSListener), null, 76);
        this.versionDsType.addSelectionListener((SelectionListener)this.notifier);
        UiUtils.createEmptyLabel(this.parentComposite);
        this.rangeLabel = UiUtils.createGridLabel(this.parentComposite, Messages.version_with_colon, 1, 0, 0);
        this.fromVersion = UiUtils.createGridText(this.parentComposite, 1, 0, readOnly, 0, this.notifier);
        this.toComposite = new Composite(this.parentComposite, 0);
        this.toComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toStackLayout = new StackLayout();
        this.toComposite.setLayout((Layout)this.toStackLayout);
        this.toEmptyLabel = UiUtils.createEmptyLabel(this.toComposite);
        this.toVersion = UiUtils.createGridText(this.toComposite, 1, 0, readOnly, 0, this.notifier);
        UiUtils.createGridLabel(this.parentComposite, Messages.type_with_colon, 1, 0, 0);
        this.versionType = UiUtils.createGridCombo(this.parentComposite, 1, 0, readOnly, null, null, 76);
        List knownTypes = VersionHelper.getKnownTypes();
        int idx = knownTypes.size();
        String[] versionTypes = new String[idx];
        while (--idx >= 0) {
            versionTypes[idx] = ((VersionType)knownTypes.get(idx)).getId();
        }
        this.versionType.setItems(versionTypes);
        this.versionType.select(this.versionType.indexOf("OSGi"));
        this.versionType.addSelectionListener((SelectionListener)this.notifier);
        UiUtils.createEmptyLabel(this.parentComposite);
        this.dsTypeIndexChanged(DesignatorType.GREATER_OR_EQUAL.ordinal());
    }

    public void addVersionDesignatorListener(VersionDesignatorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public VersionRange getDirectVersionDesignator() throws CoreException {
        int vdIndex = this.versionDsType.getSelectionIndex();
        if (vdIndex < 0) {
            return null;
        }
        return DesignatorType.values()[vdIndex].createDesignator(this.getVersionType(), this.fromVersion, this.fromVersion, this.toVersion);
    }

    public Display getDisplay() {
        return this.parentComposite.getDisplay();
    }

    public VersionRange getVersionDesignator() {
        try {
            return this.getDirectVersionDesignator();
        }
        catch (CoreException e) {
            CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
            ErrorDialog.openError((Shell)this.parentComposite.getShell(), null, null, (IStatus)e.getStatus());
            return null;
        }
    }

    public Combo getVersionDsTypeCombo() {
        return this.versionDsType;
    }

    public Label getVersionDsTypeLabel() {
        return this.versionDsTypeLabel;
    }

    public String getVersionType() {
        int vtIndex = this.versionType.getSelectionIndex();
        return vtIndex < 0 ? null : this.versionType.getItem(vtIndex);
    }

    public void refreshValues(VersionRange versionDesignator) {
        if (versionDesignator != null) {
            String vds;
            DesignatorType dsType = versionDesignator.getMinimum().equals(versionDesignator.getMaximum()) ? DesignatorType.EQUALS : (!(vds = versionDesignator.toString()).startsWith("[") && !vds.startsWith("(") && !vds.startsWith("raw:[") && !vds.startsWith("raw:(") ? DesignatorType.GREATER_OR_EQUAL : (versionDesignator.getIncludeMinimum() ? (versionDesignator.getIncludeMaximum() ? DesignatorType.RANGE_II : DesignatorType.RANGE_IE) : (versionDesignator.getIncludeMaximum() ? DesignatorType.RANGE_EI : DesignatorType.RANGE_EE)));
            this.versionDsType.select(dsType.ordinal());
            this.dsTypeIndexChanged(dsType.ordinal());
            if (versionDesignator.getFormat() == VersionHelper.getOSGiFormat()) {
                this.fromVersion.setText(versionDesignator.getMinimum().toString());
                this.toVersion.setText(TextUtils.notNullString((Object)versionDesignator.getMaximum()));
            } else {
                if (versionDesignator.getMinimum().equals(Version.emptyVersion)) {
                    this.fromVersion.setText("");
                } else {
                    this.fromVersion.setText(versionDesignator.getMinimum().getOriginal());
                }
                Version maxVer = versionDesignator.getMaximum();
                if (maxVer == null || maxVer.equals(Version.MAX_VERSION)) {
                    this.toVersion.setText("");
                } else {
                    this.toVersion.setText(TextUtils.notNullString((Object)maxVer.getOriginal()));
                }
            }
            this.versionType.select(this.versionType.indexOf(VersionHelper.getVersionType((VersionRange)versionDesignator).getId()));
        } else {
            this.fromVersion.setText("");
            this.toVersion.setText("");
            this.versionType.select(-1);
        }
    }

    public void removeVersionDesignatorListener(VersionDesignatorListener listener) {
        this.listeners.remove(listener);
    }

    public void setEnabled(boolean flag) {
        this.versionDsType.setEnabled(flag);
        this.fromVersion.setEnabled(flag);
        this.toVersion.setEnabled(flag);
        this.versionType.setEnabled(flag);
    }

    private void dsTypeIndexChanged(int idx) {
        Label toBe;
        if (idx < 0) {
            return;
        }
        Control current = this.toStackLayout.topControl;
        Object object = toBe = idx < 2 ? this.toEmptyLabel : this.toVersion;
        if (current != toBe) {
            if (current != null) {
                if (idx < 2) {
                    this.rangeLabel.setText(Messages.version_with_colon);
                } else {
                    this.rangeLabel.setText(Messages.from_to_with_colon);
                }
            }
            this.toStackLayout.topControl = toBe;
            this.toComposite.layout();
        }
    }

    static enum DesignatorType {
        EQUALS{

            public String toString() {
                return Messages.equal_to_version;
            }

            @Override
            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                Version tmp = VersionHelper.createVersion((String)versionType, (String)UiUtils.trimmedValue(version));
                return tmp == null ? null : VersionHelper.exactRange((Version)tmp);
            }
        }
        ,
        GREATER_OR_EQUAL{

            public String toString() {
                return Messages.grater_or_equal_to_version;
            }

            @Override
            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                Version tmp = VersionHelper.createVersion((String)versionType, (String)UiUtils.trimmedValue(version));
                return tmp == null ? null : VersionHelper.greaterOrEqualRange((Version)tmp);
            }
        }
        ,
        RANGE_IE{

            public String toString() {
                return Messages.from_incl_to_excl_version;
            }

            @Override
            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                return DesignatorType.createRange(from, to, versionType, '[', ')');
            }
        }
        ,
        RANGE_II{

            public String toString() {
                return Messages.from_incl_to_incl_version;
            }

            @Override
            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                return DesignatorType.createRange(from, to, versionType, '[', ']');
            }
        }
        ,
        RANGE_EE{

            public String toString() {
                return Messages.from_excl_to_excl_version;
            }

            @Override
            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                return DesignatorType.createRange(from, to, versionType, '(', ')');
            }
        }
        ,
        RANGE_EI{

            public String toString() {
                return Messages.from_excl_to_incl_version;
            }

            @Override
            VersionRange createDesignator(String versionType, Text version, Text from, Text to) throws CoreException {
                return DesignatorType.createRange(from, to, versionType, '(', ']');
            }
        };


        static String[] getStrings() {
            DesignatorType[] dsTypes = DesignatorType.values();
            int idx = dsTypes.length;
            String[] strings = new String[idx];
            while (--idx >= 0) {
                strings[idx] = dsTypes[idx].toString();
            }
            return strings;
        }

        private static VersionRange createRange(Text from, Text to, String versionType, char start, char end) throws CoreException {
            String tmp = UiUtils.trimmedValue(from);
            String tmp2 = UiUtils.trimmedValue(to);
            if (tmp == null || tmp2 == null) {
                return null;
            }
            return VersionHelper.createRange((String)versionType, (String)(String.valueOf(start) + tmp + ',' + tmp2 + end));
        }

        abstract VersionRange createDesignator(String var1, Text var2, Text var3, Text var4) throws CoreException;
    }
}

