/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.editor.cspec.AttributesTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.editor.cspec.PrerequisitesTable;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.InvalidSyntaxException;

public class GroupPrerequisitesTable
extends PrerequisitesTable {
    public GroupPrerequisitesTable(CSpecEditor editor, AttributesTable<?> parentAttributesTable, List<PrerequisiteBuilder> data, TopLevelAttributeBuilder attributeBuilder, boolean readOnly) {
        super(editor, parentAttributesTable, data, attributeBuilder, readOnly);
    }

    @Override
    public String[] getColumnHeaders() {
        return new String[]{Messages.component, Messages.type, Messages.version_designator, Messages.name, Messages.contributor, Messages.filter, Messages.include_pattern, Messages.exclude_pattern};
    }

    @Override
    public int[] getColumnWeights() {
        int[] nArray = new int[8];
        nArray[0] = 20;
        nArray[1] = 5;
        nArray[2] = 5;
        nArray[3] = 10;
        return nArray;
    }

    @Override
    public IWidgetin getWidgetin(Composite parent, int idx, Object value) {
        if (idx < 4) {
            return super.getWidgetin(parent, idx, value);
        }
        return super.getWidgetin(parent, ++idx, value);
    }

    @Override
    public Object[] toRowArray(PrerequisiteBuilder t) {
        return new Object[]{t.getComponentName(), TextUtils.notNullString((Object)t.getComponentType()), TextUtils.notNullString((Object)t.getVersionRange()), t.getName(), t.isContributor(), TextUtils.notNullString((Object)t.getFilter()), TextUtils.notNullString((Object)t.getIncludePattern()), TextUtils.notNullString((Object)t.getExcludePattern())};
    }

    @Override
    public void updateRowClass(PrerequisiteBuilder builder, Object[] args) throws ValidatorException {
        builder.setComponentName(TextUtils.notEmptyString((String)((String)args[0])));
        builder.setComponentType(TextUtils.notEmptyString((String)((String)args[1])));
        String vrStr = TextUtils.notEmptyString((String)((String)args[2]));
        if (vrStr != null) {
            try {
                builder.setVersionRange(new VersionRange(vrStr));
            }
            catch (IllegalArgumentException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setVersionRange(null);
        }
        builder.setName(TextUtils.notEmptyString((String)((String)args[3])));
        builder.setContributor(((Boolean)args[4]).booleanValue());
        String filterStr = TextUtils.notEmptyString((String)((String)args[5]));
        if (filterStr != null) {
            try {
                builder.setFilter(FilterFactory.newInstance((String)filterStr));
            }
            catch (InvalidSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setFilter(null);
        }
        String includePatternStr = TextUtils.notEmptyString((String)((String)args[6]));
        if (includePatternStr != null) {
            try {
                builder.setIncludePattern(Pattern.compile(includePatternStr));
            }
            catch (PatternSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setIncludePattern(null);
        }
        String excludePatternStr = TextUtils.notEmptyString((String)((String)args[7]));
        if (excludePatternStr != null) {
            try {
                builder.setExcludePattern(Pattern.compile(excludePatternStr));
            }
            catch (PatternSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setExcludePattern(null);
        }
    }
}

