/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.internal;

import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.MaterializationJob;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.IResolver;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.wizards.QueryWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;

public class ResolveJob
extends Job {
    private final IResolver resolver;
    private final boolean materialize;
    private final IWorkbenchPartSite site;

    public ResolveJob(ComponentQuery query, boolean materialize, IWorkbenchPartSite site, boolean continueOnError) throws CoreException {
        super(Messages.resolving_qurey);
        this.resolver = new MainResolver(new ResolutionContext(query));
        this.resolver.getContext().setContinueOnError(continueOnError);
        this.materialize = materialize;
        this.site = site;
        this.setUser(true);
        this.setPriority(40);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IStatus status;
        IProgressMonitor resolutionMonitor;
        ResolutionContext ctx = this.resolver.getContext();
        ComponentQuery query = ctx.getComponentQuery();
        if (this.materialize) {
            monitor.beginTask(null, 1000);
            resolutionMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500);
        } else {
            resolutionMonitor = monitor;
        }
        Display display = this.site.getShell().getDisplay();
        ComponentRequest rootRequest = query.getExpandedRootRequest((Map)ctx);
        BillOfMaterials bom = null;
        try {
            bom = this.resolver.resolve(rootRequest, resolutionMonitor);
            status = ctx.getStatus();
        }
        catch (OperationCanceledException e) {
            status = ctx.getStatus();
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        CorePlugin.logWarningsAndErrors((IStatus)status);
        ctx.emitWarningAndErrorTags();
        if (bom == null || status.getSeverity() == 4 && !ctx.isContinueOnError()) {
            return Status.OK_STATUS;
        }
        if (!this.materialize) {
            final BillOfMaterials finalBom = bom;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    QueryWizard.openWizard(ResolveJob.this.site, ResolveJob.this.resolver.getContext(), finalBom);
                }
            });
            return Status.OK_STATUS;
        }
        try {
            if (bom.isFullyResolved((Map)ctx) || ctx.isContinueOnError()) {
                this.setName(Messages.materializing);
                MaterializationSpecBuilder mspecBuilder = new MaterializationSpecBuilder();
                mspecBuilder.setName(bom.getViewName());
                bom.addMaterializationNodes(mspecBuilder);
                MaterializationContext matCtx = new MaterializationContext(bom, mspecBuilder.createMaterializationSpec(), (RMContext)ctx);
                MaterializationJob.runDelegated((MaterializationContext)matCtx, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
            }
            iStatus = status;
        }
        catch (Throwable throwable) {
            try {
                monitor.done();
                throw throwable;
            }
            catch (Exception e) {
                IStatus status2 = BuckminsterException.wrap((Throwable)e).getStatus();
                CorePlugin.logWarningsAndErrors((IStatus)status2);
                return status2;
            }
        }
        monitor.done();
        return iStatus;
    }
}

