/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

public abstract class SaxableEditorInput
implements IStorageEditorInput {
    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    protected abstract ISaxable getContent() throws CoreException;

    public IContentDescription getContentDescription() {
        InputStream contents = null;
        try {
            contents = this.getStorage().getContents();
            IContentDescription iContentDescription = Platform.getContentTypeManager().getDescriptionFor(contents, this.getName(), IContentDescription.ALL);
            return iContentDescription;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.close((Closeable)contents);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        IContentDescription cd = this.getContentDescription();
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.getName(), cd.getContentType());
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        return new IStorage(){

            public <T> T getAdapter(Class<T> adapter) {
                return null;
            }

            public InputStream getContents() throws CoreException {
                try {
                    return Utils.getInputStream((ISaxable)SaxableEditorInput.this.getContent());
                }
                catch (SAXException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }

            public IPath getFullPath() {
                return null;
            }

            public String getName() {
                return SaxableEditorInput.this.getName();
            }

            public boolean isReadOnly() {
                return true;
            }
        };
    }
}

