/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.javaflow.bytecode.EmptyStackException;
import org.apache.commons.javaflow.utils.ReflectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Stack
implements Serializable {
    private static final Log log = LogFactory.getLog(Stack.class);
    private static final long serialVersionUID = 2L;
    private int[] istack;
    private float[] fstack;
    private double[] dstack;
    private long[] lstack;
    private Object[] ostack;
    private Object[] rstack;
    private int iTop;
    private int fTop;
    private int dTop;
    private int lTop;
    private int oTop;
    private int rTop;
    protected Runnable runnable;

    public Stack(Runnable pRunnable) {
        this.istack = new int[10];
        this.lstack = new long[5];
        this.dstack = new double[5];
        this.fstack = new float[5];
        this.ostack = new Object[10];
        this.rstack = new Object[5];
        this.runnable = pRunnable;
    }

    public Stack(Stack pParent) {
        this.istack = new int[pParent.istack.length];
        this.lstack = new long[pParent.lstack.length];
        this.dstack = new double[pParent.dstack.length];
        this.fstack = new float[pParent.fstack.length];
        this.ostack = new Object[pParent.ostack.length];
        this.rstack = new Object[pParent.rstack.length];
        this.iTop = pParent.iTop;
        this.fTop = pParent.fTop;
        this.dTop = pParent.dTop;
        this.lTop = pParent.lTop;
        this.oTop = pParent.oTop;
        this.rTop = pParent.rTop;
        System.arraycopy(pParent.istack, 0, this.istack, 0, this.iTop);
        System.arraycopy(pParent.fstack, 0, this.fstack, 0, this.fTop);
        System.arraycopy(pParent.dstack, 0, this.dstack, 0, this.dTop);
        System.arraycopy(pParent.lstack, 0, this.lstack, 0, this.lTop);
        System.arraycopy(pParent.ostack, 0, this.ostack, 0, this.oTop);
        System.arraycopy(pParent.rstack, 0, this.rstack, 0, this.rTop);
        this.runnable = pParent.runnable;
    }

    public boolean hasDouble() {
        return this.dTop > 0;
    }

    public double popDouble() {
        if (this.dTop == 0) {
            throw new EmptyStackException("pop double");
        }
        double d = this.dstack[--this.dTop];
        if (log.isDebugEnabled()) {
            log.debug((Object)("pop double " + d + " " + this.getStats()));
        }
        return d;
    }

    public boolean hasFloat() {
        return this.fTop > 0;
    }

    public float popFloat() {
        if (this.fTop == 0) {
            throw new EmptyStackException("pop float");
        }
        float f = this.fstack[--this.fTop];
        if (log.isDebugEnabled()) {
            log.debug((Object)("pop float " + f + " " + this.getStats()));
        }
        return f;
    }

    public boolean hasInt() {
        return this.iTop > 0;
    }

    public int popInt() {
        if (this.iTop == 0) {
            throw new EmptyStackException("pop int");
        }
        int i = this.istack[--this.iTop];
        if (log.isDebugEnabled()) {
            log.debug((Object)("pop int " + i + " " + this.getStats()));
        }
        return i;
    }

    public boolean hasLong() {
        return this.lTop > 0;
    }

    public long popLong() {
        if (this.lTop == 0) {
            throw new EmptyStackException("pop long");
        }
        long l = this.lstack[--this.lTop];
        if (log.isDebugEnabled()) {
            log.debug((Object)("pop long " + l + " " + this.getStats()));
        }
        return l;
    }

    public boolean hasObject() {
        return this.oTop > 0;
    }

    public Object popObject() {
        if (this.oTop == 0) {
            throw new EmptyStackException("pop object");
        }
        Object o = this.ostack[--this.oTop];
        this.ostack[this.oTop] = null;
        if (log.isDebugEnabled()) {
            String clazz = ReflectionUtils.getClassName(o);
            String clazzLoader = ReflectionUtils.getClassLoaderName(o);
            log.debug((Object)("pop object " + clazz + "/" + clazzLoader + " [" + o + "] "));
        }
        return o;
    }

    public boolean hasReference() {
        return this.rTop > 0;
    }

    public Object popReference() {
        if (this.rTop == 0) {
            throw new EmptyStackException("pop reference");
        }
        Object o = this.rstack[--this.rTop];
        this.rstack[this.rTop] = null;
        if (log.isDebugEnabled()) {
            String clazz = ReflectionUtils.getClassName(o);
            String clazzLoader = ReflectionUtils.getClassLoaderName(o);
            log.debug((Object)("pop reference " + clazz + "/" + clazzLoader + " [" + o + "] " + this.getStats()));
        }
        return o;
    }

    public void pushDouble(double d) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("push double " + d + " " + this.getStats()));
        }
        if (this.dTop == this.dstack.length) {
            double[] hlp = new double[Math.max(8, this.dstack.length * 2)];
            System.arraycopy(this.dstack, 0, hlp, 0, this.dstack.length);
            this.dstack = hlp;
        }
        this.dstack[this.dTop++] = d;
    }

    public void pushFloat(float f) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("push float " + f + " " + this.getStats()));
        }
        if (this.fTop == this.fstack.length) {
            float[] hlp = new float[Math.max(8, this.fstack.length * 2)];
            System.arraycopy(this.fstack, 0, hlp, 0, this.fstack.length);
            this.fstack = hlp;
        }
        this.fstack[this.fTop++] = f;
    }

    public void pushInt(int i) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("push int " + i + " " + this.getStats()));
        }
        if (this.iTop == this.istack.length) {
            int[] hlp = new int[Math.max(8, this.istack.length * 2)];
            System.arraycopy(this.istack, 0, hlp, 0, this.istack.length);
            this.istack = hlp;
        }
        this.istack[this.iTop++] = i;
    }

    public void pushLong(long l) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("push long " + l + " " + this.getStats()));
        }
        if (this.lTop == this.lstack.length) {
            long[] hlp = new long[Math.max(8, this.lstack.length * 2)];
            System.arraycopy(this.lstack, 0, hlp, 0, this.lstack.length);
            this.lstack = hlp;
        }
        this.lstack[this.lTop++] = l;
    }

    public void pushObject(Object o) {
        if (log.isDebugEnabled()) {
            String clazz = ReflectionUtils.getClassName(o);
            String clazzLoader = ReflectionUtils.getClassLoaderName(o);
            log.debug((Object)("push object " + clazz + "/" + clazzLoader + " [" + o + "] " + this.getStats()));
        }
        if (this.oTop == this.ostack.length) {
            Object[] hlp = new Object[Math.max(8, this.ostack.length * 2)];
            System.arraycopy(this.ostack, 0, hlp, 0, this.ostack.length);
            this.ostack = hlp;
        }
        this.ostack[this.oTop++] = o;
    }

    public void pushReference(Object o) {
        if (log.isDebugEnabled()) {
            String clazz = ReflectionUtils.getClassName(o);
            String clazzLoader = ReflectionUtils.getClassLoaderName(o);
            log.debug((Object)("push reference " + clazz + "/" + clazzLoader + " [" + o + "] " + this.getStats()));
        }
        if (this.rTop == this.rstack.length) {
            Object[] hlp = new Object[Math.max(8, this.rstack.length * 2)];
            System.arraycopy(this.rstack, 0, hlp, 0, this.rstack.length);
            this.rstack = hlp;
        }
        this.rstack[this.rTop++] = o;
    }

    public boolean isSerializable() {
        int i;
        for (i = 0; i < this.rTop; ++i) {
            Object r = this.rstack[i];
            if (r instanceof Serializable) continue;
            return false;
        }
        for (i = 0; i < this.oTop; ++i) {
            Object o = this.ostack[i];
            if (o instanceof Serializable) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.iTop == 0 && this.lTop == 0 && this.dTop == 0 && this.fTop == 0 && this.oTop == 0 && this.rTop == 0;
    }

    private String getStats() {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("i[").append(this.iTop).append("],");
            sb.append("l[").append(this.lTop).append("],");
            sb.append("d[").append(this.dTop).append("],");
            sb.append("f[").append(this.fTop).append("],");
            sb.append("o[").append(this.oTop).append("],");
            sb.append("r[").append(this.rTop).append("]");
            return sb.toString();
        }
        return "enable debug loglevel to see stats";
    }

    private String getContent() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("i[").append(this.iTop).append("]\n");
        sb.append("l[").append(this.lTop).append("]\n");
        sb.append("d[").append(this.dTop).append("]\n");
        sb.append("f[").append(this.fTop).append("]\n");
        sb.append("o[").append(this.oTop).append("]\n");
        for (i = 0; i < this.oTop; ++i) {
            sb.append(' ').append(i).append(": ");
            sb.append(ReflectionUtils.getClassName(this.ostack[i])).append('/').append(ReflectionUtils.getClassLoaderName(this.ostack[i]));
            sb.append('\n');
        }
        sb.append("r[").append(this.rTop).append("]\n");
        for (i = 0; i < this.rTop; ++i) {
            sb.append(' ').append(i).append(": ");
            sb.append(ReflectionUtils.getClassName(this.rstack[i])).append('/').append(ReflectionUtils.getClassLoaderName(this.rstack[i]));
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.getContent();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int i;
        s.writeInt(this.iTop);
        for (i = 0; i < this.iTop; ++i) {
            s.writeInt(this.istack[i]);
        }
        s.writeInt(this.lTop);
        for (i = 0; i < this.lTop; ++i) {
            s.writeLong(this.lstack[i]);
        }
        s.writeInt(this.dTop);
        for (i = 0; i < this.dTop; ++i) {
            s.writeDouble(this.dstack[i]);
        }
        s.writeInt(this.fTop);
        for (i = 0; i < this.fTop; ++i) {
            s.writeDouble(this.fstack[i]);
        }
        s.writeInt(this.oTop);
        for (i = 0; i < this.oTop; ++i) {
            s.writeObject(this.ostack[i]);
        }
        s.writeInt(this.rTop);
        for (i = 0; i < this.rTop; ++i) {
            s.writeObject(this.rstack[i]);
        }
        s.writeObject(this.runnable);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int i;
        this.iTop = s.readInt();
        this.istack = new int[this.iTop];
        for (i = 0; i < this.iTop; ++i) {
            this.istack[i] = s.readInt();
        }
        this.lTop = s.readInt();
        this.lstack = new long[this.lTop];
        for (i = 0; i < this.lTop; ++i) {
            this.lstack[i] = s.readLong();
        }
        this.dTop = s.readInt();
        this.dstack = new double[this.dTop];
        for (i = 0; i < this.dTop; ++i) {
            this.dstack[i] = s.readDouble();
        }
        this.fTop = s.readInt();
        this.fstack = new float[this.fTop];
        for (i = 0; i < this.fTop; ++i) {
            this.fstack[i] = s.readFloat();
        }
        this.oTop = s.readInt();
        this.ostack = new Object[this.oTop];
        for (i = 0; i < this.oTop; ++i) {
            this.ostack[i] = s.readObject();
        }
        this.rTop = s.readInt();
        this.rstack = new Object[this.rTop];
        for (i = 0; i < this.rTop; ++i) {
            this.rstack[i] = s.readObject();
        }
        this.runnable = (Runnable)s.readObject();
    }
}

