/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.zkoss.json.JSONArray;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Expectable;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.AuWriters;
import org.zkoss.zk.au.RequestOutOfSequenceException;
import org.zkoss.zk.au.out.AuAlert;
import org.zkoss.zk.au.out.AuWrongValue;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.ActivationTimeoutException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.WrongValuesException;
import org.zkoss.zk.ui.event.CreateEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.FulfillEvent;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.ext.render.PrologAllowed;
import org.zkoss.zk.ui.impl.AbortBySendRedirect;
import org.zkoss.zk.ui.impl.CreateInfo;
import org.zkoss.zk.ui.impl.EventProcessingThreadImpl;
import org.zkoss.zk.ui.impl.EventProcessor;
import org.zkoss.zk.ui.impl.Initiators;
import org.zkoss.zk.ui.impl.PhantomExecution;
import org.zkoss.zk.ui.impl.ProxyEvent;
import org.zkoss.zk.ui.impl.UiVisualizer;
import org.zkoss.zk.ui.impl.VolatilePage;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.ForEachBranchInfo;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.PropertyNotFoundException;
import org.zkoss.zk.ui.metainfo.ShadowInfo;
import org.zkoss.zk.ui.metainfo.TemplateInfo;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.VariablesInfo;
import org.zkoss.zk.ui.metainfo.ZScriptInfo;
import org.zkoss.zk.ui.metainfo.ZkInfo;
import org.zkoss.zk.ui.sys.AbortingReason;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.PageConfig;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.RequestQueue;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.Visualizer;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.ExecutionMonitor;
import org.zkoss.zk.ui.util.ForEach;
import org.zkoss.zk.ui.util.FullComposer;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.PerformanceMeter;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zk.xel.Evaluators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiEngineImpl
implements UiEngine {
    static final Logger log = LoggerFactory.getLogger(UiEngineImpl.class);
    private WebApp _wapp;
    private final List<EventProcessingThreadImpl> _idles = new LinkedList<EventProcessingThreadImpl>();
    private final Map<Desktop, Map<Object, List<EventProcessingThreadImpl>>> _suspended = new HashMap<Desktop, Map<Object, List<EventProcessingThreadImpl>>>();
    private final Map<Desktop, List<EventProcessingThreadImpl>> _resumed = new HashMap<Desktop, List<EventProcessingThreadImpl>>();
    private int _suspCnt;
    private volatile Extension _ext;
    private static volatile Integer _retryTimeout;
    private static volatile Integer _destroyTimeout;
    private static boolean _abortSpecified;

    @Override
    public void start(WebApp wapp) {
        this._wapp = wapp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(WebApp wapp) {
        Object object;
        Map<Desktop, List<EventProcessingThreadImpl>> map = this._idles;
        synchronized (map) {
            for (EventProcessingThreadImpl eventProcessingThreadImpl : this._idles) {
                eventProcessingThreadImpl.cease("Stop application");
            }
            this._idles.clear();
        }
        map = this._suspended;
        synchronized (map) {
            for (Map map2 : this._suspended.values()) {
                object = map2;
                synchronized (object) {
                    for (List threads : map2.values()) {
                        for (EventProcessingThreadImpl thread : threads) {
                            thread.cease("Stop application");
                        }
                    }
                }
            }
            this._suspended.clear();
        }
        map = this._resumed;
        synchronized (map) {
            for (List list : this._resumed.values()) {
                object = list;
                synchronized (object) {
                    for (EventProcessingThreadImpl thread : list) {
                        thread.cease("Stop application");
                    }
                }
            }
            this._resumed.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSuspendedThread() {
        if (!this._suspended.isEmpty()) {
            Map<Desktop, Map<Object, List<EventProcessingThreadImpl>>> map = this._suspended;
            synchronized (map) {
                for (Map<Object, List<EventProcessingThreadImpl>> map2 : this._suspended.values()) {
                    if (map2.isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<EventProcessingThread> getSuspendedThreads(Desktop desktop) {
        Map<Object, List<EventProcessingThreadImpl>> map;
        Map<Desktop, Map<Object, List<EventProcessingThreadImpl>>> map2 = this._suspended;
        synchronized (map2) {
            map = this._suspended.get(desktop);
        }
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<EventProcessingThread> threads = new LinkedList<EventProcessingThread>();
        Map<Object, List<EventProcessingThreadImpl>> map3 = map;
        synchronized (map3) {
            for (List<EventProcessingThreadImpl> thds : map.values()) {
                threads.addAll(thds);
            }
        }
        return threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ceaseSuspendedThread(Desktop desktop, EventProcessingThread evtthd, String cause) {
        Map<Object, List<EventProcessingThreadImpl>> map;
        Map<Desktop, Map<Object, List<EventProcessingThreadImpl>>> map2 = this._suspended;
        synchronized (map2) {
            map = this._suspended.get(desktop);
        }
        if (map == null) {
            return false;
        }
        boolean found = false;
        Map<Object, List<EventProcessingThreadImpl>> map3 = map;
        synchronized (map3) {
            Iterator<Map.Entry<Object, List<EventProcessingThreadImpl>>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, List<EventProcessingThreadImpl>> me = it.next();
                List<EventProcessingThreadImpl> list = me.getValue();
                found = list.remove(evtthd);
                if (!found) continue;
                if (!list.isEmpty()) break;
                it.remove();
                break;
            }
        }
        if (found) {
            ((EventProcessingThreadImpl)evtthd).cease(cause);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void desktopDestroyed(Desktop desktop) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            exec = new PhantomExecution(desktop);
            boolean activated = this.activate(exec, UiEngineImpl.getDestroyTimeout());
            try {
                this.desktopDestroyed0(desktop);
                Object var5_4 = null;
                if (!activated) return;
                this.deactivate(exec);
                return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!activated) throw throwable;
                this.deactivate(exec);
                throw throwable;
            }
        } else {
            this.desktopDestroyed0(desktop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void desktopDestroyed0(Desktop desktop) {
        Object object;
        Configuration config = this._wapp.getConfiguration();
        if (!this._suspended.isEmpty()) {
            Map<Object, List<EventProcessingThreadImpl>> map;
            object = this._suspended;
            synchronized (object) {
                map = this._suspended.remove(desktop);
            }
            if (map != null) {
                object = map;
                synchronized (object) {
                    for (List list : map.values()) {
                        for (EventProcessingThreadImpl evtthd : list) {
                            evtthd.ceaseSilently("Destroy desktop " + desktop);
                            config.invokeEventThreadResumeAborts(evtthd.getComponent(), evtthd.getEvent());
                        }
                    }
                }
            }
        }
        if (!this._resumed.isEmpty()) {
            List<EventProcessingThreadImpl> list;
            object = this._resumed;
            synchronized (object) {
                list = this._resumed.remove(desktop);
            }
            if (list != null) {
                object = list;
                synchronized (object) {
                    for (EventProcessingThreadImpl eventProcessingThreadImpl : list) {
                        eventProcessingThreadImpl.ceaseSilently("Destroy desktop " + desktop);
                        config.invokeEventThreadResumeAborts(eventProcessingThreadImpl.getComponent(), eventProcessingThreadImpl.getEvent());
                    }
                }
            }
        }
        ((DesktopCtrl)((Object)desktop)).destroy();
    }

    private static UiVisualizer getCurrentVisualizer() {
        ExecutionCtrl execCtrl = ExecutionsCtrl.getCurrentCtrl();
        if (execCtrl == null) {
            throw new IllegalStateException("Components can be accessed only in event listeners");
        }
        return (UiVisualizer)execCtrl.getVisualizer();
    }

    @Override
    public Component setOwner(Component comp) {
        return UiEngineImpl.getCurrentVisualizer().setOwner(comp);
    }

    @Override
    public boolean isInvalidated(Component comp) {
        return UiEngineImpl.getCurrentVisualizer().isInvalidated(comp);
    }

    @Override
    public void addInvalidate(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addInvalidate(page);
    }

    @Override
    public void addInvalidate(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addInvalidate(comp);
    }

    @Override
    public void addSmartUpdate(Component comp, String attr, Object value, boolean append) {
        UiEngineImpl.getCurrentVisualizer().addSmartUpdate(comp, attr, value, append);
    }

    @Override
    public void addSmartUpdate(Component comp, String attr, Object value, int priority) {
        UiEngineImpl.getCurrentVisualizer().addSmartUpdate(comp, attr, value, priority);
    }

    @Override
    public void addResponse(AuResponse response) {
        UiEngineImpl.getCurrentVisualizer().addResponse(response);
    }

    @Override
    public void addResponse(String key, AuResponse response) {
        UiEngineImpl.getCurrentVisualizer().addResponse(key, response);
    }

    @Override
    public void addResponse(String key, AuResponse response, int priority) {
        UiEngineImpl.getCurrentVisualizer().addResponse(key, response, priority);
    }

    @Override
    public void addMoved(Component comp, Component oldparent, Page oldpg, Page newpg) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addMoved(comp, oldparent, oldpg, newpg);
    }

    @Override
    public void addUuidChanged(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addUuidChanged(comp);
    }

    @Override
    public boolean disableClientUpdate(Component comp, boolean disable) {
        return UiEngineImpl.getCurrentVisualizer().disableClientUpdate(comp, disable);
    }

    @Override
    public void execNewPage(Execution exec, Richlet richlet, Page page, Writer out) throws IOException {
        this.execNewPage0(exec, null, richlet, page, out);
    }

    @Override
    public void execNewPage(Execution exec, PageDefinition pagedef, Page page, Writer out) throws IOException {
        this.execNewPage0(exec, pagedef, null, page, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execNewPage0(Execution exec, PageDefinition pagedef, Richlet richlet, Page page, Writer out) throws IOException {
        block68: {
            block65: {
                block63: {
                    block64: {
                        desktop = exec.getDesktop();
                        desktopCtrl = (DesktopCtrl)desktop;
                        v0 = pagedef != null ? pagedef.getLanguageDefinition() : (langdef = richlet != null ? richlet.getLanguageDefinition() : null);
                        if (langdef != null) {
                            desktop.setDeviceType(langdef.getDeviceType());
                        }
                        startTime = (pfmeter = (config = (wapp = desktop.getWebApp()).getConfiguration()).getPerformanceMeter()) != null ? System.currentTimeMillis() : 0L;
                        oldexec = Executions.getCurrent();
                        oldexecCtrl = (ExecutionCtrl)oldexec;
                        v1 = olduv = oldexecCtrl != null ? (UiVisualizer)oldexecCtrl.getVisualizer() : null;
                        if (olduv != null) {
                            uv = UiEngineImpl.doReactivate(exec, olduv);
                            pfmeter = null;
                        } else {
                            uv = UiEngineImpl.doActivate(exec, false, false, null, -1);
                        }
                        execCtrl = (ExecutionCtrl)exec;
                        old = execCtrl.getCurrentPage();
                        olddef = execCtrl.getCurrentPageDefinition();
                        execCtrl.setCurrentPage(page);
                        execCtrl.setCurrentPageDefinition(pagedef);
                        pfReqId = pfmeter != null ? UiEngineImpl.meterLoadStart(pfmeter, exec, startTime) : null;
                        abrn = null;
                        try {
                            try {
                                config.invokeExecutionInits(exec, oldexec);
                                desktopCtrl.invokeExecutionInits(exec, oldexec);
                                if (olduv != null && (owner = olduv.getOwner()) != null) {
                                    ((PageCtrl)page).setOwner(owner);
                                }
                                if (pagedef != null) {
                                    ((PageCtrl)page).preInit();
                                    pagedef.preInit(page);
                                    inits = Initiators.doInit(pagedef, page, config.getInitiators());
                                    try {
                                        try {
                                            pagedef.init(page, uv.isEverAsyncUpdate() == false && uv.isAborting() == false);
                                            pageTemplates = pagedef.getTemplatesInfo();
                                            if (pageTemplates != null) {
                                                for (Map.Entry<String, TemplateInfo> entry : pageTemplates.entrySet()) {
                                                    page.addTemplate(entry.getKey(), new TemplateImpl(entry.getValue(), null));
                                                }
                                            }
                                            if ((uri = pagedef.getForwardURI(page)) != null) {
                                                comps = new Component[]{};
                                                try {
                                                    exec.forward(uri);
                                                    var28_33 = null;
                                                    errs = new LinkedList<Throwable>();
                                                    desktopCtrl.invokeExecutionCleanups(exec, oldexec, errs);
                                                    config.invokeExecutionCleanups(exec, oldexec, errs);
                                                }
                                                catch (Throwable var27_37) {
                                                    var28_34 = null;
                                                    errs = new LinkedList<Throwable>();
                                                    desktopCtrl.invokeExecutionCleanups(exec, oldexec, errs);
                                                    config.invokeExecutionCleanups(exec, oldexec, errs);
                                                    throw var27_37;
                                                }
                                            } else {
                                                exec.setAttribute("org.zkoss.zk.ui.page.created", Boolean.TRUE);
                                                comps = uv.isAborting() != false || exec.isVoided() != false ? new Component[]{} : UiEngineImpl.execCreate(new CreateInfo(((WebAppCtrl)wapp).getUiFactory(), exec, page, config.getComposer(page)), pagedef, null, null);
                                            }
                                            inits.doAfterCompose(page, comps);
                                            this.afterCreate(exec, comps);
                                        }
                                        catch (Throwable ex) {
                                            if (!inits.doCatch(ex)) {
                                                throw UiException.Aide.wrap(ex);
                                            }
                                            var31_38 = null;
                                            inits.doFinally();
                                        }
                                        var31_38 = null;
                                        inits.doFinally();
                                    }
                                    catch (Throwable var30_40) {
                                        var31_39 = null;
                                        inits.doFinally();
                                        throw var30_40;
                                    }
                                } else {
                                    ((PageCtrl)page).preInit();
                                    inits = Initiators.doInit(null, page, config.getInitiators());
                                    try {
                                        try {
                                            block62: {
                                                ((PageCtrl)page).init(new PageConfig(){

                                                    @Override
                                                    public String getId() {
                                                        return null;
                                                    }

                                                    @Override
                                                    public String getUuid() {
                                                        return null;
                                                    }

                                                    @Override
                                                    public String getTitle() {
                                                        return null;
                                                    }

                                                    @Override
                                                    public String getStyle() {
                                                        return null;
                                                    }

                                                    @Override
                                                    public String getViewport() {
                                                        return "auto";
                                                    }

                                                    @Override
                                                    public String getBeforeHeadTags() {
                                                        return "";
                                                    }

                                                    @Override
                                                    public String getAfterHeadTags() {
                                                        return "";
                                                    }

                                                    @Override
                                                    public Collection<Object[]> getResponseHeaders() {
                                                        return Collections.emptyList();
                                                    }
                                                });
                                                composer = config.getComposer(page);
                                                try {
                                                    try {
                                                        richlet.service(page);
                                                        for (root = page.getFirstRoot(); root != null; root = root.getNextSibling()) {
                                                            UiEngineImpl.doAfterCompose(composer, root);
                                                            this.afterCreate(exec, new Component[]{root});
                                                        }
                                                        var33_41 = null;
                                                    }
                                                    catch (Throwable t) {
                                                        if (composer instanceof ComposerExt && ((ComposerExt)composer).doCatch(t)) {
                                                            t = null;
                                                        }
                                                        if (t != null) {
                                                            throw t;
                                                        }
                                                        var33_41 = null;
                                                        if (composer instanceof ComposerExt) {
                                                            ((ComposerExt)composer).doFinally();
                                                        }
                                                        break block62;
                                                    }
                                                }
                                                catch (Throwable var32_43) {
                                                    var33_42 = null;
                                                    if (composer instanceof ComposerExt == false) throw var32_43;
                                                    ((ComposerExt)composer).doFinally();
                                                    throw var32_43;
                                                }
                                                if (composer instanceof ComposerExt) {
                                                    ((ComposerExt)composer).doFinally();
                                                }
                                            }
                                            var35_44 = null;
                                            inits.doFinally();
                                        }
                                        catch (Throwable ex) {
                                            if (!inits.doCatch(ex)) {
                                                throw UiException.Aide.wrap(ex);
                                            }
                                            var35_44 = null;
                                            inits.doFinally();
                                        }
                                    }
                                    catch (Throwable var34_46) {
                                        var35_45 = null;
                                        inits.doFinally();
                                        throw var34_46;
                                    }
                                }
                                if (exec.isVoided()) {
                                    var37_47 = null;
                                    if (abrn == null) break block63;
                                    break block64;
                                }
                                errs = new LinkedList<Throwable>();
                                event = UiEngineImpl.nextEvent(uv);
                                while (true) {
                                    if (event != null) {
                                        try {
                                            this.process(desktop, event);
                                        }
                                        catch (Throwable ex) {
                                            UiEngineImpl.handleError(ex, uv, errs);
                                        }
                                        event = UiEngineImpl.nextEvent(uv);
                                        continue;
                                    }
                                    this.resumeAll(desktop, uv, null);
                                    event = UiEngineImpl.nextEvent(uv);
                                    if (event == null) break;
                                }
                                abrn = uv.getAbortingReason();
                                if (abrn != null) {
                                    abrn.execute();
                                }
                                responses = this.getResponses(exec, uv, errs, false);
                                if (olduv != null && olduv.addToFirstAsyncUpdate(responses)) {
                                    responses = null;
                                } else {
                                    execCtrl.setResponses(responses);
                                }
                                ((PageCtrl)page).redraw(out);
                                this.afterRenderNewPage(page);
                                desktopCtrl.invokeExecutionCleanups(exec, oldexec, errs);
                                config.invokeExecutionCleanups(exec, oldexec, errs);
                                break block65;
                            }
                            catch (Throwable ex) {
                                errs = new LinkedList<Throwable>();
                                errs.add(ex);
                                desktopCtrl.invokeExecutionCleanups(exec, oldexec, errs);
                                config.invokeExecutionCleanups(exec, oldexec, errs);
                                if (!errs.isEmpty()) {
                                    ex = (Throwable)errs.get(0);
                                    if (ex instanceof IOException == false) throw UiException.Aide.wrap(ex);
                                    throw (IOException)ex;
                                }
                                var37_49 = null;
                                if (abrn != null) {
                                    try {
                                        abrn.finish();
                                    }
                                    catch (Throwable t) {
                                        UiEngineImpl.log.warn("", t);
                                    }
                                }
                                execCtrl.setCurrentPage(old);
                                execCtrl.setCurrentPageDefinition(olddef);
                                if (olduv != null) {
                                    UiEngineImpl.doDereactivate(exec, olduv);
                                } else {
                                    UiEngineImpl.doDeactivate(exec);
                                }
                                if (pfmeter == null) return;
                                UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
                                return;
                            }
                        }
                        catch (Throwable var36_55) {
                            block67: {
                                var37_50 = null;
                                if (abrn != null) {
                                    ** try [egrp 10[TRYBLOCK] [21 : 1162->1172)] { 
lbl190:
                                    // 1 sources

                                    abrn.finish();
                                    break block67;
lbl192:
                                    // 1 sources

                                    catch (Throwable t) {
                                        UiEngineImpl.log.warn("", t);
                                    }
                                }
                            }
                            execCtrl.setCurrentPage(old);
                            execCtrl.setCurrentPageDefinition(olddef);
                            if (olduv != null) {
                                UiEngineImpl.doDereactivate(exec, olduv);
                            } else {
                                UiEngineImpl.doDeactivate(exec);
                            }
                            if (pfmeter == null) throw var36_55;
                            UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
                            throw var36_55;
                        }
                    }
                    ** try [egrp 10[TRYBLOCK] [21 : 1162->1172)] { 
lbl206:
                    // 1 sources

                    abrn.finish();
                    break block63;
lbl208:
                    // 1 sources

                    catch (Throwable t) {
                        UiEngineImpl.log.warn("", t);
                    }
                }
                execCtrl.setCurrentPage(old);
                execCtrl.setCurrentPageDefinition(olddef);
                if (olduv != null) {
                    UiEngineImpl.doDereactivate(exec, olduv);
                } else {
                    UiEngineImpl.doDeactivate(exec);
                }
                if (pfmeter == null) return;
                UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
                return;
            }
            var37_48 = null;
            if (abrn != null) {
                ** try [egrp 10[TRYBLOCK] [21 : 1162->1172)] { 
lbl224:
                // 1 sources

                abrn.finish();
                break block68;
lbl226:
                // 1 sources

                catch (Throwable t) {
                    UiEngineImpl.log.warn("", t);
                }
            }
        }
        execCtrl.setCurrentPage(old);
        execCtrl.setCurrentPageDefinition(olddef);
        if (olduv != null) {
            UiEngineImpl.doDereactivate(exec, olduv);
        } else {
            UiEngineImpl.doDeactivate(exec);
        }
        if (pfmeter == null) return;
        UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
    }

    private static final void doAfterCompose(Composer composer, Component comp) throws Exception {
        if (composer != null) {
            composer.doAfterCompose(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycleDesktop(Execution exec, Page page, Writer out) throws IOException {
        PerformanceMeter pfmeter = page.getDesktop().getWebApp().getConfiguration().getPerformanceMeter();
        long startTime = pfmeter != null ? System.currentTimeMillis() : 0L;
        String pfReqId = pfmeter != null ? UiEngineImpl.meterLoadStart(pfmeter, exec, startTime) : null;
        UiVisualizer uv = UiEngineImpl.doActivate(exec, false, false, null, -1);
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        execCtrl.setCurrentPage(page);
        try {
            Events.postEvent(new Event("onDesktopRecycle"));
            LinkedList<Throwable> errs = new LinkedList<Throwable>();
            Desktop desktop = exec.getDesktop();
            if (desktop.isServerPushEnabled()) {
                ((DesktopCtrl)((Object)desktop)).getServerPush().resume();
            }
            Event event = UiEngineImpl.nextEvent(uv);
            while (true) {
                if (event != null) {
                    try {
                        this.process(desktop, event);
                    }
                    catch (Throwable ex) {
                        UiEngineImpl.handleError(ex, uv, errs);
                    }
                    event = UiEngineImpl.nextEvent(uv);
                    continue;
                }
                this.resumeAll(desktop, uv, null);
                event = UiEngineImpl.nextEvent(uv);
                if (event == null) break;
            }
            execCtrl.setResponses(this.getResponses(exec, uv, errs, false));
            ((PageCtrl)((Object)page)).redraw(out);
            Object var15_13 = null;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            UiEngineImpl.doDeactivate(exec);
            if (pfmeter != null) {
                UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
            }
            throw throwable;
        }
        UiEngineImpl.doDeactivate(exec);
        if (pfmeter != null) {
            UiEngineImpl.meterLoadServerComplete(pfmeter, pfReqId, exec);
        }
    }

    private void afterCreate(Execution exec, Component[] comps) {
        UiEngineImpl.afterCreate(exec, this.getExtension(), comps);
    }

    private static void afterCreate(Execution exec, Extension ext, Component[] comps) {
        if (ext == null) {
            ext = ((UiEngineImpl)((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiEngine()).getExtension();
        }
        ext.afterCreate(comps);
    }

    private void afterRenderNewPage(Page page) {
        this.getExtension().afterRenderNewPage(page);
    }

    protected void afterRenderComponents(Collection<Component> comps) {
        this.getExtension().afterRenderComponents(comps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extension getExtension() {
        if (this._ext == null) {
            UiEngineImpl uiEngineImpl = this;
            synchronized (uiEngineImpl) {
                if (this._ext == null) {
                    String clsnm = Library.getProperty((String)"org.zkoss.zk.ui.impl.UiEngineImpl.extension");
                    if (clsnm != null) {
                        try {
                            this._ext = (Extension)Classes.newInstanceByThread((String)clsnm);
                        }
                        catch (Throwable ex) {
                            log.error("Unable to instantiate " + clsnm, ex);
                        }
                    }
                    if (this._ext == null) {
                        this._ext = new DefaultExtension();
                    }
                }
            }
        }
        return this._ext;
    }

    private static final Event nextEvent(UiVisualizer uv) {
        Event evt = ((ExecutionCtrl)((Object)uv.getExecution())).getNextEvent();
        return evt != null && !uv.isAborting() ? evt : null;
    }

    private static final Component[] execCreate(CreateInfo ci, NodeInfo parentInfo, Component parent, Component insertBefore) {
        ComponentInfo pi;
        String fulfill;
        String fulfillURI = null;
        if (parentInfo instanceof ComponentInfo && (fulfill = (pi = (ComponentInfo)parentInfo).getFulfill()) != null && (fulfill = fulfill.trim()).length() > 0) {
            if (fulfill.charAt(0) == '=') {
                fulfillURI = fulfill.substring(1).trim();
            } else {
                new FulfillListener(fulfill, pi, parent);
                return new Component[0];
            }
        }
        Component[] cs = UiEngineImpl.execCreate0(ci, parentInfo, parent, insertBefore);
        if (fulfillURI != null && (fulfillURI = (String)Evaluators.evaluate(((ComponentInfo)parentInfo).getEvaluator(), parent, fulfillURI, String.class)) != null) {
            cs = UiEngineImpl.merge(cs, ci.exec.createComponents(fulfillURI, parent, insertBefore, null));
        }
        return cs;
    }

    private static Component[] merge(Component[] cs, Component c) {
        if (c != null) {
            cs = (Component[])ArraysX.resize((Object[])cs, (int)(cs.length + 1));
            cs[cs.length - 1] = c;
        }
        return cs;
    }

    private static final Component[] execCreate0(CreateInfo ci, NodeInfo parentInfo, Component parent, Component insertBefore) {
        LinkedList<Component> created = new LinkedList<Component>();
        Page page = ci.page;
        PageDefinition pagedef = parentInfo.getPageDefinition();
        if (!parentInfo.getChildren().isEmpty()) {
            ReplaceableText replaceableText = new ReplaceableText();
            for (NodeInfo meta : parentInfo.getChildren()) {
                Component[] children;
                ForEach forEach;
                ForEachBranchInfo childInfo;
                if (meta instanceof ComponentInfo) {
                    childInfo = (ComponentInfo)meta;
                    forEach = ((ComponentInfo)childInfo).resolveForEach(page, parent);
                    if (forEach == null) {
                        if (!UiEngineImpl.isEffective(childInfo, page, parent)) continue;
                        children = UiEngineImpl.execCreateChild(ci, parent, (ComponentInfo)childInfo, replaceableText, insertBefore);
                        Collections.addAll(created, children);
                        continue;
                    }
                    while (forEach.next()) {
                        if (!UiEngineImpl.isEffective(childInfo, page, parent)) continue;
                        children = UiEngineImpl.execCreateChild(ci, parent, (ComponentInfo)childInfo, replaceableText, insertBefore);
                        Collections.addAll(created, children);
                    }
                    continue;
                }
                if (meta instanceof ZkInfo) {
                    childInfo = (ZkInfo)meta;
                    forEach = ((ZkInfo)childInfo).resolveForEach(page, parent);
                    if (forEach == null) {
                        if (!UiEngineImpl.isEffective(childInfo, page, parent)) continue;
                        children = UiEngineImpl.execCreateChild(ci, parent, (ZkInfo)childInfo, replaceableText, insertBefore);
                        Collections.addAll(created, children);
                        continue;
                    }
                    while (forEach.next()) {
                        if (!UiEngineImpl.isEffective(childInfo, page, parent)) continue;
                        children = UiEngineImpl.execCreateChild(ci, parent, (ZkInfo)childInfo, replaceableText, insertBefore);
                        Collections.addAll(created, children);
                    }
                    continue;
                }
                if (meta instanceof TextInfo) {
                    String s = ((TextInfo)meta).getValue(parent);
                    if (s == null || s.length() <= 0) continue;
                    if (parent != null) {
                        parent.insertBefore(((Native)((Object)parent)).getHelper().newNative(s), insertBefore);
                        continue;
                    }
                    if (page != null) {
                        created.add(ci.uf.newComponent(page, null, page.getLanguageDefinition().newLabelInfo(null, s), insertBefore));
                        continue;
                    }
                    throw new UnsupportedOperationException("parent or page required for native label: " + s);
                }
                if (meta instanceof ShadowInfo) {
                    ShadowInfo shadow = (ShadowInfo)meta;
                    if (!UiEngineImpl.isEffective(shadow, page, parent)) continue;
                    Component[] children2 = UiEngineImpl.execCreateChild(ci, parent, shadow, insertBefore);
                    Collections.addAll(created, children2);
                    continue;
                }
                UiEngineImpl.execNonComponent(ci, parent, meta);
            }
        }
        return created.toArray(new Component[created.size()]);
    }

    private static Component[] execCreateChild(CreateInfo ci, Component parent, ZkInfo childInfo, ReplaceableText replaceableText, Component insertBefore) {
        return childInfo.withSwitch() ? UiEngineImpl.execSwitch(ci, childInfo, parent, insertBefore) : UiEngineImpl.execCreate0(ci, childInfo, parent, insertBefore);
    }

    private static Component[] execCreateChild(CreateInfo ci, Component parent, ShadowInfo childInfo, Component insertBefore) {
        Component[] componentArray;
        Component child;
        block5: {
            child = null;
            boolean bRoot = parent == null;
            try {
                child = ci.uf.newComponent(ci.page, parent, childInfo, insertBefore);
                childInfo.apply(child);
                UiEngineImpl.execCreate(ci, childInfo, child, null);
                if (child instanceof AfterCompose) {
                    ((AfterCompose)((Object)child)).afterCompose();
                }
            }
            catch (Throwable ex) {
                boolean ignore = ci.doCatch(ex, bRoot);
                if (ignore) break block5;
                throw UiException.Aide.wrap(ex);
            }
        }
        if (child != null) {
            Component[] componentArray2 = new Component[1];
            componentArray = componentArray2;
            componentArray2[0] = child;
        } else {
            componentArray = new Component[]{};
        }
        return componentArray;
    }

    private static Component[] execCreateChild(CreateInfo ci, Component parent, ComponentInfo childInfo, ReplaceableText replaceableText, Component insertBefore) {
        Component[] componentArray;
        Component child;
        ComponentDefinition childdef = childInfo.getComponentDefinition();
        if (childdef.isInlineMacro()) {
            if (insertBefore != null) {
                throw new UnsupportedOperationException("The inline macro doesn't support template");
            }
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("includer", parent);
            childInfo.evalProperties(props, ci.page, parent, true);
            return new Component[]{ci.exec.createComponents(childdef.getMacroURI(), parent, props)};
        }
        String rt = null;
        if (replaceableText != null) {
            if (parent == null || parent.getDefinition().isBlankPreserved()) {
                rt = replaceableText.text;
            }
            replaceableText.text = childInfo.getReplaceableText();
            if (replaceableText.text != null) {
                return new Component[0];
            }
        }
        if ((child = UiEngineImpl.execCreateChild0(ci, parent, childInfo, rt, insertBefore)) != null) {
            Component[] componentArray2 = new Component[1];
            componentArray = componentArray2;
            componentArray2[0] = child;
        } else {
            componentArray = new Component[]{};
        }
        return componentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Component execCreateChild0(CreateInfo ci, Component parent, ComponentInfo childInfo, String replaceableText, Component insertBefore) {
        Component component;
        boolean bRoot;
        boolean bPopComposer;
        ComposerExt composerExt;
        block36: {
            Component component2;
            block35: {
                Component component3;
                block34: {
                    Composer composer = childInfo.resolveComposer(ci.page, parent);
                    composerExt = null;
                    bPopComposer = false;
                    if (composer instanceof FullComposer) {
                        ci.pushFullComposer(composer);
                        bPopComposer = true;
                        composer = null;
                    } else if (composer instanceof ComposerExt) {
                        composerExt = (ComposerExt)((Object)composer);
                    }
                    Component child = null;
                    bRoot = parent == null;
                    try {
                        try {
                            boolean bNative;
                            Object xc;
                            if (composerExt != null && (childInfo = composerExt.doBeforeCompose(ci.page, parent, childInfo)) == null) {
                                component3 = null;
                                Object var14_15 = null;
                                break block34;
                            }
                            if ((childInfo = ci.doBeforeCompose(ci.page, parent, childInfo, bRoot)) == null) {
                                component2 = null;
                                break block35;
                            }
                            child = ci.uf.newComponent(ci.page, parent, childInfo, insertBefore);
                            if (replaceableText != null && (xc = ((ComponentCtrl)((Object)child)).getExtraCtrl()) instanceof PrologAllowed) {
                                ((PrologAllowed)xc).setPrologContent(replaceableText);
                            }
                            if (bNative = childInfo instanceof NativeInfo) {
                                UiEngineImpl.setProlog(ci, child, (NativeInfo)childInfo);
                            }
                            UiEngineImpl.doBeforeComposeChildren(composerExt, child);
                            ci.doBeforeComposeChildren(child, bRoot);
                            UiEngineImpl.execCreate(ci, childInfo, child, null);
                            if (bNative) {
                                UiEngineImpl.setEpilog(ci, child, (NativeInfo)childInfo);
                            }
                            if (child instanceof AfterCompose) {
                                ((AfterCompose)((Object)child)).afterCompose();
                            }
                            UiEngineImpl.doAfterCompose(composer, child);
                            ci.doAfterCompose(child, bRoot);
                            ComponentsCtrl.applyForward(child, childInfo.getForward());
                            Events.postEvent(new CreateEvent("onCreate", child, ci.exec.getArg()));
                            component = child;
                            break block36;
                        }
                        catch (Throwable ex) {
                            boolean ignore = false;
                            if (composerExt != null) {
                                try {
                                    ignore = composerExt.doCatch(ex);
                                }
                                catch (Throwable t) {
                                    log.error("Failed to invoke doCatch for " + childInfo, t);
                                }
                            }
                            if (!ignore && !(ignore = ci.doCatch(ex, bRoot))) {
                                throw UiException.Aide.wrap(ex);
                            }
                            Component component22 = child != null && child.getPage() != null ? child : null;
                            Object var14_18 = null;
                            try {
                                try {
                                    if (composerExt != null) {
                                        composerExt.doFinally();
                                    }
                                    ci.doFinally(bRoot);
                                }
                                catch (Throwable ex2) {
                                    throw UiException.Aide.wrap(ex2);
                                }
                                Object var17_26 = null;
                                if (!bPopComposer) return component22;
                                ci.popFullComposer();
                                return component22;
                            }
                            catch (Throwable throwable) {
                                Object var17_27 = null;
                                if (!bPopComposer) throw throwable;
                                ci.popFullComposer();
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        try {}
                        catch (Throwable throwable2) {
                            Object var17_29 = null;
                            if (!bPopComposer) throw throwable2;
                            ci.popFullComposer();
                            throw throwable2;
                        }
                        try {}
                        catch (Throwable ex2) {
                            throw UiException.Aide.wrap(ex2);
                        }
                        if (composerExt != null) {
                            composerExt.doFinally();
                        }
                        ci.doFinally(bRoot);
                        Object var17_28 = null;
                        if (!bPopComposer) throw throwable;
                        ci.popFullComposer();
                        throw throwable;
                    }
                }
                try {}
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    if (!bPopComposer) throw throwable;
                    ci.popFullComposer();
                    throw throwable;
                }
                try {}
                catch (Throwable ex2) {
                    throw UiException.Aide.wrap(ex2);
                }
                if (composerExt != null) {
                    composerExt.doFinally();
                }
                ci.doFinally(bRoot);
                Object var17_20 = null;
                if (!bPopComposer) return component3;
                ci.popFullComposer();
                return component3;
            }
            Object var14_16 = null;
            try {}
            catch (Throwable throwable) {
                Object var17_23 = null;
                if (!bPopComposer) throw throwable;
                ci.popFullComposer();
                throw throwable;
            }
            try {}
            catch (Throwable ex2) {
                throw UiException.Aide.wrap(ex2);
            }
            if (composerExt != null) {
                composerExt.doFinally();
            }
            ci.doFinally(bRoot);
            Object var17_22 = null;
            if (!bPopComposer) return component2;
            ci.popFullComposer();
            return component2;
        }
        Object var14_17 = null;
        try {}
        catch (Throwable throwable) {
            Object var17_25 = null;
            if (!bPopComposer) throw throwable;
            ci.popFullComposer();
            throw throwable;
        }
        try {}
        catch (Throwable ex2) {
            throw UiException.Aide.wrap(ex2);
        }
        if (composerExt != null) {
            composerExt.doFinally();
        }
        ci.doFinally(bRoot);
        Object var17_24 = null;
        if (!bPopComposer) return component;
        ci.popFullComposer();
        return component;
    }

    static void doBeforeComposeChildren(ComposerExt composerExt, Component comp) throws Exception {
        if (composerExt != null) {
            composerExt.doBeforeComposeChildren(comp);
        }
    }

    private static Component[] execSwitch(CreateInfo ci, ZkInfo switchInfo, Component parent, Component insertBefore) {
        Page page = ci.page;
        if (!switchInfo.getChildren().isEmpty()) {
            Object switchCond = switchInfo.resolveSwitch(page, parent);
            for (NodeInfo nodeInfo : switchInfo.getChildren()) {
                ZkInfo caseInfo = (ZkInfo)nodeInfo;
                ForEach forEach = caseInfo.resolveForEach(page, parent);
                if (forEach == null) {
                    if (!UiEngineImpl.isEffective(caseInfo, page, parent) || !UiEngineImpl.isCaseMatched(caseInfo, page, parent, switchCond)) continue;
                    return UiEngineImpl.execCreateChild(ci, parent, caseInfo, null, insertBefore);
                }
                LinkedList created = new LinkedList();
                while (forEach.next()) {
                    if (!UiEngineImpl.isEffective(caseInfo, page, parent) || !UiEngineImpl.isCaseMatched(caseInfo, page, parent, switchCond)) continue;
                    Component[] children = UiEngineImpl.execCreateChild(ci, parent, caseInfo, null, insertBefore);
                    Collections.addAll(created, children);
                    return created.toArray(new Component[created.size()]);
                }
            }
        }
        return new Component[0];
    }

    private static boolean isCaseMatched(ZkInfo caseInfo, Page page, Component parent, Object switchCond) {
        Object[] caseValues;
        if (!caseInfo.withCase()) {
            return true;
        }
        for (Object caseValue : caseValues = caseInfo.resolveCase(page, parent)) {
            String casev;
            int len;
            if (!(caseValue instanceof String && switchCond instanceof String && (len = (casev = (String)caseValue).length()) >= 2 && casev.charAt(0) == '/' && casev.charAt(len - 1) == '/' ? Pattern.compile(casev.substring(1, len - 1)).matcher((String)switchCond).matches() : Objects.equals((Object)switchCond, (Object)caseValue))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void execNonComponent(CreateInfo ci, Component comp, Object meta) {
        Page page = ci.page;
        if (meta instanceof AttributesInfo) {
            AttributesInfo attrs = (AttributesInfo)meta;
            if (comp != null) {
                attrs.apply(comp);
                return;
            } else {
                attrs.apply(page);
            }
            return;
        }
        if (meta instanceof TemplateInfo) {
            TemplateInfo tempInfo = (TemplateInfo)meta;
            if (!UiEngineImpl.isEffective(tempInfo, page, comp)) return;
            if (comp == null) {
                page.addTemplate(tempInfo.getName(), new TemplateImpl(tempInfo, comp));
                return;
            } else {
                comp.setTemplate(tempInfo.getName(), new TemplateImpl(tempInfo, comp));
            }
            return;
        }
        if (meta instanceof ZScriptInfo) {
            ZScriptInfo zsInfo = (ZScriptInfo)meta;
            if (!UiEngineImpl.isEffective(zsInfo, page, comp)) return;
            if (zsInfo.isDeferred()) {
                ((PageCtrl)((Object)page)).addDeferredZScript(comp, zsInfo.getZScript());
                return;
            }
            Scope scope = Scopes.beforeInterpret(comp != null ? comp : page);
            try {
                page.interpret(zsInfo.getLanguage(), zsInfo.getContent(page, comp), scope);
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                Scopes.afterInterpret();
                throw throwable;
            }
            Scopes.afterInterpret();
            return;
        }
        if (!(meta instanceof VariablesInfo)) throw new IllegalStateException(meta + " not allowed in " + comp);
        VariablesInfo vars = (VariablesInfo)meta;
        if (comp != null) {
            vars.apply(comp);
            return;
        } else {
            vars.apply(page);
        }
    }

    private static final boolean isEffective(Condition cond, Page page, Component comp) {
        return comp != null ? cond.isEffective(comp) : cond.isEffective(page);
    }

    @Override
    public Component[] createComponents(Execution exec, PageDefinition pagedef, Page page, Component parent, Component insertBefore, VariableResolver resolver, Map<?, ?> arg) {
        Component[] componentArray;
        Initiators inits;
        PageDefinition olddef;
        Page prevpg;
        Desktop desktop;
        boolean fakepg;
        ExecutionCtrl execCtrl;
        block22: {
            if (pagedef == null) {
                throw new IllegalArgumentException("pagedef");
            }
            execCtrl = (ExecutionCtrl)((Object)exec);
            if (parent != null) {
                Page ppg = parent.getPage();
                if (ppg != null) {
                    page = ppg;
                } else if (page == null) {
                    page = execCtrl.getCurrentPage();
                }
            }
            if (!execCtrl.isActivated()) {
                throw new IllegalStateException("Not activated yet");
            }
            boolean bl = fakepg = page == null;
            if (fakepg) {
                page = new VolatilePage(pagedef);
            }
            desktop = exec.getDesktop();
            WebApp wapp = desktop.getWebApp();
            prevpg = execCtrl.getCurrentPage();
            if (page != null && page != prevpg) {
                execCtrl.setCurrentPage(page);
            }
            olddef = execCtrl.getCurrentPageDefinition();
            execCtrl.setCurrentPageDefinition(pagedef);
            exec.pushArg(arg != null ? arg : Collections.EMPTY_MAP);
            if (fakepg) {
                ((PageCtrl)((Object)page)).preInit();
            }
            pagedef.preInit(page);
            inits = Initiators.doInit(pagedef, page, wapp.getConfiguration().getInitiators());
            if (resolver != null) {
                exec.addVariableResolver(resolver);
            }
            try {
                if (fakepg) {
                    pagedef.init(page, false);
                }
                Component[] comps = UiEngineImpl.execCreate(new CreateInfo(((WebAppCtrl)((Object)wapp)).getUiFactory(), exec, page, null), pagedef, parent, insertBefore);
                inits.doAfterCompose(page, comps);
                if (fakepg && parent == null) {
                    for (Component comp : comps) {
                        comp.detach();
                    }
                }
                this.afterCreate(exec, comps);
                componentArray = comps;
                Object var21_22 = null;
                if (resolver == null) break block22;
                exec.removeVariableResolver(resolver);
            }
            catch (Throwable ex) {
                try {
                    inits.doCatch(ex);
                    throw UiException.Aide.wrap(ex);
                }
                catch (Throwable throwable) {
                    block24: {
                        Object var21_23 = null;
                        if (resolver != null) {
                            exec.removeVariableResolver(resolver);
                        }
                        exec.popArg();
                        execCtrl.setCurrentPage(prevpg);
                        execCtrl.setCurrentPageDefinition(olddef);
                        inits.doFinally();
                        if (!fakepg) break block24;
                        try {
                            ((DesktopCtrl)((Object)desktop)).removePage(page);
                        }
                        catch (Throwable ex2) {
                            log.warn("", ex2);
                        }
                        ((PageCtrl)((Object)page)).destroy();
                    }
                    throw throwable;
                }
            }
        }
        exec.popArg();
        execCtrl.setCurrentPage(prevpg);
        execCtrl.setCurrentPageDefinition(olddef);
        inits.doFinally();
        if (fakepg) {
            try {
                ((DesktopCtrl)((Object)desktop)).removePage(page);
            }
            catch (Throwable ex2) {
                log.warn("", ex2);
            }
            ((PageCtrl)((Object)page)).destroy();
        }
        return componentArray;
    }

    @Override
    public void sendRedirect(String uri, String target) {
        if (uri != null && uri.length() == 0) {
            uri = null;
        }
        UiVisualizer uv = UiEngineImpl.getCurrentVisualizer();
        uv.setAbortingReason(new AbortBySendRedirect(uri != null ? uv.getExecution().encodeURL(uri) : "", target));
    }

    @Override
    public void setAbortingReason(AbortingReason aborting) {
        UiVisualizer uv = UiEngineImpl.getCurrentVisualizer();
        uv.setAbortingReason(aborting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execRecover(Execution exec, FailoverManager failover) {
        Desktop desktop = exec.getDesktop();
        Session sess = desktop.getSession();
        UiEngineImpl.doActivate(exec, false, true, null, -1);
        try {
            failover.recover(sess, exec, desktop);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            UiEngineImpl.doDeactivate(exec);
            throw throwable;
        }
        UiEngineImpl.doDeactivate(exec);
    }

    @Override
    public void beginUpdate(Execution exec) {
        UiVisualizer uv = UiEngineImpl.doActivate(exec, true, false, null, -1);
        Desktop desktop = exec.getDesktop();
        desktop.getWebApp().getConfiguration().invokeExecutionInits(exec, null);
        ((DesktopCtrl)((Object)desktop)).invokeExecutionInits(exec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void endUpdate(Execution exec) throws IOException {
        Desktop desktop = exec.getDesktop();
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)desktop);
        Configuration config = desktop.getWebApp().getConfiguration();
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        UiVisualizer uv = (UiVisualizer)execCtrl.getVisualizer();
        try {
            try {
                LinkedList<Throwable> errs = new LinkedList<Throwable>();
                Event event = UiEngineImpl.nextEvent(uv);
                while (true) {
                    if (event != null) {
                        try {
                            this.process(desktop, event);
                        }
                        catch (Throwable ex) {
                            UiEngineImpl.handleError(ex, uv, errs);
                        }
                        event = UiEngineImpl.nextEvent(uv);
                        continue;
                    }
                    this.resumeAll(desktop, uv, null);
                    event = UiEngineImpl.nextEvent(uv);
                    if (event == null) break;
                }
                desktopCtrl.piggyResponse(this.getResponses(exec, uv, errs, true), false);
                desktopCtrl.invokeExecutionCleanups(exec, null, errs);
                config.invokeExecutionCleanups(exec, null, errs);
            }
            catch (Throwable ex) {
                LinkedList<Throwable> errs = new LinkedList<Throwable>();
                errs.add(ex);
                desktopCtrl.invokeExecutionCleanups(exec, null, errs);
                config.invokeExecutionCleanups(exec, null, errs);
                if (!errs.isEmpty()) {
                    ex = (Throwable)errs.get(0);
                    if (!(ex instanceof IOException)) throw UiException.Aide.wrap(ex);
                    throw (IOException)ex;
                }
                Object var11_14 = null;
                UiEngineImpl.doDeactivate(exec);
                return;
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            UiEngineImpl.doDeactivate(exec);
            throw throwable;
        }
        UiEngineImpl.doDeactivate(exec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void execUpdate(Execution exec, List<AuRequest> requests, AuWriter out) throws IOException {
        block43: {
            AbortingReason abrn;
            Collection<String> doneReqIds;
            Monitor monitor;
            PerformanceMeter pfmeter;
            Configuration config;
            DesktopCtrl desktopCtrl;
            Desktop desktop;
            block39: {
                AuRequest request;
                if (requests == null) {
                    throw new IllegalArgumentException();
                }
                desktop = exec.getDesktop();
                desktopCtrl = (DesktopCtrl)((Object)desktop);
                config = desktop.getWebApp().getConfiguration();
                pfmeter = config.getPerformanceMeter();
                long startTime = 0L;
                if (pfmeter != null) {
                    startTime = System.currentTimeMillis();
                    UiEngineImpl.meterAuClientComplete(pfmeter, exec);
                }
                Object[] resultOfRepeat = new Object[1];
                UiVisualizer uv = UiEngineImpl.doActivate(exec, true, false, resultOfRepeat, -1);
                if (resultOfRepeat[0] != null) {
                    out.resend(resultOfRepeat[0]);
                    UiEngineImpl.doDeactivate(exec);
                    return;
                }
                monitor = config.getMonitor();
                if (monitor != null) {
                    try {
                        monitor.beforeUpdate(desktop, requests);
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                    }
                }
                String pfReqId = pfmeter != null ? UiEngineImpl.meterAuStart(pfmeter, exec, startTime) : null;
                doneReqIds = null;
                abrn = null;
                RequestQueue rque = desktopCtrl.getRequestQueue();
                rque.addRequests(requests);
                config.invokeExecutionInits(exec, null);
                desktopCtrl.invokeExecutionInits(exec, null);
                if (pfReqId != null) {
                    rque.addPerfRequestId(pfReqId);
                }
                LinkedList<Throwable> errs = new LinkedList<Throwable>();
                ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
                while ((request = rque.nextRequest()) != null) {
                    execCtrl.setCurrentPage(request.getPage());
                    try {
                        ((DesktopCtrl)((Object)desktop)).service(request, !errs.isEmpty());
                    }
                    catch (Throwable ex) {
                        UiEngineImpl.handleError(ex, uv, errs);
                    }
                    Event event = UiEngineImpl.nextEvent(uv);
                    while (true) {
                        if (event != null) {
                            try {
                                this.process(desktop, event);
                            }
                            catch (Throwable ex) {
                                UiEngineImpl.handleError(ex, uv, errs);
                            }
                            event = UiEngineImpl.nextEvent(uv);
                            continue;
                        }
                        this.resumeAll(desktop, uv, errs);
                        event = UiEngineImpl.nextEvent(uv);
                        if (event == null) break;
                    }
                }
                abrn = uv.getAbortingReason();
                if (abrn != null) {
                    abrn.execute();
                }
                List<AuResponse> responses = this.getResponses(exec, uv, errs, true);
                doneReqIds = rque.clearPerfRequestIds();
                List<AuResponse> prs = desktopCtrl.piggyResponse(null, true);
                if (prs != null) {
                    responses.addAll(0, prs);
                }
                out.writeResponseId(desktopCtrl.getResponseId(true));
                out.write(responses);
                String seqId = ((ExecutionCtrl)((Object)exec)).getRequestId();
                if (seqId != null) {
                    desktopCtrl.responseSent(seqId, out.complete());
                }
                desktopCtrl.invokeExecutionCleanups(exec, null, errs);
                config.invokeExecutionCleanups(exec, null, errs);
                Object var23_27 = null;
                if (abrn == null) break block39;
                try {
                    abrn.finish();
                }
                catch (Throwable t) {
                    log.warn("", t);
                }
            }
            if (monitor != null) {
                try {
                    monitor.afterUpdate(desktop);
                }
                catch (Throwable ex2) {
                    log.error("", ex2);
                }
            }
            UiEngineImpl.doDeactivate(exec);
            if (pfmeter != null && doneReqIds != null) {
                UiEngineImpl.meterAuServerComplete(pfmeter, doneReqIds, exec);
            }
            break block43;
            {
                catch (Throwable ex) {
                    LinkedList<Throwable> errs = new LinkedList<Throwable>();
                    errs.add(ex);
                    desktopCtrl.invokeExecutionCleanups(exec, null, errs);
                    config.invokeExecutionCleanups(exec, null, errs);
                    if (!errs.isEmpty()) {
                        ex = (Throwable)errs.get(0);
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        throw UiException.Aide.wrap(ex);
                    }
                    Object var23_28 = null;
                    if (abrn != null) {
                        try {
                            abrn.finish();
                        }
                        catch (Throwable t) {
                            log.warn("", t);
                        }
                    }
                    if (monitor != null) {
                        try {
                            monitor.afterUpdate(desktop);
                        }
                        catch (Throwable ex2) {
                            log.error("", ex2);
                        }
                    }
                    UiEngineImpl.doDeactivate(exec);
                    if (pfmeter != null && doneReqIds != null) {
                        UiEngineImpl.meterAuServerComplete(pfmeter, doneReqIds, exec);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var23_29 = null;
                if (abrn != null) {
                    try {
                        abrn.finish();
                    }
                    catch (Throwable t) {
                        log.warn("", t);
                    }
                }
                if (monitor != null) {
                    try {
                        monitor.afterUpdate(desktop);
                    }
                    catch (Throwable ex2) {
                        log.error("", ex2);
                    }
                }
                UiEngineImpl.doDeactivate(exec);
                if (pfmeter != null && doneReqIds != null) {
                    UiEngineImpl.meterAuServerComplete(pfmeter, doneReqIds, exec);
                }
                throw throwable;
            }
        }
    }

    @Override
    public Object startUpdate(Execution exec) throws IOException {
        Desktop desktop = exec.getDesktop();
        UiVisualizer uv = UiEngineImpl.doActivate(exec, true, false, null, -1);
        desktop.getWebApp().getConfiguration().invokeExecutionInits(exec, null);
        ((DesktopCtrl)((Object)desktop)).invokeExecutionInits(exec, null);
        return new UpdateInfo(uv);
    }

    @Override
    public JSONArray finishUpdate(Object ctx) throws IOException {
        UpdateInfo ui = (UpdateInfo)ctx;
        Execution exec = ui.uv.getExecution();
        Desktop desktop = exec.getDesktop();
        LinkedList<Throwable> errs = new LinkedList<Throwable>();
        Event event = UiEngineImpl.nextEvent(ui.uv);
        while (true) {
            if (event != null) {
                try {
                    this.process(desktop, event);
                }
                catch (Throwable ex) {
                    UiEngineImpl.handleError(ex, ui.uv, errs);
                }
                event = UiEngineImpl.nextEvent(ui.uv);
                continue;
            }
            this.resumeAll(desktop, ui.uv, errs);
            event = UiEngineImpl.nextEvent(ui.uv);
            if (event == null) break;
        }
        ui.abrn = ui.uv.getAbortingReason();
        if (ui.abrn != null) {
            ui.abrn.execute();
        }
        List<AuResponse> responses = this.getResponses(exec, ui.uv, errs, false);
        JSONArray rs = new JSONArray();
        for (AuResponse response : responses) {
            rs.add((Object)AuWriters.toJSON(response));
        }
        return rs;
    }

    @Override
    public void closeUpdate(Object ctx) throws IOException {
        UpdateInfo ui = (UpdateInfo)ctx;
        Execution exec = ui.uv.getExecution();
        Desktop desktop = exec.getDesktop();
        ((DesktopCtrl)((Object)desktop)).invokeExecutionCleanups(exec, null, null);
        desktop.getWebApp().getConfiguration().invokeExecutionCleanups(exec, null, null);
        if (ui.abrn != null) {
            try {
                ui.abrn.finish();
            }
            catch (Throwable t) {
                log.warn("", t);
            }
        }
        UiEngineImpl.doDeactivate(exec);
    }

    private static final void handleError(Throwable ex, UiVisualizer uv, List<Throwable> errs) {
        Throwable t = Exceptions.findCause((Throwable)ex, Expectable.class);
        if (t == null) {
            if (ex instanceof SAXException || ex instanceof PropertyNotFoundException) {
                log.error(Exceptions.getMessage((Throwable)ex));
            } else {
                log.error("", ex);
            }
        } else {
            ex = t;
            if (log.isDebugEnabled()) {
                log.debug("", Exceptions.getRealCause((Throwable)ex));
            }
        }
        if (ex instanceof WrongValueException) {
            WrongValueException wve = (WrongValueException)((Object)ex);
            Component comp = wve.getComponent();
            if (comp != null) {
                if ((wve = ((ComponentCtrl)((Object)comp)).onWrongValue(wve)) != null) {
                    Component c = wve.getComponent();
                    if (c == null) {
                        c = comp;
                    }
                    uv.addResponse(new AuWrongValue(c, Exceptions.getMessage((Throwable)((Object)wve))));
                }
                return;
            }
        } else if (ex instanceof WrongValuesException) {
            WrongValueException[] wves = ((WrongValuesException)((Object)ex)).getWrongValueExceptions();
            LinkedList<String> infs = new LinkedList<String>();
            for (WrongValueException wve1 : wves) {
                WrongValueException wve;
                Component comp = wve1.getComponent();
                if (comp == null || (wve = ((ComponentCtrl)((Object)comp)).onWrongValue(wve1)) == null) continue;
                Component c = wve.getComponent();
                if (c == null) {
                    c = comp;
                }
                infs.add(c.getUuid());
                infs.add(Exceptions.getMessage((Throwable)((Object)wve)));
            }
            uv.addResponse(new AuWrongValue(infs.toArray(new String[infs.size()])));
            return;
        }
        errs.add(ex);
    }

    private final List<AuResponse> getResponses(Execution exec, UiVisualizer uv, List<Throwable> errs, boolean bAfterRender) {
        LinkedList<AuResponse> responses;
        try {
            if (!errs.isEmpty()) {
                this.visualizeErrors(exec, uv, errs);
            }
            LinkedList<Component> renderedComps = bAfterRender ? new LinkedList<Component>() : null;
            responses = uv.getResponses(renderedComps);
            if (bAfterRender) {
                this.afterRenderComponents(renderedComps);
            }
        }
        catch (Throwable ex) {
            responses = new LinkedList<AuAlert>();
            responses.add(new AuAlert(Exceptions.getMessage((Throwable)ex)));
            log.error("", ex);
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void visualizeErrors(Execution exec, UiVisualizer uv, List<Throwable> errs) {
        String msg;
        block14: {
            StringBuffer sb = new StringBuffer(128);
            for (Throwable t : errs) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(Exceptions.getMessage((Throwable)t));
            }
            msg = sb.toString();
            Throwable err = errs.get(0);
            Desktop desktop = exec.getDesktop();
            Configuration config = desktop.getWebApp().getConfiguration();
            String location = config.getErrorPage(desktop.getDeviceType(), err);
            if (location != null) {
                try {
                    try {
                        exec.setAttribute("javax.servlet.error.message", msg);
                        exec.setAttribute("javax.servlet.error.exception", err);
                        exec.setAttribute("javax.servlet.error.exception_type", err.getClass());
                        exec.setAttribute("javax.servlet.error.status_code", new Integer(500));
                        exec.setAttribute("javax.servlet.error.error_page", location);
                        Richlet richlet = config.getRichletByPath(location);
                        if (richlet != null) {
                            richlet.service(((ExecutionCtrl)((Object)exec)).getCurrentPage());
                        } else {
                            exec.createComponents(location, null, null);
                        }
                        Event event = UiEngineImpl.nextEvent(uv);
                        while (true) {
                            if (event != null) {
                                try {
                                    this.process(desktop, event);
                                }
                                catch (SuspendNotAllowedException suspendNotAllowedException) {
                                    // empty catch block
                                }
                                event = UiEngineImpl.nextEvent(uv);
                                continue;
                            }
                            this.resumeAll(desktop, uv, null);
                            event = UiEngineImpl.nextEvent(uv);
                            if (event == null) break;
                        }
                        Object var14_14 = null;
                        exec.removeAttribute("javax.servlet.error.message");
                    }
                    catch (Throwable ex) {
                        log.error("Unable to generate custom error page, " + location, ex);
                        Object var14_15 = null;
                        exec.removeAttribute("javax.servlet.error.message");
                        exec.removeAttribute("javax.servlet.error.exception");
                        exec.removeAttribute("javax.servlet.error.exception_type");
                        exec.removeAttribute("javax.servlet.error.status_code");
                        exec.removeAttribute("javax.servlet.error.error_page");
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    exec.removeAttribute("javax.servlet.error.message");
                    exec.removeAttribute("javax.servlet.error.exception");
                    exec.removeAttribute("javax.servlet.error.exception_type");
                    exec.removeAttribute("javax.servlet.error.status_code");
                    exec.removeAttribute("javax.servlet.error.error_page");
                    throw throwable;
                }
                exec.removeAttribute("javax.servlet.error.exception");
                exec.removeAttribute("javax.servlet.error.exception_type");
                exec.removeAttribute("javax.servlet.error.status_code");
                exec.removeAttribute("javax.servlet.error.error_page");
                return;
            }
        }
        uv.addResponse(new AuAlert(msg, true));
    }

    private void process(Desktop desktop, Event event) {
        Component comp;
        if (event instanceof ProxyEvent) {
            ProxyEvent pe = (ProxyEvent)event;
            comp = pe.getRealTarget();
            event = pe.getProxiedEvent();
        } else {
            comp = event.getTarget();
        }
        if (comp != null) {
            this.processEvent(desktop, comp, event);
        } else {
            LinkedList<Component> roots = new LinkedList<Component>();
            for (Page page : desktop.getPages()) {
                roots.addAll(page.getRoots());
            }
            for (Component c : roots) {
                if (c.getPage() == null) continue;
                this.processEvent(desktop, c, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wait(Object mutex) throws InterruptedException, SuspendNotAllowedException {
        Map<Object, List<EventProcessingThreadImpl>> map;
        if (mutex == null) {
            throw new IllegalArgumentException("null mutex");
        }
        Thread thd = Thread.currentThread();
        if (!(thd instanceof EventProcessingThreadImpl)) {
            throw new UiException("This method can be called only in an event listener, not in paging loading.");
        }
        EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)thd;
        evtthd.newEventThreadSuspends(mutex);
        Execution exec = Executions.getCurrent();
        Desktop desktop = exec.getDesktop();
        this.incSuspended();
        Map<Object, Object> map2 = this._suspended;
        synchronized (map2) {
            map = this._suspended.get(desktop);
            if (map == null) {
                map = new IdentityHashMap<Object, List<EventProcessingThreadImpl>>(4);
                this._suspended.put(desktop, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            List<EventProcessingThreadImpl> list = map.get(mutex);
            if (list == null) {
                list = new LinkedList<EventProcessingThreadImpl>();
                map.put(mutex, list);
            }
            list.add(evtthd);
        }
        try {
            try {
                EventProcessingThreadImpl.doSuspend(mutex);
            }
            catch (Throwable ex) {
                Map<Object, List<EventProcessingThreadImpl>> map3 = map;
                synchronized (map3) {
                    List<EventProcessingThreadImpl> list = map.get(mutex);
                    if (list != null) {
                        list.remove(evtthd);
                        if (list.isEmpty()) {
                            map.remove(mutex);
                        }
                    }
                }
                if (ex instanceof InterruptedException) {
                    throw (InterruptedException)ex;
                }
                throw UiException.Aide.wrap(ex, "Unable to suspend " + evtthd);
            }
            Object var12_13 = null;
            this.decSuspended();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.decSuspended();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incSuspended() {
        int v = this._wapp.getConfiguration().getMaxSuspendedThreads();
        UiEngineImpl uiEngineImpl = this;
        synchronized (uiEngineImpl) {
            if (v >= 0 && this._suspCnt >= v) {
                throw new SuspendNotAllowedException(MZk.TOO_MANY_SUSPENDED);
            }
            ++this._suspCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decSuspended() {
        UiEngineImpl uiEngineImpl = this;
        synchronized (uiEngineImpl) {
            --this._suspCnt;
        }
    }

    @Override
    public void notify(Object mutex) {
        this.notify(Executions.getCurrent().getDesktop(), mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Desktop desktop, Object mutex) {
        EventProcessingThreadImpl evtthd;
        Map<Object, List<EventProcessingThreadImpl>> map;
        if (desktop == null || mutex == null) {
            throw new IllegalArgumentException("desktop and mutex cannot be null");
        }
        Map<Desktop, Map<Object, List<EventProcessingThreadImpl>>> map2 = this._suspended;
        synchronized (map2) {
            map = this._suspended.get(desktop);
        }
        if (map == null) {
            return;
        }
        Map<Object, List<EventProcessingThreadImpl>> map3 = map;
        synchronized (map3) {
            List<EventProcessingThreadImpl> list = map.get(mutex);
            if (list == null) {
                return;
            }
            evtthd = list.remove(0);
            if (list.isEmpty()) {
                map.remove(mutex);
            }
        }
        this.addResumed(desktop, evtthd);
    }

    @Override
    public void notifyAll(Object mutex) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new UiException("resume can be called only in processing a request");
        }
        this.notifyAll(exec.getDesktop(), mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAll(Desktop desktop, Object mutex) {
        List<EventProcessingThreadImpl> list;
        Map<Object, List<EventProcessingThreadImpl>> map;
        if (desktop == null || mutex == null) {
            throw new IllegalArgumentException("desktop and mutex cannot be null");
        }
        Map<Desktop, Map<Object, List<EventProcessingThreadImpl>>> map2 = this._suspended;
        synchronized (map2) {
            map = this._suspended.get(desktop);
        }
        if (map == null) {
            return;
        }
        Map<Object, List<EventProcessingThreadImpl>> map3 = map;
        synchronized (map3) {
            list = map.remove(mutex);
        }
        if (list == null) {
            return;
        }
        for (EventProcessingThreadImpl thread : list) {
            this.addResumed(desktop, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResumed(Desktop desktop, EventProcessingThreadImpl evtthd) {
        List<EventProcessingThreadImpl> list;
        Object object = this._resumed;
        synchronized (object) {
            list = this._resumed.get(desktop);
            if (list == null) {
                list = new LinkedList<EventProcessingThreadImpl>();
                this._resumed.put(desktop, list);
            }
        }
        object = list;
        synchronized (object) {
            list.add(evtthd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeAll(Desktop desktop, UiVisualizer uv, List<Throwable> errs) {
        while (!this._resumed.isEmpty()) {
            List<EventProcessingThreadImpl> list;
            Object object = this._resumed;
            synchronized (object) {
                list = this._resumed.remove(desktop);
                if (list == null) {
                    return;
                }
            }
            object = list;
            synchronized (object) {
                for (EventProcessingThreadImpl evtthd : list) {
                    if (uv.isAborting()) {
                        evtthd.ceaseSilently("Resume aborted");
                        continue;
                    }
                    try {
                        if (!evtthd.doResume()) continue;
                        this.recycleEventThread(evtthd);
                    }
                    catch (Throwable ex) {
                        this.recycleEventThread(evtthd);
                        if (errs == null) {
                            log.error("Unable to resume " + evtthd, ex);
                            throw UiException.Aide.wrap(ex);
                        }
                        UiEngineImpl.handleError(ex, uv, errs);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processEvent(Desktop desktop, Component comp, Event event) {
        Configuration config = desktop.getWebApp().getConfiguration();
        if (config.isEventThreadEnabled()) {
            EventProcessingThreadImpl evtthd = null;
            List<EventProcessingThreadImpl> list = this._idles;
            // MONITORENTER : list
            while (!this._idles.isEmpty() && evtthd == null) {
                evtthd = this._idles.remove(0);
                if (!evtthd.isCeased()) continue;
                evtthd = null;
            }
            // MONITOREXIT : list
            if (evtthd == null) {
                evtthd = new EventProcessingThreadImpl();
            }
            try {
                if (!evtthd.processEvent(desktop, comp, event)) return;
                this.recycleEventThread(evtthd);
                return;
            }
            catch (Throwable ex) {
                this.recycleEventThread(evtthd);
                throw UiException.Aide.wrap(ex);
            }
        }
        EventProcessor proc = new EventProcessor(desktop, comp, event);
        List<EventThreadCleanup> cleanups = null;
        LinkedList<Throwable> errs = null;
        try {
            block15: {
                try {
                    List<EventThreadInit> inits = config.newEventThreadInits(comp, event);
                    EventProcessor.inEventListener(true);
                    if (!config.invokeEventThreadInits(inits, comp, event)) break block15;
                    proc.process();
                }
                catch (Throwable ex) {
                    errs = new LinkedList<Throwable>();
                    errs.add(ex);
                    cleanups = config.newEventThreadCleanups(comp, event, errs, false);
                    if (!errs.isEmpty()) {
                        throw UiException.Aide.wrap((Throwable)errs.get(0));
                    }
                    Object var10_14 = null;
                    EventProcessor.inEventListener(false);
                    if (errs == null) {
                        cleanups = config.newEventThreadCleanups(comp, event, null, false);
                    }
                    config.invokeEventThreadCompletes(cleanups, comp, event, errs, false);
                    return;
                }
            }
            Object var10_13 = null;
            EventProcessor.inEventListener(false);
            if (errs == null) {
                cleanups = config.newEventThreadCleanups(comp, event, null, false);
            }
            config.invokeEventThreadCompletes(cleanups, comp, event, errs, false);
            return;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            EventProcessor.inEventListener(false);
            if (errs == null) {
                cleanups = config.newEventThreadCleanups(comp, event, null, false);
            }
            config.invokeEventThreadCompletes(cleanups, comp, event, errs, false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleEventThread(EventProcessingThreadImpl evtthd) {
        if (!evtthd.isCeased()) {
            if (evtthd.isIdle()) {
                int max = this._wapp.getConfiguration().getMaxSpareThreads();
                List<EventProcessingThreadImpl> list = this._idles;
                synchronized (list) {
                    if (max < 0 || this._idles.size() < max) {
                        this._idles.add(evtthd);
                        return;
                    }
                }
            }
            evtthd.ceaseSilently("Recycled");
        }
    }

    @Override
    public void activate(Execution exec) {
        this.activate(exec, -1);
    }

    @Override
    public boolean activate(Execution exec, int timeout) {
        return UiEngineImpl.doActivate(exec, false, false, null, timeout) != null;
    }

    @Override
    public void deactivate(Execution exec) {
        UiEngineImpl.doDeactivate(exec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UiVisualizer doActivate(Execution exec, boolean asyncupd, boolean recovering, Object[] resultOfRepeat, int timeout) {
        UiVisualizer uv;
        if (Executions.getCurrent() != null) {
            throw new IllegalStateException("Use doReactivate instead");
        }
        Desktop desktop = exec.getDesktop();
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)desktop);
        Session sess = desktop.getSession();
        ExecutionMonitor execmon = desktop.getWebApp().getConfiguration().getExecutionMonitor();
        String seqId = resultOfRepeat != null ? ((ExecutionCtrl)((Object)exec)).getRequestId() : null;
        Object uvlock = desktopCtrl.getActivationLock();
        int tmout = timeout >= 0 ? timeout : UiEngineImpl.getRetryTimeout();
        Object object = uvlock;
        synchronized (object) {
            boolean tried = false;
            while (true) {
                String oldSeqId;
                if (!desktop.isAlive()) {
                    throw new DesktopUnavailableException("Unable to activate destroyed desktop, " + desktop);
                }
                Visualizer old = desktopCtrl.getVisualizer();
                if (old == null) break;
                if (tried) {
                    if (timeout >= 0) {
                        return null;
                    }
                    if (_abortSpecified) {
                        throw new ActivationTimeoutException("Aborted activation because of timeout, " + tmout + "ms.");
                    }
                }
                if (seqId != null && (oldSeqId = ((ExecutionCtrl)((Object)old.getExecution())).getRequestId()) != null && !oldSeqId.equals(seqId)) {
                    throw new RequestOutOfSequenceException(seqId, oldSeqId);
                }
                if (execmon != null) {
                    execmon.executionWait(exec, desktop);
                }
                try {
                    uvlock.wait(tmout);
                    tried = true;
                }
                catch (InterruptedException ex) {
                    if (execmon != null) {
                        execmon.executionAbort(exec, desktop, ex);
                    }
                    throw UiException.Aide.wrap(ex);
                }
            }
            uv = new UiVisualizer(exec, asyncupd, recovering);
            desktopCtrl.setVisualizer(uv);
            desktopCtrl.setExecution(exec);
        }
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        ExecutionsCtrl.setCurrent(exec);
        try {
            execCtrl.onActivate();
        }
        catch (Throwable ex) {
            ExecutionsCtrl.setCurrent(null);
            Object object2 = uvlock;
            synchronized (object2) {
                desktopCtrl.setVisualizer(null);
                desktopCtrl.setExecution(null);
                uvlock.notify();
            }
            if (execmon != null) {
                execmon.executionAbort(exec, desktop, ex);
            }
            throw UiException.Aide.wrap(ex);
        }
        if (seqId != null) {
            if (log.isDebugEnabled()) {
                Object req = exec.getNativeRequest();
                log.debug("replicate request, SID: " + seqId + (req instanceof ServletRequest ? "\n" + Servlets.getDetail((ServletRequest)((ServletRequest)req)) : ""));
            }
            resultOfRepeat[0] = desktopCtrl.getLastResponse(seqId);
        }
        if (execmon != null) {
            execmon.executionActivate(exec, desktop);
        }
        return uv;
    }

    private static final int getRetryTimeout() {
        if (_retryTimeout == null) {
            int v = 0;
            String s = Library.getProperty((String)"org.zkoss.zk.ui.activate.wait.retry.timeout");
            if (s != null) {
                try {
                    v = Integer.parseInt(s);
                    if (v > 0 && "true".equals(Library.getProperty((String)"org.zkoss.zk.ui.activate.wait.retry.abort"))) {
                        _abortSpecified = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            _retryTimeout = new Integer(v > 0 ? v : 120000);
        }
        return _retryTimeout;
    }

    private static final int getDestroyTimeout() {
        if (_destroyTimeout == null) {
            int v = 0;
            String s = Library.getProperty((String)"org.zkoss.zk.ui.activate.wait.destroy.timeout");
            if (s != null) {
                try {
                    v = Integer.parseInt(s);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            _destroyTimeout = new Integer(v > 0 ? v : 20000);
        }
        return _destroyTimeout;
    }

    private static final boolean isRecovering(Desktop desktop) {
        Execution exec = desktop.getExecution();
        return exec != null && ((ExecutionCtrl)((Object)exec)).isRecovering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doDeactivate(Execution exec) {
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        Desktop desktop = exec.getDesktop();
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)desktop);
        try {
            Object uvlock;
            try {
                execCtrl.onBeforeDeactivate();
            }
            catch (Throwable ex) {
                log.warn("Failed to be deactiving", ex);
            }
            Object object = uvlock = desktopCtrl.getActivationLock();
            synchronized (object) {
                desktopCtrl.setVisualizer(null);
                desktopCtrl.setExecution(null);
                uvlock.notify();
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                execCtrl.onDeactivate();
            }
            catch (Throwable ex) {
                log.warn("Failed to deactive", ex);
            }
            ExecutionsCtrl.setCurrent(null);
            execCtrl.setCurrentPage(null);
            ExecutionMonitor execmon = desktop.getWebApp().getConfiguration().getExecutionMonitor();
            if (execmon != null) {
                execmon.executionDeactivate(exec, desktop);
            }
            throw throwable;
        }
        try {
            execCtrl.onDeactivate();
        }
        catch (Throwable ex) {
            log.warn("Failed to deactive", ex);
        }
        ExecutionsCtrl.setCurrent(null);
        execCtrl.setCurrentPage(null);
        ExecutionMonitor execmon = desktop.getWebApp().getConfiguration().getExecutionMonitor();
        if (execmon != null) {
            execmon.executionDeactivate(exec, desktop);
        }
        SessionCtrl sessCtrl = (SessionCtrl)((Object)desktop.getSession());
        if (sessCtrl.isInvalidated()) {
            sessCtrl.invalidateNow();
        }
    }

    private static UiVisualizer doReactivate(Execution curExec, UiVisualizer olduv) {
        Desktop desktop = curExec.getDesktop();
        Session sess = desktop.getSession();
        assert (olduv.getExecution().getDesktop() == desktop) : "old dt: " + olduv.getExecution().getDesktop() + ", new:" + desktop;
        UiVisualizer uv = new UiVisualizer(olduv, curExec);
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)desktop);
        desktopCtrl.setVisualizer(uv);
        desktopCtrl.setExecution(curExec);
        ExecutionCtrl curCtrl = (ExecutionCtrl)((Object)curExec);
        ExecutionsCtrl.setCurrent(curExec);
        try {
            curCtrl.onActivate();
        }
        catch (Throwable ex) {
            ExecutionsCtrl.setCurrent(olduv.getExecution());
            desktopCtrl.setVisualizer(olduv);
            desktopCtrl.setExecution(olduv.getExecution());
            throw UiException.Aide.wrap(ex);
        }
        return uv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDereactivate(Execution curExec, UiVisualizer olduv) {
        if (olduv == null) {
            throw new IllegalArgumentException("null");
        }
        ExecutionCtrl curCtrl = (ExecutionCtrl)((Object)curExec);
        Execution oldexec = olduv.getExecution();
        try {
            Desktop desktop = curExec.getDesktop();
            try {
                curCtrl.onDeactivate();
            }
            catch (Throwable ex) {
                log.warn("Failed to deactive", ex);
            }
            DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)desktop);
            desktopCtrl.setVisualizer(olduv);
            desktopCtrl.setExecution(oldexec);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ExecutionsCtrl.setCurrent(oldexec);
            curCtrl.setCurrentPage(null);
            throw throwable;
        }
        ExecutionsCtrl.setCurrent(oldexec);
        curCtrl.setCurrentPage(null);
    }

    private static final void setProlog(CreateInfo ci, Component comp, NativeInfo compInfo) {
        NativeInfo splitInfo;
        Native nc = (Native)((Object)comp);
        Native.Helper helper = nc.getHelper();
        StringBuffer sb = null;
        List<NodeInfo> prokids = compInfo.getPrologChildren();
        if (!prokids.isEmpty()) {
            sb = new StringBuffer(256);
            UiEngineImpl.getNativeContent(ci, sb, comp, prokids, helper);
        }
        if ((splitInfo = compInfo.getSplitChild()) != null && splitInfo.isEffective(comp)) {
            if (sb == null) {
                sb = new StringBuffer(256);
            }
            UiEngineImpl.getNativeFirstHalf(ci, sb, comp, splitInfo, helper);
        }
        if (sb != null && sb.length() > 0) {
            nc.setPrologContent(sb.insert(0, nc.getPrologContent()).toString());
        }
    }

    private static final void setEpilog(CreateInfo ci, Component comp, NativeInfo compInfo) {
        List<NodeInfo> epikids;
        Native nc = (Native)((Object)comp);
        Native.Helper helper = nc.getHelper();
        StringBuffer sb = null;
        NativeInfo splitInfo = compInfo.getSplitChild();
        if (splitInfo != null && splitInfo.isEffective(comp)) {
            sb = new StringBuffer(256);
            UiEngineImpl.getNativeSecondHalf(ci, sb, comp, splitInfo, helper);
        }
        if (!(epikids = compInfo.getEpilogChildren()).isEmpty()) {
            if (sb == null) {
                sb = new StringBuffer(256);
            }
            UiEngineImpl.getNativeContent(ci, sb, comp, epikids, helper);
        }
        if (sb != null && sb.length() > 0) {
            nc.setEpilogContent(sb.append(nc.getEpilogContent()).toString());
        }
    }

    @Override
    public String getNativeContent(Component comp, List<NodeInfo> children, Native.Helper helper) {
        StringBuffer sb = new StringBuffer(256);
        UiEngineImpl.getNativeContent(new CreateInfo(((WebAppCtrl)((Object)this._wapp)).getUiFactory(), Executions.getCurrent(), comp.getPage(), null), sb, comp, children, helper);
        return sb.toString();
    }

    private static final void getNativeContent(CreateInfo ci, StringBuffer sb, Component comp, List<NodeInfo> children, Native.Helper helper) {
        for (NodeInfo meta : children) {
            ForEach forEach;
            if (meta instanceof NativeInfo) {
                NativeInfo childInfo = (NativeInfo)meta;
                forEach = childInfo.resolveForEach(ci.page, comp);
                if (forEach == null) {
                    if (!childInfo.isEffective(comp)) continue;
                    UiEngineImpl.getNativeFirstHalf(ci, sb, comp, childInfo, helper);
                    UiEngineImpl.getNativeSecondHalf(ci, sb, comp, childInfo, helper);
                    continue;
                }
                while (forEach.next()) {
                    if (!childInfo.isEffective(comp)) continue;
                    UiEngineImpl.getNativeFirstHalf(ci, sb, comp, childInfo, helper);
                    UiEngineImpl.getNativeSecondHalf(ci, sb, comp, childInfo, helper);
                }
                continue;
            }
            if (meta instanceof TextInfo) {
                String s = ((TextInfo)meta).getValue(comp);
                if (s == null) continue;
                helper.appendText(sb, s);
                continue;
            }
            if (meta instanceof ZkInfo) {
                ZkInfo zkInfo = (ZkInfo)meta;
                if (zkInfo.withSwitch()) {
                    throw new UnsupportedOperationException("<zk switch> in native not allowed yet");
                }
                forEach = zkInfo.resolveForEach(ci.page, comp);
                if (forEach == null) {
                    if (!UiEngineImpl.isEffective(zkInfo, ci.page, comp)) continue;
                    UiEngineImpl.getNativeContent(ci, sb, comp, zkInfo.getChildren(), helper);
                    continue;
                }
                while (forEach.next()) {
                    if (!UiEngineImpl.isEffective(zkInfo, ci.page, comp)) continue;
                    UiEngineImpl.getNativeContent(ci, sb, comp, zkInfo.getChildren(), helper);
                }
                continue;
            }
            UiEngineImpl.execNonComponent(ci, comp, meta);
        }
    }

    private static final void getNativeFirstHalf(CreateInfo ci, StringBuffer sb, Component comp, NativeInfo childInfo, Native.Helper helper) {
        NativeInfo splitInfo;
        helper.getFirstHalf(sb, childInfo.getTag(), UiEngineImpl.evalProperties(comp, childInfo.getProperties()), childInfo.getDeclaredNamespaces());
        List<NodeInfo> prokids = childInfo.getPrologChildren();
        if (!prokids.isEmpty()) {
            UiEngineImpl.getNativeContent(ci, sb, comp, prokids, helper);
        }
        if ((splitInfo = childInfo.getSplitChild()) != null && splitInfo.isEffective(comp)) {
            UiEngineImpl.getNativeFirstHalf(ci, sb, comp, splitInfo, helper);
        }
    }

    private static final void getNativeSecondHalf(CreateInfo ci, StringBuffer sb, Component comp, NativeInfo childInfo, Native.Helper helper) {
        List<NodeInfo> epikids;
        NativeInfo splitInfo = childInfo.getSplitChild();
        if (splitInfo != null && splitInfo.isEffective(comp)) {
            UiEngineImpl.getNativeSecondHalf(ci, sb, comp, splitInfo, helper);
        }
        if (!(epikids = childInfo.getEpilogChildren()).isEmpty()) {
            UiEngineImpl.getNativeContent(ci, sb, comp, epikids, helper);
        }
        helper.getSecondHalf(sb, childInfo.getTag());
    }

    private static final Map<String, Object> evalProperties(Component comp, List<Property> props) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(props.size() * 2);
        for (Property prop : props) {
            if (!prop.isEffective(comp)) continue;
            map.put(prop.getName(), Classes.coerce(String.class, (Object)prop.getValue(comp)));
        }
        return map;
    }

    private static void meterAuClientComplete(PerformanceMeter pfmeter, Execution exec) {
        String hdr = exec.getHeader("ZK-Client-Receive");
        if (hdr != null) {
            UiEngineImpl.meterAuClient(pfmeter, exec, hdr, false);
        }
        if ((hdr = exec.getHeader("ZK-Client-Complete")) != null) {
            UiEngineImpl.meterAuClient(pfmeter, exec, hdr, true);
        }
    }

    private static void meterAuClient(PerformanceMeter pfmeter, Execution exec, String hdr, boolean complete) {
        int j = 0;
        while (true) {
            int k;
            block9: {
                String ids;
                int x;
                if ((x = (ids = (k = hdr.indexOf(44, j)) >= 0 ? hdr.substring(j, k) : (j == 0 ? hdr : hdr.substring(j))).lastIndexOf(61)) > 0) {
                    try {
                        long time = Long.parseLong(ids.substring(x + 1));
                        ids = ids.substring(0, x);
                        int y = 0;
                        while (true) {
                            String pfReqId;
                            int z;
                            String string = (z = ids.indexOf(32, y)) >= 0 ? ids.substring(y, z) : (pfReqId = y == 0 ? ids : ids.substring(y));
                            if (complete) {
                                pfmeter.requestCompleteAtClient(pfReqId, exec, time);
                            } else {
                                pfmeter.requestReceiveAtClient(pfReqId, exec, time);
                            }
                            if (z >= 0) {
                                y = z + 1;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (NumberFormatException ex) {
                        log.warn("Ingored: unable to parse " + ids);
                    }
                    catch (Throwable ex) {
                        if (!complete) break block9;
                        log.warn("Ingored: failed to invoke " + pfmeter, ex);
                    }
                }
            }
            if (k < 0) break;
            j = k + 1;
        }
    }

    private static String meterAuStart(PerformanceMeter pfmeter, Execution exec, long startTime) {
        int j;
        String hdr = exec.getHeader("ZK-Client-Start");
        if (hdr != null && (j = hdr.lastIndexOf(61)) > 0) {
            String pfReqId = hdr.substring(0, j);
            try {
                pfmeter.requestStartAtClient(pfReqId, exec, Long.parseLong(hdr.substring(j + 1)));
                pfmeter.requestStartAtServer(pfReqId, exec, startTime);
            }
            catch (NumberFormatException ex) {
                log.warn("Ingored: failed to parse ZK-Client-Start, " + hdr);
            }
            catch (Throwable ex) {
                log.warn("Ingored: failed to invoke " + pfmeter, ex);
            }
            return pfReqId;
        }
        return null;
    }

    private static void meterAuServerComplete(PerformanceMeter pfmeter, Collection<String> pfReqIds, Execution exec) {
        StringBuffer sb = new StringBuffer(256);
        long time = System.currentTimeMillis();
        for (String pfReqId : pfReqIds) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(pfReqId);
            try {
                pfmeter.requestCompleteAtServer(pfReqId, exec, time);
            }
            catch (Throwable ex) {
                log.warn("Ingored: failed to invoke " + pfmeter, ex);
            }
        }
        exec.setResponseHeader("ZK-Client-Complete", sb.toString());
    }

    private static String meterLoadStart(PerformanceMeter pfmeter, Execution exec, long startTime) {
        String pfReqId = exec.getDesktop().getId();
        try {
            pfmeter.requestStartAtServer(pfReqId, exec, startTime);
        }
        catch (Throwable ex) {
            log.warn("Ingored: failed to invoke " + pfmeter, ex);
        }
        return pfReqId;
    }

    private static void meterLoadServerComplete(PerformanceMeter pfmeter, String pfReqId, Execution exec) {
        try {
            pfmeter.requestCompleteAtServer(pfReqId, exec, System.currentTimeMillis());
        }
        catch (Throwable ex) {
            log.warn("Ingored: failed to invoke " + pfmeter, ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultExtension
    implements Extension {
        private DefaultExtension() {
        }

        @Override
        public void afterCreate(Component[] comps) {
        }

        @Override
        public void afterRenderNewPage(Page page) {
        }

        @Override
        public void afterRenderComponents(Collection<Component> comps) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Extension {
        public void afterCreate(Component[] var1);

        public void afterRenderNewPage(Page var1);

        public void afterRenderComponents(Collection<Component> var1);
    }

    private static class ReplaceableText {
        private String text;

        private ReplaceableText() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FulfillListener
    implements EventListener<Event>,
    Serializable,
    Cloneable,
    ComponentCloneListener {
        private String[] _evtnms;
        private Component[] _targets;
        private Component _comp;
        private final ComponentInfo _compInfo;
        private final String _fulfill;
        private transient String _uri;

        private FulfillListener(String fulfill, ComponentInfo compInfo, Component comp) {
            this._fulfill = fulfill;
            this._compInfo = compInfo;
            this._comp = comp;
            this.init();
            int j = this._targets.length;
            while (--j >= 0) {
                this._targets[j].addEventListener(10000, this._evtnms[j], this);
            }
        }

        private void init() {
            int k;
            this._uri = null;
            LinkedList<Object[]> results = new LinkedList<Object[]>();
            int j = 0;
            int len = this._fulfill.length();
            do {
                String sub;
                int elcnt = 0;
                for (k = j; k < len; ++k) {
                    char cc = this._fulfill.charAt(k);
                    if (elcnt == 0) {
                        if (cc == ',') break;
                        if (cc != '=') continue;
                        this._uri = this._fulfill.substring(k + 1).trim();
                        break;
                    }
                    if (cc == '{') {
                        ++elcnt;
                        continue;
                    }
                    if (cc != '}' || elcnt <= 0) continue;
                    --elcnt;
                }
                if ((sub = (k >= 0 ? this._fulfill.substring(j, k) : this._fulfill.substring(j)).trim()).length() <= 0) continue;
                results.add(ComponentsCtrl.parseEventExpression(this._comp, sub, this._comp, false));
            } while (this._uri == null && k >= 0 && (j = k + 1) < len);
            j = results.size();
            this._targets = new Component[j];
            this._evtnms = new String[j];
            j = 0;
            for (Object[] result : results) {
                this._targets[j] = (Component)result[0];
                this._evtnms[j] = (String)result[1];
                ++j;
            }
        }

        @Override
        public void onEvent(Event evt) throws Exception {
            String uri;
            int j = this._targets.length;
            while (--j >= 0) {
                this._targets[j].removeEventListener(this._evtnms[j], this);
            }
            Execution exec = Executions.getCurrent();
            UiEngineImpl.execCreate0(new CreateInfo(((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiFactory(), exec, this._comp.getPage(), null), this._compInfo, this._comp, null);
            if (this._uri != null && (uri = (String)Evaluators.evaluate(this._compInfo.getEvaluator(), this._comp, this._uri, String.class)) != null) {
                exec.createComponents(uri, this._comp, null);
            }
            Events.sendEvent(new FulfillEvent("onFulfill", this._comp, evt));
        }

        @Override
        public Object willClone(Component comp) {
            FulfillListener clone;
            try {
                clone = (FulfillListener)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
            clone._comp = comp;
            clone.init();
            return clone;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TemplateImpl
    implements Template,
    Serializable {
        private final TemplateInfo _tempInfo;
        private final Map<String, Object> _params;
        private final String _src;

        private TemplateImpl(TemplateInfo tempInfo, Component comp) {
            this._tempInfo = tempInfo;
            this._params = tempInfo.resolveParameters(comp);
            this._src = tempInfo.getSrc(comp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component[] create(Component parent, Component insertBefore, VariableResolver resolver, Composer composer) {
            Component[] cs;
            Execution exec;
            block12: {
                boolean fakepg;
                exec = Executions.getCurrent();
                ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
                if (resolver != null) {
                    exec.addVariableResolver(resolver);
                }
                Page prevPage = null;
                Page page = parent != null ? parent.getPage() : null;
                boolean bl = fakepg = page == null;
                if (fakepg) {
                    prevPage = execCtrl.getCurrentPage();
                    page = new VolatilePage(prevPage);
                    ((PageCtrl)((Object)page)).preInit();
                    execCtrl.setCurrentPage(page);
                }
                try {
                    cs = UiEngineImpl.execCreate0(new CreateInfo(((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiFactory(), exec, page, composer), this._tempInfo, parent, insertBefore);
                    if (fakepg && parent == null) {
                        for (Component c : cs) {
                            c.detach();
                        }
                    }
                    UiEngineImpl.afterCreate(exec, null, cs);
                    Object var16_15 = null;
                    if (!fakepg) break block12;
                    execCtrl.setCurrentPage(prevPage);
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    if (fakepg) {
                        execCtrl.setCurrentPage(prevPage);
                        try {
                            ((DesktopCtrl)((Object)exec.getDesktop())).removePage(page);
                        }
                        catch (Throwable ex) {
                            log.warn("", ex);
                        }
                        ((PageCtrl)((Object)page)).destroy();
                    }
                    if (resolver != null) {
                        exec.removeVariableResolver(resolver);
                    }
                    throw throwable;
                }
                try {
                    ((DesktopCtrl)((Object)exec.getDesktop())).removePage(page);
                }
                catch (Throwable ex) {
                    log.warn("", ex);
                }
                ((PageCtrl)((Object)page)).destroy();
            }
            if (resolver != null) {
                exec.removeVariableResolver(resolver);
            }
            Component c2 = this._src != null ? exec.createComponents(this._src, parent, insertBefore, resolver) : null;
            return UiEngineImpl.merge(cs, c2);
        }

        @Override
        public Map<String, Object> getParameters() {
            return this._params;
        }
    }

    private static class UpdateInfo {
        private final UiVisualizer uv;
        private AbortingReason abrn;

        private UpdateInfo(UiVisualizer uv) {
            this.uv = uv;
        }
    }
}

