/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Cell
extends XulElement {
    private AuxInfo _auxinf;

    public String getAlign() {
        return this._auxinf != null ? this._auxinf.align : null;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this.getAlign(), (Object)align)) {
            this.initAuxInfo().align = align;
            this.smartUpdate("align", this.getAlign());
        }
    }

    public String getValign() {
        return this._auxinf != null ? this._auxinf.valign : null;
    }

    public void setValign(String valign) {
        if (!Objects.equals((Object)this.getValign(), (Object)valign)) {
            this.initAuxInfo().valign = valign;
            this.smartUpdate("valign", this.getValign());
        }
    }

    public int getColspan() {
        return this._auxinf != null ? this._auxinf.colspan : 1;
    }

    public void setColspan(int colspan) throws WrongValueException {
        if (colspan <= 0) {
            throw new WrongValueException("Positive only");
        }
        if (this.getColspan() != colspan) {
            this.initAuxInfo().colspan = colspan;
            this.smartUpdate("colspan", this.getColspan());
        }
    }

    public int getRowspan() {
        return this._auxinf != null ? this._auxinf.rowspan : 1;
    }

    public void setRowspan(int rowspan) throws WrongValueException {
        if (rowspan <= 0) {
            throw new WrongValueException("Positive only");
        }
        if (this.getRowspan() != rowspan) {
            this.initAuxInfo().rowspan = rowspan;
            this.smartUpdate("rowspan", this.getRowspan());
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-cell" : this._zclass;
    }

    public Object clone() {
        Cell clone = (Cell)((Object)super.clone());
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this.getColspan() != 1) {
            renderer.render("colspan", this.getColspan());
        }
        if (this.getRowspan() != 1) {
            renderer.render("rowspan", this.getRowspan());
        }
        renderer.render("align", this.getAlign());
        renderer.render("valign", this.getValign());
    }

    private AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String align = null;
        private String valign = null;
        private int colspan = 1;
        private int rowspan = 1;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

