/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;
import org.passay.dictionary.Dictionary;

public abstract class AbstractDictionaryRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_WORD";
    public static final String ERROR_CODE_REVERSED = "ILLEGAL_WORD_REVERSED";
    private Dictionary dictionary;
    private boolean matchBackwards;

    public void setDictionary(Dictionary dict) {
        if (dict == null) {
            throw new NullPointerException("Dictionary cannot be null");
        }
        this.dictionary = dict;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public void setMatchBackwards(boolean b) {
        this.matchBackwards = b;
    }

    public boolean isMatchBackwards() {
        return this.matchBackwards;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String text = passwordData.getPassword();
        String matchingWord = this.doWordSearch(text);
        if (matchingWord != null) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(matchingWord)));
        }
        if (this.matchBackwards && text.length() > 1 && (matchingWord = this.doWordSearch(text = new StringBuilder(passwordData.getPassword()).reverse().toString())) != null) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE_REVERSED, this.createRuleResultDetailParameters(matchingWord)));
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(String word) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("matchingWord", word);
        return m;
    }

    protected abstract String doWordSearch(String var1);

    public String toString() {
        return String.format("%s@%h::dictionary=%s,matchBackwards=%s", this.getClass().getName(), this.hashCode(), this.dictionary, this.matchBackwards);
    }
}

