/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.server;

import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NegotiatingServerConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ALPNServerConnection
extends NegotiatingServerConnection
implements ALPN.ServerProvider {
    private static final Logger LOG = Log.getLogger(ALPNServerConnection.class);

    public ALPNServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        super(connector, endPoint, engine, protocols, defaultProtocol);
        ALPN.put((SSLEngine)engine, (ALPN.Provider)this);
    }

    public void unsupported() {
        this.select(Collections.emptyList());
    }

    public String select(List<String> clientProtocols) {
        SSLEngine sslEngine = this.getSSLEngine();
        List serverProtocols = this.getProtocols();
        SSLSession sslSession = sslEngine.getHandshakeSession();
        if (sslSession == null) {
            sslSession = sslEngine.getSession();
        }
        String tlsProtocol = sslSession.getProtocol();
        String tlsCipher = sslSession.getCipherSuite();
        String negotiated = null;
        for (String serverProtocol : serverProtocols) {
            if (!clientProtocols.contains(serverProtocol)) continue;
            ConnectionFactory factory = this.getConnector().getConnectionFactory(serverProtocol);
            if (factory instanceof NegotiatingServerConnection.CipherDiscriminator && !((NegotiatingServerConnection.CipherDiscriminator)factory).isAcceptable(serverProtocol, tlsProtocol, tlsCipher)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} protocol {} not acceptable to {} for {}/{}", new Object[]{this, serverProtocol, factory, tlsProtocol, tlsCipher});
                continue;
            }
            negotiated = serverProtocol;
            break;
        }
        if (negotiated == null) {
            if (clientProtocols.isEmpty()) {
                negotiated = this.getDefaultProtocol();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} could not negotiate protocol among client{} and server{}", new Object[]{this, clientProtocols, serverProtocols});
                }
                throw new IllegalStateException();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} protocol selected {} among client{} and server{}", new Object[]{this, negotiated, clientProtocols, serverProtocols});
        }
        this.setProtocol(negotiated);
        ALPN.remove((SSLEngine)sslEngine);
        return negotiated;
    }

    public void close() {
        ALPN.remove((SSLEngine)this.getSSLEngine());
        super.close();
    }
}

