/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.ShadowElementCtrl;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlShadowElement
extends AbstractComponent
implements ShadowElement,
ShadowElementCtrl {
    private static final Logger log = LoggerFactory.getLogger(HtmlShadowElement.class);
    private static final long serialVersionUID = 20141022145906L;
    private Component _firstInsertion;
    private Component _lastInsertion;
    private Component _nextInsertion;
    private Component _previousInsertion;
    protected boolean _afterComposed = false;
    private Component _host;
    protected static String ON_REBUILD_SHADOW_TREE_LATER = "onRebuildShadowTreeLater";
    protected static final String INIT_ANNO = "init";
    protected static final String BIND_ANNO = "bind";
    protected static final String LOAD_ANNO = "load";
    protected static final String SAVE_ANNO = "save";
    protected static final String REFERENCE_ANNO = "ref";
    protected static final String BINDER = "$BINDER$";
    protected Boolean _dynamicValue;

    @Override
    public Object resolveVariable(Component child, String name, boolean recurse) {
        int selfFirstIndex;
        if (this._firstInsertion == null) {
            return null;
        }
        if (child == null || child.getParent() == null) {
            return this.getAttributeOrFellow(name, recurse);
        }
        List children = child.getParent().getChildren();
        int insertIndex = children.indexOf(child);
        if (insertIndex < (selfFirstIndex = children.indexOf(this._firstInsertion))) {
            return null;
        }
        Map<Component, Integer> indexMap = this.fillUpIndexMap(this._firstInsertion, this._lastInsertion);
        int[] selfIndex = this.getInsertionIndex(this._firstInsertion, this._lastInsertion, indexMap);
        if (selfIndex[1] < insertIndex) {
            return null;
        }
        HtmlShadowElement node = this.queryIntersectedShadowIfAny(insertIndex, indexMap);
        if (node != null) {
            if (node == this) {
                return node.getShadowVariable(name, recurse);
            }
            return node.resolveVariable(child, name, recurse);
        }
        return null;
    }

    public Component getNextInsertionComponentIfAny() {
        if (this._nextInsertion == null) {
            Component result;
            Component component = result = this._lastInsertion == null ? null : this._lastInsertion.getNextSibling();
            if (result == null && this.getParent() != null) {
                return ((HtmlShadowElement)HtmlShadowElement.asShadow(this.getParent())).getNextInsertionComponentIfAny();
            }
            return result;
        }
        if (this._nextInsertion instanceof HtmlShadowElement) {
            Object nextInsertion = HtmlShadowElement.asShadow(this._nextInsertion);
            if (((HtmlShadowElement)nextInsertion)._firstInsertion != null) {
                return ((HtmlShadowElement)nextInsertion)._firstInsertion;
            }
            return ((HtmlShadowElement)nextInsertion).getNextInsertionComponentIfAny();
        }
        return this._nextInsertion;
    }

    public Component getPreviousInsertionComponentIfAny() {
        if (this._previousInsertion == null) {
            Component result;
            Component component = result = this._firstInsertion == null ? null : this._firstInsertion.getNextSibling();
            if (result == null && this.getParent() != null) {
                return ((HtmlShadowElement)HtmlShadowElement.asShadow(this.getParent())).getPreviousInsertionComponentIfAny();
            }
            return result;
        }
        if (this._previousInsertion instanceof HtmlShadowElement) {
            Object previousInsertion = HtmlShadowElement.asShadow(this._previousInsertion);
            if (((HtmlShadowElement)previousInsertion)._lastInsertion != null) {
                return ((HtmlShadowElement)previousInsertion)._lastInsertion;
            }
            return ((HtmlShadowElement)previousInsertion).getPreviousInsertionComponentIfAny();
        }
        return this._previousInsertion;
    }

    protected void onHostAttached(Component host) {
        Iterable<EventListener<? extends Event>> eventListeners = host.getEventListeners(ON_REBUILD_SHADOW_TREE_LATER);
        if (!eventListeners.iterator().hasNext()) {
            host.addEventListener(ON_REBUILD_SHADOW_TREE_LATER, (EventListener<? extends Event>)new SerializableEventListener<Event>(){

                @Override
                public void onEvent(Event event) throws Exception {
                    Component target = event.getTarget();
                    if (target instanceof ComponentCtrl && target.getDesktop() != null) {
                        for (ShadowElement se : new ArrayList(((ComponentCtrl)((Object)target)).getShadowRoots())) {
                            if (!(se instanceof HtmlShadowElement)) continue;
                            ((HtmlShadowElement)se).rebuildShadowTree();
                        }
                    } else {
                        Iterable<EventListener<? extends Event>> eventListeners = target.getEventListeners(ON_REBUILD_SHADOW_TREE_LATER);
                        for (EventListener<? extends Event> listener : eventListeners) {
                            target.removeEventListener(ON_REBUILD_SHADOW_TREE_LATER, listener);
                        }
                    }
                }
            });
        }
    }

    protected void onHostDetached(Component host) {
        if (host instanceof ComponentCtrl && ((ComponentCtrl)((Object)host)).getShadowRoots().isEmpty()) {
            Iterable<EventListener<? extends Event>> eventListeners = host.getEventListeners(ON_REBUILD_SHADOW_TREE_LATER);
            for (EventListener<? extends Event> listener : eventListeners) {
                host.removeEventListener(ON_REBUILD_SHADOW_TREE_LATER, listener);
            }
        }
    }

    @Override
    public Component getNextInsertion() {
        return this._nextInsertion;
    }

    @Override
    public Component getPreviousInsertion() {
        return this._previousInsertion;
    }

    @Override
    public Component getFirstInsertion() {
        return this._firstInsertion;
    }

    @Override
    public Component getLastInsertion() {
        return this._lastInsertion;
    }

    @Override
    public void setShadowHost(Component host, Component insertBefore) {
        if (this.getParent() != null) {
            throw new UiException("As a shadow child cannot be a shadow root. [" + this + "]");
        }
        if (host == null) {
            throw new UiException("The shadow host cannot be null. [" + this + "], please use detach() method instead!.");
        }
        if (this._host != null) {
            throw new UiException("The shadow element cannot change its host, if existed. [" + this + "]");
        }
        this._host = host;
        this.onHostAttached(host);
        this._nextInsertion = insertBefore;
        if (insertBefore != null) {
            this._previousInsertion = insertBefore.getPreviousSibling();
        } else {
            List shadowRoots = ((ComponentCtrl)((Object)host)).getShadowRoots();
            ShadowElement lastShadowElement = shadowRoots.isEmpty() ? null : (ShadowElement)shadowRoots.get(shadowRoots.size() - 1);
            Component prev = (Component)((Object)lastShadowElement);
            Object prevOwner = HtmlShadowElement.asShadow(lastShadowElement);
            Component lastChild = host.getLastChild();
            if (prevOwner == null) {
                prev = lastChild;
            } else {
                switch (HtmlShadowElement.inRange(prevOwner, lastChild)) {
                    case NEXT: 
                    case AFTER_NEXT: {
                        prev = lastChild;
                        break;
                    }
                    case UNKNOWN: {
                        ShadowElement se;
                        boolean skip = false;
                        Iterator i$ = shadowRoots.iterator();
                        while (i$.hasNext() && (se = (ShadowElement)i$.next()) != prevOwner) {
                            switch (HtmlShadowElement.inRange(HtmlShadowElement.asShadow(se), lastChild)) {
                                case UNKNOWN: {
                                    break;
                                }
                                default: {
                                    skip = true;
                                }
                            }
                            if (!skip) continue;
                            break;
                        }
                        if (skip) break;
                        prev = lastChild;
                        break;
                    }
                }
            }
            this._previousInsertion = prev;
            if (prev == lastShadowElement && prev != null) {
                ((HtmlShadowElement)prevOwner)._nextInsertion = this;
            }
        }
        ((ComponentCtrl)((Object)host)).addShadowRoot(this);
        host.getDesktop().getWebApp().getConfiguration().afterShadowAttached(this, host);
    }

    @Override
    public void detach() {
        Component prevhost = this.getShadowHostIfAny();
        if (this._host != null) {
            ComponentCtrl host = (ComponentCtrl)((Object)this._host);
            this._host = null;
            host.removeShadowRoot(this);
            this.onHostDetached((Component)((Object)host));
        }
        this.setParent0(null);
        if (prevhost != null && prevhost.getDesktop() != null) {
            prevhost.getDesktop().getWebApp().getConfiguration().afterShadowDetached(this, prevhost);
        }
    }

    @Override
    public void setParent(Component parent) {
        Component host = this.getShadowHostIfAny();
        this.setParent0(parent);
        if (host == null) {
            host = this.getShadowHostIfAny();
        }
        if (host != null) {
            if (parent != null) {
                host.getDesktop().getWebApp().getConfiguration().afterShadowAttached(this, host);
            } else {
                host.getDesktop().getWebApp().getConfiguration().afterShadowDetached(this, host);
            }
        }
    }

    private void setParent0(Component parent) {
        if (this._host != null && parent != null) {
            throw new UiException("As a shadow root cannot be a child of a shadow element.");
        }
        if (parent == null && this._host == null) {
            if (this._firstInsertion != null) {
                HtmlShadowElement.setPrevInsertion(this._firstInsertion, this._previousInsertion);
                HtmlShadowElement.setPrevInsertion(this._nextInsertion, this._lastInsertion);
            } else {
                HtmlShadowElement.setPrevInsertion(this._nextInsertion, this._previousInsertion);
            }
            this._previousInsertion = null;
            this._firstInsertion = null;
            this._lastInsertion = null;
            this._nextInsertion = null;
        }
        super.setParent(parent);
    }

    @Override
    public void beforeParentChanged(Component parent) {
        if (parent != null) {
            if (!(parent instanceof ShadowElement)) {
                throw new UiException("Unsupported parent for shadow element: " + parent);
            }
            if (this._host != null) {
                throw new UiException("Unsupported parent for shadow root: " + this);
            }
        }
        super.beforeParentChanged(parent);
    }

    @Override
    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof ShadowElement)) {
            throw new UiException("Unsupported child for shadow element: " + child);
        }
        if (refChild != null && !(refChild instanceof ShadowElement)) {
            throw new UiException("Unsupported refChild for shadow element: " + refChild);
        }
        HtmlShadowElement seChild = (HtmlShadowElement)child;
        HtmlShadowElement seRefChild = (HtmlShadowElement)refChild;
        Object lastChild = HtmlShadowElement.asShadow(this.getLastChild());
        if (lastChild != null) {
            if (refChild == null) {
                if (((HtmlShadowElement)lastChild)._nextInsertion != null) {
                    seChild._previousInsertion = ((HtmlShadowElement)lastChild)._nextInsertion;
                    if (seChild._nextInsertion == ((HtmlShadowElement)lastChild)._nextInsertion) {
                        seChild._nextInsertion = null;
                    }
                } else {
                    ((HtmlShadowElement)lastChild)._nextInsertion = child;
                    seChild._previousInsertion = lastChild;
                }
            } else if (seRefChild != null) {
                Component previousInsertion = seChild.getPreviousInsertion();
                Component nextInsertion = seChild.getNextInsertion();
                HtmlShadowElement.setPrevInsertion(nextInsertion, previousInsertion);
                previousInsertion = seRefChild.getPreviousInsertion();
                HtmlShadowElement.setPrevInsertion(seRefChild, seChild);
                HtmlShadowElement.setPrevInsertion(seChild, previousInsertion);
            }
        } else if (this._lastInsertion != null) {
            if (refChild != null) {
                throw new IllegalStateException("Some logic wrong here.");
            }
            if (this._lastInsertion instanceof HtmlShadowElement) {
                HtmlShadowElement.setPrevInsertion(seChild, this._lastInsertion);
                if (seChild._nextInsertion == ((HtmlShadowElement)this._lastInsertion)._nextInsertion) {
                    seChild._nextInsertion = null;
                }
            } else {
                seChild._previousInsertion = this._lastInsertion;
            }
        }
        super.beforeChildAdded(child, refChild);
    }

    @Override
    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        Object childSE = HtmlShadowElement.asShadow(child);
        this.stretchRange(((HtmlShadowElement)childSE)._firstInsertion, ((HtmlShadowElement)childSE)._lastInsertion);
    }

    private Map<Component, Integer> getIndexMap() {
        Map distributedIndexInfo = (Map)ShadowElementsCtrl.getDistributedIndexInfo();
        if (distributedIndexInfo == null) {
            throw new IllegalStateException("Distributed index map cannot be null! [" + this + "]");
        }
        return distributedIndexInfo;
    }

    @Override
    public void invalidate() {
        throw new UnsupportedOperationException("Unsupported for shadow element's invalidation, please use getShadowHost().invalidate() instead.");
    }

    private Map<Component, Integer> fillUpIndexMap(Component first, Component last) {
        if (first == null) {
            return this.getIndexMap();
        }
        Component parent = first.getParent();
        if (parent == null) {
            throw new UiException("The insertion point cannot be null: " + first);
        }
        List children = parent.getChildren();
        Map<Component, Integer> indexMap = this.getIndexMap();
        Integer integer = indexMap.get(first);
        if (integer != null && indexMap.containsKey(last)) {
            return indexMap;
        }
        int i = 0;
        for (Component next : children) {
            if (indexMap.isEmpty()) {
                if (first == next) {
                    indexMap.put(next, i);
                }
            } else {
                indexMap.put(next, i);
                if (next == last) break;
            }
            ++i;
        }
        return indexMap;
    }

    private int[] getInsertionIndex(Component firstChild, Component lastChild, Map<Component, Integer> indexMap) {
        if (indexMap == null) {
            indexMap = this.fillUpIndexMap(firstChild, lastChild);
            return new int[]{indexMap.get(firstChild), indexMap.get(lastChild)};
        }
        Integer start = indexMap.get(firstChild);
        Integer end = indexMap.get(lastChild);
        if (start == null || end == null) {
            indexMap = this.fillUpIndexMap(firstChild, lastChild);
        }
        start = indexMap.get(firstChild);
        end = indexMap.get(lastChild);
        return new int[]{start, end};
    }

    protected void stretchRange(Component firstChild, Component lastChild) {
        if (firstChild != null) {
            boolean isEdge = false;
            if (this._firstInsertion == null) {
                this._firstInsertion = firstChild;
                this._lastInsertion = lastChild;
                isEdge = true;
            } else {
                int[] selfIndex;
                Map<Component, Integer> indexMap = this.fillUpIndexMap(firstChild, lastChild);
                int[] childIndex = this.getInsertionIndex(firstChild, lastChild, indexMap);
                if (childIndex[0] < (selfIndex = this.getInsertionIndex(this._firstInsertion, this._lastInsertion, indexMap))[0]) {
                    isEdge = true;
                    this._firstInsertion = firstChild;
                }
                if (selfIndex[1] < childIndex[1]) {
                    isEdge = true;
                    this._lastInsertion = lastChild;
                }
            }
            if (isEdge && this.getParent() != null) {
                ((HtmlShadowElement)HtmlShadowElement.asShadow(this.getParent())).stretchRange(firstChild, lastChild);
            }
        }
    }

    protected void shrinkRange(Component firstChild, Component lastChild) {
        if (firstChild != null) {
            boolean isEdge = false;
            if (firstChild == this._firstInsertion) {
                if (lastChild == this._lastInsertion) {
                    this._lastInsertion = null;
                    this._firstInsertion = null;
                } else {
                    this._firstInsertion = lastChild.getNextSibling();
                }
                isEdge = true;
            } else if (lastChild == this._lastInsertion) {
                isEdge = true;
                this._lastInsertion = this._lastInsertion.getPreviousSibling();
            }
            if (isEdge && this.getParent() != null) {
                ((HtmlShadowElement)HtmlShadowElement.asShadow(this.getParent())).shrinkRange(firstChild, lastChild);
            }
        }
    }

    @Override
    public Object clone() {
        HtmlShadowElement clone = (HtmlShadowElement)super.clone();
        clone._previousInsertion = this._previousInsertion;
        clone._firstInsertion = this._firstInsertion;
        clone._lastInsertion = this._lastInsertion;
        clone._nextInsertion = this._nextInsertion;
        return clone;
    }

    @Override
    public Component getShadowHost() {
        return this._host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCompose() {
        if (!this._afterComposed) {
            this._afterComposed = true;
            if (this.isEffective() && this._firstInsertion == null) {
                String key;
                Component host = this.getShadowHostIfAny();
                if (host == null) {
                    throw new UiException("Host cannot be null [" + this + "]");
                }
                Object shadowInfo = ShadowElementsCtrl.getCurrentInfo();
                try {
                    ShadowElementsCtrl.setCurrentInfo(this);
                    this.compose(host);
                }
                finally {
                    ShadowElementsCtrl.setCurrentInfo(shadowInfo);
                }
                Execution exec = Executions.getCurrent();
                if (exec != null && !exec.hasAttribute(key = "org.zkoss.zk.ui.HttmlShadowelement" + host.getUuid())) {
                    exec.setAttribute(key, Boolean.TRUE);
                    Events.postEvent(-250000, new Event(ON_REBUILD_SHADOW_TREE_LATER, host));
                }
            }
        }
    }

    protected static void setPrevInsertion(Component target, Component prevInsertion) {
        if (target == prevInsertion) {
            return;
        }
        if (target instanceof HtmlShadowElement) {
            ((HtmlShadowElement)HtmlShadowElement.asShadow((Object)target))._previousInsertion = prevInsertion;
        }
        if (prevInsertion instanceof HtmlShadowElement) {
            ((HtmlShadowElement)HtmlShadowElement.asShadow((Object)prevInsertion))._nextInsertion = target;
        }
    }

    protected void mergeSubTree() {
        List children = this.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        if (this._parent != null) {
            for (HtmlShadowElement child : new ArrayList(children)) {
                Component previous = child._previousInsertion;
                Component next = child._nextInsertion;
                this._parent.insertBefore(child, this);
                if (previous != null && !(previous instanceof HtmlShadowElement)) {
                    Component newPrevious = child._previousInsertion;
                    HtmlShadowElement.setPrevInsertion(previous, newPrevious);
                    HtmlShadowElement.setPrevInsertion(child, previous);
                }
                if (next != null && !(next instanceof HtmlShadowElement)) {
                    Component newNext = child._nextInsertion;
                    HtmlShadowElement.setPrevInsertion(newNext, next);
                    HtmlShadowElement.setPrevInsertion(next, child);
                }
                if (this._firstInsertion == child._firstInsertion) {
                    this._firstInsertion = null;
                }
                if (this._lastInsertion != child._lastInsertion) continue;
                this._lastInsertion = null;
            }
        } else {
            Component previous = this._previousInsertion;
            for (HtmlShadowElement child : new ArrayList(children)) {
                Component newNext;
                child.mergeToHost(this._host);
                if (previous != null) {
                    Component newPrevious = child._previousInsertion;
                    if (newPrevious == null && previous != null) {
                        HtmlShadowElement.setPrevInsertion(child, previous);
                    } else if (previous != null) {
                        HtmlShadowElement.setPrevInsertion(newPrevious, previous);
                    }
                    previous = null;
                }
                if ((newNext = child._nextInsertion) == null) {
                    HtmlShadowElement.setPrevInsertion(this, child);
                }
                if (this._firstInsertion == child._firstInsertion || this._firstInsertion == child._previousInsertion) {
                    this._firstInsertion = null;
                }
                if (this._lastInsertion != child._lastInsertion && this._lastInsertion != child._nextInsertion) continue;
                this._lastInsertion = null;
            }
        }
    }

    public boolean mergeToHost(Component host) {
        if (host == null) {
            throw new UiException("The host cannot be null.");
        }
        if (host == this._host) {
            return false;
        }
        if (this._parent == null) {
            throw new UiException("The parent shadow cannot be null.");
        }
        HtmlShadowElement oldParent = (HtmlShadowElement)this._parent;
        if (host != this._host) {
            HtmlShadowElement parent = (HtmlShadowElement)this._parent;
            this._parent = null;
            ((ComponentCtrl)((Object)host)).addShadowRootBefore(this, parent);
            this._host = host;
            ++parent._chdinf.modCntChd;
            --parent._chdinf.nChild;
            if (parent._chdinf.first == this) {
                parent._chdinf.first = this._next;
            }
            if (parent._chdinf.last == this) {
                parent._chdinf.last = parent._chdinf.first != null ? this._prev : null;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildShadowTree() {
        Map<Component, Integer> oldCacheMap = this.getIndexCacheMap();
        boolean destroyCacheMap = oldCacheMap == null;
        try {
            if (destroyCacheMap) {
                this.initIndexCacheMap();
            }
            this.rebuildSubShadowTree();
        }
        finally {
            if (destroyCacheMap) {
                this.destroyIndexCacheMap();
            }
        }
    }

    protected void rebuildSubShadowTree() {
        List children = this.getChildren();
        for (HtmlShadowElement se : new ArrayList(children)) {
            se.rebuildSubShadowTree();
        }
        if (!this.isDynamicValue()) {
            this.mergeSubTree();
            this.detach();
        }
    }

    protected abstract boolean isEffective();

    protected abstract void compose(Component var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeHostChildRemoved(Component child, int indexOfChild) {
        Object currentInfo;
        if (log.isDebugEnabled()) {
            log.debug("beforeHostChildRemoved " + child + ", in this shadow " + ShadowElementsCtrl.getCurrentInfo());
        }
        if ((currentInfo = ShadowElementsCtrl.getCurrentInfo()) instanceof HtmlShadowElement) {
            if (currentInfo == this) {
                this.adjustInsertionForRemove(this, child);
                boolean isEdge = false;
                Component oldFirst = this._firstInsertion;
                Component oldLast = this._lastInsertion;
                if (child == this._firstInsertion) {
                    if (this._firstInsertion == this._lastInsertion) {
                        this._lastInsertion = null;
                        this._firstInsertion = null;
                    } else {
                        this._firstInsertion = child.getNextSibling();
                        oldLast = oldFirst;
                    }
                    isEdge = true;
                } else if (child == this._lastInsertion) {
                    isEdge = true;
                    this._lastInsertion = child.getPreviousSibling();
                    oldFirst = oldLast;
                }
                if (isEdge && this.getParent() != null) {
                    ((HtmlShadowElement)HtmlShadowElement.asShadow(this.getParent())).shrinkRange(oldFirst, oldLast);
                }
                this.onHostChildRemoved(child);
                return;
            }
            if (this.isAncestor(this, (HtmlShadowElement)HtmlShadowElement.asShadow(currentInfo))) {
                ((HtmlShadowElement)HtmlShadowElement.asShadow(currentInfo)).beforeHostChildRemoved(child, indexOfChild);
                return;
            }
        } else {
            if (this._firstInsertion == null) {
                return;
            }
            List children = child.getParent().getChildren();
            int selfFirstIndex = children.indexOf(this._firstInsertion);
            if (indexOfChild < selfFirstIndex) {
                return;
            }
            Map<Component, Integer> indexMap = this.fillUpIndexMap(this._firstInsertion, this._lastInsertion);
            int[] selfIndex = this.getInsertionIndex(this._firstInsertion, this._lastInsertion, this.fillUpIndexMap(this._firstInsertion, this._lastInsertion));
            if (selfIndex[1] < indexOfChild) {
                if (this._previousInsertion == child) {
                    HtmlShadowElement.setPrevInsertion(this, child.getPreviousSibling());
                } else if (this._nextInsertion == child) {
                    HtmlShadowElement.setPrevInsertion(child.getNextSibling(), this);
                }
                return;
            }
            HtmlShadowElement node = this.queryIntersectedShadowIfAny(indexOfChild, indexMap);
            if (node != null) {
                try {
                    ShadowElementsCtrl.setCurrentInfo(node);
                    ((HtmlShadowElement)HtmlShadowElement.asShadow(node)).beforeHostChildRemoved(child, indexOfChild);
                }
                finally {
                    ShadowElementsCtrl.setCurrentInfo(currentInfo);
                }
            }
        }
    }

    private HtmlShadowElement queryIntersectedShadowIfAny(int queryIndex, Map<Component, Integer> indexMap) {
        Object binarySearchSubTree = this.binarySearchSubTree(this, queryIndex, indexMap);
        if (binarySearchSubTree instanceof HtmlShadowElement) {
            return HtmlShadowElement.asShadow(binarySearchSubTree);
        }
        return null;
    }

    private Object binarySearchSubTree(HtmlShadowElement subTree, int queryIndex, Map<Component, Integer> indexMap) {
        if (subTree._firstInsertion == null) {
            return -1;
        }
        int startIndex = indexMap.get(subTree._firstInsertion);
        if (startIndex > queryIndex) {
            return startIndex;
        }
        int endIndex = indexMap.get(subTree._lastInsertion);
        if (endIndex < queryIndex) {
            return endIndex;
        }
        int nChild = subTree.nChild();
        if (nChild == 0) {
            return subTree;
        }
        BinarySearchIterator bsit = new BinarySearchIterator(subTree, nChild, queryIndex);
        while (bsit.hasNext()) {
            Object result = this.binarySearchSubTree(bsit.next(), queryIndex, indexMap);
            if (result instanceof Integer) {
                bsit.adjustCursor((Integer)result);
                continue;
            }
            return result;
        }
        return subTree;
    }

    @Override
    public void onHostChildRemoved(Component child) {
    }

    @Override
    public void onHostChildAdded(Component child) {
    }

    @Override
    public void beforeHostParentChanged(Component parent) {
        if (log.isDebugEnabled()) {
            log.debug("beforeHostParentChanged " + parent + ", in this shadow " + ShadowElementsCtrl.getCurrentInfo());
        }
        if (parent == null) {
            ((ComponentCtrl)((Object)this._host)).removeShadowRoot(this);
        } else if (this._host.getParent() == null) {
            this.onHostAttached(this._host);
        }
    }

    @Override
    public void beforeHostChildAdded(Component child, Component insertBefore, int indexOfInsertBefore) {
        if (log.isDebugEnabled()) {
            log.debug("beforeHostChildAdded " + child + ", " + insertBefore + ", in this shadow " + ShadowElementsCtrl.getCurrentInfo());
        }
        Object currentInfo = ShadowElementsCtrl.getCurrentInfo();
        if (indexOfInsertBefore < 0) {
            if (currentInfo instanceof HtmlShadowElement) {
                Object asShadow = HtmlShadowElement.asShadow(currentInfo);
                if (this.isAncestor(this, (HtmlShadowElement)asShadow)) {
                    Component lastChild = ((AbstractComponent)asShadow).getLastChild();
                    if (lastChild != null) {
                        ((HtmlShadowElement)HtmlShadowElement.asShadow((Object)lastChild))._nextInsertion = child;
                    }
                } else if (((HtmlShadowElement)asShadow).getShadowHostIfAny() != this.getShadowHostIfAny() && this._nextInsertion == null) {
                    this._nextInsertion = child;
                }
            } else if (this._nextInsertion == null) {
                this._nextInsertion = child;
            }
        } else {
            Map<Component, Integer> indexMap = this.fillUpIndexMap(this._firstInsertion, this._lastInsertion);
            HtmlShadowElement node = this.queryIntersectedShadowIfAny(indexOfInsertBefore, indexMap);
            if (currentInfo instanceof HtmlShadowElement) {
                if (this.isAncestor((HtmlShadowElement)HtmlShadowElement.asShadow(currentInfo), node)) {
                    this.adjustInsertionForInsertBefore(node, child, insertBefore);
                } else if (!((HtmlShadowElement)currentInfo).getChildren().isEmpty()) {
                    Object currentShadow = HtmlShadowElement.asShadow(currentInfo);
                    ((HtmlShadowElement)HtmlShadowElement.asShadow((Object)((AbstractComponent)currentShadow).getLastChild()))._nextInsertion = child;
                }
            } else if (node != null) {
                if (this.getParent() != null || insertBefore != this._firstInsertion) {
                    this.adjustInsertionForInsertBefore(node, child, insertBefore);
                } else {
                    this._previousInsertion = child;
                }
            } else if (this._nextInsertion == insertBefore) {
                this._nextInsertion = child;
            }
        }
    }

    protected static <T extends HtmlShadowElement> T asShadow(Object o) {
        return (T)((HtmlShadowElement)o);
    }

    private boolean isAncestor(HtmlShadowElement parent, HtmlShadowElement child) {
        if (child == null) {
            return false;
        }
        if (parent == child) {
            return true;
        }
        return this.isAncestor(parent, (HtmlShadowElement)HtmlShadowElement.asShadow(child.getParent()));
    }

    private boolean adjustInsertionForRemove(HtmlShadowElement se, Component removed) {
        Component old = null;
        Direction direction = HtmlShadowElement.inRange(se, removed);
        switch (direction) {
            case PREVIOUS: {
                old = se._previousInsertion;
                if (old != null) {
                    Object previousSibling = HtmlShadowElement.asShadow(se.getPreviousSibling());
                    if (previousSibling != null) {
                        if (((HtmlShadowElement)previousSibling)._nextInsertion == old) {
                            ((HtmlShadowElement)previousSibling)._nextInsertion = se;
                            se._previousInsertion = previousSibling;
                        } else {
                            se._previousInsertion = old.getPreviousSibling();
                        }
                    } else {
                        Object parentSe = HtmlShadowElement.asShadow(se.getParent());
                        se._previousInsertion = parentSe == null || ((HtmlShadowElement)parentSe)._firstInsertion != old ? old.getPreviousSibling() : null;
                    }
                    return true;
                }
            }
            case NEXT: {
                old = se._nextInsertion;
                if (old != null) {
                    Object nextSibling = HtmlShadowElement.asShadow(se.getNextSibling());
                    if (nextSibling != null) {
                        if (((HtmlShadowElement)nextSibling)._previousInsertion == old) {
                            ((HtmlShadowElement)nextSibling)._previousInsertion = se;
                            se._nextInsertion = nextSibling;
                        } else {
                            se._nextInsertion = old.getNextSibling();
                        }
                    } else {
                        Object parentSe = HtmlShadowElement.asShadow(se.getParent());
                        se._nextInsertion = parentSe == null || ((HtmlShadowElement)parentSe)._lastInsertion != old ? old.getPreviousSibling() : null;
                    }
                    return true;
                }
            }
            case IN_RANGE: 
            case FIRST: 
            case LAST: {
                List children = se.getChildren();
                if (!children.isEmpty()) {
                    Iterator sit = children.iterator();
                    while (sit.hasNext()) {
                        if (!this.adjustInsertionForRemove((HtmlShadowElement)sit.next(), removed)) continue;
                        return true;
                    }
                    break;
                }
                if (direction == Direction.FIRST) {
                    se.shrinkRange(se._firstInsertion, se._firstInsertion);
                    return true;
                }
                if (direction != Direction.LAST) break;
                se.shrinkRange(se._lastInsertion, se._lastInsertion);
                return true;
            }
        }
        return false;
    }

    private boolean adjustInsertionForInsertBefore(HtmlShadowElement se, Component target, Component insertBefore) {
        Component old = null;
        Direction direction = HtmlShadowElement.inRange(se, insertBefore);
        switch (direction) {
            case PREVIOUS: {
                old = se._previousInsertion;
                se._previousInsertion = target;
                if (old instanceof HtmlShadowElement) {
                    ((HtmlShadowElement)HtmlShadowElement.asShadow((Object)old))._nextInsertion = target;
                }
                return true;
            }
            case NEXT: {
                old = se._nextInsertion;
                se._nextInsertion = target;
                if (old instanceof HtmlShadowElement) {
                    ((HtmlShadowElement)HtmlShadowElement.asShadow((Object)old))._previousInsertion = target;
                }
                return true;
            }
            case IN_RANGE: 
            case FIRST: 
            case LAST: {
                List children = se.getChildren();
                if (children.isEmpty()) {
                    if (direction != Direction.FIRST) break;
                    old = se._previousInsertion;
                    se._previousInsertion = target;
                    if (old instanceof HtmlShadowElement) {
                        ((HtmlShadowElement)HtmlShadowElement.asShadow((Object)old))._nextInsertion = target;
                    }
                    return true;
                }
                Iterator sit = children.iterator();
                while (sit.hasNext()) {
                    if (!this.adjustInsertionForInsertBefore((HtmlShadowElement)sit.next(), target, insertBefore)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private static int getIndex(HtmlShadowElement owner, Component insertion, Map<Component, Integer> cacheMap) {
        if (insertion == null) {
            return -1;
        }
        if (insertion.getParent() == null) {
            if (owner == null) {
                throw new IllegalStateException("The insertion cannot be orphan" + insertion);
            }
            if (insertion instanceof HtmlShadowElement && ((HtmlShadowElement)insertion).getShadowHost() != null) {
                return -1;
            }
            throw new IllegalStateException("The insertion [" + insertion + "] of the shadow [" + owner + "] cannot be orphan");
        }
        if (insertion instanceof ShadowElement) {
            return -1;
        }
        Integer result = cacheMap.get(insertion);
        if (result != null) {
            return result;
        }
        int i = 0;
        int matched = -1;
        for (Component next : insertion.getParent().getChildren()) {
            cacheMap.put(next, new Integer(i));
            if (next == insertion) {
                matched = i;
            }
            ++i;
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Direction inRange(HtmlShadowElement se, Component target) {
        Map<Component, Integer> oldCacheMap = se.getIndexCacheMap();
        boolean destroyCacheMap = oldCacheMap == null;
        try {
            if (destroyCacheMap) {
                oldCacheMap = se.initIndexCacheMap();
            }
            int targetIndex = HtmlShadowElement.getIndex(null, target, oldCacheMap);
            int prev = HtmlShadowElement.getIndex(se, se.getPreviousInsertion(), oldCacheMap);
            int first = HtmlShadowElement.getIndex(se, se.getFirstInsertion(), oldCacheMap);
            int last = HtmlShadowElement.getIndex(se, se.getLastInsertion(), oldCacheMap);
            int next = HtmlShadowElement.getIndex(se, se.getNextInsertion(), oldCacheMap);
            if (targetIndex == prev) {
                Direction direction = Direction.PREVIOUS;
                return direction;
            }
            if (targetIndex == first) {
                Direction direction = Direction.FIRST;
                return direction;
            }
            if (targetIndex == last) {
                Direction direction = Direction.LAST;
                return direction;
            }
            if (targetIndex == next) {
                Direction direction = Direction.NEXT;
                return direction;
            }
            if (targetIndex > first && targetIndex < last) {
                Direction direction = Direction.IN_RANGE;
                return direction;
            }
            if (prev > -1) {
                Direction direction = targetIndex - prev > 0 ? Direction.AFTER_NEXT : Direction.BEFORE_PREVIOUS;
                return direction;
            }
            if (first > -1) {
                Direction direction = targetIndex - first > 0 ? Direction.AFTER_NEXT : Direction.BEFORE_PREVIOUS;
                return direction;
            }
            if (next > -1) {
                Direction direction = targetIndex - next > 0 ? Direction.AFTER_NEXT : Direction.BEFORE_PREVIOUS;
                return direction;
            }
            if (last > -1) {
                Direction direction = targetIndex - last > 0 ? Direction.AFTER_NEXT : Direction.BEFORE_PREVIOUS;
                return direction;
            }
            Direction direction = Direction.UNKNOWN;
            return direction;
        }
        finally {
            if (destroyCacheMap) {
                se.destroyIndexCacheMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterHostChildAdded(Component child, int indexOfChild) {
        Object currentInfo;
        if (log.isDebugEnabled()) {
            log.debug("afterHostChildAdded " + child + ", in this shadow " + ShadowElementsCtrl.getCurrentInfo());
        }
        if ((currentInfo = ShadowElementsCtrl.getCurrentInfo()) instanceof HtmlShadowElement) {
            if (currentInfo == this) {
                boolean isEdge = false;
                if (this._firstInsertion == null) {
                    this._firstInsertion = this._lastInsertion = child;
                    isEdge = true;
                } else if (this._firstInsertion != child && this._lastInsertion != child) {
                    int[] selfIndex = this.getInsertionIndex(this._firstInsertion, this._lastInsertion, this.fillUpIndexMap(this._firstInsertion, this._lastInsertion));
                    if (indexOfChild < selfIndex[0]) {
                        this._firstInsertion = child;
                        isEdge = true;
                    } else if (indexOfChild > selfIndex[1]) {
                        this._lastInsertion = child;
                        isEdge = true;
                    }
                }
                if (this.getParent() != null && isEdge) {
                    ((HtmlShadowElement)HtmlShadowElement.asShadow(this.getParent())).stretchRange(this._firstInsertion, this._lastInsertion);
                }
                this.onHostChildAdded(child);
                return;
            }
            if (this.isAncestor(this, (HtmlShadowElement)HtmlShadowElement.asShadow(currentInfo))) {
                ((HtmlShadowElement)HtmlShadowElement.asShadow(currentInfo)).afterHostChildAdded(child, indexOfChild);
                return;
            }
        } else {
            int selfFirstIndex;
            if (this._firstInsertion == null) {
                return;
            }
            List children = child.getParent().getChildren();
            int insertIndex = children.indexOf(child);
            if (insertIndex < (selfFirstIndex = children.indexOf(this._firstInsertion))) {
                return;
            }
            Map<Component, Integer> indexMap = this.fillUpIndexMap(this._firstInsertion, this._lastInsertion);
            int[] selfIndex = this.getInsertionIndex(this._firstInsertion, this._lastInsertion, indexMap);
            if (selfIndex[1] < insertIndex) {
                return;
            }
            HtmlShadowElement node = this.queryIntersectedShadowIfAny(insertIndex, indexMap);
            if (node != null) {
                try {
                    ShadowElementsCtrl.setCurrentInfo(node);
                    ((HtmlShadowElement)HtmlShadowElement.asShadow(node)).afterHostChildAdded(child, indexOfChild);
                }
                finally {
                    ShadowElementsCtrl.setCurrentInfo(currentInfo);
                }
            }
        }
    }

    @Override
    public void afterHostChildRemoved(Component child) {
        if (log.isDebugEnabled()) {
            log.debug("afterHostChildRemoved " + child + ", in this shadow " + ShadowElementsCtrl.getCurrentInfo());
        }
    }

    @Override
    public void recreate() {
        if (this._afterComposed) {
            if (!this.getChildren().isEmpty()) {
                this.getChildren().clear();
            }
            if (this._firstInsertion != null) {
                Component next = this._firstInsertion;
                Component end = this._lastInsertion.getNextSibling();
                while (next != end) {
                    Component tmp = next.getNextSibling();
                    next.detach();
                    next = tmp;
                }
            }
            this._afterComposed = false;
            this.afterCompose();
        }
    }

    @Override
    public Component getShadowHostIfAny() {
        Component parent = this;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return ((ShadowElement)((Object)parent)).getShadowHost();
    }

    private final int nDChild() {
        if (this._firstInsertion != null) {
            int size = 1;
            for (Component next = this._firstInsertion; next != this._lastInsertion; next = next.getNextSibling()) {
                ++size;
            }
            return size;
        }
        return 0;
    }

    @Override
    public <T extends Component> List<T> getDistributedChildren() {
        final Component shadowHostIfAny = this.getShadowHostIfAny();
        return new AbstractSequentialList<T>(){

            @Override
            public ListIterator<T> listIterator(int index) {
                return new ChildIter((AbstractComponent)shadowHostIfAny, index);
            }

            @Override
            public int size() {
                return HtmlShadowElement.this.nDChild();
            }

            @Override
            public T get(int index) {
                try {
                    return (Component)this.listIterator(index).next();
                }
                catch (NoSuchElementException exc) {
                    throw new IndexOutOfBoundsException("Index: " + index);
                }
            }
        };
    }

    protected boolean isDynamicValue(String propName) {
        HtmlShadowElement compCtrl = this;
        Collection<Annotation> annos = compCtrl.getAnnotations(propName);
        if (!annos.isEmpty()) {
            for (Annotation anno : annos) {
                String annoName = anno.getName();
                if (!annoName.equals(BIND_ANNO) && !annoName.equals(LOAD_ANNO) && !annoName.equals(SAVE_ANNO) && !annoName.equals(REFERENCE_ANNO) && !annoName.equals(INIT_ANNO)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDynamicValue(boolean dynamicValue) {
        this._dynamicValue = dynamicValue ? Boolean.valueOf(dynamicValue) : null;
    }

    @Override
    public boolean isDynamicValue() {
        HtmlShadowElement ctrl;
        List<String> props;
        if (this._dynamicValue == null && (props = (ctrl = this).getAnnotatedProperties()) != null) {
            for (String prop : props) {
                if (!this.isDynamicValue(prop)) continue;
                this._dynamicValue = true;
                break;
            }
            if (this._dynamicValue == null) {
                this._dynamicValue = Boolean.FALSE;
            }
        }
        return this._dynamicValue;
    }

    @Override
    public String toString() {
        String clsnm = this.getClass().getSimpleName();
        if (this._host == null) {
            if (this.getParent() != null) {
                return this.getParent() + " -> <" + clsnm + "@" + this.getParent().getChildren().indexOf(this) + ">";
            }
            return '<' + clsnm + '>';
        }
        ComponentCtrl host = (ComponentCtrl)((Object)this._host);
        return "<" + clsnm + "@" + host.getShadowRoots().indexOf(this) + " (" + this._host + ")>";
    }

    @Override
    protected void updateSubBindingAnnotationCount(int diff) {
        AbstractComponent node = this;
        while (node != null) {
            this.setSubBindingAnnotationCount(diff, node);
            AbstractComponent p = (AbstractComponent)node.getParent();
            if (p != null) {
                node = p;
                continue;
            }
            if ((node = (AbstractComponent)((HtmlShadowElement)node).getShadowHost()) == null) break;
            node.updateSubBindingAnnotationCount(diff);
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChildIter
    implements ListIterator<Component> {
        private AbstractComponent _p;
        private AbstractComponent _lastRet;
        private int _j;
        private int _modCntSnap;
        private AbstractComponent host;

        private ChildIter(AbstractComponent host, int index) {
            int nChild;
            this.host = host;
            if (index < 0 || index > (nChild = HtmlShadowElement.this.nDChild())) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + HtmlShadowElement.this.nDChild());
            }
            if (index < nChild >> 1) {
                this._p = (AbstractComponent)HtmlShadowElement.this._firstInsertion;
                this._j = 0;
                while (this._j < index) {
                    this._p = this._p._next;
                    ++this._j;
                }
            } else {
                this._p = null;
                this._j = nChild;
                while (this._j > index) {
                    this._p = this._p != null ? this._p._prev : (AbstractComponent)HtmlShadowElement.this._lastInsertion;
                    --this._j;
                }
            }
            this._modCntSnap = host.modCntChd();
        }

        @Override
        public boolean hasNext() {
            this.checkComodification();
            return this._j < HtmlShadowElement.this.nDChild();
        }

        @Override
        public Component next() {
            if (this._j >= HtmlShadowElement.this.nDChild()) {
                throw new NoSuchElementException();
            }
            this.checkComodification();
            this._lastRet = this._p;
            this._p = this._p._next;
            ++this._j;
            return this._lastRet;
        }

        @Override
        public boolean hasPrevious() {
            this.checkComodification();
            return this._j > 0;
        }

        @Override
        public Component previous() {
            if (this._j <= 0) {
                throw new NoSuchElementException();
            }
            this.checkComodification();
            this._p = this._p != null ? this._p._prev : (AbstractComponent)HtmlShadowElement.this._lastInsertion;
            this._lastRet = this._p;
            --this._j;
            return this._lastRet;
        }

        private void checkComodification() {
            if (this.host.modCntChd() != this._modCntSnap) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int nextIndex() {
            return this._j;
        }

        @Override
        public int previousIndex() {
            return this._j - 1;
        }

        @Override
        public void add(Component newChild) {
            throw new UnsupportedOperationException("add Component");
        }

        @Override
        public void remove() {
            if (this._lastRet == null) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            if (this._p == this._lastRet) {
                this._p = this._lastRet._next;
            } else {
                --this._j;
            }
            this.host.removeChild(this._lastRet);
            this._lastRet = null;
            ++this._modCntSnap;
        }

        @Override
        public void set(Component o) {
            throw new UnsupportedOperationException("set Component");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        BEFORE_PREVIOUS,
        PREVIOUS,
        FIRST,
        IN_RANGE,
        LAST,
        NEXT,
        AFTER_NEXT,
        UNKNOWN;

    }

    private class BinarySearchIterator {
        private HtmlShadowElement _subTree;
        private int _low;
        private int _high;
        private int _mid;
        private int _midChild;
        private int _queryIndex;

        public BinarySearchIterator(HtmlShadowElement subTree, int nChild, int queryIndex) {
            this._subTree = subTree;
            this._low = 0;
            this._high = nChild - 1;
            this._mid = this._midChild = this.getMiddleIndex(this._low, this._high);
            this._queryIndex = queryIndex;
        }

        private int getMiddleIndex(int low, int high) {
            if (low > high) {
                return -1;
            }
            return low + high >>> 1;
        }

        public boolean hasNext() {
            return this._low <= this._high && this._mid >= 0;
        }

        public HtmlShadowElement next() {
            return HtmlShadowElement.asShadow(this._subTree.getChildren().get(this._mid));
        }

        private void checkIndex() {
            int newMid = this.getMiddleIndex(this._low, this._high);
            if (this._mid == newMid) {
                this._mid = -1;
            } else {
                this._midChild = this._mid = newMid;
            }
        }

        public void adjustCursor(Integer result) {
            int queryResult = result;
            if (queryResult < 0) {
                if (this._mid <= this._low) {
                    this._low = this._midChild + 1;
                    this.checkIndex();
                } else {
                    --this._mid;
                }
            } else if (queryResult > -1) {
                if (this._low == this._mid && this._mid == this._high) {
                    this._mid = -1;
                } else {
                    if (queryResult < this._queryIndex) {
                        this._low = this._mid + 1;
                    } else {
                        this._high = this._mid - 1;
                    }
                    this.checkIndex();
                }
            }
        }
    }
}

