/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.idom.Document;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Locales;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.MessageLoader;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.xel.Evaluator;

public class Wpds {
    private static final CacheMap<String, String> _datejs = new CacheMap(8);

    public static String outWidgetListJavaScript(String lang) {
        StringBuffer sb = new StringBuffer(4096).append("zk.wgt.WidgetInfo.register([");
        boolean first = true;
        for (ComponentDefinition compdef : LanguageDefinition.lookup(lang).getComponentDefinitions()) {
            for (String mold : compdef.getMoldNames()) {
                String wgtcls = compdef.getWidgetClass(null, mold);
                if (wgtcls == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append('\'').append(wgtcls).append('\'');
            }
        }
        return sb.append("]);").toString();
    }

    public static final String outLocaleJavaScript() {
        Locale locale = Locales.getCurrent();
        return Wpds.outNumberJavaScript(locale) + Wpds.outDateJavaScript(locale);
    }

    private static final String outNumberJavaScript(Locale locale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        StringBuffer sb = new StringBuffer(128);
        Wpds.appendAssignJavaScript(sb, "zk.GROUPING", symbols.getGroupingSeparator());
        Wpds.appendAssignJavaScript(sb, "zk.DECIMAL", symbols.getDecimalSeparator());
        Wpds.appendAssignJavaScript(sb, "zk.PERCENT", symbols.getPercent());
        Wpds.appendAssignJavaScript(sb, "zk.MINUS", symbols.getMinusSign());
        Wpds.appendAssignJavaScript(sb, "zk.PER_MILL", symbols.getPerMill());
        return sb.toString();
    }

    private static final void appendAssignJavaScript(StringBuffer sb, String nm, char val) {
        char quot = val == '\"' ? (char)'\'' : '\"';
        sb.append(nm).append('=').append(quot).append(val).append(quot).append(";\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String outDateJavaScript(Locale locale) {
        int firstDayOfWeek = Utils.getFirstDayOfWeek();
        String djkey = locale + ":" + firstDayOfWeek;
        CacheMap<String, String> cacheMap = _datejs;
        synchronized (cacheMap) {
            String djs = (String)_datejs.get((Object)djkey);
            if (djs != null) {
                return djs;
            }
        }
        String djs = Wpds.getDateJavaScript(locale, firstDayOfWeek);
        CacheMap<String, String> cacheMap2 = _datejs;
        synchronized (cacheMap2) {
            for (String val : _datejs.values()) {
                if (!val.equals(djs)) continue;
                djs = val;
            }
            _datejs.put((Object)djkey, (Object)djs);
        }
        return djs;
    }

    private static final String getDateJavaScript(Locale locale, int firstDayOfWeek) {
        StringBuffer sb = new StringBuffer(512);
        Calendar cal = Calendar.getInstance(locale);
        cal.clear();
        if (firstDayOfWeek < 0) {
            firstDayOfWeek = cal.getFirstDayOfWeek();
        }
        sb.append("zk.DOW_1ST=").append(firstDayOfWeek - 1).append(";\n");
        boolean zhlang = locale.getLanguage().equals("zh");
        SimpleDateFormat df = new SimpleDateFormat("E", locale);
        String[] sdow = new String[7];
        String[] s2dow = new String[7];
        int j = firstDayOfWeek;
        for (int k = 0; k < 7; ++k) {
            int len;
            char cc;
            cal.set(7, j);
            sdow[k] = df.format(cal.getTime());
            if (++j > 7) {
                j = 1;
            }
            s2dow[k] = zhlang ? (sdow[k].length() >= 3 ? sdow[k].substring(2) : sdow[k]) : ((cc = sdow[k].charAt((len = sdow[k].length()) - 1)) == '.' || cc == ',' ? sdow[k].substring(0, len - 1) : sdow[k]);
        }
        df = new SimpleDateFormat("G", locale);
        boolean helang = locale.getLanguage().equals("iw");
        if (helang) {
            sb.append("zk.ERA='").append(df.format(new Date())).append("';\n");
        } else {
            sb.append("zk.ERA=\"").append(df.format(new Date())).append("\";\n");
        }
        Calendar ec = Calendar.getInstance(Locale.ENGLISH);
        Calendar lc = Calendar.getInstance(locale);
        sb.append("zk.YDELTA=").append(lc.get(1) - ec.get(1)).append(";\n");
        df = new SimpleDateFormat("EEEE", locale);
        String[] fdow = new String[7];
        int j2 = firstDayOfWeek;
        for (int k = 0; k < 7; ++k) {
            cal.set(7, j2);
            fdow[k] = df.format(cal.getTime());
            if (++j2 <= 7) continue;
            j2 = 1;
        }
        df = new SimpleDateFormat("MMM", locale);
        String[] smon = new String[12];
        String[] s2mon = new String[12];
        for (int j3 = 0; j3 < 12; ++j3) {
            int len;
            char cc;
            cal.set(2, j3);
            smon[j3] = df.format(cal.getTime());
            s2mon[j3] = zhlang ? (smon[0].length() >= 2 ? smon[j3].substring(0, smon[j3].length() - 1) : smon[j3]) : ((cc = smon[j3].charAt((len = smon[j3].length()) - 1)) == '.' || cc == ',' ? smon[j3].substring(0, len - 1) : smon[j3]);
        }
        df = new SimpleDateFormat("MMMM", locale);
        String[] fmon = new String[12];
        for (int j4 = 0; j4 < 12; ++j4) {
            cal.set(2, j4);
            fmon[j4] = df.format(cal.getTime());
        }
        Wpds.appendJavaScriptArray(sb, "SDOW", sdow);
        if (Objects.equals((Object)s2dow, (Object)sdow)) {
            sb.append("zk.S2DOW=zk.SDOW;\n");
        } else {
            Wpds.appendJavaScriptArray(sb, "S2DOW", s2dow);
        }
        if (Objects.equals((Object)fdow, (Object)sdow)) {
            sb.append("zk.FDOW=zk.SDOW;\n");
        } else {
            Wpds.appendJavaScriptArray(sb, "FDOW", fdow);
        }
        Wpds.appendJavaScriptArray(sb, "SMON", smon);
        if (Objects.equals((Object)s2mon, (Object)smon)) {
            sb.append("zk.S2MON=zk.SMON;\n");
        } else {
            Wpds.appendJavaScriptArray(sb, "S2MON", s2mon);
        }
        if (Objects.equals((Object)fmon, (Object)smon)) {
            sb.append("zk.FMON=zk.SMON;\n");
        } else {
            Wpds.appendJavaScriptArray(sb, "FMON", fmon);
        }
        df = new SimpleDateFormat("a", locale);
        cal.set(11, 3);
        String[] ampm = new String[2];
        ampm[0] = df.format(cal.getTime());
        cal.set(11, 15);
        ampm[1] = df.format(cal.getTime());
        Wpds.appendJavaScriptArray(sb, "APM", ampm);
        if ("true".equals(Library.getProperty((String)"org.zkoss.zk.ui.processMask.enabled"))) {
            sb.append("zk.processMask=true;\n");
        }
        if ("true".equals(Library.getProperty((String)"org.zkoss.zk.ui.invokeFirstRootForAfterKeyDown.enabled", (String)"false"))) {
            sb.append("if (zk.invokeFirstRootForAfterKeyDown == undefined)zk.invokeFirstRootForAfterKeyDown=true;\n");
        }
        return sb.toString();
    }

    private static final void appendJavaScriptArray(StringBuffer sb, String varnm, String[] vals) {
        sb.append("zk.").append(varnm).append("=[");
        int j = 0;
        while (true) {
            sb.append('\'').append(Strings.escape((String)vals[j], (String)"'\n\r\t\f\\/!")).append('\'');
            if (++j >= vals.length) break;
            sb.append(',');
        }
        sb.append("];\n");
    }

    public static final String outLocaleJavaScript(ServletRequest request, ServletResponse response) throws IOException {
        StringBuffer result = new StringBuffer(4096);
        WebApp webApp = WebApps.getCurrent();
        FakeExecution exec = new FakeExecution(webApp.getServletContext(), request, response, null, null);
        result.append(Devices.loadJavaScript(exec, "~./js/zk/lang/msgzk*.js"));
        result.append(Wpds.outLocaleJavaScript());
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType("ajax")) {
            for (MessageLoader loader : langdef.getMessageLoaders()) {
                loader.load(result, exec);
            }
        }
        return result.toString();
    }

    static {
        _datejs.setLifetime(86400000);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FakeExecution
    extends ExecutionImpl {
        FakeExecution(ServletContext ctx, ServletRequest request, ServletResponse response, Desktop desktop, Page creating) {
            super(ctx, (HttpServletRequest)request, (HttpServletResponse)response, desktop, creating);
        }

        @Override
        public void onActivate() {
        }

        @Override
        public void onDeactivate() {
        }

        @Override
        public Evaluator getEvaluator(Page page, Class<? extends ExpressionFactory> expfcls) {
            return null;
        }

        public Evaluator getEvaluator(Component page, Class expfcls) {
            return null;
        }

        public Object evaluate(Component comp, String expr, Class expectedType) {
            throw new UnsupportedOperationException();
        }

        public Object evaluate(Page page, String expr, Class expectedType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void include(Writer out, String page, Map<String, ?> params, int mode) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void include(String page) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forward(Writer out, String page, Map<String, ?> params, int mode) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forward(String page) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PageDefinition getPageDefinition(String uri) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PageDefinition getPageDefinitionDirectly(String content, String ext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PageDefinition getPageDefinitionDirectly(Document content, String ext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PageDefinition getPageDefinitionDirectly(Reader reader, String ext) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addScopeListener(ScopeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeScopeListener(ScopeListener listener) {
            throw new UnsupportedOperationException();
        }
    }
}

