/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.html.JavaScript;
import org.zkoss.html.StyleSheet;
import org.zkoss.lang.Objects;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.FastReadArray;
import org.zkoss.util.resource.Locator;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.taglib.Taglibs;
import org.zkoss.zk.device.DeviceNotFoundException;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.Macro;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentDefinitionMap;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionLoaders;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LangEvalRef;
import org.zkoss.zk.ui.metainfo.MessageLoader;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.WidgetDefinition;
import org.zkoss.zk.ui.metainfo.impl.ComponentDefinitionImpl;
import org.zkoss.zk.ui.sys.PageRenderer;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.EvaluatorRef;
import org.zkoss.zk.xel.impl.SimpleEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageDefinition {
    private static final Logger log = LoggerFactory.getLogger(LanguageDefinition.class);
    private static final Map<String, LanguageDefinition> _ldefByName = new HashMap<String, LanguageDefinition>();
    private static final Map<String, LanguageDefinition> _ldefsByExt = new HashMap<String, LanguageDefinition>();
    private static final Map<String, List<LanguageDefinition>> _ldefsByClient = new HashMap<String, List<LanguageDefinition>>();
    private static final Map<String, WidgetDefinition> _wgtdefs = new HashMap<String, WidgetDefinition>();
    public static final String ZK_NAMESPACE = "http://www.zkoss.org/2005/zk";
    public static final String NATIVE_NAMESPACE = "http://www.zkoss.org/2005/zk/native";
    public static final String CLIENT_NAMESPACE = "http://www.zkoss.org/2005/zk/client";
    public static final String CLIENT_ATTRIBUTE_NAMESPACE = "http://www.zkoss.org/2005/zk/client/attribute";
    public static final String ANNOTATION_NAMESPACE = "http://www.zkoss.org/2005/zk/annotation";
    public static final String NATIVE_NAMESPACE_PREFIX = "native:";
    public static final String SHADOW_NAMESPACE = "http://www.zkoss.org/2015/zk/shadow";
    public static final String SHADOW_NAME = "shadow";
    private final String _deviceType;
    private final String _name;
    private final String _ns;
    private List<String> _exts;
    private final ComponentDefinitionMap _compdefs;
    private String _dyntagnm;
    private ComponentDefinition _dyntagDefn;
    private Set<String> _dyntagRvAttrs;
    private final Map<String, String> _initscripts = new HashMap<String, String>();
    private final Map<String, String> _eachscripts = new HashMap<String, String>();
    private final FastReadArray<Taglib> _taglibs = new FastReadArray(Taglib.class);
    private final FastReadArray<JavaScript> _js = new FastReadArray(JavaScript.class);
    private Map<String, FastReadArray<String>> _mergepkgs = new HashMap<String, FastReadArray<String>>(4);
    private Map<String, String> _jsmods = new HashMap<String, String>();
    private final FastReadArray<StyleSheet> _ss = new FastReadArray(StyleSheet.class);
    private final Locator _locator;
    private LabelTemplate _labeltmpl;
    private Class<? extends Component> _macrocls;
    private Class<? extends Component> _shadowcls;
    private final ComponentDefinitionMap _shadowdefs;
    private ComponentDefinition _nativedef;
    private Evaluator _eval;
    private EvaluatorRef _evalr;
    private PageRenderer _pgrend;
    private final FastReadArray<MessageLoader> _msgloads = new FastReadArray(MessageLoader.class);
    private final Set<String> _cssURIs = new LinkedHashSet<String>();
    private final boolean _native;
    private final String _treeBuilderClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String name) {
        LanguageDefinition.init();
        Map<String, LanguageDefinition> map = _ldefByName;
        synchronized (map) {
            return _ldefByName.containsKey(name);
        }
    }

    public String getTreeBuilderClass() {
        return this._treeBuilderClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LanguageDefinition lookup(String name) {
        LanguageDefinition langdef;
        LanguageDefinition.init();
        if (name == null || name.length() == 0) {
            name = "xul/html";
        }
        Map<String, LanguageDefinition> map = _ldefByName;
        synchronized (map) {
            langdef = _ldefByName.get(name);
            if (langdef == null) {
                String slashnm = "/" + name;
                for (Map.Entry<String, LanguageDefinition> me : _ldefByName.entrySet()) {
                    String langnm = me.getKey();
                    int j = langnm.indexOf(47);
                    if (j < 0) continue;
                    if (langnm.indexOf(47, j + 1) < 0) {
                        if (!langnm.substring(0, j).equals(name)) continue;
                        return me.getValue();
                    }
                    if (!langnm.endsWith(slashnm)) continue;
                    return me.getValue();
                }
                if ("html".equals(name) || "htm".equals(name)) {
                    return LanguageDefinition.lookup("xhtml");
                }
            }
        }
        if (langdef == null) {
            if (ZK_NAMESPACE.equals(name)) {
                throw new DefinitionNotFoundException("http://www.zkoss.org/2005/zk is reserved. Use it only with reserved elements and attributes, such as zscript and attribute");
            }
            throw new DefinitionNotFoundException("Language not found: " + name);
        }
        return langdef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LanguageDefinition getByExtension(String ext) {
        LanguageDefinition langdef;
        LanguageDefinition.init();
        if (ext == null) {
            ext = "zul";
        }
        Map<String, LanguageDefinition> map = _ldefsByExt;
        synchronized (map) {
            langdef = _ldefsByExt.get(ext);
        }
        if (langdef == null) {
            throw new DefinitionNotFoundException("Language not found for extension " + ext);
        }
        return langdef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addExtension(String ext, String lang) {
        if (lang == null || ext == null) {
            throw new IllegalArgumentException();
        }
        LanguageDefinition.init();
        LanguageDefinition langdef = LanguageDefinition.lookup(lang);
        Map<String, LanguageDefinition> map = _ldefsByExt;
        synchronized (map) {
            _ldefsByExt.put(ext, langdef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<LanguageDefinition> getByDeviceType(String deviceType) {
        List<LanguageDefinition> ldefs;
        LanguageDefinition.init();
        Map<String, List<LanguageDefinition>> map = _ldefsByClient;
        synchronized (map) {
            ldefs = _ldefsByClient.get(deviceType);
        }
        if (ldefs != null) {
            return ldefs;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<LanguageDefinition> getAll() {
        LanguageDefinition.init();
        LinkedList<LanguageDefinition> list = new LinkedList<LanguageDefinition>();
        Map<String, List<LanguageDefinition>> map = _ldefsByClient;
        synchronized (map) {
            for (List<LanguageDefinition> langs : _ldefsByClient.values()) {
                list.addAll(langs);
            }
        }
        return list;
    }

    public static final Collection<String> getDeviceTypes() {
        LanguageDefinition.init();
        return _ldefsByClient.keySet();
    }

    private static final void init() {
        try {
            DefinitionLoaders.load();
        }
        catch (IOException ex) {
            throw new UiException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguageDefinition(String deviceType, String name, String namespace, List<String> extensions, PageRenderer pageRenderer, boolean ignoreCase, boolean bNative, Locator locator, String treeBuilderClass) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new UiException("deviceType cannot be empty");
        }
        if (!Devices.exists(deviceType)) {
            throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
        }
        if (ZK_NAMESPACE.equals(namespace)) {
            throw new UiException("http://www.zkoss.org/2005/zk is reserved.");
        }
        if (name == null || name.length() == 0 || namespace == null || namespace.length() == 0 || pageRenderer == null || locator == null) {
            throw new IllegalArgumentException();
        }
        this._deviceType = deviceType;
        this._name = name;
        this._ns = namespace;
        this._locator = locator;
        this._native = bNative;
        this._pgrend = pageRenderer;
        this._compdefs = new ComponentDefinitionMap(ignoreCase);
        this._shadowdefs = new ComponentDefinitionMap(ignoreCase);
        this._treeBuilderClass = treeBuilderClass;
        boolean replWarned = false;
        Map<String, Object> map = _ldefByName;
        synchronized (map) {
            if (!_ldefByName.containsKey(name) && _ldefByName.containsKey(namespace)) {
                throw new UiException("Different language, " + name + ", with the same namespace, " + namespace);
            }
            _ldefByName.put(namespace, this);
            LanguageDefinition old = _ldefByName.put(name, this);
            if (old != null) {
                List<LanguageDefinition> ldefs = _ldefsByClient.get(deviceType);
                if (ldefs != null) {
                    ldefs.remove(old);
                }
                replWarned = true;
                log.warn("Replicated language: " + name + ", overriden by " + this);
            }
        }
        if (extensions != null) {
            map = _ldefsByExt;
            synchronized (map) {
                for (String ext : extensions) {
                    LanguageDefinition old = _ldefsByExt.put(ext, this);
                    if (replWarned || old == null) continue;
                    log.warn("Extension " + ext + ", overriden by " + this);
                }
            }
            this._exts = Collections.unmodifiableList(extensions);
        } else {
            this._exts = Collections.emptyList();
        }
        map = _ldefsByClient;
        synchronized (map) {
            List<LanguageDefinition> ldefs = _ldefsByClient.get(deviceType);
            if (ldefs == null) {
                ldefs = new LinkedList<LanguageDefinition>();
                _ldefsByClient.put(deviceType, ldefs);
            }
            ldefs.add(this);
        }
    }

    public String getDeviceType() {
        return this._deviceType;
    }

    public boolean isNative() {
        return this._native;
    }

    public String getName() {
        return this._name;
    }

    public String getNamespace() {
        return this._ns;
    }

    public List<String> getExtensions() {
        return this._exts;
    }

    public Collection<ComponentDefinition> getShadowDefinitions() {
        return this._shadowdefs.getDefinitions();
    }

    public ComponentDefinitionMap getShadowDefinitionMap() {
        return this._shadowdefs;
    }

    public Collection<ComponentDefinition> getComponentDefinitions() {
        return this._compdefs.getDefinitions();
    }

    public ComponentDefinitionMap getComponentDefinitionMap() {
        return this._compdefs;
    }

    public ComponentDefinition getShadowDefinition(String name) {
        ComponentDefinition compdef = this._shadowdefs.get(name);
        if (compdef == null) {
            throw new DefinitionNotFoundException("Shadow element definition not found: " + name);
        }
        return compdef;
    }

    public ComponentDefinition getShadowDefinitionIfAny(String name) {
        return this._shadowdefs.get(name);
    }

    public ComponentDefinition getShadowDefinition(Class klass) {
        ComponentDefinition compdef = this._shadowdefs.get(klass);
        if (compdef == null) {
            throw new DefinitionNotFoundException("Shadow element definition not found: " + klass);
        }
        return compdef;
    }

    public boolean hasShadowDefinition(String name) {
        return this._shadowdefs.contains(name);
    }

    public void addShadowDefinition(ComponentDefinition compdef) {
        if (compdef == null) {
            throw new IllegalArgumentException();
        }
        this._shadowdefs.add(compdef);
    }

    public ComponentDefinition getComponentDefinition(String name) {
        ComponentDefinition compdef = this._compdefs.get(name);
        if (compdef == null) {
            throw new DefinitionNotFoundException("Component definition not found: " + name);
        }
        return compdef;
    }

    public ComponentDefinition getComponentDefinitionIfAny(String name) {
        return this._compdefs.get(name);
    }

    public ComponentDefinition getComponentDefinition(Class klass) {
        ComponentDefinition compdef = this._compdefs.get(klass);
        if (compdef == null) {
            throw new DefinitionNotFoundException("Component definition not found: " + klass);
        }
        return compdef;
    }

    public boolean hasComponentDefinition(String name) {
        return this._compdefs.contains(name);
    }

    public void addComponentDefinition(ComponentDefinition compdef) {
        if (compdef == null) {
            throw new IllegalArgumentException();
        }
        this._compdefs.add(compdef);
    }

    public boolean hasWidgetDefinition(String widgetClass) {
        return _wgtdefs.containsKey(widgetClass);
    }

    public WidgetDefinition getWidgetDefinition(String widgetClass) {
        WidgetDefinition wgtdef = this.getWidgetDefinitionIfAny(widgetClass);
        if (wgtdef == null) {
            throw new DefinitionNotFoundException("Widget definition not found: " + widgetClass);
        }
        return wgtdef;
    }

    public WidgetDefinition getWidgetDefinitionIfAny(String widgetClass) {
        return _wgtdefs.get(widgetClass);
    }

    public void addWidgetDefinition(WidgetDefinition wgtdef) {
        _wgtdefs.put(wgtdef.getWidgetClass(), wgtdef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitScript(String zslang, String script) {
        if (zslang == null || zslang.length() == 0) {
            throw new IllegalArgumentException("null or empty language");
        }
        if (script != null && script.length() > 0) {
            zslang = zslang.toLowerCase(Locale.ENGLISH);
            Map<String, String> map = this._initscripts;
            synchronized (map) {
                String s = this._initscripts.get(zslang);
                this._initscripts.put(zslang, s != null ? s + '\n' + script : script);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInitScript(String zslang) {
        zslang = zslang.toLowerCase(Locale.ENGLISH);
        Map<String, String> map = this._initscripts;
        synchronized (map) {
            return this._initscripts.get(zslang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEachTimeScript(String zslang, String script) {
        if (zslang == null || zslang.length() == 0) {
            throw new IllegalArgumentException("null or empty language");
        }
        if (script != null && script.length() > 0) {
            zslang = zslang.toLowerCase(Locale.ENGLISH);
            Map<String, String> map = this._eachscripts;
            synchronized (map) {
                String s = this._eachscripts.get(zslang);
                this._eachscripts.put(zslang, s != null ? s + '\n' + script : script);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEachTimeScript(String zslang) {
        zslang = zslang.toLowerCase(Locale.ENGLISH);
        Map<String, String> map = this._eachscripts;
        synchronized (map) {
            return this._eachscripts.get(zslang);
        }
    }

    public void addJavaScript(JavaScript js) {
        if (js == null) {
            throw new IllegalArgumentException();
        }
        this._js.add((Object)js);
    }

    public void removeJavaScript(String src) {
        JavaScript[] ary = (JavaScript[])this._js.toArray();
        for (int j = 0; j < ary.length; ++j) {
            JavaScript js = ary[j];
            if (!Objects.equals((Object)src, (Object)js.getSrc())) continue;
            this._js.remove((Object)js);
            return;
        }
    }

    public Collection<JavaScript> getJavaScripts() {
        return new CollectionsX.ArrayCollection(this._js.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeJavaScriptPackage(String pkgFrom, String pkgTo) {
        if (pkgFrom == null || pkgFrom.length() == 0 || pkgTo == null || pkgTo.length() == 0) {
            throw new IllegalArgumentException();
        }
        FastReadArray pkgs = this._mergepkgs.get(pkgTo);
        if (pkgs == null) {
            LanguageDefinition languageDefinition = this;
            synchronized (languageDefinition) {
                pkgs = this._mergepkgs.get(pkgTo);
                if (pkgs == null) {
                    HashMap<String, FastReadArray<String>> mpkgs = new HashMap<String, FastReadArray<String>>(this._mergepkgs);
                    pkgs = new FastReadArray(String.class);
                    mpkgs.put(pkgTo, (FastReadArray<String>)pkgs);
                    this._mergepkgs = mpkgs;
                }
            }
        }
        pkgs.add((Object)pkgFrom);
    }

    public boolean unmergeJavaScriptPackage(String pkgFrom, String pkgTo) {
        FastReadArray<String> pkgs = this._mergepkgs.get(pkgTo);
        return pkgs != null && pkgs.remove((Object)pkgFrom);
    }

    public Collection<String> getMergedJavaScriptPackages(String pkg) {
        FastReadArray<String> pkgs = this._mergepkgs.get(pkg);
        if (pkgs != null) {
            return new CollectionsX.ArrayCollection(pkgs.toArray());
        }
        return Collections.emptyList();
    }

    public Set<String> getJavaScriptPackagesWithMerges() {
        return this._mergepkgs.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavaScriptModule(String name, String version) {
        if (name == null || name.length() == 0 || version == null || version.length() == 0) {
            throw new IllegalArgumentException();
        }
        LanguageDefinition languageDefinition = this;
        synchronized (languageDefinition) {
            HashMap<String, String> jsmods = new HashMap<String, String>(this._jsmods);
            jsmods.put(name, version);
            this._jsmods = jsmods;
        }
    }

    public Map<String, String> getJavaScriptModules() {
        return Collections.unmodifiableMap(this._jsmods);
    }

    public void addStyleSheet(StyleSheet ss) {
        if (ss == null) {
            throw new IllegalArgumentException();
        }
        this._ss.add((Object)ss);
    }

    public Collection<StyleSheet> getStyleSheets() {
        return new CollectionsX.ArrayCollection(this._ss.toArray());
    }

    public boolean isCaseInsensitive() {
        return this._compdefs.isCaseInsensitive();
    }

    public PageRenderer getPageRenderer() {
        return this._pgrend;
    }

    public void addMessageLoader(MessageLoader loader) {
        this._msgloads.add((Object)loader);
    }

    public Collection<MessageLoader> getMessageLoaders() {
        return new CollectionsX.ArrayCollection(this._msgloads.toArray());
    }

    public void setMacroTemplate(Class<? extends Component> klass) {
        if (klass == null || !Component.class.isAssignableFrom(klass) || !Macro.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException("Illegal macro class: " + klass);
        }
        this._macrocls = klass;
    }

    public ComponentDefinition getMacroDefinition(String name, String macroURI, boolean inline, PageDefinition pgdef) {
        if (this._macrocls == null) {
            throw new UiException("Macro not supported by " + this);
        }
        ComponentDefinition compdef = ComponentDefinitionImpl.newMacroDefinition(pgdef != null ? null : this, pgdef, name, this._macrocls, macroURI, inline);
        return compdef;
    }

    public void setShadowTemplate(Class<? extends Component> klass) {
        if (klass == null || !Component.class.isAssignableFrom(klass) || !ShadowElement.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException("Illegal shadow class: " + klass);
        }
        this._shadowcls = klass;
    }

    public ComponentDefinition getShadowDefinition(String name, PageDefinition pgdef, String templateURI) {
        if (this._shadowcls == null) {
            throw new UiException("Shadow not supported by " + this);
        }
        ComponentDefinition compdef = ComponentDefinitionImpl.newShadowDefinition(pgdef != null ? null : this, pgdef, name, this._shadowcls, templateURI);
        return compdef;
    }

    public void setNativeTemplate(Class<? extends Component> klass) {
        if (klass == null || !Component.class.isAssignableFrom(klass) || !Native.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException("Illegal native class: " + klass);
        }
        this._nativedef = ComponentDefinitionImpl.newNativeDefinition(this, "native", klass);
    }

    public ComponentDefinition getNativeDefinition() {
        if (this._nativedef == null) {
            throw new UnsupportedOperationException("Native not supported by " + this);
        }
        return this._nativedef;
    }

    public void setLabelTemplate(String compName, String propName, boolean raw) {
        this._labeltmpl = compName != null ? new LabelTemplate(compName, propName, raw) : null;
    }

    public ComponentInfo newLabelInfo(NodeInfo parent, String text) {
        if (this._labeltmpl == null) {
            throw new UiException("No default label component is supported by " + this);
        }
        return this._labeltmpl.newComponentInfo(parent, text);
    }

    public boolean isRawLabel() {
        return this._labeltmpl != null && this._labeltmpl.raw;
    }

    public String getLabelAttribute() {
        return this._labeltmpl != null ? this._labeltmpl._name : null;
    }

    public void setDynamicTagInfo(String compnm, Set<String> reservedAttrs) {
        if (compnm != null && this._dyntagnm != null) {
            log.warn("Overwriting the definition of dynamic tag. Previous=" + this._dyntagnm + " New=" + compnm + " for " + this);
        }
        this._dyntagnm = compnm;
        this._dyntagDefn = null;
        this._dyntagRvAttrs = compnm == null || reservedAttrs.isEmpty() ? null : Collections.unmodifiableSet(new HashSet<String>(reservedAttrs));
    }

    public ComponentDefinition getDynamicTagDefinition() {
        if (this._dyntagDefn == null) {
            if (this._dyntagnm == null) {
                return null;
            }
            this._dyntagDefn = this.getComponentDefinition(this._dyntagnm);
        }
        return this._dyntagDefn;
    }

    public boolean isDynamicReservedAttributes(String attr) {
        return this._dyntagRvAttrs != null && this._dyntagRvAttrs.contains(attr);
    }

    public void addTaglib(Taglib taglib) {
        this._taglibs.add((Object)taglib);
        this._eval = null;
    }

    public Evaluator getEvaluator() {
        if (this._eval == null) {
            this._eval = this.newEvaluator();
        }
        return this._eval;
    }

    private Evaluator newEvaluator() {
        return new SimpleEvaluator(Taglibs.getFunctionMapper((Collection)new CollectionsX.ArrayCollection(this._taglibs.toArray()), (Locator)this._locator), null);
    }

    public EvaluatorRef getEvaluatorRef() {
        if (this._evalr == null) {
            this._evalr = this.newEvaluatorRef();
        }
        return this._evalr;
    }

    private EvaluatorRef newEvaluatorRef() {
        return new LangEvalRef(this);
    }

    public void addCSSURI(String cssURI) {
        if (cssURI == null || cssURI.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._cssURIs.add(cssURI);
    }

    public Collection<String> getCSSURIs() {
        return this._cssURIs;
    }

    public String toString() {
        return "[LanguageDefinition: " + this._name + ']';
    }

    private class LabelTemplate {
        private ComponentDefinition _compdef;
        private final String _name;
        private final String _prop;
        private final boolean raw;

        private LabelTemplate(String name, String prop, boolean raw) {
            if (name == null || name.length() == 0 || prop == null || prop.length() == 0) {
                throw new IllegalArgumentException();
            }
            this._name = name;
            this._prop = prop;
            this.raw = raw;
        }

        private ComponentInfo newComponentInfo(NodeInfo parent, String text) {
            if (this._compdef == null) {
                this._compdef = LanguageDefinition.this.getComponentDefinition(this._name);
            }
            ComponentInfo info = new ComponentInfo(parent, this._compdef, null);
            info.addProperty(this._prop, text, null);
            return info;
        }
    }
}

