/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.html.HTMLs;
import org.zkoss.lang.ClassResolver;
import org.zkoss.lang.ImportedClassResolver;
import org.zkoss.util.resource.Locator;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.taglib.FunctionDefinition;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.taglib.Taglibs;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.BranchInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentDefinitionMap;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.ForwardInfo;
import org.zkoss.zk.ui.metainfo.FunctionMapperInfo;
import org.zkoss.zk.ui.metainfo.HeaderInfo;
import org.zkoss.zk.ui.metainfo.InitiatorInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.LeafInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageEvalRef;
import org.zkoss.zk.ui.metainfo.ResponseHeaderInfo;
import org.zkoss.zk.ui.metainfo.TemplateInfo;
import org.zkoss.zk.ui.metainfo.VariableResolverInfo;
import org.zkoss.zk.ui.sys.PageConfig;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.EvaluatorRef;
import org.zkoss.zk.xel.ExValue;
import org.zkoss.zk.xel.impl.SimpleEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageDefinition
implements NodeInfo {
    private final List<NodeInfo> _children = new LinkedList<NodeInfo>();
    private final LanguageDefinition _langdef;
    private final Locator _locator;
    private String _id;
    private String _title;
    private String _style;
    private String _viewport;
    private String _path = "";
    private String _zslang = "Java";
    private List<Taglib> _taglibs;
    private Map<String, Class<?>> _expimps;
    private List<FunctionDefinition> _xelfuncs;
    private Evaluator _eval;
    private EvaluatorRef _evalr;
    private FunctionMapper _mapper;
    private List<InitiatorInfo> _initdefs;
    private List<VariableResolverInfo> _resolvdefs;
    private List<FunctionMapperInfo> _mapperdefs;
    private List<HeaderInfo> _hdBfrDefs;
    private List<HeaderInfo> _hdAftDefs;
    private List<ResponseHeaderInfo> _hdResDefs;
    private List<ForwardInfo> _forwdefs;
    private Map<String, ExValue> _rootAttrs;
    private ExValue _contentType;
    private ExValue _docType;
    private ExValue _firstLine;
    private ExValue _wgtcls;
    private Class<? extends ExpressionFactory> _expfcls;
    private final ImportedClassResolver _clsresolver = new ImportedClassResolver();
    private final ComponentDefinitionMap _compdefs;
    private Boolean _cacheable;
    private Boolean _autoTimeout;
    private boolean _complete;
    private Map<String, TemplateInfo> _templatesInfo;

    public PageDefinition(LanguageDefinition langdef, Locator locator) {
        if (langdef == null) {
            throw new IllegalArgumentException("null langdef");
        }
        if (locator == null) {
            throw new IllegalArgumentException("null locator");
        }
        this._langdef = langdef;
        this._locator = locator;
        this._compdefs = new ComponentDefinitionMap(this._langdef.getComponentDefinitionMap().isCaseInsensitive());
    }

    public PageDefinition(LanguageDefinition langdef, String id, String title, String style, Locator locator) {
        this(langdef, locator);
        this.setId(id);
        this.setTitle(title);
        this.setStyle(style);
    }

    public LanguageDefinition getLanguageDefinition() {
        return this._langdef;
    }

    public Locator getLocator() {
        return this._locator;
    }

    public String getZScriptLanguage() {
        return this._zslang;
    }

    public void setZScriptLanguage(String zslang) {
        if (zslang == null || zslang.length() == 0) {
            throw new IllegalArgumentException("null or empty");
        }
        this._zslang = zslang;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id != null && id.length() > 0 ? id : null;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title != null && title.length() > 0 ? title : null;
    }

    public String getStyle() {
        return this._style;
    }

    public void setStyle(String style) {
        this._style = style != null && style.length() > 0 ? style : null;
    }

    public String getViewport() {
        return this._viewport;
    }

    public void setViewport(String viewport) {
        this._viewport = viewport != null && viewport.length() > 0 ? viewport : "auto";
    }

    public String getWidgetClass(Page page) {
        return this._wgtcls != null ? (String)this._wgtcls.getValue((Evaluator)this._evalr, page) : null;
    }

    public void setWidgetClass(String wgtcls) {
        this._wgtcls = wgtcls != null && wgtcls.length() > 0 ? new ExValue(wgtcls, String.class) : null;
    }

    public String getRequestPath() {
        return this._path;
    }

    public void setRequestPath(String path) {
        this._path = path != null ? path : "";
    }

    public void imports(PageDefinition pgdef, String[] directives) {
        if (directives == null || PageDefinition.contains(directives, "import")) {
            this._clsresolver.addAll(pgdef._clsresolver);
        }
        if (pgdef._initdefs != null && (directives == null || PageDefinition.contains(directives, "init"))) {
            for (InitiatorInfo ii : pgdef._initdefs) {
                this.addInitiatorInfo(ii);
            }
        }
        if (directives == null || PageDefinition.contains(directives, "component")) {
            Iterator<String> it = pgdef._compdefs.getNames().iterator();
            while (it.hasNext()) {
                this.addComponentDefinition(pgdef._compdefs.get(it.next()));
            }
        }
        if (pgdef._taglibs != null && directives != null && PageDefinition.contains(directives, "taglib")) {
            for (Taglib tl : pgdef._taglibs) {
                this.addTaglib(tl);
            }
        }
        if (pgdef._resolvdefs != null && directives != null && PageDefinition.contains(directives, "variable-resolver")) {
            for (VariableResolverInfo vri : pgdef._resolvdefs) {
                this.addVariableResolverInfo(vri);
            }
        }
        if (pgdef._mapperdefs != null && directives != null && PageDefinition.contains(directives, "function-mapper")) {
            for (FunctionMapperInfo fmi : pgdef._mapperdefs) {
                this.addFunctionMapperInfo(fmi);
            }
        }
        if (pgdef._xelfuncs != null && directives != null && PageDefinition.contains(directives, "xel-method")) {
            for (FunctionDefinition xfi : pgdef._xelfuncs) {
                this.addXelMethod(xfi.prefix, xfi.name, xfi.function);
            }
        }
        if (pgdef._hdBfrDefs != null && directives != null && PageDefinition.contains(directives, "meta")) {
            for (HeaderInfo hi : pgdef._hdBfrDefs) {
                this.addHeaderInfo(hi, true);
            }
        }
        if (pgdef._hdAftDefs != null && directives != null && PageDefinition.contains(directives, "meta")) {
            for (HeaderInfo hi : pgdef._hdAftDefs) {
                this.addHeaderInfo(hi, false);
            }
        }
        if (pgdef._hdResDefs != null && directives != null && PageDefinition.contains(directives, "header")) {
            for (ResponseHeaderInfo rhi : pgdef._hdResDefs) {
                this.addResponseHeaderInfo(rhi);
            }
        }
    }

    private static boolean contains(String[] dirs, String dir) {
        int j = dirs.length;
        while (--j >= 0) {
            if (!"*".equals(dirs[j]) && !dir.equalsIgnoreCase(dirs[j])) continue;
            return true;
        }
        return false;
    }

    public void imports(PageDefinition pgdef) {
        this.imports(pgdef, null);
    }

    public void addImportedClass(String clsptn) throws ClassNotFoundException {
        this._clsresolver.addImportedClass(clsptn);
    }

    public List<String> getImportedClasses() {
        return this._clsresolver.getImportedClasses();
    }

    public ClassResolver getImportedClassResolver() {
        return this._clsresolver;
    }

    public void addInitiatorInfo(InitiatorInfo init) {
        if (init == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._initdefs == null) {
            this._initdefs = new LinkedList<InitiatorInfo>();
        }
        this._initdefs.add(init);
    }

    public List<Initiator> doInit(Page page) {
        if (this._initdefs == null) {
            return Collections.emptyList();
        }
        LinkedList<Initiator> inits = new LinkedList<Initiator>();
        try {
            for (InitiatorInfo ii : this._initdefs) {
                Initiator init = ii.newInitiator(this.getEvaluator(), page);
                if (init == null) continue;
                inits.add(init);
            }
        }
        catch (Throwable ex) {
            throw UiException.Aide.wrap(ex);
        }
        return inits;
    }

    public void addVariableResolverInfo(VariableResolverInfo resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._resolvdefs == null) {
            this._resolvdefs = new LinkedList<VariableResolverInfo>();
        }
        this._resolvdefs.add(resolver);
    }

    public void addFunctionMapperInfo(FunctionMapperInfo mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._mapperdefs == null) {
            this._mapperdefs = new LinkedList<FunctionMapperInfo>();
        }
        this._mapperdefs.add(mapper);
    }

    public void addXelMethod(String prefix, String name, Function func) {
        this.checkXelModifiable();
        if (name == null || prefix == null || func == null) {
            throw new IllegalArgumentException();
        }
        if (this._xelfuncs == null) {
            this._xelfuncs = new LinkedList<FunctionDefinition>();
        }
        this._xelfuncs.add(new FunctionDefinition(prefix, name, func));
    }

    public void addResponseHeaderInfo(ResponseHeaderInfo header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        if (this._hdResDefs == null) {
            this._hdResDefs = new LinkedList<ResponseHeaderInfo>();
        }
        this._hdResDefs.add(header);
    }

    public Collection<Object[]> getResponseHeaders(Page page) {
        LinkedList<Object[]> headers = new LinkedList<Object[]>();
        if (this._hdResDefs != null) {
            for (ResponseHeaderInfo rhi : this._hdResDefs) {
                headers.add(new Object[]{rhi.getName(), rhi.getValue(this, page), rhi.shallAppend(this, page)});
            }
        }
        return headers;
    }

    public void addHeaderInfo(HeaderInfo header, boolean before) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        if (before) {
            if (this._hdBfrDefs == null) {
                this._hdBfrDefs = new LinkedList<HeaderInfo>();
            }
            this._hdBfrDefs.add(header);
        } else {
            if (this._hdAftDefs == null) {
                this._hdAftDefs = new LinkedList<HeaderInfo>();
            }
            this._hdAftDefs.add(header);
        }
    }

    public void addHeaderInfo(HeaderInfo header) {
        this.addHeaderInfo(header, "meta".equals(header.getName()));
    }

    public String getBeforeHeadTags(Page page) {
        return this.getHeadTags(page, this._hdBfrDefs);
    }

    public String getAfterHeadTags(Page page) {
        return this.getHeadTags(page, this._hdAftDefs);
    }

    private String getHeadTags(Page page, List<HeaderInfo> defs) {
        if (defs == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(256);
        for (HeaderInfo hi : defs) {
            String s = hi.toHTML(this, page);
            if (s == null || s.length() <= 0) continue;
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    public void addForwardInfo(ForwardInfo forward) {
        if (forward == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._forwdefs == null) {
            this._forwdefs = new LinkedList<ForwardInfo>();
        }
        this._forwdefs.add(forward);
    }

    public String getForwardURI(Page page) {
        if (this._forwdefs == null) {
            return null;
        }
        for (ForwardInfo fi : this._forwdefs) {
            String uri = fi.resolveURI(this, page);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    public String getContentType(Page page) {
        return this._contentType != null ? (String)this._contentType.getValue((Evaluator)this._evalr, page) : null;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType != null && contentType.length() > 0 ? new ExValue(contentType, String.class) : null;
    }

    public String getDocType(Page page) {
        return this._docType != null ? (String)this._docType.getValue((Evaluator)this._evalr, page) : null;
    }

    public void setDocType(String docType) {
        this._docType = docType != null ? new ExValue(docType, String.class) : null;
    }

    public String getFirstLine(Page page) {
        return this._firstLine != null ? (String)this._firstLine.getValue((Evaluator)this._evalr, page) : null;
    }

    public void setFirstLine(String firstLine) {
        this._firstLine = firstLine != null && firstLine.length() > 0 ? new ExValue(firstLine, String.class) : null;
    }

    public Boolean getCacheable() {
        return this._cacheable;
    }

    public void setCacheable(Boolean cacheable) {
        this._cacheable = cacheable;
    }

    public Boolean getAutomaticTimeout() {
        return this._autoTimeout;
    }

    public void setAutomaticTimeout(Boolean autoTimeout) {
        this._autoTimeout = autoTimeout;
    }

    public boolean isComplete() {
        return this._complete;
    }

    public void setComplete(boolean complete) {
        this._complete = complete;
    }

    public void setRootAttribute(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this._rootAttrs == null) {
            if (value == null) {
                return;
            }
            this._rootAttrs = new LinkedHashMap<String, ExValue>();
        }
        if (value == null) {
            this._rootAttrs.remove(name);
        } else {
            this._rootAttrs.put(name, new ExValue(value, String.class));
        }
    }

    public String getRootAttributes(Page page) {
        if (this._rootAttrs == null || this._rootAttrs.isEmpty()) {
            return "";
        }
        Evaluator eval = this.getEvaluator();
        StringBuffer sb = new StringBuffer(256);
        for (Map.Entry<String, ExValue> me : this._rootAttrs.entrySet()) {
            String val = (String)me.getValue().getValue(eval, page);
            if (val == null) continue;
            HTMLs.appendAttribute((StringBuffer)sb, (String)me.getKey(), (String)val);
        }
        return sb.toString();
    }

    public ComponentDefinitionMap getComponentDefinitionMap() {
        return this._compdefs;
    }

    public void addComponentDefinition(ComponentDefinition compdef) {
        LanguageDefinition ld2;
        LanguageDefinition langdef = compdef.getLanguageDefinition();
        if (langdef != null && langdef != (ld2 = this.getLanguageDefinition()) && !langdef.getDeviceType().equals(ld2.getDeviceType())) {
            throw new UiException("Component definition, " + compdef + ", does not belong to the same device type of the page definition, " + ld2.getDeviceType());
        }
        this._compdefs.add(compdef);
    }

    public ComponentDefinition getComponentDefinition(String name, boolean recurse) {
        ComponentDefinition compdef = this._compdefs.get(name);
        if (!recurse || compdef != null) {
            return compdef;
        }
        try {
            return this.getLanguageDefinition().getComponentDefinition(name);
        }
        catch (DefinitionNotFoundException definitionNotFoundException) {
            return null;
        }
    }

    public ComponentDefinition getComponentDefinition(Class cls, boolean recurse) {
        ComponentDefinition compdef = this._compdefs.get(cls);
        if (!recurse || compdef != null) {
            return compdef;
        }
        try {
            return this.getLanguageDefinition().getComponentDefinition(cls);
        }
        catch (DefinitionNotFoundException ex) {
            try {
                return this.getLanguageDefinition().getShadowDefinition(cls);
            }
            catch (DefinitionNotFoundException definitionNotFoundException) {
                return null;
            }
        }
    }

    public void addTaglib(Taglib taglib) {
        this.checkXelModifiable();
        if (taglib == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._taglibs == null) {
            this._taglibs = new LinkedList<Taglib>();
        }
        this._taglibs.add(taglib);
    }

    public void addExpressionImport(String nm, Class<?> cls) {
        this.checkXelModifiable();
        if (nm == null || cls == null) {
            throw new IllegalArgumentException();
        }
        if (this._expimps == null) {
            this._expimps = new HashMap(4);
        }
        this._expimps.put(nm, cls);
    }

    private void checkXelModifiable() {
        if (this._eval != null || this._mapper != null) {
            throw new IllegalStateException("getEvaluator() has been called, and no further change is allowed");
        }
    }

    public void setExpressionFactoryClass(Class<?> expfcls) {
        this.checkXelModifiable();
        if (expfcls != null && !ExpressionFactory.class.isAssignableFrom(expfcls)) {
            throw new IllegalArgumentException(ExpressionFactory.class + " must be implemented: " + expfcls);
        }
        this._expfcls = expfcls;
    }

    public Class<? extends ExpressionFactory> getExpressionFactoryClass() {
        return this._expfcls;
    }

    @Override
    public Evaluator getEvaluator() {
        if (this._eval == null) {
            this._eval = this.newEvaluator();
        }
        return this._eval;
    }

    private Evaluator newEvaluator() {
        return new SimpleEvaluator(this.getTaglibMapper(), this._expfcls);
    }

    @Override
    public EvaluatorRef getEvaluatorRef() {
        if (this._evalr == null) {
            this._evalr = this.newEvaluatorRef();
        }
        return this._evalr;
    }

    private EvaluatorRef newEvaluatorRef() {
        return new PageEvalRef(this);
    }

    public FunctionMapper getTaglibMapper() {
        if (this._mapper == null) {
            this._mapper = Taglibs.getFunctionMapper(this._taglibs, this._expimps, this._xelfuncs, (Locator)this._locator);
            if (this._mapper == null) {
                this._mapper = Expressions.EMPTY_MAPPER;
            }
        }
        return this._mapper != Expressions.EMPTY_MAPPER ? this._mapper : null;
    }

    public void addTemplateInfo(TemplateInfo info) {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        if (this._templatesInfo == null) {
            this._templatesInfo = new LinkedHashMap<String, TemplateInfo>();
        }
        this._templatesInfo.put(info.getName(), info);
    }

    public Map<String, TemplateInfo> getTemplatesInfo() {
        return this._templatesInfo;
    }

    public void preInit(Page page) {
        page.addClassResolver((ClassResolver)this._clsresolver);
        page.addFunctionMapper(this.getTaglibMapper());
        if (this._mapperdefs != null) {
            for (FunctionMapperInfo functionMapperInfo : this._mapperdefs) {
                try {
                    FunctionMapper mapper = functionMapperInfo.newFunctionMapper(this, page);
                    if (mapper == null) continue;
                    page.addFunctionMapper(mapper);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
        if (this._resolvdefs != null) {
            for (VariableResolverInfo variableResolverInfo : this._resolvdefs) {
                try {
                    VariableResolver resolver = variableResolverInfo.newVariableResolver(this, page);
                    if (resolver == null) continue;
                    page.addVariableResolver(resolver);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    public void init(final Page page, final boolean evalHeaders) {
        PageCtrl pageCtrl = (PageCtrl)((Object)page);
        pageCtrl.init(new PageConfig(){

            @Override
            public String getId() {
                return PageDefinition.this._id;
            }

            @Override
            public String getUuid() {
                return null;
            }

            @Override
            public String getTitle() {
                return PageDefinition.this._title;
            }

            @Override
            public String getStyle() {
                return PageDefinition.this._style;
            }

            @Override
            public String getViewport() {
                return PageDefinition.this._viewport;
            }

            @Override
            public String getBeforeHeadTags() {
                return evalHeaders ? PageDefinition.this.getBeforeHeadTags(page) : "";
            }

            @Override
            public String getAfterHeadTags() {
                return evalHeaders ? PageDefinition.this.getAfterHeadTags(page) : "";
            }

            @Override
            public Collection<Object[]> getResponseHeaders() {
                if (evalHeaders) {
                    return PageDefinition.this.getResponseHeaders(page);
                }
                return Collections.emptyList();
            }
        });
        String s = this.getRootAttributes(page);
        if (s != null) {
            pageCtrl.setRootAttributes(s);
        }
        if ((s = this.getContentType(page)) != null) {
            pageCtrl.setContentType(s);
        }
        if ((s = this.getDocType(page)) != null) {
            pageCtrl.setDocType(s);
        }
        if ((s = this.getFirstLine(page)) != null) {
            pageCtrl.setFirstLine(s);
        }
        if ((s = this.getWidgetClass(page)) != null) {
            pageCtrl.setWidgetClass(s);
        }
        if (this._cacheable != null) {
            pageCtrl.setCacheable(this._cacheable);
        }
        if (this._autoTimeout != null) {
            pageCtrl.setAutomaticTimeout(this._autoTimeout);
        }
        if (this._expfcls != null) {
            page.setExpressionFactoryClass(this._expfcls);
        }
        page.setComplete(this._complete);
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public PageDefinition getPageDefinition() {
        return this;
    }

    @Override
    public void appendChild(NodeInfo child) {
        NodeInfo oldp = child.getParent();
        if (oldp != null) {
            oldp.removeChild(child);
        }
        this._children.add(child);
        ((LeafInfo)child).setParentDirectly(this);
        BranchInfo.fixEvaluatorRefDown(child, this.getEvaluatorRef());
    }

    @Override
    public boolean removeChild(NodeInfo child) {
        if (child != null && this._children.remove(child)) {
            ((LeafInfo)child).setParentDirectly(null);
            BranchInfo.fixEvaluatorRefDown(child, null);
            return true;
        }
        return false;
    }

    @Override
    public List<NodeInfo> getChildren() {
        return this._children;
    }

    public String toString() {
        return "[PageDefinition: " + (this._id != null ? this._id : (this._title != null ? this._title : "" + System.identityHashCode(this))) + ", path=" + this._path + ']';
    }
}

