/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.util.Maps;
import org.zkoss.util.resource.Location;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.ShadowInfo;
import org.zkoss.zk.ui.sys.ComponentCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHelper {
    final List<AnnotInfo> _annots = new LinkedList<AnnotInfo>();

    public static boolean isAnnotation(String val) {
        int len = val.length();
        if (len >= 4 && (len = (val = val.trim()).length()) >= 4 && val.charAt(0) == '@') {
            int j;
            char cc;
            if (val.charAt(1) == '{') {
                if (val.charAt(len - 1) == '}') {
                    return true;
                }
            } else if (val.charAt(len - 1) == ')' && ((cc = val.charAt(j = Strings.skipWhitespaces((CharSequence)val, (int)1))) >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc == '_' || cc == '$')) {
                while (j < len) {
                    cc = val.charAt(j);
                    switch (cc) {
                        case '(': {
                            return true;
                        }
                        case '$': 
                        case '-': 
                        case '.': 
                        case '_': {
                            break;
                        }
                        default: {
                            if (Character.isWhitespace(cc)) {
                                return (j = Strings.skipWhitespaces((CharSequence)val, (int)(j + 1))) < len && val.charAt(j) == '(';
                            }
                            if (cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc >= '0' && cc <= '9') break;
                            return false;
                        }
                    }
                    ++j;
                }
            }
        }
        return false;
    }

    public void add(String annotName, Map<String, String[]> annotAttrs, Location loc) {
        if (annotName == null || annotName.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        this._annots.add(new AnnotInfo(annotName, annotAttrs, loc));
    }

    public void add(String annotName, Map<String, String[]> annotAttrs) {
        this.add(annotName, annotAttrs, null);
    }

    public void addByCompoundValue(String cval, Location loc) {
        int len = cval.length();
        if (cval.charAt(1) == '{' && cval.charAt(len - 1) == '}') {
            this.addInV5(cval.substring(2, len - 1));
            return;
        }
        int j = 0;
        while (j >= 0) {
            int k;
            if ((k = cval.indexOf(40, ++j)) < 0) {
                throw AnnotationHelper.wrongAnnotationException(cval, "'(' expected", loc);
            }
            String annotName = cval.substring(j, k).trim();
            j = ++k;
            StringBuffer sb = new StringBuffer(len);
            int nparen = 1;
            char quot = '\u0000';
            while (true) {
                if (j >= len) {
                    throw AnnotationHelper.wrongAnnotationException(cval, "')' expected", loc);
                }
                char cc = cval.charAt(j);
                if (quot == '\u0000') {
                    if (cc == '(') {
                        ++nparen;
                    } else {
                        if (cc == ')' && --nparen == 0) break;
                        if (cc == '\'' || cc == '\"') {
                            quot = cc;
                        }
                    }
                } else if (cc == quot) {
                    quot = '\u0000';
                }
                sb.append(cc);
                if (cc == '\\' && j < len - 1) {
                    sb.append(cval.charAt(++j));
                }
                ++j;
            }
            this.addByRawValueInV6(annotName, sb.toString().trim(), loc);
            j = cval.indexOf(64, j);
        }
    }

    private void addByRawValueInV6(String annotName, String rval, Location loc) {
        LinkedHashMap<String, String[]> attrs = new LinkedHashMap<String, String[]>(4);
        int len = rval.length();
        StringBuffer sb = new StringBuffer(len);
        String nm = null;
        char quot = '\u0000';
        int nparen = 0;
        int j = 0;
        while (true) {
            block27: {
                char cc;
                block31: {
                    block28: {
                        block30: {
                            block29: {
                                if (j >= len) {
                                    if (quot != '\u0000') {
                                        throw AnnotationHelper.wrongAnnotationException(rval, quot + " expected (not paired)", loc);
                                    }
                                    if (nparen != 0) {
                                        throw AnnotationHelper.wrongAnnotationException(rval, "')' expected", loc);
                                    }
                                    String val = sb.toString().trim();
                                    if (nm == null && val.length() <= 0) break;
                                    attrs.put(nm, new String[]{val});
                                    break;
                                }
                                cc = rval.charAt(j);
                                if (quot != '\u0000') break block28;
                                if (cc != ',' || nparen != 0) break block29;
                                String val = sb.toString().trim();
                                if (nm == null && val.length() == 0) {
                                    throw AnnotationHelper.wrongAnnotationException(rval, "nothing before ','", loc);
                                }
                                attrs.put(nm, new String[]{val});
                                nm = null;
                                sb.setLength(0);
                                break block27;
                            }
                            if (cc != '=' || nparen != 0) break block30;
                            if (nm != null) {
                                throw AnnotationHelper.wrongAnnotationException(rval, "',' missed between two equal sign (=)", loc);
                            }
                            nm = sb.toString().trim();
                            sb.setLength(0);
                            break block27;
                        }
                        if (cc == '(') {
                            ++nparen;
                        } else if (cc == ')') {
                            if (--nparen < 0) {
                                throw AnnotationHelper.wrongAnnotationException(rval, "too many ')'", loc);
                            }
                        } else if (cc == '\'' || cc == '\"') {
                            quot = cc;
                        } else if (cc == '{' && nparen == 0 && (sb.length() == 0 || sb.toString().trim().length() == 0)) {
                            int k = ++j;
                            int ncur = 1;
                            while (true) {
                                if (j >= len) {
                                    throw AnnotationHelper.wrongAnnotationException(rval, "'}' expected", loc);
                                }
                                cc = rval.charAt(j);
                                if (quot == '\u0000') {
                                    if (cc == '}' && --ncur == 0) {
                                        attrs.put(nm, AnnotationHelper.parseValueArray(rval.substring(k, j).trim(), loc));
                                        j = Strings.skipWhitespaces((CharSequence)rval, (int)(j + 1));
                                        if (j < len && rval.charAt(j) != ',') {
                                            throw AnnotationHelper.wrongAnnotationException(rval, "',' expected, not '" + rval.charAt(j) + '\'', loc);
                                        }
                                        nm = null;
                                        sb.setLength(0);
                                        break block27;
                                    }
                                    if (cc == '{') {
                                        ++ncur;
                                    } else if (cc == '\'' || cc == '\"') {
                                        quot = cc;
                                    }
                                } else if (cc == quot) {
                                    quot = '\u0000';
                                }
                                if (cc == '\\' && j < len - 1) {
                                    ++j;
                                }
                                ++j;
                            }
                        }
                        break block31;
                    }
                    if (cc == quot) {
                        quot = '\u0000';
                    }
                }
                sb.append(cc);
                if (cc == '\\' && j < len - 1) {
                    sb.append(rval.charAt(++j));
                }
            }
            ++j;
        }
        this.add(annotName, attrs, loc);
    }

    public static String[] parseAttributeValue(String val, Location loc) {
        int len = val.length();
        if (len >= 2 && val.charAt(0) == '{' && val.charAt(len - 1) == '}') {
            return AnnotationHelper.parseValueArray(val.substring(1, len - 1), loc);
        }
        return new String[]{val};
    }

    private static String[] parseValueArray(String rval, Location loc) {
        ArrayList<String> attrs = new ArrayList<String>();
        int len = rval.length();
        char quot = '\u0000';
        StringBuffer sb = new StringBuffer(len);
        int nparen = 0;
        int j = 0;
        while (true) {
            block14: {
                char cc;
                block15: {
                    block12: {
                        block13: {
                            if (j >= len) {
                                if (quot != '\u0000') {
                                    throw AnnotationHelper.wrongAnnotationException(rval, 39 + quot + "' expected (not paired)", loc);
                                }
                                if (nparen != 0) {
                                    throw AnnotationHelper.wrongAnnotationException(rval, "')' expected", loc);
                                }
                                String val = sb.toString().trim();
                                if (val.length() <= 0) break;
                                attrs.add(val);
                                break;
                            }
                            cc = rval.charAt(j);
                            if (quot != '\u0000') break block12;
                            if (cc != ',' || nparen != 0) break block13;
                            attrs.add(sb.toString().trim());
                            sb.setLength(0);
                            break block14;
                        }
                        if (cc == '(') {
                            ++nparen;
                        } else if (cc == ')') {
                            if (--nparen < 0) {
                                throw AnnotationHelper.wrongAnnotationException(rval, "too many ')'", loc);
                            }
                        } else if (cc == '\'' || cc == '\"') {
                            quot = cc;
                        }
                        break block15;
                    }
                    if (cc == quot) {
                        quot = '\u0000';
                    }
                }
                sb.append(cc);
                if (cc == '\\' && j < len - 1) {
                    sb.append(rval.charAt(++j));
                }
            }
            ++j;
        }
        return attrs.toArray(new String[attrs.size()]);
    }

    private static UiException wrongAnnotationException(String cval, String reason, Location loc) {
        String msg = "Illegal annotation, " + reason + ": " + cval;
        return new UiException(loc != null ? loc.format(msg) : msg);
    }

    private void addInV5(String cval) {
        char[] seps1 = new char[]{'(', ' '};
        char[] seps2 = new char[]{')'};
        int j = 0;
        int len = cval.length();
        while (j < len) {
            int k = Strings.nextSeparator((String)cval, (int)(j = Strings.skipWhitespaces((CharSequence)cval, (int)j)), (char[])seps1, (boolean)true, (boolean)true, (boolean)false);
            if (k < len && cval.charAt(k) == '(') {
                String rv;
                String nm = cval.substring(j, k).trim();
                if (nm.length() == 0) {
                    nm = "default";
                }
                if ((rv = ((k = Strings.nextSeparator((String)cval, (int)(j = k + 1), (char[])seps2, (boolean)true, (boolean)true, (boolean)false)) < len ? cval.substring(j, k) : cval.substring(j)).trim()).length() > 0) {
                    this.addByRawValueInV5(nm, rv);
                } else {
                    this.add(nm, null);
                }
            } else {
                String rv = (k < len ? cval.substring(j, k) : cval.substring(j)).trim();
                if (rv.length() > 0) {
                    this.addByRawValueInV5("default", rv);
                }
            }
            j = k + 1;
        }
    }

    private void addByRawValueInV5(String annotName, String rval) {
        Map attrs = Maps.parse(null, (String)rval, (char)',', (char)'\'', (boolean)true);
        for (Map.Entry entry : attrs.entrySet()) {
            entry.setValue(new String[]{(String)entry.getValue()});
        }
        this.add(annotName, attrs);
    }

    public void applyAnnotations(ComponentInfo compInfo, String propName, boolean clear) {
        for (AnnotInfo info : this._annots) {
            compInfo.addAnnotation(propName, info.name, info.attrs, info.loc);
        }
        if (clear) {
            this._annots.clear();
        }
    }

    public void applyAnnotations(ShadowInfo compInfo, String propName, boolean clear) {
        for (AnnotInfo info : this._annots) {
            compInfo.addAnnotation(propName, info.name, info.attrs, info.loc);
        }
        if (clear) {
            this._annots.clear();
        }
    }

    public void applyAnnotations(ComponentInfo compInfo, String propName, boolean clear, Location loc) {
        this.applyAnnotations(compInfo, propName, clear);
    }

    public void applyAnnotations(Component comp, String propName, boolean clear) {
        for (AnnotInfo info : this._annots) {
            ComponentCtrl ctrl = (ComponentCtrl)((Object)comp);
            ctrl.addAnnotation(propName, info.name, info.attrs);
        }
        if (clear) {
            this._annots.clear();
        }
    }

    public void applyAnnotations(AnnotationMap annots, String propName, boolean clear) {
        for (AnnotInfo info : this._annots) {
            annots.addAnnotation(propName, info.name, info.attrs, info.loc);
        }
        if (clear) {
            this._annots.clear();
        }
    }

    public boolean clear() {
        if (!this._annots.isEmpty()) {
            this._annots.clear();
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotInfo {
        private final String name;
        private final Map<String, String[]> attrs;
        private final Location loc;

        private AnnotInfo(String name, Map<String, String[]> attrs, Location loc) {
            this.name = name;
            this.attrs = attrs;
            this.loc = loc;
        }
    }
}

