
(function (undefined) {
	var _binds = {}, 
		_globals = {}, 
		_floatings = [], 
		_nextUuid = 0,
		_domevtfnm = {}, 
		_domevtnm = {onDoubleClick: 'dblclick'}, 
		_wgtcls = {}, 
		_hidden = [], 
		_noChildCallback, _noParentCallback, 
		_syncdt, 
		_rdque = [], _rdtid, 
		_ignCanActivate, 
		REGEX_DQUOT = /\"/g; 

	
	function _isProlog(el) {
		var txt;
		return el && el.nodeType == 3 
			&& (txt=el.nodeValue) && !txt.trim().length;
	}

	
	function _domEvtInf(wgt, evtnm, fn, keyword) { 
		if (typeof fn != 'function') {
			if (!fn && !(fn = _domevtfnm[evtnm]))
				_domevtfnm[evtnm] = fn = '_do' + evtnm.substring(2);

			var f = wgt[fn];
			if (!f)
				throw 'Listener ' + fn + ' not found in ' + wgt.className;
			fn = f;
		}

		var domn = _domevtnm[evtnm];
		if (!domn)
			domn = _domevtnm[evtnm] = evtnm.substring(2).toLowerCase();
		return [domn, _domEvtProxy(wgt, fn, evtnm, keyword)];
	}
	function _domEvtProxy(wgt, f, evtnm, keyword) {
		var fps = wgt._$evproxs, fp;
		if (!fps) wgt._$evproxs = fps = {};
		if (keyword)
			f.__keyword = keyword;
		else if (fp = fps[f]) return fp;
		return fps[f] = _domEvtProxy0(wgt, f, keyword);
	}
	function _domEvtProxy0(wgt, f, keyword) {
		return function (evt) {
			var devt = evt; 
			evt = jq.Event.zk(devt, wgt); 

			switch (devt.type){
			case 'focus':
				if (wgt.canActivate()) {
					zk.currentFocus = wgt;
					
					zWatch.fire('onFloatUp', wgt, {triggerByFocus: true}); 
					break;
				}
				return; 
			case 'blur':
				
				
				if (!zk._cfByMD) zk.currentFocus = null;
				break;
			case 'click':
			case 'dblclick':
			case 'mouseup': 
				if (zk.Draggable.ignoreClick())
					return;
			}
			
			
			var args;
			if (keyword) {
				args = [].slice.call(arguments);
				args.push(keyword);
			} else
				args = arguments;
			var ret = f.apply(wgt, args);
			if (ret === undefined) ret = evt.returnValue;
			if (evt.domStopped) devt.stop();
			if (evt.stopped) devt.originalEvent['zkstopped'] = true;
			return devt.type == 'dblclick' && ret === undefined ? false: ret;
		};
	}

	function _unlink(wgt, child) {
		var p = child.previousSibling, n = child.nextSibling;
		if (p) p.nextSibling = n;
		else wgt.firstChild = n;
		if (n) n.previousSibling = p;
		else wgt.lastChild = p;
		child.nextSibling = child.previousSibling = child.parent = null;

		--wgt.nChildren;
	}
	
	function _replaceLink(from, to) {
		var p = to.parent = from.parent,
			q = to.previousSibling = from.previousSibling;
		if (q) q.nextSibling = to;
		else if (p) p.firstChild = to;

		q = to.nextSibling = from.nextSibling;
		if (q) q.previousSibling = to;
		else if (p) p.lastChild = to;
	}

	function _bind0(wgt) { 
		_binds[wgt.uuid] = wgt;
		if (wgt.id)
			_addGlobal(wgt);
	}
	function _unbind0(wgt) {
		if (wgt.id)
			_rmGlobal(wgt);
		delete _binds[wgt.uuid];
		wgt.desktop = null;
		wgt.clearCache();
	}
	function _bindrod(wgt) {
		_bind0(wgt);
		if (!wgt.z_rod)
			wgt.z_rod = 9; 

		for (var child = wgt.firstChild; child; child = child.nextSibling)
			_bindrod(child);
	}
	function _unbindrod(wgt, nest) {
		_unbind0(wgt);

		if (!nest || wgt.z_rod === 9) { 
			delete wgt.z_rod;

			for (var child = wgt.firstChild; child; child = child.nextSibling) {
				_unbindrod(child, true);
				
				if (child.$instanceof(zk.Native))
					zAu._storeStub(child);
			}
		}
	}

	function _fixBindLevel(wgt, v) {
		wgt.bindLevel = v++;
		for (wgt = wgt.firstChild; wgt; wgt = wgt.nextSibling)
			_fixBindLevel(wgt, v);
	}

	function _addIdSpace(wgt) {
		if (wgt._fellows) wgt._fellows[wgt.id] = wgt;
		var p = wgt.parent;
		if (p) {
			p = p.$o();
			if (p) p._fellows[wgt.id] = wgt;
		}
	}
	function _rmIdSpace(wgt) {
		if (wgt._fellows) delete wgt._fellows[wgt.id];
		var p = wgt.parent;
		if (p) {
			p = p.$o();
			if (p) delete p._fellows[wgt.id];
		}
	}
	function _addIdSpaceDown(wgt) {
		var ow = wgt.parent;
		ow = ow ? ow.$o(): null;
		if (ow)
			_addIdSpaceDown0(wgt, ow);
	}
	function _addIdSpaceDown0(wgt, owner) {
		if (wgt.id) owner._fellows[wgt.id] = wgt;
		if (!wgt._fellows)
			for (wgt = wgt.firstChild; wgt; wgt = wgt.nextSibling)
				_addIdSpaceDown0(wgt, owner);
	}
	function _rmIdSpaceDown(wgt) {
		var ow = wgt.parent;
		ow = ow ? ow.$o(): null;
		if (ow)
			_rmIdSpaceDown0(wgt, ow);
	}
	function _rmIdSpaceDown0(wgt, owner) {
		if (wgt.id)
			delete owner._fellows[wgt.id];
		if (!wgt._fellows)
			for (wgt = wgt.firstChild; wgt; wgt = wgt.nextSibling)
				_rmIdSpaceDown0(wgt, owner);
	}
	
	function _addGlobal(wgt) {
		var gs = _globals[wgt.id];
		if (gs)
			gs.push(wgt);
		else
			_globals[wgt.id] = [wgt];
	}
	function _rmGlobal(wgt) {
		var gs = _globals[wgt.id];
		if (gs) {
			gs.$remove(wgt);
			if (!gs.length) delete _globals[wgt.id];
		}
	}

	
	function _exists(wgt) {
		if (document.getElementById(wgt.uuid)) 
			return true;

		for (wgt = wgt.firstChild; wgt; wgt = wgt.nextSibling)
			if (_exists(wgt))
				return  true;
	}

	function _fireClick(wgt, evt) {
		if (!wgt.shallIgnoreClick_(evt) && 
			!wgt.fireX(evt).stopped && evt.shallStop) {
			evt.stop();
			return false;	
		}
		return !evt.stopped;
	}

	function _rmDom(wgt, n) {
		
		
		
		var act;
		if (wgt._visible && (act = wgt.actions_['hide'])) {
			wgt._rmAftAnm = function () {
				jq(n).remove();
			};
			n.style.visibility = ""; 
			act[0].call(wgt, n, act[1]);
		} else
			jq(n).remove();
	}

	
	
	function _dragCtl(wgt, invoke) {
		var p;
		return wgt && (p = wgt.parent) && p.dragControl && (!invoke || p.dragControl(wgt));
	}

	
	function _bkFocus(wgt) {
		var cf = zk.currentFocus;
		if (cf && zUtl.isAncestor(wgt, cf)) {
			zk.currentFocus = null;
			return {focus: cf, range: _bkRange(cf)};
		}
	}
	function _bkRange(wgt) {
		if (zk.ie < 11 && zk.cfrg) { 
			var cfrg = zk.cfrg;
			delete zk.cfrg;
			return cfrg;
		}
		return wgt.getInputNode && (wgt = wgt.getInputNode())
			&& zk(wgt).getSelectionRange();
	}
	
	function _rsFocus(cfi) {
		var cf;
		if (cfi && (cf = cfi.focus) && cf.desktop && !zk.currentFocus) {
			_ignCanActivate = true;
				
			try {
				cf.focus();
				
				if (cfi.range && cf.getInputNode && (cf = cf.getInputNode()) && zk(cf).isRealVisible())
					zk(cf).setSelectionRange(cfi.range[0], cfi.range[1]);
			} finally {
				_ignCanActivate = false;
			}
		}
	}
	
	function _listenFlex(wgt) {
		if (!wgt._flexListened){
			zWatch.listen({onSize: [wgt, zFlex.onSize], beforeSize: [wgt, zFlex.beforeSize]});
			if (wgt._hflex == 'min' || wgt._vflex == 'min')
				wgt.listenOnFitSize_();
			else
				wgt.unlistenOnFitSize_();
			wgt._flexListened = true;
		}
	}
	function _unlistenFlex(wgt) {
		if (wgt._flexListened) {
			zWatch.unlisten({onSize: [wgt, zFlex.onSize], beforeSize: [wgt, zFlex.beforeSize]});
			wgt.unlistenOnFitSize_();
			delete wgt._flexListened;
		}
	}
	
	
	zk.DnD = { 
		
		getDrop: function (drag, pt, evt) {
			var wgt = evt.target;
			return wgt ? wgt.getDrop_(drag.control): null;
		},
		
		ghost: function (drag, ofs, msg) {
			if (msg != null)  {
				jq(document.body).append(
					'<div id="zk_ddghost" class="z-drop-ghost z-drop-disallow" style="position:absolute;top:'
					+ofs[1]+'px;left:'+ofs[0]+'px;"><div class="z-drop-content"><span id="zk_ddghost-img" class="z-drop-icon"></span>&nbsp;'+msg+'</div></div>');
				drag._dragImg = jq('#zk_ddghost-img')[0];
				return jq('#zk_ddghost')[0];
			}

			var dgelm = jq(drag.node).clone()[0];
			dgelm.id = 'zk_ddghost';
			zk.copy(dgelm.style, {
				position: "absolute", left: ofs[0] + 'px', top: ofs[1] + 'px'
			});
			jq(dgelm).addClass('z-drag-ghost');
			document.body.appendChild(dgelm);
			return dgelm;
		}
	};
	function DD_cleanLastDrop(drag) {
		if (drag) {
			var drop;
			if (drop = drag._lastDrop) {
				drag._lastDrop = null;
				drop.dropEffect_();
			}
			drag._lastDropTo = null;
		}
	}
	function DD_pointer(evt, height) {
		if (zk.ios)
			return [evt.pageX - 50, evt.pageY - height - 30];
		return [evt.pageX + 7, evt.pageY + 5];
	}
	function DD_enddrag(drag, evt) {
		DD_cleanLastDrop(drag);
		var pt = [evt.pageX, evt.pageY],
			wgt = zk.DnD.getDrop(drag, pt, evt);
		if (wgt) wgt.onDrop_(drag, evt);
	}
	function DD_dragging(drag, pt, evt) {
		var dropTo;
		if (!evt || (dropTo = evt.domTarget) == drag._lastDropTo)
			return;

		var dropw = zk.DnD.getDrop(drag, pt, evt),
			found = dropw && dropw == drag._lastDrop;
		if (!found) {
			DD_cleanLastDrop(drag); 
			if (dropw) {
				drag._lastDrop = dropw;
				dropw.dropEffect_(true);
				found = true;
			}
		}

		var dragImg = drag._dragImg;
		if (dragImg) {
			if (found) {
				jq(drag.node).removeClass('z-drop-disallow').addClass('z-drop-allow');
				
				jq(dragImg).removeClass('z-icon-times').addClass('z-icon-check');
			} else {
				jq(drag.node).removeClass('z-drop-allow').addClass('z-drop-disallow');
				
				jq(dragImg).removeClass('z-icon-check').addClass('z-icon-times');
			}
		}

		drag._lastDropTo = dropTo; 
		
		if (zk.mobile)
			zk(drag.node).redoCSS();
	}
	function DD_ghosting(drag, ofs, evt) {
		return drag.control.cloneDrag_(drag, DD_pointer(evt, jq(drag.node).height()));
	}
	function DD_endghosting(drag, origin) {
		drag.control.uncloneDrag_(drag);
		drag._dragImg = null;
	}
	function DD_constraint(drag, pt, evt) {
		return DD_pointer(evt, jq(drag.node).height());
	}
	function DD_ignoredrag(drag, pt, evt) {
		
		
		return drag.control.ignoreDrag_(pt,evt,drag); 
	}

	function _topnode(n) {
		for (var v, body = document.body; n && n != body; n = n.parentNode) 
			if ((v=n.style) && ((v=v.position) == 'absolute' || v == 'relative'))
				return n;
	}
	function _zIndex(n) {
		return n ? zk.parseInt(n.style.zIndex): 0;
	}

	function _getFirstNodeDown(wgt) {
		var n = wgt.$n();
		if (n) return n;
		for (var w = wgt.firstChild; w; w = w.nextSibling) {
			n = w.getFirstNode_();
			if (n) return n;
		}
	}
	
	function _floatVisibleDependent(self, wgt) {
		for (; wgt; wgt = wgt.parent)
			if (wgt == self) return true;
			else if (!wgt.isVisible()) break;
		return false;
	}
	
	function _fullScreenZIndex(zi) {
		var pseudoFullscreen = null;
		if (document.fullscreenElement) {
			pseudoFullscreen = ':fullscreen';
		} else if (document.mozFullScreen) {
			
			
			
			return 2147483648;
		} else if (document.webkitIsFullScreen) {
			pseudoFullscreen = ':-webkit-full-screen';
		}
		if (pseudoFullscreen) {
			var fsZI = jq.css(jq(pseudoFullscreen)[0], 'zIndex');
			return fsZI == 'auto' ? 2147483648 : ++fsZI;
		}
		return zi;
	}

	
	function _topZIndex(wgt) {
		var zi = 1800; 
		
		
		
		zi = _fullScreenZIndex(zi);
		
		
		for (var j = _floatings.length; j--;) {
			var w = _floatings[j].widget,
				wzi = zk.parseInt(w.getFloatZIndex_(_floatings[j].node));
			if (wzi >= zi && !zUtl.isAncestor(wgt, w) && w.isVisible())
				zi = wzi + 1;
		}
		return zi;
	}

	function _prepareRemove(wgt, ary) {
		for (wgt = wgt.firstChild; wgt; wgt = wgt.nextSibling) {
			var n = wgt.$n();
			if (n) ary.push(n);
			else _prepareRemove(wgt, ary);
		}
	}

	
	function _doDeferRender(wgt) {
		if (wgt._z$rd) { 
			delete wgt._z$rd;
			wgt._norenderdefer = true;
			wgt.replaceHTML('#' + wgt.uuid, wgt.parent ? wgt.parent.desktop: null, null, true);
			if (wgt.parent)
				wgt.parent.onChildRenderDefer_(wgt);
		}
	}

	
	function _rerender(wgt, timeout) {
		if (_rdtid)
			clearTimeout(_rdtid);
		_rdque.push(wgt);
		_rdtid = setTimeout(_rerender0, timeout);
	}
	function _rerender0() {
		_rdtid = null;
		l_out:
		for (var wgt; wgt = _rdque.shift();) {
			if (!wgt.desktop)
				continue;

			for (var j = _rdque.length; j--;)
				if (zUtl.isAncestor(wgt, _rdque[j]))
					_rdque.splice(j, 1); 
				else if (zUtl.isAncestor(_rdque[j], wgt))
					continue l_out; 

			wgt.rerender(-1);
		}
	}
	
	function _rerenderNow(wgt, skipper) {
		var rdque = [];
		for (var j = _rdque.length; j--;)
			if (zUtl.isAncestor(wgt, _rdque[j])) {
				if (!skipper || !skipper.skipped(wgt, _rdque[j]))
					rdque = rdque.concat(_rdque.splice(j, 1));
			}
		
		
		if (!_rdque.length && _rdtid) {
			clearTimeout(_rdtid);
			_rdtid = null; 
		}
		
		l_out2:
			for (var w; w = rdque.shift();) {
				if (!w.desktop)
					continue;

				for (var j = rdque.length; j--;)
					if (zUtl.isAncestor(w, rdque[j]))
						rdque.splice(j, 1); 
					else if (zUtl.isAncestor(rdque[j], w))
						continue l_out2; 

				w.rerender(-1);
			}
	}
	function _rerenderDone(wgt, skipper ) {
		for (var j = _rdque.length; j--;)
			if (zUtl.isAncestor(wgt, _rdque[j])) {
				if (!skipper || !skipper.skipped(wgt, _rdque[j]))
					_rdque.splice(j, 1);
			}
	}

	function _markCache(cache, visited, visible) {
		if (cache)
			for (var p; p = visited.pop();)
				cache[p.uuid] = visible;
		return visible;
	}
	var _dragoptions = {
		starteffect: zk.$void, 
		endeffect: DD_enddrag, change: DD_dragging,
		ghosting: DD_ghosting, endghosting: DD_endghosting,
		constraint: DD_constraint, 
		ignoredrag: DD_ignoredrag,
		zIndex: 88800
	};

var Widget =

zk.Widget = zk.$extends(zk.Object, {
	_visible: true,
	
	nChildren: 0,
	
	bindLevel: -1,
	_mold: 'default',
	
	className: 'zk.Widget',
	
	widgetName: 'widget',
	
	

	
	
	actions_: {}, 

	_floating: false,

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

	
	

	
	

	
	$init: function (props) {
		this._asaps = {}; 
		this._lsns = {}; 
		this._bklsns = {}; 
		this._subnodes = {}; 
		this.effects_ = {};
		this._subzcls = {}; 

		
		
		
		if (this.z$is)
			this._fellows = {};

		
		if (props !== zkac)
			this.afterInit(function () {
				
				if (props && typeof props == 'object' && !props.$oid)
					for (var nm in props)
						this.set(nm, props[nm]);

				if ((zk.spaceless || this.rawId) && this.id)
					this.uuid = this.id; 
				if (!this.uuid)
					this.uuid = Widget.nextUuid();
			});
	},

	$define: {
		
		
		mold: function () {
			this.rerender();
		},
		
		
		style: function () {
			this.updateDomStyle_();
		},
		
		
		sclass: function () {
			this.updateDomClass_();
		},
		
		
		zclass: function () {
			this._subzcls = {}; 
			this.rerender();
		},
		
		
		width: function (v) {
			if (!this._nhflex) {
				var n = this.$n();
				if (n) n.style.width = v || '';
			}
		},
		
		
		height: function (v) {
			if (!this._nvflex) {
				var n = this.$n();
				if (n) n.style.height = v || '';
			}
		},
		
		
		left: function (v) {
			var n = this.$n();
			if (n) n.style.left = v || '';
		},
		
		
		top: function (v) {
			var n = this.$n();
			if (n) n.style.top = v || '';
		},
		
		
		tooltiptext: function (v) {
			var n = this.$n();
			
			if (n) n.title = v || '';
		},

		
		
		droppable: [
			function (v) {
				return v && 'false' != v ? v: null;
			},
			function (v) {
				var dropTypes;
				if (v && v != 'true') {
					dropTypes = v.split(',');
					for (var j = dropTypes.length; j--;)
						if (!(dropTypes[j] = dropTypes[j].trim()))
							dropTypes.splice(j, 1);
				}
				this._dropTypes = dropTypes;
			}
		],
		
		
		vflex: function(v) {
			this.setVflex_(v);

			var p;
			if (this.desktop
			&& (p = this.parent) && !p.isBinding()) 
				zUtl.fireSized(p, -1); 
		},
		
		
		hflex: function(v) {
			this.setHflex_(v);

			var p;
			if (this.desktop
			&& (p = this.parent) && !p.isBinding())
				zUtl.fireSized(p, -1); 
		},
		
		
		 renderdefer: null,
		
		
		action: function (v) {
			this.actions_ = {}; 
			if (v)
				for (var ps = v.split(';'), j = ps.length; j--;) {
					var p = ps[j], k = p.indexOf(':');
					if (k >= 0) {
						var nm = p.substring(0, k).trim(),
							val = p.substring(k + 1).trim(),
							opts, fn, l;
						if (nm && val) {
							k = val.indexOf('(');
							if (k >= 0) {
								if ((l = val.lastIndexOf(')')) > k)
									opts = jq.evalJSON(val.substring(k + 1, l));
								val = val.substring(0, k);
							}
							if (fn = zk.eff.Actions[val])
								this.actions_[nm] = [fn, opts];
							else
								zk.error('Unknown action: '+val);
							continue;
						}
					}
					zk.error('Illegal action: '+v+', '+this.className);
				}
		}
	},
	setHflex_: function (v) {
		this._nhflex = (true === v || 'true' == v) ? 1 : v == 'min' ? -65500 : zk.parseInt(v);
		if (this._nhflex < 0 && v != 'min')
			this._nhflex = 0;
		if (this.desktop) { 
		                    
		                    
		                    
			if (!this._nhflex) {
				this.setFlexSize_({width: 'auto'}); 
				delete this._hflexsz;
				this._hflex = undefined;
				if (!this._nvflex)
					_unlistenFlex(this);
			} else
				_listenFlex(this);
		}
	},
	setVflex_: function (v) {
		this._nvflex = (true === v || 'true' == v) ? 1 : v == 'min' ? -65500 : zk.parseInt(v);
		if (this._nvflex < 0 && v != 'min')
			this._nvflex = 0;
		if (this.desktop) {
			if (!this._nvflex) {
				this.setFlexSize_({height: 'auto'});
				delete this._vflexsz;
				this._vflex = undefined;
				if (!this._nhflex)
					_unlistenFlex(this);
			} else
				_listenFlex(this);
		}
	},
	
	afterAnima_: function (visible) {
		var fn;
		if (fn = this._rmAftAnm) {
			this._rmAftAnm = null;
			fn();
		}
	},

	
	setDraggable: function (v) {
		if (!v && v != null) v = 'false'; 
		this._draggable = v;

		if (this.desktop && !_dragCtl(this, true))
			if (v && v != 'false') this.initDrag_();
			else this.cleanDrag_();
	},
	
	getDraggable: function () {
		var v = this._draggable;
		return v ? v: _dragCtl(this) ? 'true': 'false';
	},
	
	$o: function () {
		for (var w = this; w; w = w.parent)
			if (w._fellows) return w;
	},
	
	
	
	$f: function (id, global) {
		var f = this.$o();
		if (!arguments.length)
			return f ? f._fellows: {};
		for (var ids = id.split('/'), j = 0, len = ids.length; j < len; ++j) {
			id = ids[j];
			if (id) {
				if (f) f = f._fellows[id];
				if (!f && global && (f=_globals[id])) f = f[0];
				if (!f || zk.spaceless) break;
				global = false;
			}
		}
		return f;
	},
	
	getId: function () {
		return this.id;
	},
	
	setId: function (id) {
		if (id != this.id) {
			if (this.id) {
				_rmIdSpace(this);
				_rmGlobal(this); 
			}

			if (id && (zk.spaceless || this.rawId))
				zk._wgtutl.setUuid(this, id);
			this.id = id;

			if (id) {
				_addIdSpace(this);
				if (this.desktop || this.z_rod)
					_addGlobal(this);
			}
		}
		return this;
	},

	
	
	set: (function () {

		
		var _setCaches = {};
		function _setterName(name) {
			var setter = {name : 'set' + name.charAt(0).toUpperCase() + name.substring(1)},
				cc;
			if ((cc = name.charAt(0)) == '$') {
				setter.func = function (wgt, nm, val, extra) {
					var result = wgt._setServerListener(nm, val);
					if (!result)
						zk._set2(wgt, null, nm, val, extra);
					return wgt;
				};
			} else if (cc == 'o' && name.charAt(1) == 'n'
				&& ((cc = name.charAt(2)) <= 'Z' && cc >= 'A')) {
				setter.func = function (wgt, nm, val, extra) {
					wgt.setListener(nm, val);
					return wgt;
				};
			} else {
				setter.func = function (wgt, nm, val, extra) {
					var fun;
					if (fun = wgt[setter.name]) {
                		
                		zk._set2(wgt, fun, null, val, extra);
                		return wgt;
                	}
                	zk._set2(wgt, null, nm, val, extra);
                	return wgt;
				};
			}
			_setCaches[name] = setter;
			return setter;
		}
		return function (name, value, extra) {
			var cc;
			if ((cc = value && value.$u) 
			&& !(value = Widget.$(cc))) { 
				var self = this;
				zk.afterMount(function () {
					var v = Widget.$(cc);
					
					if (v)
						zk._set(self, name, v, extra);
					else
						setTimeout(function () {
							zk._set(self, name, Widget.$(cc), extra);
						});
				}, -1);
				return this;
			}
			var setter = _setCaches[name] || _setterName(name);
			return setter.func.call(this, this, name, value, extra);
		};
	})(),
	_setServerListener: function (name, value) {
   		if (name.startsWith('$$')) {
			if (name.startsWith('$$on')) {
				var cls = this.$class,
					ime = cls._importantEvts;
				(ime || (cls._importantEvts = {}))[name.substring(2)] = value;
				return this;
			} else if (name.startsWith('$$0on')) {
				var cls = this.$class,
					ime = cls._duplicateIgnoreEvts;
				(ime || (cls._duplicateIgnoreEvts = {}))[name.substring(3)] = value;
				return this;
			} else if (name.startsWith('$$1on')) {
				var cls = this.$class,
					ime = cls._repeatIgnoreEvts;
				(ime || (cls._repeatIgnoreEvts = {}))[name.substring(3)] = value;
				return this;
			}
		} else if (name.startsWith('$on')) {
			this._asaps[name.substring(1)] = value;
			return this;
		}
	},
	
	get: function (name) {
		return zk.get(this, name);
	},
	
	getChildAt: function (j) {
		if (j >= 0 && j < this.nChildren)
			for (var w = this.firstChild; w; w = w.nextSibling)
				if (--j < 0)
					return w;
	},
	
	getChildIndex: function () {
		var w = this.parent, j = 0;
		if (w)
			for (w = w.firstChild; w; w = w.nextSibling, ++j)
				if (w == this)
					return j;
		return 0;
	},
	
	setChildren: function (children) {
		if (children)
			for (var j = 0, l = children.length; j < l;)
				this.appendChild(children[j++]);
		return this;
	},
	
	
	appendChild: function (child, ignoreDom) {
		if (child == this.lastChild)
			return false;

		var oldpt;
		if ((oldpt = child.parent) != this)
			child.beforeParentChanged_(this);

		if (oldpt) {
			_noParentCallback = true;
			try {
				oldpt.removeChild(child);
			} finally {
				_noParentCallback = false;
			}
		}

		child.parent = this;
		var ref = this.lastChild;
		if (ref) {
			ref.nextSibling = child;
			child.previousSibling = ref;
			this.lastChild = child;
		} else {
			this.firstChild = this.lastChild = child;
		}
		++this.nChildren;

		if (child.id || child.firstChild) 
			_addIdSpaceDown(child);

		if (!ignoreDom)
			if (this.shallChildROD_(child))
				_bindrod(child);
			else {
				var dt = this.desktop;
				if (dt) this.insertChildHTML_(child, null, dt);
			}

		child.afterParentChanged_(oldpt);
		if (!_noChildCallback)
			this.onChildAdded_(child);
		return true;
	},
	
	shallChildROD_: function (child) {
		return child.z_rod || this.z_rod;
	},
	
	insertBefore: function (child, sibling, ignoreDom) {
		if (!sibling || sibling.parent != this) {
			this.insertingBefore_ = true;
			try {
				return this.appendChild(child, ignoreDom);
			} finally {
				this.insertingBefore_ = false;
			}
		}

		if (child == sibling || child.nextSibling == sibling)
			return false;

		var oldpt;
		if ((oldpt = child.parent) != this)
			child.beforeParentChanged_(this);

		if (oldpt) {
			_noParentCallback = true;
			try {
				oldpt.removeChild(child);
			} finally {
				_noParentCallback = false;
			}
		}

		child.parent = this;
		var ref = sibling.previousSibling;
		if (ref) {
			child.previousSibling = ref;
			ref.nextSibling = child;
		} else this.firstChild = child;

		sibling.previousSibling = child;
		child.nextSibling = sibling;

		++this.nChildren;

		_addIdSpaceDown(child);

		if (!ignoreDom)
			if (this.shallChildROD_(child))
				_bindrod(child);
			else {
				var dt = this.desktop;
				if (dt) this.insertChildHTML_(child, sibling, dt);
			}

		child.afterParentChanged_(oldpt);
		if (!_noChildCallback)
			this.onChildAdded_(child);
		return true;
	},
	
	
	removeChild: function (child, ignoreDom) {
		var oldpt;
		if (!(oldpt = child.parent))
			return false;
		if (this != oldpt)
			return false;

		_rmIdSpaceDown(child);

		
		if (child.z_rod) {
			_unbindrod(child);
			
			
			jq(child.uuid, zk).remove();
		} else if (child.desktop) 
			this.removeChildHTML_(child, ignoreDom);

		if (!_noParentCallback)
			child.beforeParentChanged_(null);

		_unlink(this, child);


		if (!_noParentCallback)
			child.afterParentChanged_(oldpt);
		if (!_noChildCallback)
			this.onChildRemoved_(child);
		return true;
	},
	
	detach: function () {
		if (this.parent) this.parent.removeChild(this);
		else {
			var cf = zk.currentFocus;
			if (cf && zUtl.isAncestor(this, cf))
				zk.currentFocus = null;
			var n = this.$n();
			if (n) {
				this.unbind();
				_rmDom(this, n);
			}
		}
	},
	
	clear: function () {
		while (this.lastChild)
			this.removeChild(this.lastChild);
	},
	
	replaceWidget: function (newwgt) {
		_replaceLink(this, newwgt);

		_rmIdSpaceDown(this);
		_addIdSpaceDown(newwgt);

		var cf = zk.currentFocus, cfid, cfrg;
		if (cf && zUtl.isAncestor(this, cf)) {
			cfid = cf.uuid;
			cfrg = _bkRange(cf);
			zk.currentFocus = null;
		}

		var node = this.$n(),
			p = this.parent, shallReplace,
			dt = newwgt.desktop || this.desktop;
		if (this.z_rod) {
			_unbindrod(this);
			if (!(shallReplace = (dt = dt || (p ? p.desktop: p))
			&& (node = jq('#' + this.uuid))))
				_bindrod(newwgt);
		} else
			shallReplace = dt;

		var callback = [];
		if (shallReplace) {
			if (node) newwgt.replaceHTML(node, dt, null, true, callback);
			else {
				this.unbind();
				newwgt.bind(dt);
			}

			_fixBindLevel(newwgt, p ? p.bindLevel + 1: 0);
			zWatch.fire('onBindLevelMove', newwgt);
		}

		if (p)
			p.onChildReplaced_(this, newwgt);

		this.parent = this.nextSibling = this.previousSibling = null;
		
		
		
		if (callback && callback.length) {
			var f;
			while ((f = callback.shift()) && jq.isFunction(f))
				f();
		}
		if (cfid) {
			cf = zk.Widget.$(cfid);
			if (!cf) {
			    
			    
			    
			} else if (zUtl.isAncestor(newwgt, cf))
				_rsFocus({focus: cf, range: cfrg});
		}
	},
	
	replaceCavedChildren_: function (subId, wgts, tagBeg, tagEnd) {
		_noChildCallback = true; 
		try {
			
			var cave = this.$n(subId), fc, oldwgts = [];
			for (var w = this.firstChild; w;) {
				var sib = w.nextSibling;
				if (jq.isAncestor(cave, w.$n())) {
					if (!fc || fc == w) fc = sib;
					this.removeChild(w, true); 
					oldwgts.push(w);
				}
				w = sib;
			}

			
			for (var j = 0, len = wgts.length; j < len; ++j)
				this.insertBefore(wgts[j], fc, true); 
		} finally {
			_noChildCallback = false;
		}

		if (fc = this.desktop) {
			
			var out = new zk.Buffer();
			if (tagBeg) out.push(tagBeg);
			for (var j = 0, len = wgts.length; j < len; ++j)
				wgts[j].redraw(out);
			if (tagEnd) out.push(tagEnd);

			
			jq(cave).html(out.join(''));

			
			for (var j = 0, len = wgts.length; j < len; ++j) {
				wgts[j].bind(fc);
				
				
				var n = this._nrows;  
				this.onChildReplaced_(oldwgts[j], wgts[j]);
				this._nrows = n;
			}
		}
	},

	
	beforeParentChanged_: function () {
	},
	
	afterParentChanged_: function () {
	},

	
	
	isRealVisible: function (opts) {
		var dom = opts && opts.dom,
			cache = opts && opts.cache, visited = [], ck,
			wgt = this;
		
		
		if (!wgt.desktop)
			return false;
		
		while (wgt) {
			if (cache && (ck=wgt.uuid) && (ck=cache[ck]) !== undefined)
				return _markCache(cache, visited, ck);

			if (cache)
				visited.push(wgt);
	
			if (dom && !wgt.z_virnd) { 
			
			
			
				if (!zk(wgt.$n()).isVisible(opts.strict))
					return _markCache(cache, visited, false);
			} else if (!wgt._visible) 
				return _markCache(cache, visited, false);

			
			var wp = wgt.parent, p, n;
			if (wp && wp._visible && (p=wp.$n()) && (n=wgt.$n()))
				while ((n=zk(n).vparentNode(true)) && p != n)
					if ((n.style||{}).display == 'none') 
						return _markCache(cache, visited, false);

			if (opts && opts.until == wgt)
				break;

			wgt = wp;
		}
		return _markCache(cache, visited, true);
	},
	
	
	isVisible: function (strict) {
		var visible = this._visible;
		if (!strict || !visible)
			return visible;
		var n = this.$n();
		return n && zk(n).isVisible(); 
	},
	
	setVisible: function (visible) {
		if (this._visible != visible) {
			this._visible = visible;

			var p = this.parent, ocvCalled;
			if (this.desktop) {
				var parentVisible = !p || p.isRealVisible(),
					node = this.$n(),
					floating = this._floating;

				if (!parentVisible) {
					if (!floating) this.setDomVisible_(node, visible);
				} else if (visible) {
					var zi;
					if (floating)
						this.setZIndex(zi = _topZIndex(this), {fire:true});

					this.setDomVisible_(node, true);

					
					for (var j = 0, fl = _floatings.length; j < fl; ++j) {
						var w = _floatings[j].widget,
							n = _floatings[j].node;
						if (this == w)
							w.setDomVisible_(n, true, {visibility:1});
						else if (_floatVisibleDependent(this, w)) {
							zi = zi >= 0 ? ++zi: _topZIndex(w);
							w.setFloatZIndex_(n, zi);
							w.setDomVisible_(n, true, {visibility:1});
						}
					}

					if (ocvCalled = p) p.onChildVisible_(this);
						
					
					this.fire('onShow');
					
					var wgt = this;
					zk.afterAnimate(function() {zUtl.fireShown(wgt);}, -1);
				} else {
					this.fire('onHide');
					
					var wgt = this;
					zWatch.fireDown('onHide', this);

					for (var j = _floatings.length, bindLevel = this.bindLevel; j--;) {
						var w = _floatings[j].widget;
						if (bindLevel >= w.bindLevel)
							break; 
						if (_floatVisibleDependent(this, w))
							w.setDomVisible_(_floatings[j].node, false, {visibility:1});
					}

					this.setDomVisible_(node, false);
					
					
					if (wgt._nvflex || wgt._nhflex)
						zk.afterAnimate(function() {
							if (wgt.parent)
								zUtl.fireSized(wgt.parent);
						}, -1);
				}
			}
			if (p && !ocvCalled) p.onChildVisible_(this);
				
			jq.onSyncScroll(this);
		}
		return this;
	},
	
	zsync: function () {
		for (var nm in this.effects_) {
			var ef = this.effects_[nm];
			if (ef && ef.sync) ef.sync();
		}
	},
	
	show: function () {return this.setVisible(true);},
	
	hide: function () {return this.setVisible(false);},
	
	setDomVisible_: function (n, visible, opts) {
		if (!opts || opts.display) {
			var act;
			if (act = this.actions_[visible ? 'show': 'hide'])
				act[0].call(this, n, act[1]);
			else
				n.style.display = visible ? '' : 'none';
		}
		if (opts && opts.visibility)
			n.style.visibility = visible ? 'visible': 'hidden';
	},
	
	onChildAdded_: function () {
		if (this.desktop)
			jq.onSyncScroll(this);
	},
	
	onChildRemoved_: function () {
		if (this.desktop)
			jq.onSyncScroll(this);
	},
	
	onChildReplaced_: function (oldc, newc) {
		this.childReplacing_ = true;
		try {
			if (oldc) this.onChildRemoved_(oldc);
			if (newc) this.onChildAdded_(newc);
		} finally {
			this.childReplacing_ = false;
		}
	},
	
	onChildVisible_: function () {
	},
	
	onChildRenderDefer_: function () {
	},
	
	setTopmost: function () {
		if (!this.desktop) return -1;

		for (var wgt = this; wgt; wgt = wgt.parent)
			if (wgt._floating) {
				var zi = _topZIndex(wgt);
				for (var j = 0, fl = _floatings.length; j < fl; ++j) { 
					var w = _floatings[j].widget,
						n = _floatings[j].node;
					if (wgt == w)
						w.setFloatZIndex_(n, zi); 
					else if (zUtl.isAncestor(wgt, w) && w.isVisible())
						w.setFloatZIndex_(n, ++zi);
				}
				return zi;
			}
		return -1;
	},
	
	setFloatZIndex_: function (node, zi) {
		if (node != this.$n()) node.style.zIndex = zi; 
		else this.setZIndex(zi, {fire:true});
	},
	
	getFloatZIndex_: function (node) {
		return node != this.$n() ? node.style.zIndex: this._zIndex;
	},
	
	getTopWidget: function () {
		for (var wgt = this; wgt; wgt = wgt.parent)
			if (wgt._floating)
				return wgt;
	},
	
	isFloating_: function () {
		return this._floating;
	},
	
	setFloating_: function (floating, opts) {
		if (this._floating != floating) {
			if (floating) {
				
				var inf = {widget: this, node: opts && opts.node? opts.node: this.$n()},
					bindLevel = this.bindLevel;
				for (var j = _floatings.length;;) {
					if (--j < 0) {
						_floatings.unshift(inf);
						break;
					}
					if (bindLevel >= _floatings[j].widget.bindLevel) { 
						_floatings.splice(j + 1, 0, inf);
						break;
					}
				}
				this._floating = true;
			} else {
				for (var j = _floatings.length; j--;)
					if (_floatings[j].widget == this)
						_floatings.splice(j, 1);
				this._floating = false;
			}
		}
		return this;
	},

	
	getZIndex: _zkf = function () {
		return this._zIndex;
	},
	getZindex: _zkf,
	
	setZIndex: _zkf = function (zIndex, opts) {
		if (this._zIndex != zIndex) {
			this._zIndex = zIndex;
			var n = this.$n();
			if (n) {
				n.style.zIndex = zIndex >= 0 ? zIndex: '';
				if (opts && opts.fire) this.fire('onZIndex', (zIndex > 0 || zIndex === 0) ? zIndex: -1, {ignorable: true});
			}
		}
		return this;
	},
	setZindex: _zkf,

	
	getScrollTop: function () {
		var n = this.$n();
		return n ? n.scrollTop: 0;
	},
	
	getScrollLeft: function () {
		var n = this.$n();
		return n ? n.scrollLeft: 0;
	},
	
	setScrollTop: function (val) {
		var n = this.$n();
		if (n) n.scrollTop = val;
		return this;
	},
	
	setScrollLeft: function (val) {
		var n = this.$n();
		if (n) n.scrollLeft = val;
		return this;
	},
	
	scrollIntoView: function () {
		zk(this.$n()).scrollIntoView();
		return this;
	},

	
	redraw: function (out) {
		if (!this.deferRedraw_(out)) {
			var f;
			if (f = this.prolog)
				out.push(f);

			if ((f = this.$class.molds) && (f = f[this._mold]))
				return f.apply(this, arguments);

			zk.error('Mold '+this._mold+' not found in '+this.className);
		}
	},
	
	deferRedraw_: function (out) {
		var delay;
		if ((delay = this._renderdefer) >= 0) {
			if (!this._norenderdefer) {
				this.z_rod = this._z$rd = true;
				this.deferRedrawHTML_(out);
				out = null; 

				var wgt = this;
				setTimeout(function () {_doDeferRender(wgt);}, delay);
				return true;
			}
			delete this._norenderdefer;
			delete this.z_rod;
		}
		return false;
	},
	
	deferRedrawHTML_: function (out) {
		out.push('<div', this.domAttrs_({domClass:1}), ' class="z-renderdefer"></div>');
	},
	
	forcerender: function () {
		_doDeferRender(this);
	},
	
	updateDomClass_: function () {
		if (this.desktop) {
			var n = this.$n();
			if (n) n.className = this.domClass_();
			this.zsync();
		}
	},
	
	updateDomStyle_: function () {
		if (this.desktop) {
			var s = jq.parseStyle(this.domStyle_()),
				n = this.$n();
			
			if (!s.width && this._hflex)
				s.width = n.style.width;
			if (!s.height && this._vflex)
				s.height = n.style.height;
			zk(n).clearStyles().jq.css(s);

			var t = this.getTextNode();
			if (t && t != n) {
				s = this._domTextStyle(t, s);
				zk(t).clearStyles().jq.css(s);
			}
			this.zsync();
		}
	},
	_domTextStyle: function (t, s) {
		
		s = jq.filterTextStyle(s);
		
		if (t.style.width)
			s.width = t.style.width;
		if (t.style.height)
			s.height = t.style.height;
		return s;
	},
	getZclass: function () {
		var zcls = this._zclass;
		return zcls != null ? zcls : 'z-' + this.widgetName;
	},
	
	getTextNode: function () {
	},

	
	domStyle_: function (no) {
		var out = '', s;
		if (s = this.z$display) 
			out += 'display:' + s + ';';
		else if (!this.isVisible() && (!no || !no.visible))
			out += 'display:none;';

		if ((!no || !no.style) && (s = this.getStyle())) {
			s = s.replace(REGEX_DQUOT,'\'');  
			out += s;
			if (s.charAt(s.length - 1) != ';')
				out += ';';
		}
		if ((!no || !no.width) && (s = this.getWidth()))
			out += 'width:' + s + ';';
		if ((!no || !no.height) && (s = this.getHeight())) 
			out += 'height:' + s + ';';
		if ((!no || !no.left) && (s = this.getLeft()))
			out += 'left:' + s + ';';
		if ((!no || !no.top) && (s = this.getTop()))
			out += 'top:' + s + ';';
		if ((!no || !no.zIndex) && (s = this.getZIndex()) >= 0)
			out += 'z-index:' + s + ';';
		return out;
	},
	
	domClass_: function (no) {
		var s, z;
		if (!no || !no.sclass)
			s = this.getSclass();
		if (!no || !no.zclass)
			z = this.getZclass();
		return s ? z ? s + ' ' + z: s: z||'';
	},
	
	domAttrs_: function (no) {
		var out = '', attrs, s;
		if (!no) {
			if ((s = this.uuid))
        		out += ' id="' + s + '"';
        	if ((s = this.domStyle_(no)))
        		out += ' style="' + s + '"';
        	if ((s = this.domClass_(no)))
        		out += ' class="' + s + '"';
        	if ((s = this.domTooltiptext_()))
        		out += ' title="' + zUtl.encodeXML(s) + '"'; 
		} else {
			if (!no.id && (s = this.uuid))
				out += ' id="' + s + '"';
			if (!no.domStyle && (s = this.domStyle_(no)))
				out += ' style="' + s + '"';
			if (!no.domClass && (s = this.domClass_(no)))
				out += ' class="' + s + '"';
			if (!no.tooltiptext && (s = this.domTooltiptext_()))
				out += ' title="' + zUtl.encodeXML(s) + '"'; 
		}
		if (this.domExtraAttrs) {
			out += this.domExtraAttrs_();
		}
		return out;
	},
	
	domExtraAttrs_: function () {
		var dh = {},
			has = false,
			out = '';

		for (var nm in (attrs = this.domExtraAttrs)) {
			if (zk.hasDataHandler(nm)) {
				has = true;
				dh[nm] = attrs[nm];
			}
			out += ' ' + nm + '="' + zUtl.encodeXMLAttribute(attrs[nm] || '') + '"'; 
		}
		if (has && !this.z_isDataHandlerBound) {
			this.z_isDataHandlerBound = function () {
				for(var nm in dh)
					zk.getDataHandler(nm).run(this, dh[nm]);
			};
			this.listen({onBind: this.z_isDataHandlerBound});
		}
		return out;
	},
	
	domTooltiptext_ : function () {
		return this.getTooltiptext();
	},
	
	domTextStyleAttr_: function () {
		var s = this.getStyle();
		return s ? zUtl.appendAttr('style', jq.filterTextStyle(s)): s;
	},

	
	replaceHTML: function (n, desktop, skipper, _trim_, _callback_) {
		if (!desktop) {
			desktop = this.desktop;
			if (!zk.Desktop._ndt) zk.stateless();
		}

		var cfi = skipper ? null: _bkFocus(this);

		var p = this.parent;
		if (p) p.replaceChildHTML_(this, n, desktop, skipper, _trim_);
		else {
			var oldwgt = this.getOldWidget_(n);
			if (oldwgt) oldwgt.unbind(skipper); 
			else if (this.z_rod) _unbindrod(this); 
			jq(n).replaceWith(this.redrawHTML_(skipper, _trim_));
			this.bind(desktop, skipper);
		}

		if (!skipper) {
			if (!jq.isArray(_callback_))
				zUtl.fireSized(this);
			else {
				
				var self = this;
				_callback_.push(function (){
					zUtl.fireSized(self);
				});
			}
				
		}

		_rsFocus(cfi);
		return this;
	},
	
	getOldWidget_: function (n) {
		return Widget.$(n, {strict:true});
	},
	
	redrawHTML_: function (skipper, trim) {
		var out = new zk.Buffer(); 
		this.redraw(out, skipper);
		out = out.join('');
		return trim ? out.trim(): out;
			
			
	},
	
	
	rerender: function (skipper) {
		if (this.desktop) {
			if (!skipper || skipper > 0) { 
				_rerender(this, skipper||0);
				return this;
			}
			if (skipper < 0)
				skipper = null; 

			var n = this.$n();
			if (n) {
				var oldrod = this.z$rod;
				this.z$rod = false;
					

				var skipInfo;
				if (skipper) {
					skipInfo = skipper.skip(this);
					if (skipInfo) {
						var cfi = _bkFocus(this);

						this.replaceHTML(n, null, skipper, true);

						skipper.restore(this, skipInfo);

						zWatch.fireDown('onRestore', this);
							
						zUtl.fireSized(this);

						_rsFocus(cfi);
					}
				}

				if (!skipInfo)
					this.replaceHTML(n, null, null, true);

				this.z$rod = oldrod;
			}
		}
		return this;
	},

	
	replaceChildHTML_: function (child, n, desktop, skipper, _trim_) {
		var oldwgt = child.getOldWidget_(n);
		if (oldwgt) oldwgt.unbind(skipper); 
		else if (this.shallChildROD_(child))
			_unbindrod(child); 
		jq(n).replaceWith(child.redrawHTML_(skipper, _trim_));
		child.bind(desktop, skipper);
	},
	
	insertChildHTML_: function (child, before, desktop) {
		var ben, html = child.redrawHTML_();
		if (before) {
			if (before.$instanceof(zk.Native)) { 
				ben = before.previousSibling;
				if (ben) {
					if (ben == child) 
						ben = ben.previousSibling;
					if (ben && (ben = ben.$n())) {
						jq(ben).after(html);
						child.bind(desktop);
						return;
					}
				}
				
			}
			before = before.getFirstNode_();
		}
		if (!before)
			for (var w = this;;) {
				ben = w.getCaveNode();
				if (ben) break;

				var w2 = w.nextSibling;
				if (w2 && (before = w2.getFirstNode_()))
					break;

				if (!(w = w.parent)) {
					ben = document.body;
					break;
				}
			}

		if (before) {
			var sib = before.previousSibling;
			if (_isProlog(sib)) before = sib;
			jq(before).before(html);
		} else
			jq(ben).append(html);
		child.bind(desktop);
	},
	
	getCaveNode: function () {
		return this.$n('cave') || this.$n();
	},
	
	getFirstNode_: function () {
		for (var w = this; w; w = w.nextSibling) {
			var n = _getFirstNodeDown(w);
			if (n) return n;
		}
	},
	
	removeChildHTML_: function (child, ignoreDom) {
		var cf = zk.currentFocus;
		if (cf && zUtl.isAncestor(child, cf))
			zk.currentFocus = null;

		var n = child.$n();
		if (n) {
			var sib = n.previousSibling;
			if (child.prolog && _isProlog(sib))
				jq(sib).remove();
		} else
			_prepareRemove(child, n = []);

		child.unbind();

		if (!ignoreDom)
			child.removeHTML_(n);
	},
	
	removeHTML_: function (n) {
		_rmDom(this, n);
		this.clearCache();
	},
	
	
	$n: function (subId) {
		if (subId) {
			var n = this._subnodes[subId];
			if (!n && this.desktop) {
				n = jq(this.uuid + '-' + subId, zk)[0];
				this._subnodes[subId] = n ? n : 'n/a';
			}
			return n == 'n/a' ? null : n;
		}
		var n = this._node;
		if (!n && this.desktop && !this._nodeSolved) {
			this._node = n = jq(this.uuid, zk)[0];
			this._nodeSolved = true;
		}
		return n;
	},
	
	$service: function () {
		var w = this;
		for (; w ; w = w.parent) {
			if (w['$ZKAUS$'])
				break;
		}
		if (w) {
			if (!w._$service)
				w._$service = new zk.Service(w, this);
			return w._$service;
		}
		return null;
	},
	$afterCommand: function (command, args) {
		var service = this.$service();
		if (service)
			service.$doAfterCommand(command, args);
	},
	
	isRealElement: function () {
		return true;
	},
	
	$s: function (subclass) {
		if (subclass) {
			var subcls = this._subzcls[subclass];
			if (!subcls) {
				subcls = this._subzcls[subclass] = this.getZclass() + '-' + subclass;
			}
			return subcls;
		}
		return this.getZclass();
	},
	
	clearCache: function () {
		this._node = null;
		this._subnodes = {};
		this._nodeSolved = false;
	},
	
	getPage: function () {
		var page, dt;
		for (page = this.parent; page; page = page.parent)
			if (page.$instanceof(zk.Page))
				return page;

		return (page = (dt = this.desktop)._bpg) ?
			page: (dt._bpg = new zk.Body(dt));
	},

	
	isBinding: function () {
		if (this.desktop)
			for (var w = this; w; w = w.parent)
				if (w._binding)
					return true;
	},
	
	rerenderNow_: function (skipper) { 
		_rerenderNow(this, skipper);
	},
	
	bind: function (desktop, skipper) {
		this._binding = true;

		_rerenderDone(this, skipper); 
		if (this.z_rod) 
			_bindrod(this);
		else {
			var after = [], fn;
			this.bind_(desktop, skipper, after);
			while (fn = after.shift())
				fn();
		}

		delete this._binding;
		return this;
	},
	
	unbind: function (skipper) {
		if (this._$service) {
			this._$service.destroy();
			this._$service = null;
		}
		_rerenderDone(this, skipper); 
		if (this.z_rod)
			_unbindrod(this);
		else {
			var after = [];
			this.unbind_(skipper, after);
			for (var j = 0, len = after.length; j < len;)
				after[j++]();
		}
		return this;
	},

	
	bind_: function (desktop, skipper, after) {
		_bind0(this);

		this.desktop = desktop || (desktop = zk.Desktop.$(this.parent));

		var p = this.parent, v;
		this.bindLevel = p ? p.bindLevel + 1: 0;

		if ((v = this._draggable) && v != 'false' && !_dragCtl(this))
			this.initDrag_();
		
		if (this._nvflex || this._nhflex)
			_listenFlex(this);

		this.bindChildren_(desktop, skipper, after);
		var self = this;
		if (this.isListen('onBind')) {
			zk.afterMount(function () {
				if (self.desktop) 
					self.fire('onBind');
			});
		}
		
		if (this.isListen('onAfterSize')) 
			zWatch.listen({onSize: this});
		
		if (zk.mobile) {
			after.push(function (){
				setTimeout(function () {
					self.bindSwipe_();
					self.bindDoubleTap_();
					self.bindTapHold_();
				}, 300);
			});
		}
	},
	
	bindChildren_: function (desktop, skipper, after) {
		for (var child = this.firstChild, nxt; child; child = nxt) {
			nxt = child.nextSibling;
				

			if (!skipper || !skipper.skipped(this, child))
				if (child.z_rod) _bindrod(child);
				else child.bind_(desktop, null, after); 
		}
	},

	
	unbind_: function (skipper, after) {
		_unbind0(this);
		_unlistenFlex(this);

		this.unbindChildren_(skipper, after);
		this.cleanDrag_(); 
		this.unbindSwipe_();
		this.unbindDoubleTap_();
		this.unbindTapHold_();
		
		if (this.isListen('onAfterSize')) 
			zWatch.unlisten({onSize: this});
		
		if (this.isListen('onUnbind')) {
			var self = this;
			zk.afterMount(function () {
				if (!self.desktop) 
					self.fire('onUnbind');
			});
		}

		for (var nm in this.effects_) {
			var ef = this.effects_[nm];
			if (ef) ef.destroy();
		}
		this.effects_ = {};
	},
	
	unbindChildren_: function (skipper, after) {
		for (var child = this.firstChild, nxt; child; child = nxt) {
			nxt = child.nextSibling; 

			
			if (!skipper || !skipper.skipped(this, child))
				if (child.z_rod) _unbindrod(child);
				else if (child.desktop) {
					child.unbind_(null, after); 
					
					if (child.$instanceof(zk.Native))
						zAu._storeStub(child);
				}
		}
	},

	
	extraBind_: function (uuid, add) {
		if (add == false) delete _binds[uuid];
		else _binds[uuid] = this;
	},
	setFlexSize_: function(sz, isFlexMin) {
		var n = this.$n(),
			zkn = zk(n);
		if (sz.height !== undefined) {
			if (sz.height == 'auto')
				n.style.height = '';
			else if (sz.height != '' || (sz.height === 0 && !this.isFloating_())) 
				this.setFlexSizeH_(n, zkn, sz.height, isFlexMin);
			else
				n.style.height = this._height || '';
		}
		if (sz.width !== undefined) {
			if (sz.width == 'auto')
				n.style.width = '';
			else if (sz.width != '' || (sz.width === 0 && !this.isFloating_())) 
				this.setFlexSizeW_(n, zkn, sz.width, isFlexMin);
			else
				n.style.width = this._width || '';
		}
	},
	setFlexSizeH_: function(n, zkn, height, isFlexMin) {
		
		n.style.height = jq.px0(height - (!isFlexMin ? zkn.marginHeight() : 0));
	},
	setFlexSizeW_: function(n, zkn, width, isFlexMin) {
		
		n.style.width = jq.px0(width - (!isFlexMin ? zkn.marginWidth() : 0));
	},
	beforeChildrenFlex_: function(kid) {
		
		return true; 
	},
	afterChildrenFlex_: function(kid) {
		
	},
	
	afterChildMinFlexChanged_: function (kid, attr) { 
		
		
	},
	ignoreFlexSize_: function(attr) { 
		
		return false;
	},
	ignoreChildNodeOffset_: function(attr) { 
		
		return false;
	},
	beforeMinFlex_: function (attr) { 
		
		return null;
	},
	beforeParentMinFlex_: function (attr) { 
		
	},
	afterChildrenMinFlex_: function() {
		
	},
	afterResetChildSize_: function() {
		
	},
	isExcludedHflex_: function () {
		return jq(this.$n()).css('position') == 'absolute'; 
		
	},
	isExcludedVflex_: function () {
		return jq(this.$n()).css('position') == 'absolute'; 
		
	},
	
	
	getChildMinSize_: function (attr, wgt) { 
		if (attr == 'w') {
			
			var wd = zjq.minWidth(wgt);
			if(zk.ie > 8 && zk.isLoaded('zul.wgt') && wgt.$instanceof(zul.wgt.Image)) {
				wd = zk(wgt).offsetWidth();
			}
			return wd;
		} else {
			return zk(wgt).offsetHeight();
		}
	},
	
	
	getParentSize_: function(p) { 
		var zkp = zk(p);
		return {height: zkp.contentHeight(), width: zkp.contentWidth()};
	},
	getMarginSize_: function (attr) { 
		return zk(this).sumStyles(attr == 'h' ? 'tb' : 'lr', jq.margins);
	},
	getContentEdgeHeight_: function (height) {
		var p = this.$n(),
			fc = this.firstChild,
			
			fc = fc && zk.isLoaded('zul.wgt') && fc.$instanceof(zul.wgt.Caption) ? fc.nextSibling : fc;
	
		
		while (fc && fc.ignoreFlexSize_('h'))
			fc = fc.nextSibling;
		
		var c = fc ? fc.$n() : p.firstChild,
			zkp = zk(p),
			h = zkp.padBorderHeight();
		
		if (c) {
			c = c.parentNode;
			while (c && c.nodeType == 1 && p != c) {
				var zkc = zk(c);
				h += zkc.padBorderHeight() + zkc.sumStyles('tb', jq.margins);
				c = c.parentNode;
			}
			return h;
		}
		return 0;
	},
	getContentEdgeWidth_: function (width) {
		var p = this.$n(),
			fc = this.firstChild,
			
			fc = fc && zk.isLoaded('zul.wgt') && fc.$instanceof(zul.wgt.Caption) ? fc.nextSibling : fc;
	
		
		while (fc && fc.ignoreFlexSize_('w'))
			fc = fc.nextSibling;
		
		var	c = fc ? fc.$n() : p.firstChild,
			zkp = zk(p),
			w = zkp.padBorderWidth();
		
		if (c) {
			c = c.parentNode;
			while (c && c.nodeType == 1 && p != c) {
				var zkc = zk(c);
				w += zkc.padBorderWidth() + zkc.sumStyles('lr', jq.margins);
				c = c.parentNode;
			}
			return w;
		}
		return 0;
	},
	fixFlex_: function() {
		zFlex.fixFlex(this);
	},
	fixMinFlex_: function(n, orient) { 
		return zFlex.fixMinFlex(this, n, orient);
	},
	clearCachedSize_: function() {
		delete this._hflexsz;
		delete this._vflexsz;
	},
	resetSize_: function(orient) {
		var n = this.$n();
		if (n.scrollTop || n.scrollLeft) 
			return;
		n.style[orient == 'w' ? 'width': 'height'] = '';
	},
	
	initDrag_: function () {
		var n = this.getDragNode();
		if (n) { 
			this._drag = new zk.Draggable(this, n, this.getDragOptions_(_dragoptions));
			
			if (zk.ie9 && jq.nodeName(n, 'img'))
				jq(n).bind('mousedown', zk.$void);
		}
	},
	
	cleanDrag_: function () {
		var drag = this._drag;
		if (drag) {
			var n;
			if (zk.ie9 && (n = this.getDragNode()) && jq.nodeName(n, 'img'))
				jq(n).unbind('mousedown', zk.$void);

			this._drag = null;
			drag.destroy();
		}
	},
	
	getDragNode: function () {
		return this.$n();
	},
	
	getDragOptions_: function (map) {
		return map;
	},
	
	ignoreDrag_: function (pt) {
		return false;
	},
	
	getDrop_: function (dragged) {
		if (this == dragged) {
			return null; 
		} else {
			var dropType = this._droppable,
				dragType = dragged._draggable;
			if (dropType == 'true') return this;
			if (dropType && dragType != 'true')
				for (var dropTypes = this._dropTypes, j = dropTypes.length; j--;)
					if (dragType == dropTypes[j])
						return this;
		}
		return this.parent ? this.parent.getDrop_(dragged): null;
	},
	
	dropEffect_: function (over) {
		jq(this.$n()||[])[over ? 'addClass' : 'removeClass']('z-drag-over');
	},
	
	getDragMessage_: function () {
		if (jq.nodeName(this.getDragNode(), 'tr', 'td', 'th')) {
			var n = this.$n('real') || this.getCaveNode();
			return n ? n.textContent || n.innerText || '': '';
		}
	},
	
	onDrop_: function (drag, evt) {
		var data = zk.copy({dragged: drag.control}, evt.data);
		this.fire('onDrop', data, null, Widget.auDelay);
	},
	
	cloneDrag_: function (drag, ofs) {
		

		var msg = this.getDragMessage_();
		if (typeof msg == 'string' && msg.length > 9)
			msg = msg.substring(0, 9) + '...';

		var dgelm = zk.DnD.ghost(drag, ofs, msg);

		drag._orgcursor = document.body.style.cursor;
		document.body.style.cursor = 'pointer';
		jq(this.getDragNode()).addClass('z-dragged'); 
		return dgelm;
	},
	
	uncloneDrag_: function (drag) {
		document.body.style.cursor = drag._orgcursor || '';

		jq(this.getDragNode()).removeClass('z-dragged');
	},
	
	
	
	onSize: function() {},
	
	onAfterSize: function () {
		if (this.desktop && this.isListen('onAfterSize')) {
			var n = this.getCaveNode(),
				width = n.offsetWidth,
				height = n.offsetHeight;
			if (this._preWidth != width || this._preHeight != height) {
				this._preWidth = width;
				this._preHeight = height;
				this.fire('onAfterSize', {width: width, height: height});
			}
		}
	},
	
	
	bindSwipe_: zk.$void,
	
	unbindSwipe_: zk.$void,
	
	bindDoubleTap_: zk.$void,
	
	unbindDoubleTap_: zk.$void,
	
	bindTapHold_: zk.$void,
	
	unbindTapHold_: zk.$void,
	
	focus: function (timeout) {
		return this.canActivate({checkOnly:true})
			&& zk(this.$n()).isRealVisible()
			&& this.focus_(timeout);
	},
	
	focus_: function (timeout) {
		if (zk(this.$n()).focus(timeout)) {
			this.setTopmost();
			return true;
		}
		for (var w = this.firstChild; w; w = w.nextSibling) {
			
			if (w.isRealVisible() && w.focus_(timeout))
				return true;
		}
		return false;
	},
	
	canActivate: function (opts) {
		if (_ignCanActivate)
			return true;
		if (zk.busy && (!opts || !opts.checkOnly)) { 
			jq.focusOut(); 
			return false;
		}

		var modal = zk.currentModal;
		if (modal && !zUtl.isAncestor(modal, this)
		&& !jq.isAncestor(modal.$n(), this.$n())) { 
			var wgt = this.getTopWidget();
			
			
			if (wgt && wgt != modal && wgt.getZIndex() > modal.getZIndex())
				return true;
			
			if (!opts || !opts.checkOnly) {
				var cf = zk.currentFocus;
				
				if (cf && zUtl.isAncestor(modal, cf) && cf.focus(0)) {
				    return true;
				} else {
				    modal.focus(0);
				}
			}
			return false;
		}
		return true;
	},

	
	
	smartUpdate: function (nm, val, timeout) {
		zAu.send(new zk.Event(this, 'setAttr', [nm, val]),
			timeout >= 0 ? timeout: -1);
		return this;
	},

	
	
	fireX: function (evt, timeout) {
		var oldtg = evt.currentTarget;
		evt.currentTarget = this;
		try {
			var evtnm = evt.name,
				lsns = this._lsns[evtnm],
				len = lsns ? lsns.length: 0;
			if (len) {
				for (var j = 0; j < len;) {
					var inf = lsns[j++], o = inf[0];
					(inf[1] || o[evtnm]).call(o, evt);
					if (evt.stopped) return evt; 
				}
			}

			if (!evt.auStopped) {
				var toServer = evt.opts && evt.opts.toServer;
				if (toServer || (this.inServer && this.desktop)) {
					var asap = toServer || this._asaps[evtnm];
					if (asap == null) {
						var ime = this.$class._importantEvts;
						if (ime) {
							var ime = ime[evtnm];
							if (ime != null) 
								asap = ime;
						}
					}
					if (asap != null 
					|| evt.opts.sendAhead)
						this.sendAU_(evt,
							asap ? timeout >= 0 ? timeout : Widget.auDelay : -1);
				}
			}
			return evt;
		} finally {
			evt.currentTarget = oldtg;
		}
	},
	
	beforeSendAU_: function (wgt, evt) {
		var en = evt.name;
		if (en == 'onClick' || en == 'onRightClick' || en == 'onDoubleClick')
			evt.shallStop = true;
	},
	
	sendAU_: function (evt, timeout, opts) {
		(evt.target||this).beforeSendAU_(this, evt);
		evt = new zk.Event(this, evt.name, evt.data, evt.opts, evt.domEvent);
			
		if (evt.opts.sendAhead) zAu.sendAhead(evt, timeout);
		else zAu.send(evt, timeout);
	},
	
	shallIgnoreClick_: function (evt) {
	},

	
	fire: function (evtnm, data, opts, timeout) {
		return this.fireX(new zk.Event(this, evtnm, data, opts), timeout);
	},
	
	listen: function (infs, priority) {
		priority = priority ? priority: 0;
		for (var evt in infs) {
			var inf = infs[evt];
			if (jq.isArray(inf)) inf = [inf[0]||this, inf[1]];
			else if (typeof inf == 'function') inf = [this, inf];
			else inf = [inf||this, null];
			inf.priority = priority;

			var lsns = this._lsns[evt];
			if (!lsns) this._lsns[evt] = [inf];
			else
				for (var j = lsns.length;;)
					if (--j < 0 || lsns[j].priority >= priority) {
						lsns.splice(j + 1, 0, inf);
						break;
					}
		}
		return this;
	},
	
	unlisten: function (infs) {
		l_out:
		for (var evt in infs) {
			var inf = infs[evt],
				lsns = this._lsns[evt], lsn;
			for (var j = lsns ? lsns.length: 0; j--;) {
				lsn = lsns[j];
				if (jq.isArray(inf)) inf = [inf[0]||this, inf[1]];
				else if (typeof inf == 'function') inf = [this, inf];
				else inf = [inf||this, null];
				if (lsn[0] == inf[0] && lsn[1] == inf[1]) {
					lsns.splice(j, 1);
					continue l_out;
				}
			}
		}
		return this;
	},
	
	isListen: function (evt, opts) {
		var v = this._asaps[evt];
		if (v) return true;
		if (opts) {
			if (opts.asapOnly) {
				v = this.$class._importantEvts;
				return v && v[evt];
			}
			if (opts.any) {
				if (v != null) return true;
				v = this.$class._importantEvts;
				if (v && v[evt] != null) return true;
			}
		}

		var lsns = this._lsns[evt];
		return lsns && lsns.length;
	},
	
	setListeners: function (infs) {
		for (var evt in infs)
			this.setListener(evt, infs[evt]);
	},
	
	setListeners0: function (infs) { 
		for (var evt in infs)
			this.setListener0(evt, infs[evt]);
	},
	
	
	setListener: function (evt, fn) { 
		if (jq.isArray(evt)) {
			fn = evt[1];
			evt = evt[0]
		}

		var bklsns = this._bklsns,
			oldfn = bklsns[evt],
			inf = {};
		if (oldfn) { 
			delete bklsns[evt];
			inf[evt] = oldfn
			this.unlisten(inf);
		}
		if (fn) {
			inf[evt] = bklsns[evt]
				= typeof fn != 'function' ? new Function('var event=arguments[0];'+fn): fn;
			this.listen(inf);
		}
	},
	
	setListener0: function (evt, fn) { 
		if (jq.isArray(evt)) {
			fn = evt[1];
			evt = evt[0]
		}

		var bklsns = this._bklsns,
			oldfn = bklsns[evt],
			inf = {};
		if (fn) {
			inf[evt] = bklsns[evt]
				= typeof fn != 'function' ? new Function('var event=arguments[0];'+fn): fn;
			this.listen(inf);
		}
	},
	setOverride: function (nm, val) { 
		if (jq.isArray(nm)) {
			val = nm[1];
			nm = nm[0];
		}
		if (val) {
			var oldnm = '$' + nm;
			if (this[oldnm] == null && this[nm]) 
				this[oldnm] = this[nm];
			this[nm] = val;
				
		} else {
			var oldnm = '$' + nm;
			this[nm] = this[oldnm]; 
			delete this[oldnm];
		}
	},
	setOverrides: function (infs) { 
		for (var nm in infs)
			this.setOverride(nm, infs[nm]);
	},

	
	
	doSelect_: function(evt) {
		if (!evt.stopped) {
			var p = this.parent;
			if (p) p.doSelect_(evt);
		}
	},
	
	doTooltipOver_: function (evt) {
		if (!evt.stopped) {
			var p = this.parent;
			if (p) p.doTooltipOver_(evt);
		}
	},
	
	doTooltipOut_: function (evt) {
		if (!evt.stopped) {
			var p = this.parent;
			if (p) p.doTooltipOut_(evt);
		}
	},
	
	doClick_: function (evt) {
		if (_fireClick(this, evt)) {
			var p = this.parent;
			if (p) p.doClick_(evt);
		}
	},
	
	doDoubleClick_: function (evt) {
		if (_fireClick(this, evt)) {
			var p = this.parent;
			if (p) p.doDoubleClick_(evt);
		}
	},
	
	doRightClick_: function (evt) {
		if (_fireClick(this, evt)) {
			var p = this.parent;
			if (p) p.doRightClick_(evt);
		}
	},
	
	doMouseOver_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doMouseOver_(evt);
		}
	},
	
	doMouseOut_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doMouseOut_(evt);
		}
	},
	
	doMouseDown_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doMouseDown_(evt);
		}
	},
	
	doMouseUp_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doMouseUp_(evt);
		}
	},
	
	doMouseMove_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doMouseMove_(evt);
		}
	},

	
	doKeyDown_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doKeyDown_(evt);
		}
	},
	
	doKeyUp_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doKeyUp_(evt);
		}
	},
	
	doKeyPress_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doKeyPress_(evt);
		}
	},
	
	doSwipe_: function(evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doSwipe_(evt);
		}
	},

	
	doFocus_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doFocus_(evt);
		}
	},
	
	doBlur_: function (evt) {
		if (!this.fireX(evt).stopped) {
			var p = this.parent;
			if (p) p.doBlur_(evt);
		}
	},

	
	doResizeScroll_: function () {
		var p = this.parent;
		if (p) p.doResizeScroll_();
	},
	
	
	
	domListen_: function (n, evtnm, fn, keyword) {
		if (!this.$weave) {
			var inf = _domEvtInf(this, evtnm, fn, keyword);
			jq(n, zk).bind(inf[0], inf[1]);
		}
		return this;
	},
	
	domUnlisten_: function (n, evtnm, fn, keyword) {
		if (!this.$weave) {
			var inf = _domEvtInf(this, evtnm, fn, keyword);
			jq(n, zk).unbind(inf[0], inf[1]);
		}
		return this;
	},
	
	listenOnFitSize_: function () {
		if (!this._fitSizeListened && (this._hflex == 'min' || this._vflex == 'min')){
			zWatch.listen({onFitSize: [this, zFlex.onFitSize]});
			this._fitSizeListened = true;
		}
	},
	
	unlistenOnFitSize_: function () {
		if (this._fitSizeListened) {
			zWatch.unlisten({onFitSize: [this, zFlex.onFitSize]});
			delete this._fitSizeListened;
		}
	},
	
	fromPageCoord: function (x, y) {
		var ofs = zk(this).revisedOffset();
		return [x - ofs[0], y - ofs[1]];
	},
	
	isWatchable_: function (name, p, cache) {
		
		
		var strict = name != 'onShow', wgt;
		if (p)
			return this.isRealVisible({dom:true, strict:strict, until:p, cache: cache});

		for (wgt = this;;) {
			if (!wgt.$instanceof(zk.Native)) 
				break;

			
			
			if (!wgt._visible)
				return false;

			
			if (!(wgt = wgt.parent))
				return true; 
		}

		return zk(wgt.$n()).isRealVisible(strict);
	},
	toJSON: function () { 
		return this.uuid;
	},
	
	ignoreDescendantFloatUp_: function (des) {
		return false;
	},
	
	getDomEvtInf_: function (wgt, evtnm, fn, keyword) {
		return _domEvtInf(wgt, evtnm, fn, keyword);
	}

}, {
	
	disableChildCallback: function () {
		_noChildCallback = true;
	},
	
	enableChildCallback: function () {
		_noChildCallback = false;
	},
	
	$: function (n, opts) {
		if (n && n.zk && n.zk.jq == n) 
			n = n[0];

		if (!n || Widget.isInstance(n))
			return n;

		var wgt, id;
		if (typeof n == 'string') {
		
			if ((id = n.charAt(0)) == '#') n = n.substring(1);
			else if (id == '$') {
				id = _globals[n.substring(1)];
				return id ? id[0]: null;
			}
			wgt = _binds[n]; 
			if (!wgt)
				wgt = (id = n.indexOf('-')) >= 0 ? _binds[n.substring(0, id)]: null;

			if (!wgt)
				return jq(n).zk.$();
			return wgt;
		}

		if (!n.nodeType) { 
			var e1, e2;
			n = ((e1 = n.originalEvent) ? e1.z$target:null)
				|| ((e1 = n.target) && (e2 = e1.z$proxy) ? e2: e1) || n; 
		}

		opts = opts || {};
		if (opts.exact)
			return _binds[n.id];

		for (; n; n = zk(n).vparentNode(true)) {
			try {
				id = n.id || (n.getAttribute ? n.getAttribute('id') : '');
				if (id && typeof id == 'string') {
					wgt = _binds[id]; 
					if (wgt)
						return wgt;

					var j = id.indexOf('-');
					if (j >= 0) {
						wgt = _binds[id = id.substring(0, j)];
						if (wgt) {
							if (!opts.child)
								return wgt;

							var n2 = wgt.$n();
							if (n2 && jq.isAncestor(n2, n))
								return wgt;
						}
					}
				}
			} catch (e) { 
			}
			if (opts.strict)
				break;
		}
		return null;
	},

	
	mimicMouseDown_: function (wgt, noFocusChange, which) { 
		var modal = zk.currentModal;
		if (modal && !wgt) {
			var cf = zk.currentFocus;
			
			
			if (cf && zUtl.isAncestor(modal, cf)) cf.focus(0);
			else modal.focus(0);
		} else if (!wgt || wgt.canActivate()) {
			if (!noFocusChange) {
				zk._prevFocus = zk.currentFocus;
				zk.currentFocus = wgt;
				zk._cfByMD = true;
				setTimeout(function(){zk._cfByMD = false; zk._prevFocus = null;}, 0);
					
			}

			if (wgt) 
				zWatch.fire('onFloatUp', wgt, {triggerByClick: which}); 
			else
				for (var dtid in zk.Desktop.all)
					zWatch.fire('onFloatUp', zk.Desktop.all[dtid]); 
		}
	},
	
	getElementsByName: function (name) {
		var els = [];
		for (var wid in _binds) {
			if (name == '*' || name == _binds[wid].widgetName) {
				var n = _binds[wid].$n(), w;
				
				if (n && (w = Widget.$(_binds[wid]))) {
					els.push({
						n: n,
						w: w
					});
				}
			}
		}
		if (els.length) {
			
			
			els.sort(function(a, b) {
				var w1 = a.w,
					w2 = b.w;
				
				
				if (w1.bindLevel < w2.bindLevel) {
					do {
						w2 = w2.parent;
					} while (w1 && w1.bindLevel < w2.bindLevel);
				} else if (w1.bindLevel > w2.bindLevel) {
					do {
						w1 = w1.parent;
					} while (w2 && w1.bindLevel > w2.bindLevel);
				}
				var wp1 = w1.parent,
					wp2 = w2.parent;
				while (wp1 && wp2 && wp1 != wp2) {
					w1 = wp1;
					w2 = wp2;
					wp1 = wp1.parent;
					wp2 = wp2.parent;
				}
				if (w1 && w2) {
					return w1.getChildIndex() - w2.getChildIndex();
				}	
				return 0;
			});
			var tmp = [];
			for (var i = els.length; i--;)
				tmp.unshift(els[i].n);
			els = tmp;
		}
		return els;
	},
	
	getElementsById: function (id) {
		var els = [];
		for (var n, wgts = _globals[id], i = wgts?wgts.length:0; i--;) {
			n = wgts[i].$n();
			if (n) els.unshift(n);
		}
		return els;
	},

	
	
	uuid: function (id) {
		var uuid = typeof id == 'object' ? id.id || '' : id,
			j = uuid.indexOf('-');
		return j >= 0 ? uuid.substring(0, j): id;
	},
	
	nextUuid: function () {
		return '_z_' + _nextUuid++;
	},

	
	isAutoId: function (id) {
		return !id;
	},

	
	register: function (clsnm, blankprev) {
		var cls = zk.$import(clsnm);
		cls.prototype.className = clsnm;
		var j = clsnm.lastIndexOf('.');
		if (j >= 0) clsnm = clsnm.substring(j + 1);
		_wgtcls[cls.prototype.widgetName = clsnm.toLowerCase()] = cls;
		if (blankprev) cls.prototype.blankPreserved = true;
	},
	
	getClass: function (wgtnm) {
		return _wgtcls[wgtnm];
	},
	
	newInstance: function (wgtnm, props) {
		var cls = _wgtcls[wgtnm];
		if (!cls) {
			zk.error(cls = 'Unknown widget: '+wgtnm);
			throw cls;
		}
		return new cls(props);
	},
	
	auDelay: 38
});


	
	

zk.$ = function (n, opts) {
	return zk.Widget.$(n, opts);
}
zkreg = Widget.register; 


zk.RefWidget = zk.$extends(zk.Widget, {
	
	className: 'zk.RefWidget',
	
	widgetName: 'refWidget',
	bind_: function () {
		var w = Widget.$(this.uuid);
		if (!w) {
			zk.error('RefWidget not found: ' + this.uuid);
			return;
		}

		var p;
		if (p = w.parent) 
			_unlink(p, w); 

		_replaceLink(this, w);
		this.parent = this.nextSibling = this.previousSibling = null;

		_addIdSpaceDown(w); 

		
	}
});



zk.Desktop = zk.$extends(zk.Widget, {
	
	z_virnd: true,

	bindLevel: 0,
	
	className: 'zk.Desktop',
	
	widgetName: 'desktop',
	
	
	
	
	$init: function (dtid, contextURI, updateURI, reqURI, stateless) {
		this.$super('$init', {uuid: dtid}); 

		var Desktop = zk.Desktop, dts = Desktop.all, dt;

		this._aureqs = [];
		

		if (dt = dts[dtid]) {
			if (updateURI != null) dt.updateURI = updateURI;
			if (contextURI != null) dt.contextURI = contextURI;
		} else {
			this.uuid = this.id = dtid;
			this.updateURI = updateURI != null ? updateURI: zk.updateURI;
			this.contextURI = contextURI != null ? contextURI: zk.contextURI;
			this.requestPath = reqURI || '';
			this.stateless = stateless;
			dts[dtid] = this;
			++Desktop._ndt;
		}

		Desktop._dt = dt||this; 
		Desktop.sync(60000); 
	},
	bind_: zk.$void,
	unbind_: zk.$void,
	
	setId: zk.$void,
	
	
	isRealVisible: function() {
		return true;
	}
},{
	
	$: function (dtid) {
		var Desktop = zk.Desktop, w;
		if (dtid) {
			if (Desktop.isInstance(dtid))
				return dtid;

			w = Desktop.all[dtid];
			if (w)
				return w;

			w = Widget.$(dtid);
			for (; w; w = w.parent) {
				if (w.desktop)
					return w.desktop;
				if (w.$instanceof(Desktop))
					return w;
			}
			return null;
		}

		if (w = Desktop._dt)
			return w;
		for (dtid in Desktop.all)
			return Desktop.all[dtid];
	},
	
	all: {},
	_ndt: 0, 
	
	sync: function (timeout) {
		var Desktop = zk.Desktop, dts = Desktop.all, dt;

		if (_syncdt) {
			clearTimeout(_syncdt);
			_syncdt = null;
		}

		if (timeout >= 0)
			_syncdt = setTimeout(function () {
				_syncdt = null;
				Desktop.sync();
			}, timeout); 
		else {
			for (var dtid in dts)
				if (!_exists(dt = dts[dtid]) && dt.firstChild) { 
					delete dts[dtid];
					--Desktop._ndt;
					if (Desktop._dt == dt)
						Desktop._dt = null;
					zAu._rmDesktop(dt);
				}

			if (!Desktop._dt)
				for (var dtid in dts) {
					Desktop._dt = dts[dtid];
					break;
				}
		}
		return Desktop._dt;
	}
});

zk._wgtutl = { 
	setUuid: function (wgt, uuid) { 
		if (!uuid)
			uuid = Widget.nextUuid();
		if (uuid != wgt.uuid) {
			var n = wgt.$n();
			if (n) {
				
				if (!wgt.rawId)
					throw 'id immutable after bound'; 
				n.id = uuid;
				delete _binds[wgt.uuid];
				_binds[uuid] = wgt;
				wgt.clearCache();
			}
			wgt.uuid = uuid;
		}
	},
	
	replace: function (from, to, kids) { 
		_replaceLink(from, to);
		from.parent = from.nextSibling = from.previousSibling = null;

		if (kids) {
			to.lastChild = from.lastChild;
			for (var p = to.firstChild = from.firstChild; p; p = p.nextSibling)
				p.parent = to;
			to.nChildren = from.nChildren;
			from.firstChild = from.lastChild = null;
			from.nChildren = 0;
		}
		from.nChildren = 0;
	},

	autohide: function () { 
		if (!_floatings.length) {
			for (var n; n = _hidden.shift();)
				n.style.visibility = n.getAttribute('z_ahvis')||'';
			return;
		}

		for (var tns = ['IFRAME', 'APPLET'], i = 2; i--;)
			l_nxtel:
			for (var ns = document.getElementsByTagName(tns[i]), j = ns.length; j--;) {
				var n = ns[j], $n = zk(n), visi;
				if ((!(visi=$n.isVisible(true)) && !_hidden.$contains(n))
				|| (!i && !n.getAttribute('z_autohide') && !n.getAttribute('z.autohide'))) 
					continue; 

				var tc = _topnode(n);
				function hide(f) {
					var tf = _topnode(f);
					if (tf == tc || _zIndex(tf) < _zIndex(tc) || !$n.isOverlapped(f))
						return;

					if (visi) {
						_hidden.push(n);
						try {
							n.setAttribute('z_ahvis', n.style.visibility);
						} catch (e) {
						}
						n.style.visibility = 'hidden';
					}
					return true; 
				}

				for (var k = _floatings.length; k--;)
					if (hide(_floatings[k].node))
						continue l_nxtel;

				if (_hidden.$remove(n))
					n.style.visibility = n.getAttribute('z_ahvis')||'';
			}
	}
};
})();


zk.Page = zk.$extends(zk.Widget, {
	
	z_virnd: true,

	_style: 'width:100%;height:100%',
	
	className: 'zk.Page',
	
	widgetName: 'page',

	
	$init: function (props, contained) {
		this._fellows = {};

		this.$super('$init', props);

		if (contained) zk.Page.contained.push(this);
	},
	
	redraw: _zkf = function (out) {
		out.push('<div', this.domAttrs_(), '>');
		for (var w = this.firstChild; w; w = w.nextSibling)
			w.redraw(out);
		out.push('</div>');
	}
},{
	$redraw: _zkf,
	
	contained: []
});
zkreg('zk.Page', true);


zk.Body = zk.$extends(zk.Page, {
	$init: function (dt) {
		this.$super('$init', {});
		this.desktop = dt;
	},
	$n: function (subId) {
		return subId ? null: document.body;
	},
	redraw: zk.$void
});

zk.Native = zk.$extends(zk.Widget, {
	
	z_virnd: true,

	
	className: 'zk.Native',
	
	widgetName: 'native',
	

	$n: function (subId) {
		return !subId && this.id ? jq('#' + this.id):
			this.$supers('$n', arguments); 
	},
	redraw: _zkf = function (out) {
		var s = this.prolog, p;
		if (s) {
			
			
			
			if (this.$instanceof(zk.Native) 
			&& !this.id && (p=this.parent) && !p.z_virnd) { 
				var j = 0, len = s.length, cond, cc;
				for (cond = {whitespace:1}; j < len; ++j) {
					if ((cc = s.charAt(j)) == '<')
						break; 
					if (!zUtl.isChar(cc, cond)) {
						j = len; 
						break;
					}
				}
				if (j < len) {
					cond = {upper:1,lower:1,digit:1,'-':1};
					while (++j < len)
						if (!zUtl.isChar(s.charAt(j), cond))
							break;
					s = s.substring(0, j) + ' id="' + this.uuid + '"' + s.substring(j); 
				}
			}
			
			if (this.domExtraAttrs) {
				s = s.substring(0, s.indexOf("/>")) + this.domExtraAttrs_() + "/>";
			}
			
			out.push(zk.Native.replaceScriptContent(s.replace(/ sclass=/ig, ' class=')));
			if (this.value && s.startsWith('<textarea'))
				out.push(this.value);
		}

		for (var w = this.firstChild; w; w = w.nextSibling)
			w.redraw(out);

		s = this.epilog;
		if (s) out.push(s);
	}
}, {
	$redraw: _zkf,
	replaceScriptContent: (function () {
		var Script_RE = new RegExp(/<script[^>]*>([\s\S]*?)<\/script>/g);
		var Replace_RE = new RegExp(/<\/(?=script>)/ig);
		return function (str) {
			try {
				var result = str.match(Script_RE);
				if (!result)
					return str.replace(Replace_RE, '<\\/');
				else {
					for (var i = 0, j = result.length; i < j; i++) {
						var substr = result[i];
						
						
						if (substr.length >= 17) {
							var cnt = substr.substring(8, substr.length - 9);
							var cnt2 = zk.Native.replaceScriptContent(cnt);
							if (cnt != cnt2)
								str = str.replace(cnt, cnt2);
						}
					}
				}
				return str;
			} catch (e) {}
			return str;
		};
	})()
});


zk.Macro = zk.$extends(zk.Widget, {
	
	className: 'zk.Macro',
	
	widgetName: 'macro',
	
	_enclosingTag: 'div',

	$init: function () {
		this._fellows = {};
		this.$supers('$init', arguments);
	},
	$define: {
		
		
		enclosingTag: function () {
			this.rerender();
		}
	},

	
	redraw: function (out) {
		var style = ' style="display: inline-block; min-width: 1px;"';
		out.push('<', this._enclosingTag, this.domAttrs_(), style, '>'); 
		for (var w = this.firstChild; w; w = w.nextSibling)
			w.redraw(out);
		out.push('</', this._enclosingTag, '>');
	}
});


zkservice = {
	$: function (n, opts) {
		var widget = zk.Widget.$(n, opts);
		if (widget)
			return widget.$service();
		zk.error('Not found ZK Service with [' + n + ']');
	}
};
(function () {
	function _fixCommandName(prefix, opts, prop) {
		if (opts[prop]) {
			var ignores = {};
			for (var key in opts[prop]) {
				ignores[prefix+key] = opts[prop][key];
			}
			opts[prop] = ignores;
		}
	}

zk.Service = zk.$extends(zk.Object, {
	$init: function (widget, currentTarget) {
		this.$supers('$init', arguments);
		this.$view = widget;
		this.$currentTarget = currentTarget;
		this._aftercmd = {};
	},
	
	after: function (cmd, fn) {
		if (!fn && jq.isFunction(cmd)) {
			fn = cmd;
			cmd = this._lastcmd;
		}

		var ac = this._aftercmd[cmd];
		if (!ac) this._aftercmd[cmd] = [fn];
		else
			ac.push(fn);
		return this;
	},
	
	unAfter: function (cmd, fn) {
		var ac = this._aftercmd[cmd];
		for (var j = ac ? ac.length: 0; j--;) {
			if (ac[j] == fn)
				ac.splice(j, 1);
		}
		return this;
	},
	
	destroy: function () {
		this._aftercmd = null;
		this.$view = null;
		this.$currentTarget = null;
	},
	
	command: function (cmd, args, opts, timeout) {
		var wgt = this.$view;
		if (opts) {
			if (opts.duplicateIgnore)
				_fixCommandName('onAuServiceCommand$', opts, 'duplicateIgnore');
			if (opts.repeatIgnore)
				_fixCommandName('onAuServiceCommand$', opts, 'repeatIgnore');
		}
        zAu.send(new zk.Event(wgt, 'onAuServiceCommand$' + cmd, {cmd: cmd, args: args}, zk.copy({toServer:true}, opts)), timeout != undefined ? timeout : 38);
        this._lastcmd = cmd;
		return this;
	},
	$doAfterCommand: function (cmd, args) {
		var ac = this._aftercmd[cmd];
		for (var i = 0, j = ac ? ac.length: 0; i < j; i++)
			ac[i].apply(this, [args]);
	}
 });
})();

zk.Skipper = zk.$extends(zk.Object, {
	
	skipped: function (wgt, child) {
		return wgt.caption != child;
	},
	
	skip: function (wgt, skipId) {
		var skip = jq(skipId || wgt.getCaveNode(), zk)[0];
		if (skip && skip.firstChild) {
			var cf = zk.currentFocus,
				iscf = cf && cf.getInputNode;
			
			if (iscf && zk.ie < 11) 
				zk.cfrg = zk(cf.getInputNode()).getSelectionRange();
			
			skip.parentNode.removeChild(skip);
				
			
			if (iscf && zk.chrome) 
				zk.currentFocus = cf;
			
			return skip;
		}
	},
	
	restore: function (wgt, skip) {
		if (skip) {
			var loc = jq(skip.id, zk)[0];
			for (var el; el = skip.firstChild;) {
				skip.removeChild(el);
				loc.appendChild(el);

				zjq._fixIframe(el); 
			}
		}
	}
});


	
	

zk.Skipper.nonCaptionSkipper = new zk.Skipper();



function zkopt(opts) {
	for (var nm in opts) {
		var val = opts[nm];
		switch (nm) {
		case 'pd': zk.procDelay = val; break;
		case 'td': zk.tipDelay =  val; break;
		case 'art': zk.resendTimeout = val; break;
		case 'dj': zk.debugJS = val; break;
		case 'kd': zk.keepDesktop = val; break;
		case 'pf': zk.pfmeter = val; break;
		case 'ta': zk.timerAlive = val; break;
		case 'gd': zk.groupingDenied = val; break;
		case 'to':
			zk.timeout = val;
			zAu._resetTimeout();
			break;
		case 'ed':
			switch (val) {
			case 'e':
				zk.feature.ee = true;
			case 'p':
				zk.feature.pe = true;
			}
			break;
		case 'eu': zAu.setErrorURI(val); break;
		case 'ppos': zk.progPos = val; break;
		case 'eup': zAu.setPushErrorURI(val);
		}
	}
}
