/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom;

import java.util.Locale;
import org.xml.sax.Locator;
import org.zkoss.idom.DOMException;

public class Verifier {
    private static final byte[] VALCONST = new byte[]{0, 1, 0, 1, 0, 1, 65, 1, 65, 73, 65, 89, 65, 1, 65, 1, 65, 79, 1, 77, 1, 79, 1, 65, 1, 9, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 9, 1, 41, 1, 41, 1, 15, 9, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 15, 1, 9, 15, 41, 1, 25, 1, 41, 15, 1, 15, 1, 15, 1, 15, 1, 15, 41, 15, 41, 1, 41, 1, 25, 1, 41, 1, 15, 1, 41, 15, 41, 1, 41, 1, 15, 41, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 41, 1, 25, 15, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 25, 41, 15, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 15, 41, 1, 41, 1, 41, 1, 15, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 15, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 25, 1, 15, 1, 15, 41, 15, 41, 1, 15, 9, 41, 1, 25, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 41, 15, 41, 1, 41, 15, 1, 15, 1, 9, 1, 41, 1, 25, 1, 41, 1, 25, 1, 41, 1, 41, 1, 41, 1, 41, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 9, 1, 15, 1, 15, 41, 1, 9, 1, 15, 1, 41, 1, 9, 1, 15, 1, 9, 1, 15, 1, 15, 1, 15, 1, 0, 1, 0};
    private static final int[] LENCONST = new int[]{9, 2, 2, 1, 18, 1, 1, 2, 9, 2, 1, 10, 1, 2, 1, 1, 2, 26, 4, 1, 1, 26, 3, 1, 56, 1, 8, 23, 1, 31, 1, 58, 2, 11, 2, 8, 1, 53, 1, 68, 9, 36, 3, 2, 4, 30, 56, 89, 18, 7, 14, 2, 46, 70, 26, 2, 36, 1, 1, 3, 1, 1, 1, 20, 1, 44, 1, 7, 3, 1, 1, 1, 1, 1, 1, 1, 1, 18, 13, 12, 1, 66, 1, 12, 1, 36, 1, 4, 9, 53, 2, 2, 2, 2, 3, 28, 2, 8, 2, 2, 55, 38, 2, 1, 7, 38, 10, 17, 1, 23, 1, 3, 1, 1, 1, 2, 1, 1, 11, 27, 5, 3, 46, 26, 5, 1, 10, 8, 13, 10, 6, 1, 71, 2, 5, 1, 15, 1, 4, 1, 1, 15, 2, 2, 1, 4, 2, 10, 519, 3, 1, 53, 2, 1, 1, 16, 3, 4, 3, 10, 2, 2, 10, 17, 3, 1, 8, 2, 2, 2, 22, 1, 7, 1, 1, 3, 4, 2, 1, 1, 7, 2, 2, 2, 3, 9, 1, 4, 2, 1, 3, 2, 2, 10, 2, 16, 1, 2, 6, 4, 2, 2, 22, 1, 7, 1, 2, 1, 2, 1, 2, 2, 1, 1, 5, 4, 2, 2, 3, 11, 4, 1, 1, 7, 10, 2, 3, 12, 3, 1, 7, 1, 1, 1, 3, 1, 22, 1, 7, 1, 2, 1, 5, 2, 1, 1, 8, 1, 3, 1, 3, 18, 1, 5, 10, 17, 3, 1, 8, 2, 2, 2, 22, 1, 7, 1, 2, 2, 4, 2, 1, 1, 6, 3, 2, 2, 3, 8, 2, 4, 2, 1, 3, 4, 10, 18, 2, 1, 6, 3, 3, 1, 4, 3, 2, 1, 1, 1, 2, 3, 2, 3, 3, 3, 8, 1, 3, 4, 5, 3, 3, 1, 4, 9, 1, 15, 9, 17, 3, 1, 8, 1, 3, 1, 23, 1, 10, 1, 5, 4, 7, 1, 3, 1, 4, 7, 2, 9, 2, 4, 10, 18, 2, 1, 8, 1, 3, 1, 23, 1, 10, 1, 5, 4, 7, 1, 3, 1, 4, 7, 2, 7, 1, 1, 2, 4, 10, 18, 2, 1, 8, 1, 3, 1, 23, 1, 16, 4, 6, 2, 3, 1, 4, 9, 1, 8, 2, 4, 10, 145, 46, 1, 1, 1, 2, 7, 5, 6, 1, 8, 1, 10, 39, 2, 1, 1, 2, 2, 1, 1, 2, 1, 6, 4, 1, 7, 1, 3, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 2, 6, 1, 2, 1, 2, 5, 1, 1, 1, 6, 2, 10, 62, 2, 6, 10, 11, 1, 1, 1, 1, 1, 4, 2, 8, 1, 33, 7, 20, 1, 6, 4, 6, 1, 1, 1, 21, 3, 7, 1, 1, 230, 38, 10, 39, 9, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 5, 41, 1, 1, 1, 1, 1, 11, 1, 1, 1, 1, 1, 3, 2, 3, 1, 5, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 3, 2, 1, 1, 40, 1, 9, 1, 2, 1, 2, 2, 7, 2, 1, 1, 1, 7, 40, 1, 4, 1, 8, 1, 3078, 156, 4, 90, 6, 22, 2, 6, 2, 38, 2, 6, 2, 8, 1, 1, 1, 1, 1, 1, 1, 31, 2, 53, 1, 7, 1, 1, 3, 3, 1, 7, 3, 4, 2, 6, 4, 13, 5, 3, 1, 7, 211, 13, 4, 1, 68, 1, 3, 2, 2, 1, 81, 3, 3714, 1, 1, 1, 25, 9, 6, 1, 5, 11, 84, 4, 2, 2, 2, 2, 90, 1, 3, 6, 40, 7379, 20902, 3162, 11172, 92, 2048, 8190, 2};
    private static final int CHARCNT = 65536;
    private static final byte[] CHARFLAGS = Verifier.buildBitFlags();
    private static final byte MASKXMLCHARACTER = 1;
    private static final byte MASKXMLLETTER = 2;
    private static final byte MASKXMLSTARTCHAR = 4;
    private static final byte MASKXMLNAMECHAR = 8;
    private static final byte MASKXMLDIGIT = 16;
    private static final byte MASKXMLCOMBINING = 32;
    private static final byte MASKURICHAR = 64;
    private static final byte MASKXMLLETTERORDIGIT = 18;

    private static final byte[] buildBitFlags() {
        byte[] ret = new byte[65536];
        int index = 0;
        for (int i = 0; i < VALCONST.length; ++i) {
            byte v = VALCONST[i];
            int l = LENCONST[i];
            while (--l >= 0) {
                ret[index++] = v;
            }
        }
        return ret;
    }

    private Verifier() {
    }

    public static final void checkElementName(String name, Locator loc) {
        if (name.indexOf(":") >= 0) {
            throw new DOMException(5, "Element or attribute names cannot contain colons", loc);
        }
        Verifier.checkXMLName(name, loc);
    }

    public static final void checkAttributeName(String name, Locator loc) {
        if (!name.equals("xml:space") && !name.equals("xml:lang")) {
            Verifier.checkElementName(name, loc);
        }
    }

    protected static final StringBuffer appendAsHex(StringBuffer sb, char c) {
        return sb.append('\'').append(c).append("' (0x").append(Integer.toHexString(c)).append(')');
    }

    public static final void checkCharacterData(String text, Locator loc) {
        if (text == null) {
            throw new DOMException(5, "A null is not a legal XML value", loc);
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            while (CHARFLAGS[text.charAt(i)] != 0) {
                if (++i != len) continue;
                return;
            }
            if (Character.isHighSurrogate(text.charAt(i))) {
                if (++i >= len) {
                    throw new DOMException(5, String.format("Truncated Surrogate Pair 0x%04x????", text.charAt(i - 1)), loc);
                }
                if (Character.isLowSurrogate(text.charAt(i))) {
                    if (Verifier.isXMLCharacter(Verifier.decodeSurrogatePair(text.charAt(i - 1), text.charAt(i)))) continue;
                    throw new DOMException(5, String.format("0x%06x is not a legal XML character", Verifier.decodeSurrogatePair(text.charAt(i - 1), text.charAt(i))), loc);
                }
                throw new DOMException(5, String.format("Illegal Surrogate Pair 0x%04x%04x", text.charAt(i - 1), (int)text.charAt(i)), loc);
            }
            throw new DOMException(5, String.format("0x%04x is not a legal XML character", text.charAt(i)), loc);
        }
    }

    public static int decodeSurrogatePair(char high, char low) {
        return 65536 + (high - 55296) * 1024 + (low - 56320);
    }

    public static final void checkCData(String data, Locator loc) {
        if (data.indexOf("]]>") >= 0) {
            throw new DOMException(5, "']]>' is not allowed inside a CDATA string", loc);
        }
        Verifier.checkCharacterData(data, loc);
    }

    public static final void checkNamespacePrefix(String prefix, Locator loc) {
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        String reason = null;
        char first = prefix.charAt(0);
        if (Verifier.isXMLDigit(first)) {
            reason = "a number";
        } else if (first == '$') {
            reason = "a dollar sign ($)";
        } else if (first == '-') {
            reason = "a hyphen (-)";
        } else if (first == '.') {
            reason = "a period (.)";
        } else {
            String s = prefix.toLowerCase(Locale.ENGLISH);
            if (s.startsWith("xml") && !s.equals("xmlns")) {
                reason = "\"xml\" in any combination of case";
            }
        }
        if (reason != null) {
            throw new DOMException(5, "Namespace prefixes, " + prefix + ", cannot begin with " + reason, loc);
        }
        int len = prefix.length();
        for (int j = 0; j < len; ++j) {
            if (Verifier.isXMLNameCharacter(prefix.charAt(j))) continue;
            StringBuffer sb = new StringBuffer("Namespace prefixes cannot contain ");
            throw new DOMException(5, Verifier.appendAsHex(sb, prefix.charAt(j)).toString(), loc);
        }
        if (prefix.indexOf(":") >= 0) {
            throw new DOMException(5, "Namespace prefixes cannot contain colons", loc);
        }
    }

    public static final void checkNamespaceURI(String uri, Locator loc) {
        if (uri == null || uri.length() == 0) {
            return;
        }
        String reason = null;
        char first = uri.charAt(0);
        if (Character.isDigit(first)) {
            reason = "a number";
        } else if (first == '$') {
            reason = "a dollar sign ($)";
        } else if (first == '-') {
            reason = "a hyphen (-)";
        }
        if (reason != null) {
            throw new DOMException(5, "Namespace URIs cannot begin with " + reason, loc);
        }
    }

    public static final void checkPITarget(String target, Locator loc) {
        if (target.indexOf(":") >= 0) {
            throw new DOMException(5, "Processing instruction targets cannot contain colons", loc);
        }
        if (target.equalsIgnoreCase("xml")) {
            throw new DOMException(5, "Processing instruction targets cannot be \"xml\" in any combination of case", loc);
        }
        Verifier.checkXMLName(target, loc);
    }

    public static final void checkCommentData(String data, Locator loc) {
        if (data.indexOf("--") >= 0) {
            throw new DOMException(5, "Comments cannot contain double hyphens (--)", loc);
        }
        Verifier.checkCharacterData(data, loc);
    }

    public static void checkXMLName(String name, Locator loc) {
        if (name == null || name.length() == 0) {
            throw new DOMException(5, "XML names cannot be null or empty", loc);
        }
        if (!Verifier.isXMLNameStartCharacter(name.charAt(0))) {
            throw new DOMException(5, "XML names cannot begin with '" + name.charAt(0) + '\'', loc);
        }
        int len = name.length();
        for (int j = 0; j < len; ++j) {
            if (Verifier.isXMLNameCharacter(name.charAt(j))) continue;
            throw new DOMException(5, "XML names cannot contain '" + name.charAt(j) + '\'', loc);
        }
    }

    public static boolean isXMLCharacter(int c) {
        if (c >= 65536) {
            return c <= 0x10FFFF;
        }
        return 0 != (byte)(CHARFLAGS[c] & 1);
    }

    public static boolean isXMLNameCharacter(char c) {
        return 0 != (byte)(CHARFLAGS[c] & 8) || c == ':';
    }

    public static boolean isXMLNameStartCharacter(char c) {
        return 0 != (byte)(CHARFLAGS[c] & 4) || c == ':';
    }

    public static boolean isXMLLetterOrDigit(char c) {
        return 0 != (byte)(CHARFLAGS[c] & 0x12);
    }

    public static boolean isXMLLetter(char c) {
        return 0 != (byte)(CHARFLAGS[c] & 2);
    }

    public static boolean isXMLCombiningChar(char c) {
        return 0 != (byte)(CHARFLAGS[c] & 0x20);
    }

    public static boolean isXMLExtender(char c) {
        if (c < '\u00b6') {
            return false;
        }
        if (c == '\u00b7') {
            return true;
        }
        if (c == '\u02d0') {
            return true;
        }
        if (c == '\u02d1') {
            return true;
        }
        if (c == '\u0387') {
            return true;
        }
        if (c == '\u0640') {
            return true;
        }
        if (c == '\u0e46') {
            return true;
        }
        if (c == '\u0ec6') {
            return true;
        }
        if (c == '\u3005') {
            return true;
        }
        if (c < '\u3031') {
            return false;
        }
        if (c <= '\u3035') {
            return true;
        }
        if (c < '\u309d') {
            return false;
        }
        if (c <= '\u309e') {
            return true;
        }
        if (c < '\u30fc') {
            return false;
        }
        return c <= '\u30fe';
    }

    public static boolean isXMLDigit(char c) {
        return 0 != (byte)(CHARFLAGS[c] & 0x10);
    }
}

