
zhtml.Widget = zk.$extends(zk.Widget, {
	rawId: true,
	
	className: 'zhtml.Widget',
	
	widgetName: 'zhtml',

	setDynamicProperty: function (prop) {
		var n = this.$n();
		if (n) {
			var nm = prop[0], val = prop[1];
			switch (nm) {
			case 'checked':
				n.checked = this._defChecked = 'true' == val;
				break;
			case 'value':
				n.value = this._defValue = val;
				break;
			case 'style':
				zk(n).clearStyles().jq.css(jq.parseStyle(val));
				break;
			case 'class':
				n.className = val;
				break;
			case 'disabled':
			case 'readOnly':
				n[nm] = 'true' == val;
				break;
			default:
				n[nm] = val;
			}
		}
	},
	doClick_: function (wevt) {
		var n = this.$n();
		if (n) {
			if (n.tagName != 'INPUT')
				this.$supers('doClick_', arguments);
			else if (!n.disabled) {
				if (n.type == 'checkbox' || n.type == 'radio')
					this._doCheck();
					
				this.fireX(wevt); 
			}
		}
	},
	_doCheck: function () {
		var n = this.$n();
		if (n) {
			var val = n.checked;
			if (val != this._defChecked) { 
				this._defChecked = val;
				this.fire('onCheck', val);
			}
		}
	},
	redraw: zk.Native.$redraw
});
