/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.CollectionsX;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.http.WebManagerActivationListener;
import org.zkoss.zk.ui.impl.ScopeListeners;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.SessionActivationListener;
import org.zkoss.zk.ui.util.SessionSerializationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSession
implements Session,
SessionCtrl {
    private static final Logger log = LoggerFactory.getLogger(SimpleSession.class);
    private static final String ATTR_PRIVATE = "javax.zkoss.ui.session.private";
    private WebApp _wapp;
    private Object _navsess;
    private String _devType = "ajax";
    private Map<String, Object> _attrs;
    private DesktopCache _cache;
    private int _nextUuid;
    private long _tmLastReq = System.currentTimeMillis();
    private final ScopeListeners _scopeListeners = new ScopeListeners(this);
    private boolean _invalid;
    private boolean _invalidated;

    public SimpleSession(WebApp wapp, HttpSession hsess, Object request) {
        this(wapp, (Object)hsess, request);
    }

    public SimpleSession(WebApp wapp, Object navsess, Object request) {
        if (wapp == null || navsess == null) {
            throw new IllegalArgumentException();
        }
        SessionsCtrl.updateCount(true);
        this._wapp = wapp;
        this._navsess = navsess;
        this.cleanSessAttrs();
        this.init();
    }

    private final void init() {
        this._attrs = new AttributesMap(){

            protected Enumeration<String> getKeys() {
                return SimpleSession.this.getAttrNames();
            }

            protected Object getValue(String key) {
                return SimpleSession.this.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                SimpleSession.this.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                SimpleSession.this.removeAttribute(key);
            }
        };
    }

    private final void cleanSessAttrs() {
        Object names = this.getAttribute(ATTR_PRIVATE);
        if (names instanceof Set) {
            Iterator it = ((Set)names).iterator();
            while (it.hasNext()) {
                this.rmAttr((String)it.next());
            }
        }
        this.rmAttr(ATTR_PRIVATE);
    }

    private final Enumeration<String> getAttrNames() {
        return this._navsess instanceof HttpSession ? ((HttpSession)this._navsess).getAttributeNames() : (this._navsess != null ? ((PortletSession)this._navsess).getAttributeNames(1) : CollectionsX.EMPTY_ENUMERATION);
    }

    @Override
    public String getDeviceType() {
        return this._devType;
    }

    @Override
    public void setDeviceType(String deviceType) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._devType = deviceType;
    }

    @Override
    public Object getAttribute(String name) {
        return this._navsess instanceof HttpSession ? ((HttpSession)this._navsess).getAttribute(name) : (this._navsess != null ? ((PortletSession)this._navsess).getAttribute(name, 1) : null);
    }

    @Override
    public Object getAttribute(String name, boolean recurse) {
        Object val = this.getAttribute(name);
        return val != null || !recurse || this._wapp == null ? val : this._wapp.getAttribute(name, true);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    @Override
    public boolean hasAttribute(String name, boolean recurse) {
        return this.hasAttribute(name) || recurse && this._wapp != null && this._wapp.hasAttribute(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(String name, Object value) {
        Object old = this.getAttribute(name);
        if (!(this instanceof Serializable) && !(this instanceof Externalizable)) {
            boolean bStore = value instanceof Serializable || value instanceof Externalizable;
            SimpleSession simpleSession = this;
            synchronized (simpleSession) {
                this.setAttr(name, value);
                HashSet prv = this.getAttribute(ATTR_PRIVATE);
                if (bStore) {
                    if (!(prv instanceof Set)) {
                        prv = new HashSet();
                        this.setAttr(ATTR_PRIVATE, prv);
                    }
                    ((Set)prv).add(name);
                } else if (prv instanceof Set) {
                    ((Set)prv).remove(name);
                }
            }
        } else {
            this.setAttr(name, value);
        }
        return old;
    }

    @Override
    public Object setAttribute(String name, Object value, boolean recurse) {
        if (recurse && !this.hasAttribute(name) && this._wapp != null && this._wapp.hasAttribute(name, true)) {
            return this._wapp.setAttribute(name, value, true);
        }
        return this.setAttribute(name, value);
    }

    @Override
    public Object removeAttribute(String name, boolean recurse) {
        if (recurse && !this.hasAttribute(name)) {
            if (this._wapp != null && this._wapp.hasAttribute(name, true)) {
                return this._wapp.removeAttribute(name, true);
            }
            return null;
        }
        return this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        if (!(this instanceof Serializable) && !(this instanceof Externalizable)) {
            SimpleSession simpleSession = this;
            synchronized (simpleSession) {
                this.rmAttr(name);
                Object prv = this.getAttribute(ATTR_PRIVATE);
                if (prv instanceof Set) {
                    ((Set)prv).remove(name);
                }
            }
        } else {
            this.rmAttr(name);
        }
        return old;
    }

    @Override
    public boolean addScopeListener(ScopeListener listener) {
        return this._scopeListeners.addScopeListener(listener);
    }

    @Override
    public boolean removeScopeListener(ScopeListener listener) {
        return this._scopeListeners.removeScopeListener(listener);
    }

    ScopeListeners getScopeListeners() {
        return this._scopeListeners;
    }

    private void setAttr(String name, Object value) {
        if (this._navsess instanceof HttpSession) {
            ((HttpSession)this._navsess).setAttribute(name, value);
        } else if (this._navsess != null) {
            ((PortletSession)this._navsess).setAttribute(name, value, 1);
        }
    }

    private void rmAttr(String name) {
        if (this._navsess instanceof HttpSession) {
            ((HttpSession)this._navsess).removeAttribute(name);
        } else if (this._navsess != null) {
            ((PortletSession)this._navsess).removeAttribute(name, 1);
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attrs;
    }

    @Override
    public String getRemoteAddr() {
        Execution execution = Executions.getCurrent();
        if (execution != null) {
            return execution.getRemoteAddr();
        }
        return null;
    }

    @Override
    public String getRemoteHost() {
        Execution execution = Executions.getCurrent();
        if (execution != null) {
            return execution.getRemoteHost();
        }
        return null;
    }

    @Override
    public String getServerName() {
        Execution execution = Executions.getCurrent();
        if (execution != null) {
            return execution.getServerName();
        }
        return null;
    }

    @Override
    public String getLocalName() {
        Execution execution = Executions.getCurrent();
        if (execution != null) {
            return execution.getLocalName();
        }
        return null;
    }

    @Override
    public String getLocalAddr() {
        Execution execution = Executions.getCurrent();
        if (execution != null) {
            return execution.getLocalAddr();
        }
        return null;
    }

    @Override
    public void invalidateNow() {
        this._invalid = true;
        if (!this._invalidated) {
            this._invalidated = true;
            this.rmAttr("org.zkoss.zk.ui.renewNativeSession");
            if (this._navsess instanceof HttpSession) {
                ((HttpSession)this._navsess).invalidate();
            } else {
                ((PortletSession)this._navsess).invalidate();
            }
        }
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        if (this._navsess instanceof HttpSession) {
            ((HttpSession)this._navsess).setMaxInactiveInterval(interval);
        } else if (this._navsess != null) {
            ((PortletSession)this._navsess).setMaxInactiveInterval(interval);
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._navsess instanceof HttpSession ? ((HttpSession)this._navsess).getMaxInactiveInterval() : (this._navsess != null ? ((PortletSession)this._navsess).getMaxInactiveInterval() : -1);
    }

    @Override
    public Object getNativeSession() {
        return this._navsess;
    }

    @Override
    public boolean notifyClientRequest(boolean keepAlive) {
        long now = System.currentTimeMillis();
        if (keepAlive) {
            this._tmLastReq = now;
        } else {
            int tmout = this.getMaxInactiveInterval();
            if (tmout >= 0 && (now - this._tmLastReq) / 1000L > (long)tmout) {
                this.invalidate();
                return true;
            }
        }
        return false;
    }

    @Override
    public final WebApp getWebApp() {
        return this._wapp;
    }

    @Override
    public final void invalidate() {
        this._invalid = true;
    }

    @Override
    public final boolean isInvalidated() {
        return this._invalid;
    }

    @Override
    public DesktopCache getDesktopCache() {
        return this._cache;
    }

    @Override
    public void setDesktopCache(DesktopCache cache) {
        this._cache = cache;
    }

    @Override
    public void recover(Object nativeSession) {
        this._invalid = false;
        this._invalidated = false;
        if (this._navsess == null) {
            this.sessionDidActivate((HttpSession)nativeSession);
        } else {
            this._navsess = nativeSession;
        }
    }

    @Override
    public void onDestroyed() {
        SessionsCtrl.updateCount(false);
        this._invalid = true;
        this._invalidated = true;
        Configuration config = this.getWebApp().getConfiguration();
        config.invokeSessionCleanups(this);
        this.cleanSessAttrs();
        Monitor monitor = config.getMonitor();
        if (monitor != null) {
            try {
                monitor.sessionDestroyed(this);
            }
            catch (Throwable ex) {
                log.error("", ex);
            }
        }
        this._navsess = null;
    }

    protected SimpleSession() {
    }

    protected void writeThis(ObjectOutputStream s) throws IOException {
        s.writeObject(this._cache);
        s.writeInt(this._nextUuid);
        Enumeration<String> en = this.getAttrNames();
        while (en.hasMoreElements()) {
            String nm = en.nextElement();
            if ("javax.zkoss.zk.ui.Session".equals(nm)) continue;
            this.willSerialize(this.getAttribute(nm));
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof SessionSerializationListener) {
            ((SessionSerializationListener)o).willSerialize(this);
        }
    }

    protected void readThis(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.init();
        this._cache = (DesktopCache)s.readObject();
        this._nextUuid = s.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionWillPassivate() {
        Object old = SessionsCtrl.getRawCurrent();
        SessionsCtrl.setCurrent(this);
        try {
            ((WebAppCtrl)((Object)this._wapp)).sessionWillPassivate(this);
            Enumeration<String> en = this.getAttrNames();
            while (en.hasMoreElements()) {
                String nm = en.nextElement();
                this.willPassivate(this.getAttribute(nm));
            }
        }
        finally {
            SessionsCtrl.setRawCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionDidActivate(HttpSession hsess) {
        Object old = SessionsCtrl.getRawCurrent();
        SessionsCtrl.setCurrent(this);
        try {
            this._navsess = hsess;
            WebManager.addActivationListener(hsess.getServletContext(), new WebManagerActivationListener(){

                public void didActivate(WebManager webman) {
                    SimpleSession.this._wapp = webman.getWebApp();
                    ((WebAppCtrl)((Object)SimpleSession.this._wapp)).sessionDidActivate(SimpleSession.this);
                }
            });
            Enumeration<String> en = this.getAttrNames();
            while (en.hasMoreElements()) {
                String nm = en.nextElement();
                this.didActivate(this.getAttribute(nm));
            }
        }
        finally {
            SessionsCtrl.setRawCurrent(old);
        }
    }

    private void willPassivate(Object o) {
        if (o instanceof SessionActivationListener) {
            ((SessionActivationListener)o).willPassivate(this);
        }
    }

    private void didActivate(Object o) {
        if (o instanceof SessionActivationListener) {
            ((SessionActivationListener)o).didActivate(this);
        }
    }
}

