/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.File;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.CData;
import org.zkoss.idom.Comment;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.Item;
import org.zkoss.idom.Namespace;
import org.zkoss.idom.ProcessingInstruction;
import org.zkoss.idom.Text;
import org.zkoss.lang.ClassResolver;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.resource.Location;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.xel.Function;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.util.Evaluators;
import org.zkoss.xel.util.MethodFunction;
import org.zkoss.xml.Locators;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.impl.ZScriptInitiator;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.ForwardInfo;
import org.zkoss.zk.ui.metainfo.FunctionMapperInfo;
import org.zkoss.zk.ui.metainfo.HeaderInfo;
import org.zkoss.zk.ui.metainfo.InitiatorInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.NamespaceParser;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.ResponseHeaderInfo;
import org.zkoss.zk.ui.metainfo.ShadowInfo;
import org.zkoss.zk.ui.metainfo.TemplateInfo;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.TreeBuilderFactory;
import org.zkoss.zk.ui.metainfo.VariableResolverInfo;
import org.zkoss.zk.ui.metainfo.VariablesInfo;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.metainfo.ZScriptInfo;
import org.zkoss.zk.ui.metainfo.ZkInfo;
import org.zkoss.zk.ui.metainfo.impl.AnnotationHelper;
import org.zkoss.zk.ui.metainfo.impl.ComponentDefinitionImpl;
import org.zkoss.zk.ui.metainfo.impl.ShadowDefinitionImpl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.ui.util.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    private final WebApp _wapp;
    private final Locator _locator;
    private final List<NamespaceParser> _nsParsers;
    private static Boolean _trimLabel;

    public Parser(WebApp wapp, Locator locator) {
        if (wapp == null) {
            throw new IllegalArgumentException("null");
        }
        this._wapp = wapp;
        this._nsParsers = wapp.getConfiguration().getNamespaceParsers();
        Collections.sort(this._nsParsers, new Comparator<NamespaceParser>(){

            @Override
            public int compare(NamespaceParser o1, NamespaceParser o2) {
                int op2;
                int op1 = o1.getPriority();
                return op1 < (op2 = o2.getPriority()) ? 1 : (op1 > op2 ? -1 : 0);
            }
        });
        this._locator = locator != null ? locator : wapp;
    }

    public PageDefinition parse(File file, String path) throws Exception {
        String extension = Servlets.getExtension((String)file.getName());
        PageDefinition pgdef = this.parse(TreeBuilderFactory.makeBuilder(extension).parse(file), extension);
        pgdef.setRequestPath(path);
        return pgdef;
    }

    public PageDefinition parse(URL url, String path) throws Exception {
        String extension = Servlets.getExtension((String)url.toExternalForm());
        PageDefinition pgdef = this.parse(TreeBuilderFactory.makeBuilder(extension).parse(url), extension);
        pgdef.setRequestPath(path);
        return pgdef;
    }

    public PageDefinition parse(Reader reader, String extension) throws Exception {
        return this.parse(TreeBuilderFactory.makeBuilder(extension).parse(reader), extension);
    }

    public PageDefinition parse(Document doc, String extension) throws Exception {
        LinkedList<ProcessingInstruction> pis = new LinkedList<ProcessingInstruction>();
        LinkedList<String[]> imports = new LinkedList<String[]>();
        LinkedList<String> impclses = new LinkedList<String>();
        String lang = null;
        for (Object o : doc.getChildren()) {
            Map params;
            if (!(o instanceof ProcessingInstruction)) continue;
            ProcessingInstruction pi = (ProcessingInstruction)o;
            String target = pi.getTarget();
            if ("page".equals(target)) {
                params = pi.parseData();
                String l = (String)params.remove("language");
                if (l != null) {
                    Parser.noEL("language", l, (Item)pi);
                    lang = l;
                }
                if (params.isEmpty()) continue;
                pis.add(pi);
                continue;
            }
            if ("import".equals(target)) {
                params = pi.parseData();
                String src = (String)params.remove("src");
                String dirs = (String)params.remove("directives");
                String cls = (String)params.remove("class");
                if (src != null) {
                    Parser.noELnorEmpty("src", src, (Item)pi);
                    Parser.noEL("directives", dirs, (Item)pi);
                    imports.add(new String[]{src, dirs});
                }
                if (cls != null) {
                    Parser.noELnorEmpty("class", cls, (Item)pi);
                    impclses.add(cls);
                }
                for (Map.Entry me : params.entrySet()) {
                    String nm = (String)me.getKey();
                    String val = (String)me.getValue();
                    if (val == null) {
                        Parser.noELnorEmpty(nm, nm, (Item)pi);
                        impclses.add(nm);
                        continue;
                    }
                    log.warn(Parser.message("Ignored unknown attribute for import: " + nm, (Item)pi));
                }
                continue;
            }
            pis.add(pi);
        }
        LanguageDefinition langdef = extension != null && lang == null ? LanguageDefinition.getByExtension(extension) : LanguageDefinition.lookup(lang);
        PageDefinition pgdef = new PageDefinition(langdef, this.getLocator());
        if (!imports.isEmpty()) {
            RequestInfoImpl ri = new RequestInfoImpl(this._wapp, null, null, null, this.getLocator());
            UiFactory uf = ((WebAppCtrl)((Object)this._wapp)).getUiFactory();
            for (String[] imprt : imports) {
                String path = imprt[0];
                String dirs = imprt[1];
                try {
                    PageDefinition pd = uf.getPageDefinition(ri, path);
                    if (pd == null) {
                        throw new UiException("The imported page not found: " + path);
                    }
                    pgdef.imports(pd, Parser.parseToArray(dirs));
                }
                catch (PotentialDeadLockException ex) {
                    throw new UiException("Recursive import not allowed: " + path, (Throwable)ex);
                }
            }
        }
        for (String impcls : impclses) {
            pgdef.addImportedClass(impcls);
        }
        Iterator it = pis.iterator();
        while (it.hasNext()) {
            this.parse(pgdef, (ProcessingInstruction)it.next());
        }
        Element root = doc.getRootElement();
        if (root != null) {
            this.parseItem(pgdef, pgdef, root, new AnnotationHelper(), false, ParsingState.ROOT);
        }
        return pgdef;
    }

    private void parse(PageDefinition pgdef, ProcessingInstruction pi) throws Exception {
        String target = pi.getTarget();
        Map params = pi.parseData();
        if ("page".equals(target)) {
            Parser.parsePageDirective(pgdef, pi, params);
        } else if ("init".equals(target)) {
            this.parseInitDirective(pgdef, pi, params);
        } else if ("variable-resolver".equals(target) || "function-mapper".equals(target)) {
            String clsnm = (String)params.remove("class");
            if (Parser.isEmpty(clsnm)) {
                throw new UiException(Parser.message("The class attribute is required", (Item)pi));
            }
            LinkedHashMap<String, String> args = new LinkedHashMap<String, String>(params);
            if ("variable-resolver".equals(target)) {
                pgdef.addVariableResolverInfo(new VariableResolverInfo(clsnm, args));
            } else {
                pgdef.addFunctionMapperInfo(new FunctionMapperInfo(clsnm, args));
            }
        } else if ("component".equals(target)) {
            this.parseComponentDirective(pgdef, pi, params);
        } else if ("taglib".equals(target)) {
            String uri = (String)params.remove("uri");
            String prefix = (String)params.remove("prefix");
            if (!params.isEmpty()) {
                log.warn(Parser.message("Ignored unknown attributes: " + params.keySet(), (Item)pi));
            }
            if (uri == null || prefix == null) {
                throw new UiException(Parser.message("Both uri and prefix attribute are required", (Item)pi));
            }
            Parser.noEL("prefix", prefix, (Item)pi);
            Parser.noEL("uri", uri, (Item)pi);
            pgdef.addTaglib(new Taglib(prefix, this.toAbsoluteURI(uri, false)));
        } else if ("evaluator".equals(target)) {
            Parser.parseEvaluatorDirective(pgdef, pi, params);
        } else if ("xel-method".equals(target)) {
            Parser.parseXelMethod(pgdef, pi, params);
        } else if ("link".equals(target) || "meta".equals(target) || "script".equals(target) || "style".equals(target)) {
            pgdef.addHeaderInfo(new HeaderInfo(target, params, ConditionImpl.getInstance((String)params.remove("if"), (String)params.remove("unless"))));
        } else if ("header".equals(target)) {
            pgdef.addResponseHeaderInfo(new ResponseHeaderInfo((String)params.remove("name"), (String)params.remove("value"), (String)params.remove("append"), ConditionImpl.getInstance((String)params.remove("if"), (String)params.remove("unless"))));
        } else if ("root-attributes".equals(target)) {
            for (Map.Entry me : pi.parseData().entrySet()) {
                pgdef.setRootAttribute((String)me.getKey(), (String)me.getValue());
            }
        } else if ("forward".equals(target)) {
            String uri = (String)params.remove("uri");
            String ifc = (String)params.remove("if");
            String unless = (String)params.remove("unless");
            if (!params.isEmpty()) {
                log.warn(Parser.message("Ignored unknown attributes: " + params.keySet(), (Item)pi));
            }
            Parser.noEmpty("uri", uri, (Item)pi);
            pgdef.addForwardInfo(new ForwardInfo(uri, ConditionImpl.getInstance(ifc, unless)));
        } else {
            if ("import".equals(target)) {
                throw new UiException(Parser.message("The import directive can be used only at the top level", (Item)pi));
            }
            if ("template".equals(target)) {
                String name = (String)params.remove("name");
                String src = (String)params.remove("src");
                if (name != null && name.length() != 0 && src != null && src.length() != 0) {
                    pgdef.addTemplateInfo(new TemplateInfo(null, name, src, params, null));
                }
            } else {
                log.warn(Parser.message("Unknown processing instruction: " + target, (Item)pi));
            }
        }
    }

    private static String[] parseToArray(String s) {
        if (s == null) {
            return null;
        }
        Collection ims = CollectionsX.parse(null, (String)s, (char)',', (boolean)false);
        return ims.toArray(new String[ims.size()]);
    }

    public Locator getLocator() {
        return this._locator;
    }

    private void parseInitDirective(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        String clsnm = params.remove("class");
        String zsrc = params.remove("zscript");
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>(params);
        if (clsnm == null) {
            URL url;
            if (zsrc == null) {
                throw new UiException(Parser.message("Either the class or zscript attribute must be specified", (Item)pi));
            }
            this.checkZScriptEnabled(pi.getLocator());
            ZScript zs = null;
            String zslang = pgdef.getZScriptLanguage();
            if (zsrc.indexOf("${") < 0 && (url = this.getLocator().getResource(zsrc)) != null) {
                zs = new ZScript(zslang, url);
            }
            if (zs == null) {
                zs = new ZScript(pgdef.getEvaluatorRef(), zslang, zsrc, this.getLocator());
            }
            pgdef.addInitiatorInfo(new InitiatorInfo(new ZScriptInitiator(zs), args));
        } else {
            if (zsrc != null) {
                throw new UiException(Parser.message("You cannot specify both class and zscript", (Item)pi));
            }
            pgdef.addInitiatorInfo(new InitiatorInfo(clsnm, args));
        }
    }

    private static String message(String message, Item el) {
        return Locators.format((String)message, (org.zkoss.xml.Locator)(el != null ? el.getLocator() : null));
    }

    private static String message(String message, org.zkoss.xml.Locator loc) {
        return Locators.format((String)message, (org.zkoss.xml.Locator)loc);
    }

    private static Location location(Item el) {
        return Locators.toLocation((org.zkoss.xml.Locator)(el != null ? el.getLocator() : null));
    }

    private void checkZScriptEnabled(Element el) {
        this.checkZScriptEnabled(el.getLocator());
    }

    private void checkZScriptEnabled(org.zkoss.xml.Locator loc) {
        if (!this._wapp.getConfiguration().isZScriptEnabled()) {
            throw new UiException(Parser.message("zscript is not allowed since <disable-zscript> is configured", loc));
        }
    }

    private static void parsePageDirective(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        for (Map.Entry me : pi.parseData().entrySet()) {
            String nm = (String)me.getKey();
            String val = (String)me.getValue();
            if ("language".equals(nm)) {
                if (pi.getParent() instanceof Document) continue;
                log.warn(Parser.message("Ignored language attribute since the page directive is not at the top level", (Item)pi));
                continue;
            }
            if ("title".equals(nm)) {
                pgdef.setTitle(val);
                continue;
            }
            if ("style".equals(nm)) {
                pgdef.setStyle(val);
                continue;
            }
            if ("viewport".equals(nm)) {
                pgdef.setViewport(val);
                continue;
            }
            if ("id".equals(nm)) {
                pgdef.setId(val);
                continue;
            }
            if ("widgetClass".equals(nm)) {
                pgdef.setWidgetClass(val);
                continue;
            }
            if ("zscriptLanguage".equals(nm) || "zscript-language".equals(nm)) {
                Parser.noELnorEmpty("zscriptLanguage", val, (Item)pi);
                pgdef.setZScriptLanguage(val);
                continue;
            }
            if ("cacheable".equals(nm)) {
                Parser.noELnorEmpty("cacheable", val, (Item)pi);
                pgdef.setCacheable("true".equals(val));
                continue;
            }
            if ("automaticTimeout".equals(nm)) {
                Parser.noELnorEmpty("automaticTimeout", val, (Item)pi);
                pgdef.setAutomaticTimeout("true".equals(val));
                continue;
            }
            if ("contentType".equals(nm)) {
                Parser.noEmpty("contentType", val, (Item)pi);
                pgdef.setContentType(val);
                continue;
            }
            if ("docType".equals(nm)) {
                pgdef.setDocType(Parser.isEmpty(val) ? "" : "<!DOCTYPE " + val + '>');
                continue;
            }
            if ("xml".equals(nm)) {
                Parser.noEmpty("xml", val, (Item)pi);
                pgdef.setFirstLine("<?xml " + val + "?>");
                continue;
            }
            if ("complete".equals(nm)) {
                pgdef.setComplete("true".equals(val));
                continue;
            }
            log.warn(Parser.message("Ignored unknown attribute: " + nm, (Item)pi));
        }
    }

    private void parseComponentDirective(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        String wgtnm;
        ComponentDefinition compdef;
        String name = params.remove("name");
        Parser.noELnorEmpty("name", name, (Item)pi);
        String macroURI = params.remove("macroURI");
        if (macroURI == null) {
            macroURI = params.remove("macro-uri");
        }
        String extds = params.remove("extends");
        String clsnm = params.remove("class");
        String lang = params.remove("language");
        LanguageDefinition langdef = lang != null ? LanguageDefinition.lookup(lang) : pgdef.getLanguageDefinition();
        String templateURI = params.remove("templateURI");
        if (templateURI != null) {
            Parser.noEL("templateURI", templateURI, (Item)pi);
            compdef = langdef.getShadowDefinition(name, pgdef, this.toAbsoluteURI(templateURI, false));
            if (!Parser.isEmpty(clsnm)) {
                Parser.noEL("class", clsnm, (Item)pi);
                compdef.setImplementationClass(clsnm);
            }
        } else if (macroURI != null) {
            String inline = params.remove("inline");
            Parser.noEL("inline", inline, (Item)pi);
            Parser.noEL("macroURI", macroURI, (Item)pi);
            boolean bInline = "true".equals(inline);
            compdef = langdef.getMacroDefinition(name, this.toAbsoluteURI(macroURI, false), bInline, pgdef);
            if (!Parser.isEmpty(clsnm)) {
                if (bInline) {
                    throw new UiException(Parser.message("class not allowed with inline macros", (Item)pi));
                }
                Parser.noEL("class", clsnm, (Item)pi);
                compdef.setImplementationClass(clsnm);
            }
        } else {
            ComponentDefinition ref = null;
            if (extds != null) {
                Parser.noEL("extends", extds, (Item)pi);
                ref = langdef.getComponentDefinition(extds);
            } else {
                try {
                    Class cls = pgdef.getImportedClassResolver().resolveClass(clsnm);
                    if (lang != null) {
                        ref = langdef.getComponentDefinition(cls);
                    } else {
                        ref = pgdef.getComponentDefinition(cls, true);
                        if (ref == null) {
                            ref = Components.getDefinitionByDeviceType(langdef.getDeviceType(), cls);
                        }
                    }
                }
                catch (Throwable cls) {
                    // empty catch block
                }
            }
            if (ref != null) {
                if (ref.isMacro()) {
                    throw new UiException(Parser.message("Unable to extend from a macro component", (Item)pi));
                }
                compdef = ref.clone(null, name);
                if (!Parser.isEmpty(clsnm)) {
                    Parser.noEL("class", clsnm, (Item)pi);
                    compdef.setImplementationClass(clsnm);
                }
            } else {
                Parser.noELnorEmpty("class", clsnm, (Item)pi);
                ComponentDefinitionImpl cdi = new ComponentDefinitionImpl(null, pgdef, name, (Class<? extends Component>)null);
                cdi.setCurrentDirectory(this.getLocator().getDirectory());
                compdef = cdi;
                compdef.setImplementationClass(clsnm);
            }
        }
        if ((wgtnm = params.remove("widgetClass")) == null) {
            wgtnm = params.remove("widget-class");
        }
        if (wgtnm != null) {
            compdef.setDefaultWidgetClass(wgtnm);
        }
        pgdef.addComponentDefinition(compdef);
        String o = params.remove("moldURI");
        if (o == null) {
            o = params.remove("mold-uri");
        }
        if (o != null) {
            throw new UnsupportedOperationException(Parser.message("moldURI not supported in 5.0. Use <?script?> or lang-addon.xml instead", (Item)pi));
        }
        o = params.remove("cssURI");
        if (o != null) {
            throw new UnsupportedOperationException(Parser.message("cssURI not supported in 5.0. Use <?link?> or lang-addon.xml instead", (Item)pi));
        }
        compdef.setApply(params.remove("apply"));
        for (Map.Entry<String, String> me : params.entrySet()) {
            compdef.addProperty(me.getKey(), me.getValue());
        }
    }

    private static void parseEvaluatorDirective(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        String clsnm = params.remove("class");
        if (clsnm != null && clsnm.length() > 0) {
            Parser.noELnorEmpty("class", clsnm, (Item)pi);
            pgdef.setExpressionFactoryClass(pgdef.getImportedClassResolver().resolveClass(clsnm));
        } else {
            String nm = params.remove("name");
            if (nm != null) {
                pgdef.setExpressionFactoryClass(Evaluators.getEvaluatorClass((String)nm));
            }
        }
        String imports = params.remove("import");
        if (imports != null && imports.length() > 0) {
            Collection ims = CollectionsX.parse(null, (String)imports, (char)',', (boolean)false);
            for (String im : ims) {
                int k = im.indexOf(61);
                String nm = k > 0 ? im.substring(0, k).trim() : null;
                String cn = (k >= 0 ? im.substring(k + 1) : im).trim();
                if (cn.length() == 0) continue;
                if (nm == null || nm.length() == 0) {
                    int j = cn.lastIndexOf(46);
                    nm = j >= 0 ? cn.substring(j + 1) : cn;
                }
                pgdef.addExpressionImport(nm, Classes.forNameByThread((String)cn));
            }
        }
    }

    private static void parseXelMethod(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        Method mtd;
        String prefix = params.remove("prefix");
        Parser.noELnorEmpty("prefix", prefix, (Item)pi);
        String nm = params.remove("name");
        Parser.noELnorEmpty("name", nm, (Item)pi);
        String clsnm = params.remove("class");
        Parser.noELnorEmpty("class", clsnm, (Item)pi);
        String sig = params.remove("signature");
        Parser.noELnorEmpty("signature", sig, (Item)pi);
        try {
            ClassResolver clsresolver = pgdef.getImportedClassResolver();
            Class cls = clsresolver.resolveClass(clsnm);
            mtd = Classes.getMethodBySignature((Class)cls, (String)sig, null, (ClassResolver)clsresolver);
        }
        catch (ClassNotFoundException ex) {
            throw new UiException(Parser.message("Class not found: " + clsnm, (Item)pi));
        }
        catch (Exception ex) {
            throw new UiException(Parser.message("Method not found: " + sig + " in " + clsnm, (Item)pi));
        }
        if ((mtd.getModifiers() & 8) == 0) {
            throw new UiException(Parser.message("Not a static method: " + mtd, (Item)pi));
        }
        pgdef.addXelMethod(prefix, nm, (Function)new MethodFunction(mtd));
    }

    private static void noELnorEmpty(String nm, String val, Item item) throws UiException {
        if (Parser.isEmpty(val)) {
            throw new UiException(Parser.message(nm + " cannot be empty", item));
        }
        Parser.noEL(nm, val, item);
    }

    private static void noEL(String nm, String val, Item item) throws UiException {
        if (val != null && val.indexOf("${") >= 0) {
            throw new UiException(Parser.message(nm + " does not support EL expressions", item));
        }
    }

    private static void noEmpty(String nm, String val, Item item) throws UiException {
        if (val != null && val.length() == 0) {
            throw new UiException(Parser.message(nm + " cannot be empty", item));
        }
    }

    private String toAbsoluteURI(String uri, boolean allowEL) {
        String dir;
        char cc;
        if (!(uri == null || uri.length() <= 0 || (cc = uri.charAt(0)) == '/' || cc == '~' || allowEL && uri.indexOf("${") >= 0 || Servlets.isUniversalURL((String)uri) || (dir = this.getLocator().getDirectory()) == null || dir.length() <= 0)) {
            return dir.charAt(dir.length() - 1) == '/' ? dir + uri : dir + '/' + uri;
        }
        return uri;
    }

    private void parseItems(PageDefinition pgdef, NodeInfo parent, Collection items, AnnotationHelper annHelper, boolean bNativeContent) throws Exception {
        LanguageDefinition parentlang = Parser.getLanguageDefinition(parent);
        if (parentlang == null) {
            parentlang = pgdef.getLanguageDefinition();
        }
        boolean bZkSwitch = Parser.isZkSwitch(parent);
        ComponentInfo pi = null;
        String textAs = null;
        StringBuilder textAsBuffer = null;
        for (NodeInfo p = parent; p != null; p = p.getParent()) {
            if (!(p instanceof ComponentInfo)) continue;
            pi = (ComponentInfo)p;
            textAs = pi.getTextAs();
            if (textAs == null || pi != parent) break;
            textAsBuffer = new StringBuilder();
            break;
        }
        boolean isXHTML = "xhtml".equals(parentlang.getName());
        boolean isAllBlankPreserved = !"false".equals(Library.getProperty((String)"preserve-all-blank"));
        boolean breakLine = false;
        NativeInfo preNativeInfo = null;
        for (Object o : items) {
            if (!(o instanceof Element)) continue;
            this.parseItem(pgdef, parent, (Element)o, annHelper, bNativeContent, ParsingState.FIRST);
        }
        for (Object o : items) {
            String label;
            if (o instanceof Element) {
                breakLine = false;
                preNativeInfo = (NativeInfo)this.parseItem(pgdef, parent, (Element)o, annHelper, bNativeContent, ParsingState.SECOND);
                continue;
            }
            if (o instanceof ProcessingInstruction) {
                breakLine = false;
                this.parse(pgdef, (ProcessingInstruction)o);
                continue;
            }
            if (o instanceof Comment) {
                breakLine = false;
                if (!parentlang.isNative() && !isXHTML) continue;
                label = "<!--" + ((Item)o).getText() + "-->";
                ComponentInfo labelInfo = parentlang.newLabelInfo(parent, label);
                labelInfo.addProperty("encode", "false", null);
                continue;
            }
            if (o instanceof Text || o instanceof CData) {
                String trimLabel;
                label = ((Item)o).getText();
                String string = trimLabel = !isXHTML ? label.trim() : label;
                if (breakLine && o instanceof Text && label.trim().isEmpty()) {
                    List<NodeInfo> children = parent.getChildren();
                    String labelAttr = parentlang.getLabelAttribute();
                    for (Property prop : ((ComponentInfo)children.get(children.size() - 1)).getProperties()) {
                        if (!prop.getName().equals(labelAttr)) continue;
                        prop.setRawValue(prop.getRawValue() + trimLabel);
                    }
                    continue;
                }
                if (label.length() == 0) continue;
                if (bZkSwitch) {
                    if (trimLabel.length() == 0) continue;
                    throw new UiException(Parser.message("Only <zk> can be used in <zk switch>", (Item)o));
                }
                if (isXHTML && items.size() <= 1 && trimLabel.trim().length() == 0 || trimLabel.length() == 0 && pi != null && !pi.isBlankPreserved() && !Parser.isNativeText(pi) || label.trim().isEmpty() && !isAllBlankPreserved) continue;
                if (!isXHTML && o instanceof Text && label.trim().isEmpty()) {
                    breakLine = true;
                }
                if (Parser.isNativeText(pi)) {
                    String newLabel = label.trim();
                    if (newLabel.startsWith("<![CDATA[") && newLabel.endsWith("]]>")) {
                        label = newLabel.substring(9, newLabel.length() - 3);
                    }
                    if (parent instanceof ShadowInfo) continue;
                    new TextInfo(parent, trimLabel.length() == 0 ? " " : label);
                    continue;
                }
                if (textAs != null) {
                    if (trimLabel.length() == 0) continue;
                    if (textAsBuffer != null) {
                        textAsBuffer.append(label);
                        continue;
                    }
                    if (parent instanceof TemplateInfo) continue;
                    throw new UnsupportedOperationException(Parser.message("Not allowed in text-as", (Item)((Item)o).getParent()));
                }
                if (parent instanceof ShadowInfo && trimLabel.isEmpty()) continue;
                if (Parser.isTrimLabel() && !parentlang.isRawLabel()) {
                    if (trimLabel.length() == 0) continue;
                    label = trimLabel;
                }
                if (isXHTML && preNativeInfo != null && label.trim().length() == 0) {
                    preNativeInfo.addEpilogChild(new TextInfo(null, label));
                    continue;
                }
                ComponentInfo labelInfo = parentlang.newLabelInfo(parent, label);
                if (trimLabel.length() != 0) continue;
                labelInfo.setReplaceableText(" ");
                continue;
            }
            breakLine = false;
        }
        if (textAsBuffer != null) {
            String trimLabel = textAsBuffer.toString();
            if (pi == null || !pi.isBlankPreserved()) {
                trimLabel = trimLabel.trim();
            }
            if (trimLabel.length() != 0) {
                pi.addProperty(textAs, trimLabel, null);
            }
        }
    }

    static boolean isNativeText(ComponentInfo pi) {
        if (pi instanceof NativeInfo) {
            return true;
        }
        if (pi != null) {
            try {
                Class cls = pi.resolveImplementationClass(null, null);
                return cls != null && Native.class.isAssignableFrom(cls);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isTrimLabel() {
        if (_trimLabel == null) {
            String s = Library.getProperty((String)"org.zkoss.zk.ui.parser.trimLabel");
            _trimLabel = s != null && s.length() > 0;
        }
        return _trimLabel;
    }

    private static final LanguageDefinition getLanguageDefinition(NodeInfo node) {
        while (node != null) {
            if (node instanceof ComponentInfo) {
                LanguageDefinition langdef = ((ComponentInfo)node).getLanguageDefinition();
                if (langdef != null) {
                    return langdef;
                }
            } else {
                if (node instanceof PageDefinition) {
                    return ((PageDefinition)node).getLanguageDefinition();
                }
                if (node instanceof ShadowInfo) {
                    return ((ShadowInfo)node).getLanguageDefinition();
                }
            }
            node = node.getParent();
        }
        return null;
    }

    private Object parseItem(PageDefinition pgdef, NodeInfo parent, Element el, AnnotationHelper annHelper, boolean bNativeContent, ParsingState parsingState) throws Exception {
        String nm = el.getLocalName();
        Namespace ns = el.getNamespace();
        String pref = ns != null ? ns.getPrefix() : "";
        String uri = ns != null ? ns.getURI() : "";
        LanguageDefinition langdef = pgdef.getLanguageDefinition();
        String langName = langdef.getName();
        if ("http://www.zkoss.org/2005/zk/annotation".equals(uri) || "annotation".equals(uri)) {
            throw new UiException(Parser.message("Namespace, " + uri + ", no longer supported element's annotation", (Item)el));
        }
        if (parsingState != ParsingState.SECOND) {
            if ("attribute".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri, bNativeContent)) {
                if (!(parent instanceof ComponentInfo)) {
                    throw new UiException(Parser.message("<attribute> cannot be the root element", (Item)el));
                }
                this.parseAttribute(pgdef, (ComponentInfo)parent, el, annHelper);
            } else if ("template".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri, bNativeContent)) {
                this.parseItems(pgdef, Parser.parseTemplate(parent, el, annHelper), el.getChildren(), annHelper, bNativeContent);
            }
        }
        if (parsingState != ParsingState.FIRST) {
            if ("attribute".equals(nm) || "template".equals(nm)) {
                return null;
            }
            if ("zscript".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
                this.checkZScriptEnabled(el);
                this.parseZScript(parent, el, annHelper);
            } else if ("custom-attributes".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri, bNativeContent)) {
                Parser.parseCustomAttributes(langdef, parent, el, annHelper);
            } else if ("variables".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri, bNativeContent)) {
                Parser.parseVariables(langdef, parent, el, annHelper);
            } else if ("zk".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
                this.parseItems(pgdef, Parser.parseZk(parent, el, annHelper), el.getChildren(), annHelper, bNativeContent);
            } else if (Parser.isShadowElement(langdef, pgdef, nm, pref, uri, bNativeContent)) {
                this.parseItems(pgdef, Parser.parseShadowElement(pgdef, parent, el, annHelper), el.getChildren(), annHelper, bNativeContent);
            } else {
                ComponentInfo compInfo;
                boolean bNative;
                if (Parser.isZkSwitch(parent)) {
                    throw new UiException(Parser.message("Only <zk> can be used in <zk switch>", (Item)el));
                }
                boolean prefRequired = uri.startsWith("native:");
                boolean bl = bNative = bNativeContent || prefRequired || "http://www.zkoss.org/2005/zk/native".equals(uri) || "native".equals(uri);
                if (!bNative && langdef.isNative() && !langdef.getNamespace().equals(uri)) {
                    prefRequired = "".equals(pref) && "".equals(uri) || !LanguageDefinition.exists(uri);
                    bNative = prefRequired;
                }
                if (bNative) {
                    if (annHelper.clear()) {
                        log.warn(Parser.message("Annotations are ignored since native doesn't support them", (Item)el));
                    }
                    NativeInfo ni = new NativeInfo(parent, langdef.getNativeDefinition(), prefRequired && pref.length() > 0 ? pref + ":" + nm : nm);
                    compInfo = ni;
                    Collection dns = el.getDeclaredNamespaces();
                    if (!dns.isEmpty()) {
                        Parser.addDeclaredNamespace(ni, dns, langdef);
                    }
                } else {
                    ComponentDefinition compdef;
                    boolean defaultNS = Parser.isDefaultNS(langdef, pref, uri);
                    LanguageDefinition complangdef = defaultNS ? langdef : LanguageDefinition.lookup(uri);
                    ComponentDefinition componentDefinition = compdef = defaultNS ? pgdef.getComponentDefinitionMap().get(nm) : null;
                    if (compdef != null) {
                        compInfo = new ComponentInfo(parent, compdef, nm);
                    } else if (complangdef.hasComponentDefinition(nm)) {
                        compdef = complangdef.getComponentDefinition(nm);
                        compInfo = new ComponentInfo(parent, compdef, nm);
                        langdef = complangdef;
                    } else {
                        compdef = complangdef.getDynamicTagDefinition();
                        if (compdef == null) {
                            throw new DefinitionNotFoundException(Parser.message("Component definition not found: " + nm + " in " + complangdef, (Item)el));
                        }
                        compInfo = new ComponentInfo(parent, compdef, nm);
                        langdef = complangdef;
                    }
                    String use = el.getAttributeValue("use");
                    if (use != null && (use = use.trim()).length() != 0) {
                        compInfo.setImplementation(use);
                    }
                }
                String ifc = null;
                String unless = null;
                String forEach = null;
                String forEachBegin = null;
                String forEachEnd = null;
                String forEachStep = null;
                AnnotationHelper attrAnnHelper = null;
                boolean isMVVM = false;
                block0: for (Attribute attr : el.getAttributeItems()) {
                    String attvaltrim;
                    String attPref;
                    Namespace attrns = attr.getNamespace();
                    String attURI = attrns != null ? attrns.getURI() : "";
                    String attnm = attr.getLocalName();
                    String attval = attr.getValue();
                    String string = attPref = attrns != null ? attrns.getPrefix() : "";
                    if (Parser.isNativeNamespace(uri) || Parser.isXmlNamespace(uri) || "native".equals(langName) || "xml".equals(langName)) {
                        if (!(Parser.isZkAttr(langdef, attrns) || Parser.isZKNamespace(attURI) || "xmlns".equals(attPref) || "xmlns".equals(attnm) && "".equals(attPref) || "http://www.w3.org/2001/XMLSchema-instance".equals(attURI))) {
                            boolean handled = false;
                            for (NamespaceParser nsParser : this._nsParsers) {
                                if (!nsParser.isMatched(attURI) || !nsParser.parse(attr, compInfo, pgdef)) continue;
                                handled = true;
                                break;
                            }
                            if (handled) continue;
                            compInfo.addProperty(attr.getName(), attval, null);
                            continue;
                        }
                        if (Parser.isClientNamespace(attURI) || Parser.isClientAttrNamespace(attURI)) {
                            compInfo.addProperty(attnm, attval, null);
                            continue;
                        }
                    }
                    if ("apply".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                        compInfo.setApply(attval);
                        continue;
                    }
                    if ("forward".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                        compInfo.setForward(attval);
                        continue;
                    }
                    if ("if".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                        ifc = attval;
                        continue;
                    }
                    if ("unless".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                        unless = attval;
                        continue;
                    }
                    if ("forEach".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                        forEach = attval;
                        continue;
                    }
                    if ("forEachStep".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                        forEachStep = attval;
                        continue;
                    }
                    if ("forEachBegin".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                        forEachBegin = attval;
                        continue;
                    }
                    if ("forEachEnd".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                        forEachEnd = attval;
                        continue;
                    }
                    if ("fulfill".equals(attnm) && Parser.isZkAttr(langdef, attrns, bNativeContent)) {
                        compInfo.setFulfill(attval);
                        continue;
                    }
                    if ("http://www.zkoss.org/2005/zk/annotation".equals(attURI) || "annotation".equals(attURI)) {
                        if (attrAnnHelper == null) {
                            attrAnnHelper = new AnnotationHelper();
                        }
                        Parser.applyAttrAnnot(attrAnnHelper, compInfo, attnm, attval.trim(), true, Parser.location((Item)attr));
                        continue;
                    }
                    if ("use".equals(attnm) && Parser.isZkAttr(langdef, attrns, bNativeContent) || "xmlns".equals(attPref) || "xmlns".equals(attnm) && "".equals(attPref) || "http://www.w3.org/2001/XMLSchema-instance".equals(attURI)) continue;
                    if (!bNativeContent && !bNative && (attURI.length() == 0 || "http://www.zkoss.org/2005/zk".endsWith(attURI)) && AnnotationHelper.isAnnotation(attvaltrim = attval.trim())) {
                        if (attrAnnHelper == null) {
                            attrAnnHelper = new AnnotationHelper();
                        }
                        Parser.applyAttrAnnot(attrAnnHelper, compInfo, attnm, attvaltrim, true, Parser.location((Item)attr));
                        Configuration config = WebApps.getCurrent().getConfiguration();
                        if (config.getBinderInitAttribute().equals(attnm)) {
                            isMVVM = true;
                        }
                        Set<String> binderAnnotations = config.getBinderAnnotations();
                        for (String annot : binderAnnotations) {
                            if (attvaltrim.indexOf(annot) == -1) continue;
                            compInfo.enableBindingAnnotation();
                            continue block0;
                        }
                        continue;
                    }
                    boolean handled = false;
                    for (NamespaceParser nsParser : this._nsParsers) {
                        if (!nsParser.isMatched(attURI) || !nsParser.parse(attr, compInfo, pgdef)) continue;
                        handled = true;
                        break;
                    }
                    if (handled) continue;
                    this.addAttribute(compInfo, attrns, attnm, attval, null, attr.getLocator());
                    if (attrAnnHelper == null) continue;
                    attrAnnHelper.applyAnnotations(compInfo, attnm, true);
                }
                if (isMVVM) {
                    String apply = compInfo.getApply();
                    String bindComposerStr = "org.zkoss.bind.BindComposer";
                    if (apply != null && apply.contains(bindComposerStr) && !apply.contains(",")) {
                        log.warn(Parser.message("If the attribute of viewModel is being used, then \"" + bindComposerStr + "\" will be applied automatically. " + "Notice that if you want to use another Composer, you will need to apply the \"" + bindComposerStr + "\" yourself.", (Item)el));
                    } else if (apply == null || apply.length() == 0) {
                        compInfo.setApply(bindComposerStr);
                    }
                }
                compInfo.setCondition(ConditionImpl.getInstance(ifc, unless));
                compInfo.setForEach(forEach, forEachBegin, forEachEnd, forEachStep);
                annHelper.applyAnnotations(compInfo, null, true);
                if (compInfo.getAnnotationMap() != null && el.getLocator() != null) {
                    compInfo.addAnnotation(null, "ZKLOC", null, Locators.toLocation((org.zkoss.xml.Locator)el.getLocator()));
                }
                List items = el.getChildren();
                String textAs = null;
                if (!(bNativeContent || items.isEmpty() || (textAs = compInfo.getTextAs()) == null || !compInfo.isChildAllowedInTextAs() && this.textAsAllowed(langdef, items, bNativeContent))) {
                    textAs = null;
                }
                if (textAs != null) {
                    this.parseAsProperty(pgdef, compInfo, textAs, items, annHelper, null);
                } else {
                    this.parseItems(pgdef, compInfo, items, annHelper, bNativeContent);
                }
                if (compInfo instanceof NativeInfo && !compInfo.getChildren().isEmpty()) {
                    Parser.optimizeNativeInfos((NativeInfo)compInfo);
                    return compInfo;
                }
            }
        }
        return null;
    }

    private boolean textAsAllowed(LanguageDefinition langdef, Collection<Item> items, boolean bNativeContent) {
        boolean textAsAllowed = true;
        String xmlFound = null;
        String zkElem = null;
        boolean empty = true;
        Iterator<Item> it = items.iterator();
        while (true) {
            if (zkElem != null && xmlFound != null) {
                throw new UnsupportedOperationException(Parser.message("Unable to handle XML fragment, <" + xmlFound + ">, with <" + zkElem + ">. Please use CDATA instead", (Item)(it.hasNext() ? it.next() : items.iterator().next().getParent())));
            }
            if (!it.hasNext()) break;
            Item o = it.next();
            if (empty) {
                boolean bl = empty = (o instanceof Text || o instanceof CData) && o.getText().trim().length() == 0;
            }
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            String n = e.getLocalName();
            if (Parser.isZkElement(langdef, e, bNativeContent) && ("attribute".equals(n) || "custom-attributes".equals(n) || "variables".equals(n) || "template".equals(n) || "zscript".equals(n))) {
                zkElem = n;
                textAsAllowed = false;
                continue;
            }
            xmlFound = n;
        }
        return textAsAllowed && !empty;
    }

    private void parseAsProperty(PageDefinition pgdef, ComponentInfo compInfo, String name, Collection items, AnnotationHelper annHelper, ConditionImpl cond) throws Exception {
        NativeInfo nativeInfo = new NativeInfo(compInfo.getEvaluatorRef(), pgdef.getLanguageDefinition().getNativeDefinition(), "");
        this.parseItems(pgdef, nativeInfo, items, annHelper, true);
        compInfo.addProperty(name, nativeInfo, cond);
    }

    private static void applyAttrAnnot(AnnotationHelper attrAnnHelper, ComponentInfo compInfo, String nm, String val, boolean selfAllowed, Location loc) {
        attrAnnHelper.addByCompoundValue(val.trim(), loc);
        attrAnnHelper.applyAnnotations(compInfo, (String)(selfAllowed && "self".equals(nm) ? null : nm), true);
    }

    private static void applyAttrAnnot(AnnotationHelper attrAnnHelper, ShadowInfo compInfo, String nm, String val, boolean selfAllowed, Location loc) {
        attrAnnHelper.addByCompoundValue(val.trim(), loc);
        attrAnnHelper.applyAnnotations(compInfo, (String)(selfAllowed && "self".equals(nm) ? null : nm), true);
    }

    private static void warnWrongZkAttr(Attribute attr) {
        log.warn(Parser.message("Attribute " + attr.getName() + " ignored in <zk>", (Item)attr));
    }

    private static boolean isZkSwitch(NodeInfo nodeInfo) {
        return nodeInfo instanceof ZkInfo && ((ZkInfo)nodeInfo).withSwitch();
    }

    private void parseZScript(NodeInfo parent, Element el, AnnotationHelper annHelper) {
        String script;
        if (el.getAttributeItem("forEach") != null) {
            throw new UiException(Parser.message("forEach not applicable to <zscript>", (Item)el));
        }
        if (annHelper.clear()) {
            log.warn(Parser.message("Annotations are ignored since <zscript> doesn't support them", (Item)el));
        }
        String ifc = el.getAttributeValue("if");
        String unless = el.getAttributeValue("unless");
        String zsrc = el.getAttributeValue("src");
        boolean deferred = "true".equals(el.getAttributeValue("deferred"));
        String zslang = el.getAttributeValue("language");
        if (zslang == null) {
            zslang = parent.getPageDefinition().getZScriptLanguage();
        } else {
            Parser.noEmpty("language", zslang, (Item)el);
            Parser.noEL("language", zslang, (Item)el);
        }
        ConditionImpl cond = ConditionImpl.getInstance(ifc, unless);
        if (!Parser.isEmpty(zsrc)) {
            URL url;
            ZScriptInfo zs = null;
            if (zsrc.indexOf("${") < 0 && (url = this.getLocator().getResource(zsrc)) != null) {
                zs = new ZScriptInfo(parent, zslang, url, cond);
            }
            if (zs == null) {
                zs = new ZScriptInfo(parent, zslang, zsrc, this.getLocator(), cond);
            }
            if (deferred) {
                zs.setDeferred(true);
            }
        }
        if (!Parser.isEmpty((script = el.getText(false)).trim())) {
            int lno;
            org.zkoss.xml.Locator l = el.getLocator();
            int n = lno = l != null ? l.getLineNumber() : 0;
            if (lno > 1) {
                StringBuilder sb = new StringBuilder(lno);
                while (--lno > 0) {
                    sb.append('\n');
                }
                script = sb.append(script).toString();
            }
            ZScriptInfo zs = new ZScriptInfo(parent, zslang, script, cond);
            if (deferred) {
                zs.setDeferred(true);
            }
        }
    }

    private void parseAttribute(PageDefinition pgdef, ComponentInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        Attribute attr;
        if (el.getAttributeItem("forEach") != null) {
            throw new UiException(Parser.message("forEach not applicable to attribute", (Item)el));
        }
        String elFound = null;
        for (Object o : el.getChildren()) {
            if (!(o instanceof Element)) continue;
            elFound = ((Element)o).getName();
            break;
        }
        if ((attr = el.getAttributeItem(null, "name", 0)) == null) {
            throw new UiException(Parser.message("The name attribute required", (Item)el));
        }
        String attnm = attr.getValue();
        Parser.noEmpty("name", attnm, (Item)el);
        ConditionImpl cond = ConditionImpl.getInstance(el.getAttributeValue("if"), el.getAttributeValue("unless"));
        if (elFound != null) {
            if (Events.isValid(attnm)) {
                throw new UiException(Parser.message("<" + elFound + "> not allowed in an event listener", (Item)el));
            }
            this.parseAsProperty(pgdef, parent, attnm, el.getChildren(), annHelper, cond);
        } else {
            String trim = el.getAttributeValue("trim");
            Parser.noEL("trim", trim, (Item)el);
            String attval = el.getText(trim != null && "true".equals(trim));
            this.addAttribute(parent, attr.getNamespace(), attnm, attval, cond, el.getLocator());
        }
        annHelper.applyAnnotations(parent, attnm, true);
    }

    private static void parseCustomAttributes(LanguageDefinition langdef, NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (parent instanceof PageDefinition) {
            throw new UiException(Parser.message("<custom-attributes> must be used under a component", (Item)el));
        }
        if (annHelper.clear()) {
            log.warn(Parser.message("Annotations are ignored since <custom-attributes> doesn't support them", (Item)el));
        }
        String ifc = null;
        String unless = null;
        String scope = null;
        String composite = null;
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        AnnotationHelper attrAnnHelper = null;
        for (Attribute attr : el.getAttributeItems()) {
            String attvaltrim;
            Namespace attrns = attr.getNamespace();
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                unless = attval;
                continue;
            }
            if ("scope".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                scope = attval;
                continue;
            }
            if ("composite".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                composite = attval;
                continue;
            }
            if ("forEach".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                throw new UiException(Parser.message("forEach not applicable to <custom-attributes>", (Item)el));
            }
            if (parent instanceof ComponentInfo && AnnotationHelper.isAnnotation(attvaltrim = attval.trim())) {
                if (attrAnnHelper == null) {
                    attrAnnHelper = new AnnotationHelper();
                }
                Parser.applyAttrAnnot(attrAnnHelper, (ComponentInfo)parent, attnm, attvaltrim, false, Parser.location((Item)attr));
                continue;
            }
            attrs.put(attnm, attval);
        }
        if (!attrs.isEmpty()) {
            new AttributesInfo(parent, attrs, scope, composite, ConditionImpl.getInstance(ifc, unless));
        }
    }

    private static void parseVariables(LanguageDefinition langdef, NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (annHelper.clear()) {
            log.warn(Parser.message("Annotations are ignored since <variables> doesn't support them", (Item)el));
        }
        String ifc = null;
        String unless = null;
        String composite = null;
        boolean local = false;
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        for (Attribute attr : el.getAttributeItems()) {
            Namespace attrns = attr.getNamespace();
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                unless = attval;
                continue;
            }
            if ("local".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                local = "true".equals(attval);
                continue;
            }
            if ("composite".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                composite = attval;
                continue;
            }
            if ("forEach".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                throw new UiException(Parser.message("forEach not applicable to <variables>", (Item)el));
            }
            vars.put(attnm, attval);
        }
        if (!vars.isEmpty()) {
            new VariablesInfo(parent, vars, local, composite, ConditionImpl.getInstance(ifc, unless));
        }
    }

    private static void parseAnnotation(Element el, AnnotationHelper annHelper) throws Exception {
        if (!el.getElements().isEmpty()) {
            throw new UiException(Parser.message("Child elements are not allowed for the annotations", (Item)el));
        }
        LinkedHashMap<String, String[]> attrs = new LinkedHashMap<String, String[]>();
        for (Attribute attr : el.getAttributeItems()) {
            attrs.put(attr.getLocalName(), AnnotationHelper.parseAttributeValue(attr.getValue().trim(), Parser.location((Item)attr)));
        }
        annHelper.add(el.getLocalName(), attrs, Parser.location((Item)el));
    }

    private static NodeInfo parseShadowElement(PageDefinition pgdef, NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        String rn;
        Node root;
        String ifc = null;
        String unless = null;
        String name = el.getLocalName();
        AnnotationHelper attrAnnHelper = null;
        LanguageDefinition lookup = LanguageDefinition.lookup("xul/html");
        ComponentDefinition shadowDefinition = lookup.hasShadowDefinition(name) ? lookup.getShadowDefinition(name) : pgdef.getComponentDefinitionMap().get(name);
        ShadowInfo compInfo = new ShadowInfo(parent, shadowDefinition, name, ConditionImpl.getInstance(ifc, unless));
        block0: for (Attribute attr : el.getAttributeItems()) {
            String attvaltrim;
            Namespace attrns = attr.getNamespace();
            String attURI = attrns != null ? attrns.getURI() : "";
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm)) {
                unless = attval;
                continue;
            }
            if ("http://www.zkoss.org/2005/zk/annotation".equals(attURI) || "annotation".equals(attURI)) {
                if (attrAnnHelper == null) {
                    attrAnnHelper = new AnnotationHelper();
                }
                Parser.applyAttrAnnot(attrAnnHelper, compInfo, attnm, attval.trim(), false, Parser.location((Item)attr));
                continue;
            }
            String attPref = attrns != null ? attrns.getPrefix() : null;
            if ("xmlns".equals(attPref) || "xmlns".equals(attnm) && "".equals(attPref) || "http://www.w3.org/2001/XMLSchema-instance".equals(attURI)) continue;
            if ((attURI.length() == 0 || "http://www.zkoss.org/2005/zk".endsWith(attURI)) && AnnotationHelper.isAnnotation(attvaltrim = attval.trim())) {
                if (attrAnnHelper == null) {
                    attrAnnHelper = new AnnotationHelper();
                }
                Parser.applyAttrAnnot(attrAnnHelper, compInfo, attnm, attvaltrim, true, Parser.location((Item)attr));
                Set<String> binderAnnotations = WebApps.getCurrent().getConfiguration().getBinderAnnotations();
                for (String annot : binderAnnotations) {
                    if (attvaltrim.indexOf(annot) == -1) continue;
                    compInfo.enableBindingAnnotation();
                    continue block0;
                }
                continue;
            }
            compInfo.addProperty(attnm, attval, null);
            if (attrAnnHelper == null) continue;
            attrAnnHelper.applyAnnotations(compInfo, attnm, true);
        }
        compInfo.setCondition(ConditionImpl.getInstance(ifc, unless));
        annHelper.applyAnnotations(compInfo, null, true);
        for (root = el.getFirstChild(); !(root == null || root instanceof Element || root instanceof Text && !((Text)root).getText().trim().isEmpty()); root = root.getNextSibling()) {
        }
        if (root != null && !"template".equals(rn = root.getLocalName())) {
            for (Node item = root; item != null; item = item.getNextSibling()) {
                if (!"template".equals(item.getLocalName())) continue;
                throw new UiException(Parser.message(rn + " does not support between templates", (Item)root));
            }
            return new TemplateInfo(compInfo, "", null, null, null);
        }
        return compInfo;
    }

    private static TemplateInfo parseTemplate(NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (annHelper.clear()) {
            log.warn(Parser.message("Annotations are ignored since <template> doesn't support them", (Item)el));
        }
        if (el.getAttributeItem("forEach") != null) {
            log.warn(Parser.message("forEach is ignored since <template> doesn't support it", (Item)el));
        }
        String ifc = null;
        String unless = null;
        String name = null;
        String src = null;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Attribute attr : el.getAttributeItems()) {
            String attPref;
            Namespace attrns = attr.getNamespace();
            String attURI = attrns != null ? attrns.getURI() : "";
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("name".equals(attnm)) {
                name = attval;
                continue;
            }
            if ("src".equals(attnm)) {
                src = attval;
                continue;
            }
            if ("if".equals(attnm)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm)) {
                unless = attval;
                continue;
            }
            String string = attPref = attrns != null ? attrns.getPrefix() : null;
            if ("xmlns".equals(attnm) || "xml".equals(attnm) || attURI.indexOf("w3.org") >= 0 || attPref != null && ("xmlns".equals(attPref) || "xml".equals(attPref))) continue;
            params.put(attnm, attval);
        }
        if (name == null) {
            name = "";
        }
        return new TemplateInfo(parent, name, src, params, ConditionImpl.getInstance(ifc, unless));
    }

    private static ZkInfo parseZk(NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (annHelper.clear()) {
            log.warn(Parser.message("Annotations are ignored since <zk> doesn't support them", (Item)el));
        }
        ZkInfo zi = new ZkInfo(parent, null);
        String ifc = null;
        String unless = null;
        String forEach = null;
        String forEachBegin = null;
        String forEachEnd = null;
        String forEachStep = null;
        for (Attribute attr : el.getAttributeItems()) {
            String attPref;
            Namespace attrns = attr.getNamespace();
            String attURI = attrns != null ? attrns.getURI() : "";
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm) || "when".equals(attnm)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm)) {
                unless = attval;
                continue;
            }
            if ("forEach".equals(attnm)) {
                forEach = attval;
                continue;
            }
            if ("forEachStep".equals(attnm)) {
                forEachStep = attval;
                continue;
            }
            if ("forEachBegin".equals(attnm)) {
                forEachBegin = attval;
                continue;
            }
            if ("forEachEnd".equals(attnm)) {
                forEachEnd = attval;
                continue;
            }
            if ("switch".equals(attnm) || "choose".equals(attnm)) {
                if (Parser.isZkSwitch(parent)) {
                    throw new UiException(Parser.message("<zk " + attnm + "> cannot be used in <zk switch/choose>", (Item)el));
                }
                zi.setSwitch(attval);
                continue;
            }
            if ("case".equals(attnm)) {
                if (!Parser.isZkSwitch(parent)) {
                    throw new UiException(Parser.message("<zk case> can be used only in <zk switch>", (Item)attr));
                }
                zi.setCase(attval);
                continue;
            }
            String string = attPref = attrns != null ? attrns.getPrefix() : null;
            if ("xmlns".equals(attnm) || "xml".equals(attnm) || attURI.indexOf("w3.org") >= 0 || attPref != null && ("xmlns".equals(attPref) || "xml".equals(attPref))) continue;
            Parser.warnWrongZkAttr(attr);
        }
        zi.setCondition(ConditionImpl.getInstance(ifc, unless));
        zi.setForEach(forEach, forEachBegin, forEachEnd, forEachStep);
        return zi;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static final boolean isDefaultNS(LanguageDefinition langdef, String pref, String uri) {
        return !langdef.isNative() && "".equals(pref) && "".equals(uri) || langdef.getNamespace().equals(uri);
    }

    private static final boolean isShadowElement(LanguageDefinition langdef, PageDefinition pgdef, String nm, String pref, String uri, boolean bNativeContent) {
        if ("true".equalsIgnoreCase(Library.getProperty((String)"org.zkoss.zk.namespace.tolerant", (String)"false"))) {
            return langdef.hasShadowDefinition(nm) || !"xul/html".equals(langdef.getName()) && LanguageDefinition.lookup("xul/html").hasShadowDefinition(nm);
        }
        ComponentDefinition componentDefinition = pgdef.getComponentDefinitionMap().get(nm);
        if (componentDefinition instanceof ShadowDefinitionImpl || "http://www.zkoss.org/2015/zk/shadow".equals(uri) || "shadow".equals(uri)) {
            return true;
        }
        if (Parser.isDefaultNS(langdef, pref, uri)) {
            return !bNativeContent && langdef.hasShadowDefinition(nm);
        }
        return false;
    }

    private static final boolean isZkElement(LanguageDefinition langdef, String nm, String pref, String uri, boolean bNativeContent) {
        if ("true".equalsIgnoreCase(Library.getProperty((String)"org.zkoss.zk.namespace.tolerant", (String)"false"))) {
            return true;
        }
        if (Parser.isDefaultNS(langdef, pref, uri)) {
            return !bNativeContent && !langdef.hasComponentDefinition(nm);
        }
        return "http://www.zkoss.org/2005/zk".equals(uri) || "zk".equals(uri);
    }

    private static final boolean isZkElement(LanguageDefinition langdef, Element el, boolean bNativeContent) {
        Namespace ns = el.getNamespace();
        return Parser.isZkElement(langdef, el.getLocalName(), ns != null ? ns.getPrefix() : "", ns != null ? ns.getURI() : "", bNativeContent);
    }

    private static final boolean isZkElement(LanguageDefinition langdef, String nm, String pref, String uri) {
        return Parser.isZkElement(langdef, nm, pref, uri, false);
    }

    private static final boolean isZkAttr(LanguageDefinition langdef, Namespace attrns, boolean bNativeContent) {
        if ((bNativeContent || langdef.isNative()) && attrns != null && "".equals(attrns.getPrefix())) {
            return false;
        }
        return Parser.isZkElementAttr(langdef, attrns);
    }

    private static final boolean isZkAttr(LanguageDefinition langdef, Namespace attrns) {
        return Parser.isZkAttr(langdef, attrns, false);
    }

    private static final boolean isZkElementAttr(LanguageDefinition langdef, Namespace attrns) {
        if (attrns == null || "".equals(attrns.getPrefix())) {
            return true;
        }
        String uri = attrns.getURI();
        return "http://www.zkoss.org/2005/zk".equals(uri) || "zk".equals(uri) || langdef.getNamespace().equals(uri);
    }

    private void addAttribute(ComponentInfo compInfo, Namespace attrns, String name, String value, ConditionImpl cond, org.zkoss.xml.Locator xl) throws Exception {
        if (Events.isValid(name)) {
            boolean bZkAttr;
            boolean bl = bZkAttr = attrns == null;
            if (!bZkAttr) {
                String uri = attrns.getURI();
                if ("http://www.zkoss.org/2005/zk/client".equals(uri) || "client".equals(uri)) {
                    compInfo.addWidgetListener(name, value, cond);
                    return;
                }
                if ("http://www.zkoss.org/2005/zk/client/attribute".equals(uri) || "client/attribute".equals(uri)) {
                    compInfo.addWidgetAttribute(name, value, cond);
                    return;
                }
                String pref = attrns.getPrefix();
                LanguageDefinition langdef = compInfo.getLanguageDefinition();
                ComponentDefinition compdef = compInfo.getComponentDefinition();
                if (langdef == null) {
                    bZkAttr = true;
                } else if (Parser.isDefaultNS(langdef, pref, uri) && !compdef.isNative()) {
                    bZkAttr = !langdef.isDynamicReservedAttributes("[event]");
                } else {
                    boolean bl2 = bZkAttr = "http://www.zkoss.org/2005/zk".equals(uri) || "zk".equals(uri);
                }
            }
            if (bZkAttr) {
                this.checkZScriptEnabled(xl);
                int lno = xl != null ? xl.getLineNumber() : 0;
                ZScript zscript = ZScript.parseContent(value, lno);
                if (zscript.getLanguage() == null) {
                    zscript.setLanguage(compInfo.getPageDefinition().getZScriptLanguage());
                }
                compInfo.addEventHandler(name, zscript, cond);
                return;
            }
        } else {
            String uri = attrns.getURI();
            if ("http://www.zkoss.org/2005/zk/client".equals(uri) || "client".equals(uri)) {
                if (name.length() == 0) {
                    throw new UiException(Parser.message("Client attribute name required", xl));
                }
                if ("use".equals(name)) {
                    if (cond != null) {
                        throw new UnsupportedOperationException(Parser.message("if and unless not allowed for w:use", xl));
                    }
                    compInfo.setWidgetClass(value);
                } else {
                    compInfo.addWidgetOverride(name, value, cond);
                }
                return;
            }
            if ("http://www.zkoss.org/2005/zk/client/attribute".equals(uri) || "client/attribute".equals(uri)) {
                compInfo.addWidgetAttribute(name, value, cond);
                return;
            }
        }
        compInfo.addProperty(name, value, cond);
    }

    private static void addDeclaredNamespace(NativeInfo nativeInfo, Collection<Namespace> namespaces, LanguageDefinition langdef) {
        for (Namespace ns : namespaces) {
            String uri = ns.getURI();
            boolean bNatPrefix = uri.startsWith("native:");
            if (!bNatPrefix && (Parser.isZKNamespace(uri) || langdef.getNamespace().equals(uri))) continue;
            nativeInfo.addDeclaredNamespace(new Namespace(ns.getPrefix(), bNatPrefix ? uri.substring("native:".length()) : uri));
        }
    }

    private static void optimizeNativeInfos(NativeInfo compInfo) {
        NativeInfo childInfo;
        Object o;
        Iterator it;
        int sz;
        Iterator it2 = compInfo.getChildren().iterator();
        while (it2.hasNext()) {
            NodeInfo o2 = (NodeInfo)it2.next();
            if (o2 instanceof NativeInfo) {
                NativeInfo childInfo2 = (NativeInfo)o2;
                if (!childInfo2.getChildren().isEmpty()) break;
                childInfo2.setParentDirectly(null);
                AnnotationMap annotationMap = childInfo2.getAnnotationMap();
                if (annotationMap != null) {
                    for (String propName : annotationMap.getAnnotatedProperties()) {
                        for (Annotation anno : annotationMap.getAnnotations(propName)) {
                            compInfo.addAnnotation(propName, anno.getName(), anno.getAttributes(), anno.getLocation());
                        }
                    }
                }
            } else if (o2 instanceof ComponentInfo || o2 instanceof ShadowInfo) break;
            compInfo.addPrologChild(o2);
            it2.remove();
        }
        if ((sz = compInfo.getChildren().size()) >= 0) {
            it = compInfo.getChildren().listIterator(sz);
            while (it.hasPrevious()) {
                o = it.previous();
                if (o instanceof NativeInfo) {
                    childInfo = (NativeInfo)o;
                    if (!childInfo.getChildren().isEmpty()) {
                        it.next();
                        break;
                    }
                    childInfo.setParentDirectly(null);
                    continue;
                }
                if (!(o instanceof ComponentInfo) && !(o instanceof ShadowInfo)) continue;
                it.next();
                break;
            }
            while (it.hasNext()) {
                o = (NodeInfo)it.next();
                compInfo.addEpilogChild((NodeInfo)o);
                it.remove();
            }
        }
        if (compInfo.getChildren().size() == 1 && compInfo.getSplitChild() == null && (o = (it = compInfo.getChildren().iterator()).next()) instanceof NativeInfo && !(childInfo = (NativeInfo)o).withForEach() && !childInfo.withCondition()) {
            childInfo.setParentDirectly(null);
            compInfo.setSplitChild(childInfo);
            it.remove();
            it = new ArrayList(childInfo.getChildren()).iterator();
            while (it.hasNext()) {
                compInfo.appendChild((NodeInfo)it.next());
            }
        }
    }

    private static LanguageDefinition langdefLookup(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        try {
            return LanguageDefinition.lookup(name);
        }
        catch (DefinitionNotFoundException e) {
            return null;
        }
    }

    private static boolean isZKNamespace(String uri) {
        return "http://www.zkoss.org/2005/zk".equals(uri) || "zk".equals(uri) || "http://www.zkoss.org/2005/zk/native".equals(uri) || "native".equals(uri) || "annotation".equals(uri) || "http://www.zkoss.org/2005/zk/annotation".equals(uri) || "client".equals(uri) || "http://www.zkoss.org/2005/zk/client".equals(uri) || "client/attribute".equals(uri) || "http://www.zkoss.org/2005/zk/client/attribute".equals(uri) || "xhtml".equals(uri) || "http://www.w3.org/1999/xhtml/".equals(uri) || "zul".equals(uri) || "http://www.zkoss.org/2005/zul/".equals(uri) || "xml".equals(uri) || "http://www.zkoss.org/2007/xml".equals(uri) || Parser.langdefLookup(uri) != null;
    }

    private static boolean isNativeNamespace(String uri) {
        return "native".equals(uri) || "http://www.zkoss.org/2005/zk/native".equals(uri);
    }

    private static boolean isXmlNamespace(String uri) {
        return "xml".equals(uri) || "http://www.zkoss.org/2007/xml".equals(uri);
    }

    private static boolean isClientNamespace(String uri) {
        return "client".equals(uri) || "http://www.zkoss.org/2005/zk/client".equals(uri);
    }

    private static boolean isClientAttrNamespace(String uri) {
        return "client/attribute".equals(uri) || "http://www.zkoss.org/2005/zk/client/attribute".equals(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParsingState {
        ROOT,
        FIRST,
        SECOND;

    }
}

