/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AbstractForEachStatus;
import org.zkoss.bind.impl.AbstractRenderer;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.IndirectBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.PropertyNotWritableException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;

public class BindChildRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;

    public BindChildRenderer() {
        this.setAttributeName("$CHILDREN$");
    }

    public void render(Component owner, Object data, int index, int size) {
        this.render(owner, data, index, size, false);
    }

    public void render(final Component owner, final Object data, int index, int size, boolean isListModel) {
        Template tm = this.resolveTemplate(owner, owner, data, index, size, "children");
        if (tm == null) {
            Label l = new Label(data == null ? "" : data.toString());
            l.setParent(owner);
            this.addChildrenBindingRenderedComps(owner, new Component[]{l}, index);
            return;
        }
        ChildrenBindingForEachStatus iterStatus = new ChildrenBindingForEachStatus(index, data, size);
        String var = (String)tm.getParameters().get("var");
        String varnm = var == null ? "each" : var;
        String itervar = (String)tm.getParameters().get("status");
        String itervarnm = itervar == null ? (var == null ? "forEachStatus" : varnm + "Status") : itervar;
        Object oldVar = owner.getAttribute(varnm);
        Object oldIter = owner.getAttribute(itervarnm);
        owner.setAttribute(varnm, data);
        owner.setAttribute(itervarnm, (Object)iterStatus);
        Component insertBefore = null;
        List cbrCompsList = (List)owner.getAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
        if (cbrCompsList != null) {
            int newIndex = 0;
            int steps = 0;
            for (Component[] cmps : cbrCompsList) {
                if (steps++ >= index) break;
                newIndex += cmps.length;
            }
            if (owner.getChildren().size() > newIndex) {
                insertBefore = (Component)owner.getChildren().get(newIndex);
            }
        }
        Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create(owner, insertBefore, null, null));
        if (oldVar != null) {
            owner.setAttribute(varnm, oldVar);
        } else {
            owner.removeAttribute(varnm);
        }
        if (oldIter != null) {
            owner.setAttribute(itervarnm, oldIter);
        } else {
            owner.removeAttribute(itervarnm);
        }
        boolean templateTracked = false;
        if (isListModel) {
            this.addChildrenBindingRenderedComps(owner, items, index);
        } else {
            this.recordRenderedIndex(owner, items.length);
        }
        for (final Component comp : items) {
            comp.setAttribute("$VAR$", (Object)varnm);
            comp.setAttribute("$isTemplateModelEnabled$", (Object)true);
            comp.setAttribute("$currentIndexResolver$", (Object)new IndirectBinding(data){

                public Binder getBinder() {
                    return BinderUtil.getBinder(comp, true);
                }

                public Component getComponent() {
                    return comp;
                }

                protected ListModel getModel() {
                    return null;
                }

                public void setValue(BindELContext ctx, Object value) {
                    Collection collection = (Collection)owner.getAttribute(BindELContext.getModelName(owner));
                    if (collection instanceof List) {
                        List list = (List)collection;
                        int index = list.indexOf(data);
                        try {
                            list.set(index, value);
                            this.setData(value);
                        }
                        catch (UnsupportedOperationException e) {
                            throw new PropertyNotWritableException((Throwable)e);
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new PropertyNotFoundException((Throwable)e);
                        }
                    }
                }
            });
            this.addItemReference(owner, comp, index, varnm);
            comp.setAttribute(itervarnm, (Object)iterStatus);
            if (!templateTracked) {
                Object obj = owner.removeAttribute("$TemplateVar$");
                if (obj != null) {
                    comp.setAttribute("$TemplateVar$", obj);
                } else {
                    comp.removeAttribute("$TemplateVar$");
                }
                this.addTemplateTracking(owner, comp, data, index, size);
                templateTracked = true;
            }
            Events.sendEvent((Event)new Event("onBindInit", comp));
        }
    }

    protected void recordRenderedIndex(Component owner, int itemSize) {
        List indexList = (List)owner.getAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
        if (indexList == null) {
            super.recordRenderedIndex(owner, itemSize);
        }
    }

    protected int getRenderedIndex(Component owner, int childIndex) {
        List indexList = (List)owner.getAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
        if (indexList == null) {
            return super.getRenderedIndex(owner, childIndex);
        }
        if (childIndex == 0) {
            return 0;
        }
        if (indexList != null) {
            Component[] list;
            int index = 0;
            int currentIndex = 0;
            Iterator i$ = indexList.iterator();
            while (i$.hasNext() && (currentIndex += (list = (Component[])i$.next()).length) <= childIndex) {
                ++index;
            }
            return index;
        }
        return childIndex;
    }

    private void addChildrenBindingRenderedComps(Component owner, Component[] items, int index) {
        LinkedList<Component[]> cbrCompsList = (LinkedList<Component[]>)owner.getAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
        if (cbrCompsList == null) {
            cbrCompsList = new LinkedList<Component[]>();
        }
        cbrCompsList.add(index, items);
        owner.setAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$", cbrCompsList);
    }

    private class ChildrenBindingForEachStatus
    extends AbstractForEachStatus {
        private static final long serialVersionUID = 1L;
        private int index;
        private transient Object data;
        private Integer size;

        public ChildrenBindingForEachStatus(int index, Object data, Integer size) {
            this.index = index;
            this.data = data;
            this.size = size;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getCurrent() {
            return this.data;
        }

        public Integer getEnd() {
            return this.size;
        }
    }
}

