/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;

public class MouseEvent
extends Event {
    private final int _x;
    private final int _y;
    private final int _pgx;
    private final int _pgy;
    private final String _area;
    private final int _keys;
    private Component _areacomp;
    public static final int ALT_KEY = 1;
    public static final int CTRL_KEY = 2;
    public static final int SHIFT_KEY = 4;
    public static final int META_KEY = 8;
    public static final int LEFT_CLICK = 256;
    public static final int RIGHT_CLICK = 512;
    public static final int MIDDLE_CLICK = 1024;

    public static MouseEvent getMouseEvent(AuRequest request) {
        Map<String, Object> data = request.getData();
        String name = request.getCommand();
        int keys = AuRequests.parseKeys(data);
        String area = (String)data.get("area");
        return area != null ? new MouseEvent(name, request.getComponent(), area, keys) : new MouseEvent(name, request.getComponent(), AuRequests.getInt(data, "x", 0, true), AuRequests.getInt(data, "y", 0, true), AuRequests.getInt(data, "pageX", 0, true), AuRequests.getInt(data, "pageY", 0, true), keys);
    }

    public MouseEvent(String name, Component target) {
        super(name, target);
        this._area = null;
        this._keys = 0;
        this._pgy = 0;
        this._pgx = 0;
        this._y = 0;
        this._x = 0;
    }

    public MouseEvent(String name, Component target, int x, int y, int pageX, int pageY) {
        this(name, target, x, y, pageX, pageY, 0);
    }

    public MouseEvent(String name, Component target, int x, int y, int pageX, int pageY, int keys) {
        super(name, target);
        this._x = x;
        this._y = y;
        this._pgx = pageX;
        this._pgy = pageY;
        this._area = null;
        this._keys = keys;
    }

    public MouseEvent(String name, Component target, String area, int keys) {
        super(name, target);
        this._area = area;
        this._pgy = 0;
        this._pgx = 0;
        this._y = 0;
        this._x = 0;
        this._keys = keys;
    }

    public String getArea() {
        return this._area;
    }

    public Component getAreaComponent() {
        if (this._areacomp == null && this._area != null) {
            Execution exec;
            Component target = this.getTarget();
            Desktop desktop = null;
            if (target != null) {
                this._areacomp = target.getFellowIfAny(this._area);
                if (this._areacomp != null) {
                    return this._areacomp;
                }
                desktop = target.getDesktop();
            }
            if (desktop == null && (exec = Executions.getCurrent()) != null) {
                desktop = exec.getDesktop();
            }
            if (desktop != null) {
                this._areacomp = desktop.getComponentByUuidIfAny(this._area);
                return this._areacomp;
            }
        }
        return this._areacomp;
    }

    public final int getX() {
        return this._x;
    }

    public final int getY() {
        return this._y;
    }

    public final int getPageX() {
        return this._pgx;
    }

    public final int getPageY() {
        return this._pgy;
    }

    public final int getKeys() {
        return this._keys;
    }
}

