/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import org.zkoss.fsm.StateCtx;
import org.zkoss.fsm.StateMachine;
import org.zkoss.zk.ui.select.impl.Attribute;
import org.zkoss.zk.ui.select.impl.ParseException;
import org.zkoss.zk.ui.select.impl.Selector;
import org.zkoss.zk.ui.select.impl.SimpleSelectorSequence;
import org.zkoss.zk.ui.select.impl.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InSeqMachine
extends StateMachine<SubState, Token.Type, Token> {
    private Selector _selector;
    private String _source;
    private SimpleSelectorSequence _seq;

    InSeqMachine() {
    }

    public InSeqMachine setSource(String source) {
        this._source = source;
        return this;
    }

    public InSeqMachine setSelector(Selector selector) {
        this._selector = selector;
        return this;
    }

    protected Token.Type getClass(Token input) {
        return input.getType();
    }

    protected SubState getLandingState(Token input, Token.Type inputClass) {
        switch (inputClass) {
            case IDENTIFIER: 
            case UNIVERSAL: {
                return SubState.MAIN;
            }
            case NTN_ID: {
                return SubState.ID_PRE_VALUE;
            }
            case NTN_CLASS: {
                return SubState.CLASS_PRE_VALUE;
            }
            case NTN_PSDOCLS: {
                return SubState.PSDOCLS_PRE_NAME;
            }
            case NTN_PSDOELEM: {
                return SubState.PSDOELEM_PRE_NAME;
            }
            case OPEN_BRACKET: {
                return SubState.ATTR_PRE_NAME;
            }
        }
        return null;
    }

    protected void init() {
        this.setState((Object)SubState.PSDOCLS_PRE_PARAM, (StateCtx)new StateCtx<SubState, Token.Type, Token>(){

            protected void onLeave(Token input, Token.Type inputClass, SubState dest) {
                InSeqMachine.this._seq.attachPseudoClassParameter(input.source(InSeqMachine.this._source));
            }
        });
        this.getState((Object)SubState.MAIN).addRoute((Object)Token.Type.NTN_ID, (Object)SubState.ID_PRE_VALUE).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.MAIN, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                if (InSeqMachine.this._seq.getId() != null) {
                    throw new ParseException("Illegal selector syntax: cannot have more than 1 ID, failed at index " + input.getBeginIndex());
                }
                InSeqMachine.this._seq.setId(input.source(InSeqMachine.this._source));
            }
        });
        this.getState((Object)SubState.MAIN).addRoute((Object)Token.Type.NTN_CLASS, (Object)SubState.CLASS_PRE_VALUE).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.MAIN, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.addClass(input.source(InSeqMachine.this._source));
            }
        });
        this.getState((Object)SubState.MAIN).addRoute((Object)Token.Type.NTN_PSDOCLS, (Object)SubState.PSDOCLS_PRE_NAME).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.PSDOCLS_POST_NAME, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.addPseudoClass(input.source(InSeqMachine.this._source));
            }
        }).addRoute((Object)Token.Type.OPEN_PAREN, (Object)SubState.PSDOCLS_PRE_PARAM).addReturningClasses((Object[])new Token.Type[]{Token.Type.MINOR_WHITESPACE}).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.PSDOCLS_POST_PARAM).addReturningClasses((Object[])new Token.Type[]{Token.Type.MINOR_WHITESPACE}).addTransition((Object)Token.Type.PARAM_SEPARATOR, (Object)SubState.PSDOCLS_PRE_PARAM).addRoute((Object)Token.Type.CLOSE_PAREN, (Object)SubState.MAIN);
        this.getState((Object)SubState.PSDOCLS_POST_NAME).addTransition((Object)Token.Type.NTN_ID, (Object)SubState.ID_PRE_VALUE).addTransition((Object)Token.Type.NTN_CLASS, (Object)SubState.CLASS_PRE_VALUE).addTransition((Object)Token.Type.NTN_PSDOCLS, (Object)SubState.PSDOCLS_PRE_NAME).addTransition((Object)Token.Type.NTN_PSDOELEM, (Object)SubState.PSDOELEM_PRE_NAME).addTransition((Object)Token.Type.OPEN_BRACKET, (Object)SubState.ATTR_PRE_NAME);
        this.getState((Object)SubState.MAIN).addRoute((Object)Token.Type.NTN_PSDOELEM, (Object)SubState.PSDOELEM_PRE_NAME).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.MAIN, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.addPseudoElement(input.source(InSeqMachine.this._source));
            }
        });
        this.getState((Object)SubState.MAIN).addRoute((Object)Token.Type.OPEN_BRACKET, (Object)SubState.ATTR_PRE_NAME).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.ATTR_POST_NAME, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.addAttribute(input.source(InSeqMachine.this._source));
            }
        }).addRoutes((Object)SubState.ATTR_PRE_VALUE, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.attachAttributeOperator(InSeqMachine.this.getOperator(inputClass));
            }
        }, (Object[])new Token.Type[]{Token.Type.OP_EQUAL, Token.Type.OP_BEGIN_WITH, Token.Type.OP_END_WITH, Token.Type.OP_CONTAIN}).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.ATTR_POST_VALUE, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.attachAttributeValue(input.source(InSeqMachine.this._source));
            }
        }).addRoute((Object)Token.Type.CLOSE_BRACKET, (Object)SubState.MAIN);
        this.getState((Object)SubState.ATTR_PRE_VALUE).addRoute((Object)Token.Type.DOUBLE_QUOTE, (Object)SubState.ATTR_PRE_VALUE_INDQT).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.ATTR_POST_VALUE_INDQT, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.attachAttributeValue(input.source(InSeqMachine.this._source), true);
            }
        }).addRoute((Object)Token.Type.DOUBLE_QUOTE, (Object)SubState.ATTR_POST_VALUE);
        this.getState((Object)SubState.ATTR_PRE_VALUE).addRoute((Object)Token.Type.SINGLE_QUOTE, (Object)SubState.ATTR_PRE_VALUE_INSQT).addRoute((Object)Token.Type.IDENTIFIER, (Object)SubState.ATTR_POST_VALUE_INSQT, (StateCtx.TransitionListener)new StateCtx.TransitionListener<Token, Token.Type>(){

            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.attachAttributeValue(input.source(InSeqMachine.this._source), true);
            }
        }).addRoute((Object)Token.Type.SINGLE_QUOTE, (Object)SubState.ATTR_POST_VALUE);
    }

    protected void onStart(Token input, Token.Type inputClass, SubState landing) {
        this._seq = new SimpleSelectorSequence();
        this._selector.add(this._seq);
        if (inputClass == Token.Type.IDENTIFIER) {
            this._seq.setType(input.source(this._source));
        }
    }

    protected void onStop(boolean endOfInput) {
        switch ((SubState)((Object)this._current)) {
            case MAIN: 
            case PSDOCLS_POST_NAME: 
            case PSDOCLS_POST_PARAM: 
            case ATTR_POST_VALUE: {
                break;
            }
            default: {
                if (!endOfInput) break;
                throw new ParseException("Illegal selector syntax: unexpected end of selector string.");
            }
        }
    }

    protected void onDebug(String message) {
        super.onDebug("\t" + message);
    }

    private Attribute.Operator getOperator(Token.Type inputClass) {
        switch (inputClass) {
            case OP_EQUAL: {
                return Attribute.Operator.EQUAL;
            }
            case OP_BEGIN_WITH: {
                return Attribute.Operator.BEGIN_WITH;
            }
            case OP_END_WITH: {
                return Attribute.Operator.END_WITH;
            }
            case OP_CONTAIN: {
                return Attribute.Operator.CONTAIN;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubState {
        MAIN,
        ID_PRE_VALUE,
        CLASS_PRE_VALUE,
        PSDOCLS_PRE_NAME,
        PSDOCLS_POST_NAME,
        PSDOCLS_PRE_PARAM,
        PSDOCLS_POST_PARAM,
        PSDOELEM_PRE_NAME,
        ATTR_PRE_NAME,
        ATTR_POST_NAME,
        ATTR_PRE_VALUE,
        ATTR_POST_VALUE,
        ATTR_PRE_VALUE_INSQT,
        ATTR_POST_VALUE_INSQT,
        ATTR_PRE_VALUE_INDQT,
        ATTR_POST_VALUE_INDQT;

    }
}

