/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.util.HashMap;
import org.eclipse.compare.examples.xml.IdMap;
import org.eclipse.compare.examples.xml.XMLCompareMessages;
import org.eclipse.compare.examples.xml.XMLComparePreferencePage;
import org.eclipse.compare.examples.xml.ui.StatusDialog;
import org.eclipse.compare.examples.xml.ui.StatusInfo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XMLCompareEditCopyIdMapDialog
extends StatusDialog {
    private HashMap fIdMaps;
    private HashMap fIdMapsInternal;
    private Text fIdMapText;
    private String fResult;

    public XMLCompareEditCopyIdMapDialog(Shell parent, IdMap idmap, HashMap idmaps, HashMap idmapsInternal) {
        super(parent);
        this.setTitle(XMLCompareMessages.XMLCompareEditCopyIdMapDialog_title);
        this.fIdMaps = idmaps;
        this.fIdMapsInternal = idmapsInternal;
    }

    public String getResult() {
        return this.fResult;
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite composite = (Composite)super.createDialogArea(ancestor);
        Label comment = new Label(composite, 0);
        comment.setText(XMLCompareMessages.XMLCompareEditCopyIdMapDialog_comment);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        comment.setLayoutData((Object)data);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        Label label = new Label(inner, 0);
        label.setText(XMLCompareMessages.XMLCompareEditCopyIdMapDialog_label);
        label.setLayoutData((Object)new GridData());
        this.fIdMapText = new Text(inner, 2048);
        this.fIdMapText.setLayoutData((Object)new GridData(768));
        this.fIdMapText.addModifyListener(e -> this.doValidation());
        this.fIdMapText.setFocus();
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fIdMapText.getText();
        if (newText.length() == 0) {
            status.setError(XMLCompareMessages.XMLCompareEditCopyIdMapDialog_error_noname);
        } else if (XMLComparePreferencePage.containsInvalidCharacters(newText)) {
            status.setError(XMLCompareMessages.XMLCompareEditCopyIdMapDialog_error_invalidname);
        } else if (this.fIdMaps.containsKey(newText) || this.fIdMapsInternal.containsKey(newText)) {
            status.setError(XMLCompareMessages.XMLCompareEditCopyIdMapDialog_error_nameExists);
        }
        this.updateStatus(status);
    }

    protected void okPressed() {
        this.fResult = this.fIdMapText.getText();
        super.okPressed();
    }
}

