/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.internal.expressions.Expressions;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runners.MethodSorters;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ExpressionTestsPluginUnloading {
    @Rule
    public TestName name = new TestName();

    @Test
    public void test01PluginStopping() throws Exception {
        Bundle bundle = ExpressionTestsPluginUnloading.getBundle("com.ibm.icu");
        Assert.assertEquals((long)8L, (long)bundle.getState());
        this.doTestInstanceofICUDecimalFormat(bundle);
        Assert.assertEquals((long)32L, (long)bundle.getState());
        bundle.stop();
        Assert.assertEquals((long)4L, (long)bundle.getState());
        bundle.start();
        Assert.assertEquals((long)32L, (long)bundle.getState());
        this.doTestInstanceofICUDecimalFormat(bundle);
    }

    @Test
    public void test02MultipleClassloaders() throws Exception {
        Bundle expr = ExpressionTestsPluginUnloading.getBundle("org.eclipse.core.expressions.tests");
        Bundle icu = ExpressionTestsPluginUnloading.getBundle("com.ibm.icu");
        Class exprClass = expr.loadClass("com.ibm.icu.text.DecimalFormat");
        Class icuClass = icu.loadClass("com.ibm.icu.text.DecimalFormat");
        Assert.assertNotSame((Object)exprClass, (Object)icuClass);
        Object exprObj = exprClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object icuObj = icuClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.assertInstanceOf(exprObj, "java.lang.Runnable", "java.lang.String");
        this.assertInstanceOf(exprObj, "java.lang.Object", "java.io.Serializable");
        this.assertInstanceOf(icuObj, "java.io.Serializable", "java.lang.String");
        this.assertInstanceOf(icuObj, "java.text.Format", "java.lang.Runnable");
    }

    private void assertInstanceOf(Object obj, String isInstance, String isNotInstance) throws Exception {
        Class<?> clazz = obj.getClass();
        System.out.println("ExpressionTestsPluginUnloading#" + this.name.getMethodName() + "() - " + clazz.getName() + ": " + clazz.hashCode());
        System.out.println("ExpressionTestsPluginUnloading#" + this.name.getMethodName() + "() - ClassLoader: " + clazz.getClassLoader().hashCode());
        int i = 0;
        while (i < 2) {
            Assert.assertTrue((boolean)Expressions.isInstanceOf((Object)obj, (String)isInstance));
            Assert.assertFalse((boolean)Expressions.isInstanceOf((Object)obj, (String)isNotInstance));
            ++i;
        }
    }

    private void doTestInstanceofICUDecimalFormat(Bundle bundle) throws Exception {
        Class clazz = bundle.loadClass("com.ibm.icu.text.DecimalFormat");
        Object decimalFormat = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.assertInstanceOf(decimalFormat, "com.ibm.icu.text.DecimalFormat", "java.text.NumberFormat");
    }

    private static Bundle getBundle(String bundleName) {
        Bundle[] bundles;
        BundleContext bundleContext = ExpressionPlugin.getDefault().getBundleContext();
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundleName.equals(bundle.getSymbolicName())) {
                return bundle;
            }
            ++n2;
        }
        Assert.fail((String)("Could not find bundle: " + bundleName));
        return null;
    }
}

