/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.OutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.filesystem.FileSystemTest;

public class SymlinkTest
extends FileSystemTest {
    private static final boolean SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES = SymlinkTest.isWindowsVistaOrHigher();
    private static String specialCharName = "\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd";
    protected IFileStore aDir;
    protected IFileStore aFile;
    protected IFileInfo iDir;
    protected IFileInfo iFile;
    protected IFileInfo ilDir;
    protected IFileInfo ilFile;
    protected IFileInfo illDir;
    protected IFileInfo illFile;
    protected IFileStore lDir;
    protected IFileStore lFile;
    protected IFileStore llDir;
    protected IFileStore llFile;

    public static IFileSystem getFileSystem() {
        try {
            return EFS.getFileSystem((String)"file");
        }
        catch (CoreException e) {
            SymlinkTest.fail((String)"getFileSystem", (Throwable)e);
            return null;
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void fetchFileInfos() {
        this.iDir = this.aDir.fetchInfo();
        this.iFile = this.aFile.fetchInfo();
        this.ilDir = this.lDir.fetchInfo();
        this.ilFile = this.lFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        this.illFile = this.llFile.fetchInfo();
    }

    public boolean haveSymlinks() {
        return this.isAttributeSupported(32);
    }

    protected void makeLinkStructure() {
        this.aDir = this.baseStore.getChild("aDir");
        this.aFile = this.baseStore.getChild("aFile");
        this.lDir = this.baseStore.getChild("lDir");
        this.lFile = this.baseStore.getChild("lFile");
        this.llDir = this.baseStore.getChild("llDir");
        this.llFile = this.baseStore.getChild("llFile");
        this.ensureExists(this.aDir, true);
        this.ensureExists(this.aFile, false);
        this.mkLink(this.baseStore, "lDir", "aDir", true);
        this.mkLink(this.baseStore, "llDir", "lDir", true);
        this.mkLink(this.baseStore, "lFile", "aFile", false);
        this.mkLink(this.baseStore, "llFile", "lFile", false);
        this.fetchFileInfos();
    }

    protected void mkLink(IFileStore dir, String src, String tgt, boolean isDir) {
        try {
            this.createSymLink(dir.toLocalFile(0, this.getMonitor()), src, tgt, isDir);
        }
        catch (CoreException e) {
            SymlinkTest.fail((String)"mkLink", (Throwable)e);
        }
    }

    @Override
    protected void setUp() throws Exception {
        this.baseStore = SymlinkTest.getFileSystem().getStore(SymlinkTest.getWorkspace().getRoot().getLocation().append("temp"));
        this.baseStore.mkdir(0, null);
    }

    @Override
    protected void tearDown() throws Exception {
        this.baseStore.delete(0, null);
    }

    public void testBrokenSymlinkAttributes() {
        if (!this.canCreateSymLinks()) {
            return;
        }
        long testStartTime = System.currentTimeMillis();
        this.makeLinkStructure();
        this.ensureDoesNotExist(this.aDir);
        this.ensureDoesNotExist(this.aFile);
        this.fetchFileInfos();
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)this.ilFile.exists());
        SymlinkTest.assertFalse((boolean)this.ilFile.isDirectory());
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)this.illFile.exists());
        SymlinkTest.assertFalse((boolean)this.illFile.isDirectory());
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)this.ilDir.exists());
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)this.ilDir.isDirectory());
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)this.illDir.exists());
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)this.illDir.isDirectory());
        if (SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES) {
            SymlinkTest.assertTrue((this.ilFile.getLastModified() >= testStartTime ? 1 : 0) != 0);
            SymlinkTest.assertTrue((this.ilDir.getLastModified() >= testStartTime ? 1 : 0) != 0);
            SymlinkTest.assertTrue((this.illFile.getLastModified() >= testStartTime ? 1 : 0) != 0);
            SymlinkTest.assertTrue((this.illDir.getLastModified() >= testStartTime ? 1 : 0) != 0);
        } else {
            SymlinkTest.assertEquals((long)0L, (long)this.ilFile.getLastModified());
            SymlinkTest.assertEquals((long)0L, (long)this.ilDir.getLastModified());
            SymlinkTest.assertEquals((long)0L, (long)this.illFile.getLastModified());
            SymlinkTest.assertEquals((long)0L, (long)this.illDir.getLastModified());
        }
        SymlinkTest.assertEquals((long)0L, (long)this.ilFile.getLength());
        SymlinkTest.assertEquals((long)0L, (long)this.ilDir.getLength());
        SymlinkTest.assertEquals((long)0L, (long)this.illFile.getLength());
        SymlinkTest.assertEquals((long)0L, (long)this.illDir.getLength());
        SymlinkTest.assertTrue((boolean)this.ilFile.getAttribute(32));
        SymlinkTest.assertEquals((String)this.ilFile.getStringAttribute(64), (String)"aFile");
        SymlinkTest.assertTrue((boolean)this.ilDir.getAttribute(32));
        SymlinkTest.assertEquals((String)this.ilDir.getStringAttribute(64), (String)"aDir");
        SymlinkTest.assertTrue((boolean)this.illFile.getAttribute(32));
        SymlinkTest.assertEquals((String)this.illFile.getStringAttribute(64), (String)"lFile");
        SymlinkTest.assertTrue((boolean)this.illDir.getAttribute(32));
        SymlinkTest.assertEquals((String)this.illDir.getStringAttribute(64), (String)"lDir");
    }

    public void testBrokenSymlinkMove() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        this.ensureDoesNotExist(this.aFile);
        this.ensureDoesNotExist(this.aDir);
        IFileInfo[] infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)4);
        IFileStore _llFile = this.baseStore.getChild("_llFile");
        IFileStore _llDir = this.baseStore.getChild("_llDir");
        this.llFile.move(_llFile, 0, this.getMonitor());
        this.llDir.move(_llDir, 0, this.getMonitor());
        infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)4);
        SymlinkTest.assertFalse((String)"1.0", (boolean)this.containsSymlink(infos, this.llFile.getName()));
        SymlinkTest.assertFalse((String)"1.1", (boolean)this.containsSymlink(infos, this.llDir.getName()));
        SymlinkTest.assertTrue((String)"1.2", (boolean)this.containsSymlink(infos, _llFile.getName()));
        SymlinkTest.assertTrue((String)"1.3", (boolean)this.containsSymlink(infos, _llFile.getName()));
        IFileStore _lFile = this.baseStore.getChild("_lFile");
        IFileStore _lDir = this.baseStore.getChild("_lDir");
        this.lFile.move(_lFile, 0, this.getMonitor());
        this.lDir.move(_lDir, 0, this.getMonitor());
        infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)4);
        SymlinkTest.assertFalse((String)"1.4", (boolean)this.containsSymlink(infos, this.lFile.getName()));
        SymlinkTest.assertFalse((String)"1.5", (boolean)this.containsSymlink(infos, this.lDir.getName()));
        SymlinkTest.assertTrue((String)"1.6", (boolean)this.containsSymlink(infos, _lFile.getName()));
        SymlinkTest.assertTrue((String)"1.7", (boolean)this.containsSymlink(infos, _lFile.getName()));
    }

    private boolean containsSymlink(IFileInfo[] infos, String link) {
        IFileInfo[] iFileInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo info = iFileInfoArray[n2];
            if (link.equals(info.getName()) && info.getAttribute(32)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void testBrokenSymlinkRemove() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        this.ensureDoesNotExist(this.aFile);
        this.ensureDoesNotExist(this.aDir);
        IFileInfo[] infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)4);
        this.llFile.delete(0, this.getMonitor());
        this.llDir.delete(0, this.getMonitor());
        infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)2);
        this.lFile.delete(0, this.getMonitor());
        this.lDir.delete(0, this.getMonitor());
        infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)0);
    }

    public void testRecursiveSymlink() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.mkLink(this.baseStore, "l1", "l2", false);
        this.mkLink(this.baseStore, "l2", "l1", false);
        IFileStore l1 = this.baseStore.getChild("l1");
        IFileInfo i1 = l1.fetchInfo();
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)i1.exists());
        SymlinkTest.assertFalse((boolean)i1.isDirectory());
        SymlinkTest.assertTrue((boolean)i1.getAttribute(32));
        SymlinkTest.assertEquals((String)"l2", (String)i1.getStringAttribute(64));
        IFileInfo[] infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)2);
        i1.setAttribute(2, true);
        boolean exceptionThrown = false;
        try {
            l1.putInfo(i1, 1024, this.getMonitor());
        }
        catch (CoreException coreException) {
            exceptionThrown = true;
        }
        i1 = l1.fetchInfo();
        boolean fixMeFixed = false;
        if (fixMeFixed) {
            SymlinkTest.assertTrue((boolean)exceptionThrown);
            SymlinkTest.assertTrue((boolean)i1.getAttribute(2));
        }
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)i1.exists());
        i1.setLastModified(12345L);
        exceptionThrown = false;
        try {
            l1.putInfo(i1, 2048, this.getMonitor());
        }
        catch (CoreException coreException) {
            exceptionThrown = true;
        }
        i1 = l1.fetchInfo();
        SymlinkTest.assertEquals((boolean)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (boolean)i1.exists());
        l1.delete(0, this.getMonitor());
        infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)1);
    }

    public void testSymlinkAttributes() {
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        SymlinkTest.assertFalse((boolean)this.iFile.getAttribute(32));
        SymlinkTest.assertFalse((boolean)this.iDir.getAttribute(32));
        SymlinkTest.assertTrue((boolean)this.ilFile.exists());
        SymlinkTest.assertFalse((boolean)this.ilFile.isDirectory());
        SymlinkTest.assertTrue((boolean)this.illFile.exists());
        SymlinkTest.assertFalse((boolean)this.illFile.isDirectory());
        SymlinkTest.assertTrue((boolean)this.ilDir.exists());
        SymlinkTest.assertTrue((boolean)this.ilDir.isDirectory());
        SymlinkTest.assertTrue((boolean)this.illDir.exists());
        SymlinkTest.assertTrue((boolean)this.illDir.isDirectory());
        if (SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES) {
            SymlinkTest.assertTrue((this.illFile.getLastModified() >= this.iFile.getLastModified() ? 1 : 0) != 0);
            SymlinkTest.assertEquals((long)0L, (long)this.illFile.getLength());
            SymlinkTest.assertTrue((this.illDir.getLastModified() >= this.iDir.getLastModified() ? 1 : 0) != 0);
            SymlinkTest.assertEquals((long)0L, (long)this.illDir.getLength());
        } else {
            SymlinkTest.assertEquals((long)this.iFile.getLastModified(), (long)this.illFile.getLastModified());
            SymlinkTest.assertEquals((long)this.iFile.getLength(), (long)this.illFile.getLength());
            SymlinkTest.assertEquals((long)this.iDir.getLastModified(), (long)this.illDir.getLastModified());
            SymlinkTest.assertEquals((long)this.iDir.getLength(), (long)this.illDir.getLength());
        }
        SymlinkTest.assertTrue((boolean)this.ilFile.getAttribute(32));
        SymlinkTest.assertEquals((String)this.ilFile.getStringAttribute(64), (String)"aFile");
        SymlinkTest.assertTrue((boolean)this.ilDir.getAttribute(32));
        SymlinkTest.assertEquals((String)this.ilDir.getStringAttribute(64), (String)"aDir");
        SymlinkTest.assertTrue((boolean)this.illFile.getAttribute(32));
        SymlinkTest.assertEquals((String)this.illFile.getStringAttribute(64), (String)"lFile");
        SymlinkTest.assertTrue((boolean)this.illDir.getAttribute(32));
        SymlinkTest.assertEquals((String)this.illDir.getStringAttribute(64), (String)"lDir");
    }

    public void testSymlinkDirRead() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        IFileStore childDir = this.aDir.getChild("subDir");
        this.ensureExists(childDir, true);
        IFileInfo[] infos = this.llDir.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)1);
        SymlinkTest.assertTrue((boolean)infos[0].isDirectory());
        SymlinkTest.assertFalse((boolean)infos[0].getAttribute(32));
        SymlinkTest.assertNull((Object)infos[0].getStringAttribute(64));
        SymlinkTest.assertEquals((String)infos[0].getName(), (String)"subDir");
        this.ensureDoesNotExist(childDir);
    }

    public void testSymlinkDirWrite() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        IFileStore childFile = this.llDir.getChild("subFile");
        this.ensureExists(childFile, false);
        IFileInfo[] infos = this.aDir.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((int)infos.length, (int)1);
        SymlinkTest.assertFalse((boolean)infos[0].isDirectory());
        SymlinkTest.assertFalse((boolean)infos[0].getAttribute(32));
        SymlinkTest.assertNull((Object)infos[0].getStringAttribute(64));
        SymlinkTest.assertEquals((String)infos[0].getName(), (String)"subFile");
        this.ensureDoesNotExist(this.aDir);
        childFile = this.llDir.getChild("subFile");
        OutputStream out = null;
        boolean exceptionThrown = false;
        try {
            out = childFile.openOutputStream(0, this.getMonitor());
        }
        catch (CoreException coreException) {
            exceptionThrown = true;
        }
        if (out != null) {
            out.close();
        }
        SymlinkTest.assertNull((Object)out);
        SymlinkTest.assertTrue((boolean)exceptionThrown);
    }

    public void testSymlinkEnabled() {
        String os = Platform.getOS();
        if ("linux".equals(os) || "macosx".equals(os) || SymlinkTest.isWindowsVistaOrHigher()) {
            SymlinkTest.assertTrue((boolean)this.haveSymlinks());
        } else {
            SymlinkTest.assertFalse((boolean)this.haveSymlinks());
        }
    }

    public void _testSymlinkExtendedChars() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        IFileStore childDir = this.baseStore.getChild(specialCharName);
        this.ensureExists(childDir, true);
        IFileStore childFile = this.baseStore.getChild("ff" + specialCharName);
        this.ensureExists(childFile, false);
        this.mkLink(this.baseStore, "l" + specialCharName, specialCharName, true);
        this.mkLink(this.baseStore, "lf" + specialCharName, "ff" + specialCharName, false);
        IFileInfo[] infos = this.baseStore.childInfos(0, this.getMonitor());
        SymlinkTest.assertEquals((String)"0.1", (int)infos.length, (int)4);
        IFileInfo[] iFileInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo info = iFileInfoArray[n2];
            String infoName = info.getName();
            SymlinkTest.assertTrue((String)("1." + infoName), (boolean)infoName.endsWith(specialCharName));
            SymlinkTest.assertTrue((String)("2." + infoName), (boolean)info.exists());
            if (info.getName().charAt(1) == 'f') {
                SymlinkTest.assertFalse((String)("3." + infoName), (boolean)info.isDirectory());
            } else {
                SymlinkTest.assertTrue((String)("4." + infoName), (boolean)info.isDirectory());
            }
            if (info.getName().charAt(0) == 'l') {
                SymlinkTest.assertTrue((String)("5." + infoName), (boolean)info.getAttribute(32));
                SymlinkTest.assertTrue((String)("6." + infoName), (boolean)info.getStringAttribute(64).endsWith(specialCharName));
            }
            ++n2;
        }
    }

    public void testSymlinkPutLastModified() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        if ("macosx".equals(Platform.getOS())) {
            return;
        }
        this.makeLinkStructure();
        long oldTime = this.iFile.getLastModified();
        long timeToSet = oldTime - 100000L;
        this.illFile.setLastModified(timeToSet);
        this.llFile.putInfo(this.illFile, 3072, this.getMonitor());
        this.iFile = this.aFile.fetchInfo();
        SymlinkTest.assertEquals((long)this.iFile.getLastModified(), (long)timeToSet);
        oldTime = this.iDir.getLastModified();
        timeToSet = oldTime - 100000L;
        this.illDir.setLastModified(timeToSet);
        this.llDir.putInfo(this.illDir, 3072, this.getMonitor());
        this.iDir = this.aDir.fetchInfo();
        SymlinkTest.assertTrue((this.iDir.getLastModified() != oldTime ? 1 : 0) != 0);
        SymlinkTest.assertEquals((long)this.iDir.getLastModified(), (long)timeToSet);
        this.illFile = this.llFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.illFile.getAttribute(32));
        SymlinkTest.assertTrue((boolean)this.illDir.getAttribute(32));
        SymlinkTest.assertEquals((String)this.illFile.getStringAttribute(64), (String)"lFile");
        SymlinkTest.assertEquals((String)this.illDir.getStringAttribute(64), (String)"lDir");
    }

    public void testSymlinkPutReadOnly() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        this.illFile.setAttribute(2, true);
        this.llFile.putInfo(this.illFile, 1024, this.getMonitor());
        this.iFile = this.aFile.fetchInfo();
        SymlinkTest.assertEquals((!SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES ? 1 : 0) != 0, (boolean)this.iFile.getAttribute(2));
        this.illFile.setAttribute(2, false);
        this.llFile.putInfo(this.illFile, 1024, this.getMonitor());
        this.iFile = this.aFile.fetchInfo();
        SymlinkTest.assertFalse((boolean)this.iFile.getAttribute(2));
        this.illDir.setAttribute(2, true);
        this.llDir.putInfo(this.illDir, 1024, this.getMonitor());
        this.iDir = this.aDir.fetchInfo();
        SymlinkTest.assertEquals((!SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES ? 1 : 0) != 0, (boolean)this.iDir.getAttribute(2));
        this.illDir.setAttribute(2, false);
        this.llDir.putInfo(this.illDir, 1024, this.getMonitor());
        this.iDir = this.aDir.fetchInfo();
        SymlinkTest.assertFalse((boolean)this.iDir.getAttribute(2));
        this.illFile = this.llFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.illFile.getAttribute(32));
        SymlinkTest.assertTrue((boolean)this.illDir.getAttribute(32));
        SymlinkTest.assertEquals((String)this.illFile.getStringAttribute(64), (String)"lFile");
        SymlinkTest.assertEquals((String)this.illDir.getStringAttribute(64), (String)"lDir");
    }

    public void testSymlinkPutExecutable() throws Exception {
        if (!this.isAttributeSupported(4)) {
            return;
        }
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        this.illFile.setAttribute(4, true);
        this.llFile.putInfo(this.illFile, 1024, this.getMonitor());
        this.iFile = this.aFile.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.iFile.getAttribute(4));
        this.illDir.setAttribute(4, false);
        this.llDir.putInfo(this.illDir, 1024, this.getMonitor());
        this.iDir = this.aDir.fetchInfo();
        SymlinkTest.assertFalse((boolean)this.iDir.getAttribute(4));
        this.illFile = this.llFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.illFile.getAttribute(32));
        SymlinkTest.assertTrue((boolean)this.illDir.getAttribute(32));
        SymlinkTest.assertEquals((String)this.illFile.getStringAttribute(64), (String)"lFile");
        SymlinkTest.assertEquals((String)this.illDir.getStringAttribute(64), (String)"lDir");
    }

    public void testSymlinkPutHidden() throws Exception {
        if (!this.isAttributeSupported(16)) {
            return;
        }
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        this.illFile.setAttribute(16, true);
        this.llFile.putInfo(this.illFile, 1024, this.getMonitor());
        this.illFile = this.llFile.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.illFile.getAttribute(16));
        this.iFile = this.aFile.fetchInfo();
        SymlinkTest.assertFalse((boolean)this.iFile.getAttribute(16));
        this.illDir.setAttribute(16, true);
        this.llDir.putInfo(this.illDir, 1024, this.getMonitor());
        this.illDir = this.llDir.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.illDir.getAttribute(16));
        this.iDir = this.aDir.fetchInfo();
        SymlinkTest.assertFalse((boolean)this.iDir.getAttribute(16));
        this.illFile = this.llFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.illFile.getAttribute(32));
        SymlinkTest.assertTrue((boolean)this.illDir.getAttribute(32));
        SymlinkTest.assertEquals((String)this.illFile.getStringAttribute(64), (String)"lFile");
        SymlinkTest.assertEquals((String)this.illDir.getStringAttribute(64), (String)"lDir");
    }

    public void testSymlinkRemove() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        this.makeLinkStructure();
        this.lFile.delete(0, this.getMonitor());
        this.illFile = this.lFile.fetchInfo();
        SymlinkTest.assertFalse((boolean)this.illFile.exists());
        this.iFile = this.aFile.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.iFile.exists());
        IFileStore childFile = this.aDir.getChild("subFile");
        this.ensureExists(childFile, false);
        this.lDir.delete(0, this.getMonitor());
        this.illDir = this.lDir.fetchInfo();
        SymlinkTest.assertFalse((boolean)this.illFile.exists());
        this.iDir = this.aDir.fetchInfo();
        SymlinkTest.assertTrue((boolean)this.iDir.exists());
        IFileInfo iFileInsideDir = childFile.fetchInfo();
        SymlinkTest.assertTrue((boolean)iFileInsideDir.exists());
    }
}

