/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public abstract class AbstractBuilderTest
extends ResourceTest {
    private boolean autoBuilding;
    private int simultaneousBuilds;

    public AbstractBuilderTest(String name) {
        super(name);
    }

    protected void addBuilder(IProject project, String builderName) throws CoreException {
        IProjectDescription desc = project.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, builderName, "Project1Build1")});
        project.setDescription(desc, this.getMonitor());
    }

    protected ICommand createCommand(IProjectDescription description, String buildID) {
        return this.createCommand(description, "org.eclipse.core.tests.resources.sortbuilder", buildID);
    }

    protected ICommand createCommand(IProjectDescription description, String builderName, String buildID) {
        ICommand command = description.newCommand();
        Map args = command.getArguments();
        args.put("BuildID", buildID);
        command.setBuilderName(builderName);
        command.setArguments(args);
        return command;
    }

    protected void dirty(IFile file) throws CoreException {
        file.setContents(this.getRandomContents(), true, true, this.getMonitor());
    }

    protected void setAutoBuilding(boolean value) throws CoreException {
        IWorkspace workspace = AbstractBuilderTest.getWorkspace();
        if (workspace.isAutoBuilding() == value) {
            return;
        }
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(value);
        workspace.setDescription(desc);
    }

    protected void setBuildOrder(IProject project) throws CoreException {
        IWorkspace workspace = AbstractBuilderTest.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setBuildOrder(new String[]{project.getName()});
        workspace.setDescription(desc);
    }

    protected void setBuildOrder(IProject project1, IProject project2) throws CoreException {
        IWorkspace workspace = AbstractBuilderTest.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setBuildOrder(new String[]{project1.getName(), project2.getName()});
        workspace.setDescription(desc);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.autoBuilding = AbstractBuilderTest.getWorkspace().isAutoBuilding();
        this.simultaneousBuilds = AbstractBuilderTest.getWorkspace().getDescription().getMaxConcurrentBuilds();
    }

    @Override
    protected void tearDown() throws Exception {
        IWorkspace workspace = AbstractBuilderTest.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setBuildOrder(null);
        desc.setMaxConcurrentBuilds(this.simultaneousBuilds);
        workspace.setDescription(desc);
        this.waitForBuild();
        this.setAutoBuilding(this.autoBuilding);
        super.tearDown();
    }
}

