/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.CycleBuilder;
import org.eclipse.core.tests.internal.builders.SortBuilder;

public class BuilderCycleTest
extends AbstractBuilderTest {
    public BuilderCycleTest(String name) {
        super(name);
    }

    public BuilderCycleTest() {
        super(null);
    }

    public static Test suite() {
        return new TestSuite(BuilderCycleTest.class);
    }

    public void testIsBeforeThisProject() {
        IWorkspaceDescription description;
        IWorkspaceRoot root = BuilderCycleTest.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IProject before1 = root.getProject("Before1");
        IProject before2 = root.getProject("Before2");
        IProject after1 = root.getProject("After1");
        IProject after2 = root.getProject("After2");
        this.ensureExistsInWorkspace(new IResource[]{project, before1, before2, after1, after2}, true);
        try {
            description = BuilderCycleTest.getWorkspace().getDescription();
            description.setBuildOrder(new String[]{before1.getName(), before2.getName(), project.getName(), after1.getName(), after2.getName()});
            description.setAutoBuilding(false);
            BuilderCycleTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            description = project.getDescription();
            ICommand command1 = this.createCommand((IProjectDescription)description, "org.eclipse.core.tests.resources.cyclebuilder", "Build0");
            description.setBuildSpec(new ICommand[]{command1});
            project.setDescription((IProjectDescription)description, 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            BuilderCycleTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"3.0", (Throwable)e);
        }
        CycleBuilder builder = CycleBuilder.getInstance();
        builder.resetBuildCount();
        builder.setBeforeProjects(new IProject[]{before1, before2});
        builder.setAfterProjects(new IProject[]{after1, after2});
        try {
            project.getFile("Foo.txt").create(this.getRandomContents(), 0, this.getMonitor());
            BuilderCycleTest.getWorkspace().build(10, this.getMonitor());
            builder.resetBuildCount();
            BuilderCycleTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void skipTestNeedRebuild() {
        IWorkspaceRoot root = BuilderCycleTest.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IFolder unsorted = project.getFolder(SortBuilder.DEFAULT_UNSORTED_FOLDER);
        IFile unsortedFile = unsorted.getFile("File.txt");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace((IResource)unsorted, true);
        this.ensureExistsInWorkspace((IResource)unsortedFile, true);
        try {
            this.setAutoBuilding(true);
            IProjectDescription description = project.getDescription();
            ICommand command1 = this.createCommand(description, "org.eclipse.core.tests.resources.cyclebuilder", "Build0");
            ICommand command2 = this.createCommand(description, "org.eclipse.core.tests.resources.sortbuilder", "Build1");
            description.setBuildSpec(new ICommand[]{command1, command2});
            project.setDescription(description, 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"1.0", (Throwable)e);
        }
        CycleBuilder builder = CycleBuilder.getInstance();
        builder.resetBuildCount();
        try {
            BuilderCycleTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"3.0", (Throwable)e);
        }
        builder.setRebuildsToRequest(0);
        builder.resetBuildCount();
        try {
            BuilderCycleTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"4.0", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"4.1", (int)1, (int)builder.getBuildCount());
        IFile file = project.getFile("foo.txt");
        builder.resetBuildCount();
        try {
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"4.2", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"4.3", (int)1, (int)builder.getBuildCount());
        builder.setRebuildsToRequest(1);
        builder.resetBuildCount();
        try {
            BuilderCycleTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"5.0", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"5.1", (int)2, (int)builder.getBuildCount());
        builder.resetBuildCount();
        try {
            file.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"5.2", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"5.3", (int)2, (int)builder.getBuildCount());
        builder.setRebuildsToRequest(5);
        builder.resetBuildCount();
        try {
            BuilderCycleTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"6.0", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"6.1", (int)6, (int)builder.getBuildCount());
        builder.resetBuildCount();
        try {
            file.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"6.2", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"6.3", (int)6, (int)builder.getBuildCount());
        int maxBuilds = BuilderCycleTest.getWorkspace().getDescription().getMaxBuildIterations();
        builder.setRebuildsToRequest(maxBuilds * 2);
        builder.resetBuildCount();
        try {
            BuilderCycleTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"7.0", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"7.1", (int)maxBuilds, (int)builder.getBuildCount());
        builder.resetBuildCount();
        try {
            file.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"7.2", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"7.3", (int)maxBuilds, (int)builder.getBuildCount());
        maxBuilds = 7;
        try {
            IWorkspaceDescription desc = BuilderCycleTest.getWorkspace().getDescription();
            desc.setMaxBuildIterations(maxBuilds);
            BuilderCycleTest.getWorkspace().setDescription(desc);
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"8.0", (Throwable)e);
        }
        builder.setRebuildsToRequest(maxBuilds * 2);
        builder.resetBuildCount();
        try {
            BuilderCycleTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"8.1", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"8.2", (int)maxBuilds, (int)builder.getBuildCount());
        builder.resetBuildCount();
        try {
            file.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderCycleTest.fail((String)"8.3", (Throwable)e);
        }
        BuilderCycleTest.assertEquals((String)"8.4", (int)maxBuilds, (int)builder.getBuildCount());
    }
}

