/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestSuite;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.TimerBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ParallelBuildChainTest
extends AbstractBuilderTest {
    private static final int LONG_BUILD_DURATION = 1000;

    public static junit.framework.Test suite() {
        return new TestSuite(ParallelBuildChainTest.class);
    }

    public ParallelBuildChainTest() {
        super(null);
    }

    public ParallelBuildChainTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceDescription description = ParallelBuildChainTest.getWorkspace().getDescription();
        description.setMaxConcurrentBuilds(3);
        ParallelBuildChainTest.getWorkspace().setDescription(description);
        this.setAutoBuilding(false);
        TimerBuilder.reset();
        IWorkspaceRoot root = ParallelBuildChainTest.getWorkspace().getRoot();
        IProject projectInstantaneousBuild1 = root.getProject("projectInstantaneousBuild1");
        IProject projectLongBuild1 = root.getProject("projectLongBuild1");
        IProject projectInstantaneousBuild2 = root.getProject("projectInstantaneousBuild2");
        IProject projectLongBuild2 = root.getProject("projectLongBuild2");
        IProject projectInstantaneousBuild3 = root.getProject("projectInstantaneousBuild3");
        IProject projectLongBuild3 = root.getProject("projectLongBuild3");
        this.ensureExistsInWorkspace(new IResource[]{projectInstantaneousBuild1, projectInstantaneousBuild2, projectInstantaneousBuild3, projectLongBuild1, projectLongBuild2, projectLongBuild3}, true);
        this.configureTimerBuilder(projectInstantaneousBuild1, 0);
        this.configureTimerBuilder(projectInstantaneousBuild2, 0);
        this.configureTimerBuilder(projectInstantaneousBuild3, 0);
        this.configureTimerBuilder(projectLongBuild1, 1000);
        this.configureTimerBuilder(projectLongBuild2, 1000);
        this.configureTimerBuilder(projectLongBuild3, 1000);
    }

    private void configureTimerBuilder(IProject project, int duration) throws CoreException {
        BuildCommand buildCommand = new BuildCommand();
        buildCommand.setBuilderName("org.eclipse.core.tests.resources.timerbuilder");
        HashMap<String, String> arguments = new HashMap<String, String>(2, 1.0f);
        arguments.put("duration", Integer.toString(duration));
        arguments.put("ruleType", TimerBuilder.RuleType.NO_CONFLICT.toString());
        buildCommand.setArguments(arguments);
        IProjectDescription projectDescription = project.getDescription();
        projectDescription.setBuildSpec(new ICommand[]{buildCommand});
        project.setDescription(projectDescription, this.getMonitor());
    }

    public IProject[] projectWithLongRunningBuilds() {
        return (IProject[])Arrays.stream(ParallelBuildChainTest.getWorkspace().getRoot().getProjects()).filter(project -> {
            try {
                ICommand[] commands = project.getDescription().getBuildSpec();
                return commands.length > 0 && commands[0].getBuilderName().equals("org.eclipse.core.tests.resources.timerbuilder") && Integer.parseInt((String)commands[0].getArguments().get("duration")) > 0;
            }
            catch (CoreException e) {
                ParallelBuildChainTest.fail((String)e.getMessage(), (Throwable)e);
                return false;
            }
        }).toArray(IProject[]::new);
    }

    private void setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType type, IProgressMonitor monitor) throws CoreException {
        IProject[] iProjectArray = ParallelBuildChainTest.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IProjectDescription projectDescription = project.getDescription();
            BuildCommand command = (BuildCommand)projectDescription.getBuildSpec()[0];
            Map<String, String> args = command.getArguments();
            if (args == null) {
                args = Collections.singletonMap("ruleType", type.toString());
            } else {
                args.put("ruleType", type.toString());
            }
            command.setArguments(args);
            projectDescription.setBuildSpec(new ICommand[]{command});
            project.setDescription(projectDescription, this.getMonitor());
            ++n2;
        }
    }

    @Test
    public void testIndividualProjectBuildsInParallelNoConflict() throws CoreException, OperationCanceledException, InterruptedException {
        long duration = System.currentTimeMillis();
        JobGroup group = new JobGroup("Build Group", 5, ParallelBuildChainTest.getWorkspace().getRoot().getProjects().length);
        IProject[] iProjectArray = ParallelBuildChainTest.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IProject project = iProjectArray[n2];
            Job job = new Job("Building " + project){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        project.build(6, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                    }
                }
            };
            job.setJobGroup(group);
            job.schedule();
            ++n2;
        }
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)group.join(5000L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)ParallelBuildChainTest.getWorkspace().getRoot().getProjects().length, (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertTrue((TimerBuilder.getMaxSimultaneousBuilds() >= 3 ? 1 : 0) != 0);
        ParallelBuildChainTest.assertTrue((duration < (long)(this.projectWithLongRunningBuilds().length * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void testIndividualProjectBuildsInParallelProjectScheduling() throws CoreException, OperationCanceledException, InterruptedException {
        this.setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType.CURRENT_PROJECT_RELAXED, this.getMonitor());
        long duration = System.currentTimeMillis();
        JobGroup group = new JobGroup("Build Group", 5, ParallelBuildChainTest.getWorkspace().getRoot().getProjects().length);
        IProject[] iProjectArray = ParallelBuildChainTest.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IProject project = iProjectArray[n2];
            Job job = new Job("Building " + project){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        project.build(6, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                    }
                }
            };
            job.setJobGroup(group);
            job.schedule();
            ++n2;
        }
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)group.join(5000L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)ParallelBuildChainTest.getWorkspace().getRoot().getProjects().length, (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertTrue((TimerBuilder.getMaxSimultaneousBuilds() >= 3 ? 1 : 0) != 0);
        ParallelBuildChainTest.assertTrue((duration < (long)(this.projectWithLongRunningBuilds().length * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void testWorkspaceBuildConfigParrallelProjectRule() throws CoreException, OperationCanceledException, InterruptedException {
        this.setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType.CURRENT_PROJECT, this.getMonitor());
        long duration = System.currentTimeMillis();
        Job job = new Job("Workspace Build"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ParallelBuildChainTest.getWorkspace().build((IBuildConfiguration[])Arrays.stream(ParallelBuildChainTest.getWorkspace().getRoot().getProjects()).map(p -> {
                        try {
                            return p.getActiveBuildConfig();
                        }
                        catch (CoreException e) {
                            ParallelBuildChainTest.fail((String)e.getMessage(), (Throwable)e);
                            return null;
                        }
                    }).toArray(IBuildConfiguration[]::new), 10, true, ParallelBuildChainTest.this.getMonitor());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)job.join(5000L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)ParallelBuildChainTest.getWorkspace().getRoot().getProjects().length, (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertTrue((TimerBuilder.getMaxSimultaneousBuilds() > 1 ? 1 : 0) != 0);
        ParallelBuildChainTest.assertTrue((TimerBuilder.getMaxSimultaneousBuilds() <= ParallelBuildChainTest.getWorkspace().getDescription().getMaxConcurrentBuilds() ? 1 : 0) != 0);
        ParallelBuildChainTest.assertTrue((duration < (long)(this.projectWithLongRunningBuilds().length * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void testWorkspaceParrallelBuildNoConflict() throws CoreException, OperationCanceledException, InterruptedException {
        this.setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType.NO_CONFLICT, this.getMonitor());
        long duration = System.currentTimeMillis();
        Job job = new Job("Workspace Build"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ParallelBuildChainTest.getWorkspace().build(10, ParallelBuildChainTest.this.getMonitor());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)job.join(5000L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)ParallelBuildChainTest.getWorkspace().getRoot().getProjects().length, (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertTrue((TimerBuilder.getMaxSimultaneousBuilds() > 1 ? 1 : 0) != 0);
        ParallelBuildChainTest.assertTrue((TimerBuilder.getMaxSimultaneousBuilds() <= ParallelBuildChainTest.getWorkspace().getDescription().getMaxConcurrentBuilds() ? 1 : 0) != 0);
        ParallelBuildChainTest.assertTrue((duration < (long)(this.projectWithLongRunningBuilds().length * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void testWorkspaceParrallelBuildConflictingRules() throws CoreException, OperationCanceledException, InterruptedException {
        this.setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType.WORKSPACE_ROOT, this.getMonitor());
        long duration = System.currentTimeMillis();
        Job job = new Job("Workspace Build"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ParallelBuildChainTest.getWorkspace().build(10, ParallelBuildChainTest.this.getMonitor());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)job.join(5000L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)ParallelBuildChainTest.getWorkspace().getRoot().getProjects().length, (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertEquals((int)1, (int)TimerBuilder.getMaxSimultaneousBuilds());
        ParallelBuildChainTest.assertTrue((duration > (long)(this.projectWithLongRunningBuilds().length * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void testWorkspaceParrallelBuildCurrentProject() throws CoreException, OperationCanceledException, InterruptedException {
        this.setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType.CURRENT_PROJECT, this.getMonitor());
        long duration = System.currentTimeMillis();
        Job job = new Job("Workspace Build"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ParallelBuildChainTest.getWorkspace().build(10, ParallelBuildChainTest.this.getMonitor());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)job.join(5000L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)ParallelBuildChainTest.getWorkspace().getRoot().getProjects().length, (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertTrue((TimerBuilder.getMaxSimultaneousBuilds() > 1 ? 1 : 0) != 0);
        ParallelBuildChainTest.assertTrue((TimerBuilder.getMaxSimultaneousBuilds() <= ParallelBuildChainTest.getWorkspace().getDescription().getMaxConcurrentBuilds() ? 1 : 0) != 0);
        ParallelBuildChainTest.assertTrue((duration < (long)(this.projectWithLongRunningBuilds().length * 1000) ? 1 : 0) != 0);
    }

    public void testDependentProjectsBuildSequentially() throws Exception {
        IProject[] allProjects = ParallelBuildChainTest.getWorkspace().getRoot().getProjects();
        int i = 1;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            IProjectDescription desc = project.getDescription();
            desc.setReferencedProjects(new IProject[]{allProjects[i - 1]});
            project.setDescription(desc, this.getMonitor());
            ++i;
        }
        this.setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType.NO_CONFLICT, this.getMonitor());
        long duration = System.currentTimeMillis();
        Job job = new Job("Workspace Build"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ParallelBuildChainTest.getWorkspace().build(10, ParallelBuildChainTest.this.getMonitor());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)job.join(5000L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)allProjects.length, (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertEquals((int)1, (int)TimerBuilder.getMaxSimultaneousBuilds());
        ParallelBuildChainTest.assertTrue((duration > (long)(this.projectWithLongRunningBuilds().length * 1000) ? 1 : 0) != 0);
        ParallelBuildChainTest.assertEquals(this.sequentialBuildEvents(allProjects), TimerBuilder.events);
    }

    private List<Object> sequentialBuildEvents(IProject[] allProjects) {
        ArrayList<Object> res = new ArrayList<Object>(allProjects.length * 2);
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            res.add(TimerBuilder.buildStartEvent(project));
            res.add(TimerBuilder.buildCompleteEvent(project));
            ++n2;
        }
        return res;
    }

    public void testDependentBuildConfigBuildSequentially() throws Exception {
        IProject[] allProjects = ParallelBuildChainTest.getWorkspace().getRoot().getProjects();
        int i = 1;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            IProjectDescription desc = project.getDescription();
            desc.setBuildConfigReferences(project.getActiveBuildConfig().getName(), new IBuildConfiguration[]{allProjects[i - 1].getActiveBuildConfig()});
            project.setDescription(desc, this.getMonitor());
            ++i;
        }
        this.setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType.NO_CONFLICT, this.getMonitor());
        long duration = System.currentTimeMillis();
        Job job = new Job("Workspace Build"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ParallelBuildChainTest.getWorkspace().build(10, ParallelBuildChainTest.this.getMonitor());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)job.join(0L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)allProjects.length, (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertEquals((int)1, (int)TimerBuilder.getMaxSimultaneousBuilds());
        ParallelBuildChainTest.assertTrue((duration > (long)(this.projectWithLongRunningBuilds().length * 1000) ? 1 : 0) != 0);
        ParallelBuildChainTest.assertEquals(this.sequentialBuildEvents(allProjects), TimerBuilder.events);
    }

    public void testDependentBuildConfigsSubset() throws Exception {
        this.setTimerBuilderSchedulingRuleForAllProjects(TimerBuilder.RuleType.NO_CONFLICT, this.getMonitor());
        final IProject[] allProjects = ParallelBuildChainTest.getWorkspace().getRoot().getProjects();
        int i = 1;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            IProjectDescription desc = project.getDescription();
            desc.setBuildConfigReferences(project.getActiveBuildConfig().getName(), new IBuildConfiguration[]{allProjects[i - 1].getActiveBuildConfig()});
            project.setDescription(desc, this.getMonitor());
            ++i;
        }
        long duration = System.currentTimeMillis();
        Job job = new Job("Workspace Build"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ParallelBuildChainTest.getWorkspace().build(new IBuildConfiguration[]{allProjects[0].getActiveBuildConfig(), allProjects[2].getActiveBuildConfig(), allProjects[3].getActiveBuildConfig(), allProjects[5].getActiveBuildConfig()}, 10, false, ParallelBuildChainTest.this.getMonitor());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.core.tests.resources", e.getMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        Assert.assertTrue((String)"Timeout, most likely a deadlock", (boolean)job.join(0L, this.getMonitor()));
        duration = System.currentTimeMillis() - duration;
        ParallelBuildChainTest.assertEquals((int)(allProjects.length - 2), (int)TimerBuilder.getTotalBuilds());
        ParallelBuildChainTest.assertEquals(Arrays.asList(TimerBuilder.buildStartEvent(allProjects[0]), TimerBuilder.buildCompleteEvent(allProjects[0]), TimerBuilder.buildStartEvent(allProjects[2]), TimerBuilder.buildCompleteEvent(allProjects[2]), TimerBuilder.buildStartEvent(allProjects[3]), TimerBuilder.buildCompleteEvent(allProjects[3]), TimerBuilder.buildStartEvent(allProjects[5]), TimerBuilder.buildCompleteEvent(allProjects[5])), TimerBuilder.events);
    }
}

