/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class TimerBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.timerbuilder";
    public static final String DURATION_ARG = "duration";
    public static final String RULE_TYPE_ARG = "ruleType";
    private static int totalBuilds = 0;
    private static int currentBuilds = 0;
    private static int maxSimultaneousBuilds = 0;
    public static final List<Object> events = Collections.synchronizedList(new ArrayList());
    final ISchedulingRule noConflictRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }
    };
    final ISchedulingRule relaxedProjetRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule || ResourcesPlugin.getWorkspace().getRoot().contains(rule);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        Class<TimerBuilder> clazz = TimerBuilder.class;
        synchronized (TimerBuilder.class) {
            ++totalBuilds;
            maxSimultaneousBuilds = Math.max(++currentBuilds, maxSimultaneousBuilds);
            events.add(TimerBuilder.buildStartEvent(this.getProject()));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            int duration = 0;
            try {
                duration = Integer.parseInt(args.get(DURATION_ARG));
                Thread.sleep(duration);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Class<TimerBuilder> clazz2 = TimerBuilder.class;
            synchronized (TimerBuilder.class) {
                --currentBuilds;
                events.add(TimerBuilder.buildCompleteEvent(this.getProject()));
                // ** MonitorExit[var5_7] (shouldn't be in output)
                return new IProject[]{this.getProject()};
            }
        }
    }

    public static Object buildCompleteEvent(IProject project) {
        return "Compete " + project.getName();
    }

    public static Object buildStartEvent(IProject project) {
        return "Started " + project.getName();
    }

    public ISchedulingRule getRule(int trigger, Map<String, String> args) {
        if (args != null) {
            RuleType ruleType = RuleType.valueOf(args.get(RULE_TYPE_ARG));
            switch (ruleType) {
                case NO_CONFLICT: {
                    return this.noConflictRule;
                }
                case CURRENT_PROJECT: {
                    return this.getProject();
                }
                case WORKSPACE_ROOT: {
                    return this.getProject().getWorkspace().getRoot();
                }
                case CURRENT_PROJECT_RELAXED: {
                    return this.relaxedProjetRule;
                }
            }
        }
        return this.noConflictRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTotalBuilds() {
        Class<TimerBuilder> clazz = TimerBuilder.class;
        synchronized (TimerBuilder.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return totalBuilds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxSimultaneousBuilds() {
        Class<TimerBuilder> clazz = TimerBuilder.class;
        synchronized (TimerBuilder.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return maxSimultaneousBuilds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<TimerBuilder> clazz = TimerBuilder.class;
        synchronized (TimerBuilder.class) {
            totalBuilds = 0;
            currentBuilds = 0;
            maxSimultaneousBuilds = 0;
            events.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static enum RuleType {
        NO_CONFLICT,
        CURRENT_PROJECT,
        WORKSPACE_ROOT,
        CURRENT_PROJECT_RELAXED;

    }
}

