/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.resources.ResourceTest;

public class BuildProjectFromMultipleJobsTest
extends ResourceTest {
    private static final String TEST_PROJECT_NAME = "ProjectForBuildCommandTest";
    private final ErrorLogListener logListener = new ErrorLogListener();
    private boolean wasAutoBuildOn;

    public static Test suite() {
        return new TestSuite(BuildProjectFromMultipleJobsTest.class);
    }

    public BuildProjectFromMultipleJobsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.wasAutoBuildOn = BuildProjectFromMultipleJobsTest.setWorkspaceAutoBuild(false);
        Platform.addLogListener((ILogListener)this.logListener);
    }

    @Override
    protected void tearDown() throws Exception {
        Job.getJobManager().cancel(BuildTestProject.class);
        Platform.removeLogListener((ILogListener)this.logListener);
        this.logListener.clear();
        try {
            IProject testProject = BuildProjectFromMultipleJobsTest.getTestProject();
            if (testProject.exists()) {
                testProject.delete(true, null);
            }
        }
        finally {
            BuildProjectFromMultipleJobsTest.setWorkspaceAutoBuild(this.wasAutoBuildOn);
        }
        super.tearDown();
    }

    public void test10IterationsWithBuildsFrom8Jobs() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        int iterations = 10;
        int jobs = 8;
        int i = 0;
        while (i < iterations) {
            IProject project = this.createTestProject("org.eclipse.core.tests.resources.simplebuilder", (IProgressMonitor)monitor);
            ArrayList<BuildTestProject> buildJobs = new ArrayList<BuildTestProject>();
            int j = 0;
            while (j < jobs) {
                BuildTestProject buildTestProject = new BuildTestProject(project, j);
                buildJobs.add(buildTestProject);
                ++j;
            }
            for (BuildTestProject buildJob : buildJobs) {
                buildJob.schedule();
            }
            for (BuildTestProject buildJob : buildJobs) {
                buildJob.join();
            }
            project.delete(true, (IProgressMonitor)monitor);
            String errorMessage = "Building in parallel encountered an exception in iteration " + i;
            this.logListener.assertNoExceptionsWereLogged(errorMessage);
            ++i;
        }
    }

    public void testBuildersAreNotModifiable() throws Exception {
        Project project = (Project)this.createTestProject("org.eclipse.core.tests.resources.configbuilder", null);
        project.build(6, null);
        BuildCommand buildCommand = (BuildCommand)project.internalGetDescription().getBuildSpec(false)[0];
        Map buildersMap = (Map)buildCommand.getBuilders();
        BuildProjectFromMultipleJobsTest.assertEquals((int)1, (int)buildersMap.size());
        buildersMap.clear();
        BuildProjectFromMultipleJobsTest.assertEquals((int)0, (int)buildersMap.size());
        buildersMap = (Map)buildCommand.getBuilders();
        BuildProjectFromMultipleJobsTest.assertEquals((String)"BuildCommand state was changed!", (int)1, (int)buildersMap.size());
    }

    private IProject createTestProject(String builderId, IProgressMonitor monitor) throws CoreException {
        IProject project = BuildProjectFromMultipleJobsTest.getTestProject();
        BuildProjectFromMultipleJobsTest.assertFalse((String)"Expected test project to not exist at beginning of test", (boolean)project.exists());
        this.ensureExistsInWorkspace((IResource)project, true);
        BuildProjectFromMultipleJobsTest.assertTrue((String)"Expected test project to be open after creation", (boolean)project.isOpen());
        IProjectDescription projectDescription = project.getDescription();
        ICommand[] buildSpec = projectDescription.getBuildSpec();
        ICommand command = projectDescription.newCommand();
        command.setBuilderName(builderId);
        ArrayList<ICommand> builders = new ArrayList<ICommand>(Arrays.asList(buildSpec));
        builders.add(command);
        projectDescription.setBuildSpec(builders.toArray(new ICommand[0]));
        project.setDescription(projectDescription, monitor);
        return project;
    }

    private static IProject getTestProject() {
        IWorkspaceRoot workspaceRoot = BuildProjectFromMultipleJobsTest.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(TEST_PROJECT_NAME);
        return project;
    }

    private static boolean setWorkspaceAutoBuild(boolean autobuildOn) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        boolean oldAutoBuildingState = description.isAutoBuilding();
        if (oldAutoBuildingState != autobuildOn) {
            description.setAutoBuilding(autobuildOn);
            workspace.setDescription(description);
        }
        return oldAutoBuildingState;
    }

    private static class BuildTestProject
    extends Job {
        private final IProject project;

        public BuildTestProject(IProject project, int number) {
            super("build test project " + number);
            this.project = project;
        }

        protected IStatus run(IProgressMonitor jobMonitor) {
            try {
                if (!jobMonitor.isCanceled()) {
                    this.project.build(6, jobMonitor);
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return new Status(0, "org.eclipse.core.tests.resources", String.valueOf(this.getName()) + " finished");
        }

        public boolean belongsTo(Object family) {
            return BuildTestProject.class == family;
        }
    }

    private static class ErrorLogListener
    implements ILogListener {
        private final List<Throwable> loggedExceptions = new ArrayList<Throwable>();

        public void logging(IStatus status, String plugin) {
            Throwable statusException = status.getException();
            this.loggedExceptions.add(statusException);
        }

        void assertNoExceptionsWereLogged(String errorMessage) {
            Iterator<Throwable> iterator = this.loggedExceptions.iterator();
            if (iterator.hasNext()) {
                Throwable loggedException = iterator.next();
                throw new AssertionError(errorMessage, loggedException);
            }
        }

        void clear() {
            this.loggedExceptions.clear();
        }
    }
}

