/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.filesystem.bug440110;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.filesystem.bug440110.Bug440110FileStore;
import org.eclipse.core.tests.internal.filesystem.bug440110.Bug440110FileTree;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryFileSystem;

public class Bug440110FileSystem
extends MemoryFileSystem {
    public static final String SCHEME = "bug440110";
    private static IFileSystem instance;
    private static boolean fetchedFileTree;

    static {
        fetchedFileTree = false;
    }

    public static void clearFetchedFileTree() {
        fetchedFileTree = false;
    }

    public static IFileSystem getInstance() {
        return instance;
    }

    public static boolean hasFetchedFileTree() {
        return fetchedFileTree;
    }

    public Bug440110FileSystem() {
        instance = this;
    }

    @Override
    public IFileTree fetchFileTree(IFileStore root, IProgressMonitor monitor) throws CoreException {
        fetchedFileTree = true;
        return new Bug440110FileTree(root);
    }

    @Override
    public IFileStore getStore(URI uri) {
        return new Bug440110FileStore(Path.fromPortableString((String)uri.getSchemeSpecificPart()));
    }
}

