/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.filesystem.wrapper;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;

public class WrapperFileStore
extends FileStore {
    private final IFileStore baseStore;

    public WrapperFileStore(IFileStore baseStore) {
        this.baseStore = baseStore;
    }

    public static IFileStore newInstance(Class<? extends WrapperFileStore> clazz, IFileStore baseStore) {
        try {
            return (IFileStore)clazz.getConstructor(IFileStore.class).newInstance(baseStore);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected IFileStore createNewWrappedStore(IFileStore store) {
        return WrapperFileStore.newInstance(((Object)((Object)this)).getClass(), store);
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.childInfos(options, monitor);
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.childNames(options, monitor);
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        IFileStore[] childStores = this.baseStore.childStores(options, monitor);
        int i = 0;
        while (i < childStores.length) {
            childStores[i] = this.createNewWrappedStore(childStores[i]);
            ++i;
        }
        return childStores;
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        this.baseStore.copy(destination, options, monitor);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.baseStore.delete(options, monitor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WrapperFileStore)) {
            return false;
        }
        return this.baseStore.equals(((WrapperFileStore)((Object)obj)).baseStore);
    }

    public IFileInfo fetchInfo() {
        return this.baseStore.fetchInfo();
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.fetchInfo(options, monitor);
    }

    public IFileStore getBaseStore() {
        return this.baseStore;
    }

    @Deprecated
    public IFileStore getChild(IPath path) {
        return this.createNewWrappedStore(this.baseStore.getChild(path));
    }

    public IFileStore getFileStore(IPath path) {
        return this.createNewWrappedStore(this.baseStore.getFileStore(path));
    }

    public IFileStore getChild(String name) {
        return this.createNewWrappedStore(this.baseStore.getChild(name));
    }

    public IFileSystem getFileSystem() {
        return WrapperFileSystem.getInstance();
    }

    public String getName() {
        return this.baseStore.getName();
    }

    public IFileStore getParent() {
        IFileStore baseParent = this.baseStore.getParent();
        return baseParent == null ? null : this.createNewWrappedStore(baseParent);
    }

    public int hashCode() {
        return this.baseStore.hashCode();
    }

    public boolean isParentOf(IFileStore other) {
        if (!(other instanceof WrapperFileStore)) {
            return false;
        }
        IFileStore otherBaseStore = ((WrapperFileStore)other).baseStore;
        return this.baseStore.isParentOf(otherBaseStore);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        this.baseStore.mkdir(options, monitor);
        return this;
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (destination instanceof WrapperFileStore) {
            destination = ((WrapperFileStore)destination).baseStore;
        }
        this.baseStore.move(destination, options, monitor);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.openInputStream(options, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.openOutputStream(options, monitor);
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        this.baseStore.putInfo(info, options, monitor);
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.toLocalFile(options, monitor);
    }

    public URI toURI() {
        return WrapperFileSystem.getWrappedURI(this.baseStore.toURI());
    }
}

