/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class CaseSensitivityTest
extends LocalStoreTest {
    private boolean isCaseSensitive = Workspace.caseSensitive;

    public CaseSensitivityTest() {
    }

    public CaseSensitivityTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(CaseSensitivityTest.class);
    }

    public void testCreateProjects() {
        block4: {
            String projectName = "testProject31415";
            IProject project1 = CaseSensitivityTest.getWorkspace().getRoot().getProject(projectName);
            try {
                project1.create(null);
                project1.open(null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
            }
            IProject project2 = CaseSensitivityTest.getWorkspace().getRoot().getProject(projectName.toUpperCase());
            try {
                project2.create(null);
                project2.open(null);
                CaseSensitivityTest.assertTrue((String)"2.0", (boolean)this.isCaseSensitive);
            }
            catch (CoreException e) {
                if (!this.isCaseSensitive) break block4;
                CaseSensitivityTest.fail((String)"2.1", (Throwable)e);
            }
        }
    }

    public void testCreateFolders() {
        IProject aProject;
        String folderName;
        block6: {
            folderName = "testFolder31415";
            aProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
            IFolder folder1 = aProject.getFolder(folderName);
            try {
                folder1.create(true, true, null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
            }
            IFolder folder2 = aProject.getFolder(folderName.toUpperCase());
            try {
                folder2.create(true, true, null);
                CaseSensitivityTest.assertTrue((String)"2.0", (boolean)this.isCaseSensitive);
            }
            catch (CoreException e) {
                if (!this.isCaseSensitive) break block6;
                CaseSensitivityTest.fail((String)"2.1", (Throwable)e);
            }
        }
        IFile file = aProject.getFile(folderName.toUpperCase());
        try {
            file.create(this.getRandomContents(), true, null);
            CaseSensitivityTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
    }

    public void testCreateFiles() {
        IProject aProject;
        String fileName;
        block6: {
            fileName = "testFile31415";
            aProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
            IFile file1 = aProject.getFile(fileName);
            try {
                file1.create(this.getRandomContents(), true, null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
            }
            IFile file2 = aProject.getFile(fileName.toUpperCase());
            try {
                file2.create(this.getRandomContents(), true, null);
                CaseSensitivityTest.assertTrue((String)"2.0", (boolean)this.isCaseSensitive);
            }
            catch (CoreException e) {
                if (!this.isCaseSensitive) break block6;
                CaseSensitivityTest.fail((String)"2.1", (Throwable)e);
            }
        }
        IFolder folder = aProject.getFolder(fileName.toUpperCase());
        try {
            folder.create(true, true, null);
            CaseSensitivityTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
    }

    public void testRenameProject() {
        block6: {
            String project1name = "project1test31415";
            String project2name = "project2test31415";
            IProject project1 = CaseSensitivityTest.getWorkspace().getRoot().getProject(project1name);
            try {
                project1.create(null);
                project1.open(null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
            }
            IProject project2 = CaseSensitivityTest.getWorkspace().getRoot().getProject(project2name);
            try {
                project2.create(null);
                project2.open(null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"2.0", (Throwable)e);
            }
            try {
                project1.move(Path.ROOT.append(project2.getName().toUpperCase()), true, null);
                CaseSensitivityTest.assertTrue((String)"3.0", (boolean)this.isCaseSensitive);
            }
            catch (CoreException e) {
                if (!this.isCaseSensitive) break block6;
                CaseSensitivityTest.fail((String)"3.99", (Throwable)e);
            }
        }
    }

    public void testRenameFolder() {
        block6: {
            String folder1name = "folder1test31415";
            String folder2name = "folder2test31415";
            IProject aProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
            IFolder folder1 = aProject.getFolder(folder1name);
            try {
                folder1.create(true, true, null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
            }
            IFolder folder2 = aProject.getFolder(folder2name);
            try {
                folder2.create(true, true, null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"2.2", (Throwable)e);
            }
            IFolder folder3 = aProject.getFolder(folder2name.toUpperCase());
            try {
                folder1.move(folder3.getFullPath(), true, null);
                CaseSensitivityTest.assertTrue((String)"3.1", (boolean)this.isCaseSensitive);
            }
            catch (CoreException e) {
                if (!this.isCaseSensitive) break block6;
                CaseSensitivityTest.fail((String)"3.2", (Throwable)e);
            }
        }
    }

    public void testRenameFile() {
        block6: {
            String file1name = "file1test31415";
            String file2name = "file2test31415";
            IProject aProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
            IFile file1 = aProject.getFile(file1name);
            try {
                file1.create(this.getRandomContents(), true, null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
            }
            IFile file2 = aProject.getFile(file2name);
            try {
                file2.create(this.getRandomContents(), true, null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"2.2", (Throwable)e);
            }
            IFile file3 = aProject.getFile(file2name.toUpperCase());
            try {
                file1.move(file3.getFullPath(), true, null);
                CaseSensitivityTest.assertTrue((String)"3.1", (boolean)this.isCaseSensitive);
            }
            catch (CoreException e) {
                if (!this.isCaseSensitive) break block6;
                CaseSensitivityTest.fail((String)"3.2", (Throwable)e);
            }
        }
    }

    public void testCopyAndMoveFolder() {
        String folderName = "folderTest31415";
        IProject sourceProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IProject destinationProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[1];
        IFolder folder1 = sourceProject.getFolder(folderName);
        try {
            folder1.create(true, true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
        }
        IFolder folder2 = destinationProject.getFolder(folderName.toUpperCase());
        try {
            folder2.create(true, true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            folder1.copy(destinationProject.getFullPath().append(folder1.getName()), true, null);
            CaseSensitivityTest.assertTrue((String)"1.2.1", (boolean)this.isCaseSensitive);
        }
        catch (CoreException e) {
            CaseSensitivityTest.assertTrue((String)("1.2.2." + e.getMessage()), (!this.isCaseSensitive ? 1 : 0) != 0);
        }
        try {
            folder1.move(destinationProject.getFullPath().append(folder1.getName()), true, null);
            CaseSensitivityTest.fail((String)"1.3");
        }
        catch (CoreException coreException) {}
    }

    public void testCopyAndMoveFile() {
        IFile file1;
        IProject destinationProject;
        block8: {
            String fileName = "fileTest31415";
            IProject sourceProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
            destinationProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[1];
            file1 = sourceProject.getFile(fileName);
            try {
                file1.create(this.getRandomContents(), true, null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
            }
            IFile file2 = destinationProject.getFile(fileName.toUpperCase());
            try {
                file2.create(this.getRandomContents(), true, null);
            }
            catch (CoreException e) {
                CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
            }
            try {
                file1.copy(destinationProject.getFullPath().append(file1.getName()), true, null);
                CaseSensitivityTest.assertTrue((String)"1.2.1", (boolean)this.isCaseSensitive);
            }
            catch (CoreException e) {
                if (!this.isCaseSensitive) break block8;
                CaseSensitivityTest.fail((String)"1.2.2", (Throwable)e);
            }
        }
        try {
            file1.move(destinationProject.getFullPath().append(file1.getName()), true, null);
            CaseSensitivityTest.fail((String)"1.3");
        }
        catch (CoreException coreException) {}
    }

    public void testCopyAndMoveFolderOverFile() {
        String name = "test31415";
        IProject sourceProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IProject destinationProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[1];
        IFolder folder = sourceProject.getFolder(name);
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
        }
        IFile file = destinationProject.getFile(name.toUpperCase());
        try {
            file.create(this.getRandomContents(), true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            folder.copy(destinationProject.getFullPath().append(folder.getName()), true, null);
            CaseSensitivityTest.assertTrue((String)"1.2.1", (boolean)this.isCaseSensitive);
        }
        catch (CoreException e) {
            CaseSensitivityTest.assertTrue((String)("1.2.2." + e.getMessage()), (!this.isCaseSensitive ? 1 : 0) != 0);
        }
        try {
            folder.move(destinationProject.getFullPath().append(folder.getName()), true, null);
            CaseSensitivityTest.fail((String)"1.3");
        }
        catch (CoreException coreException) {}
    }

    public void testCopyAndMoveFileOverFolder() {
        String name = "test31415";
        IProject sourceProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IProject destinationProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[1];
        IFile file = sourceProject.getFile(name);
        try {
            file.create(this.getRandomContents(), true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
        }
        IFolder folder = destinationProject.getFolder(name.toUpperCase());
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            file.copy(destinationProject.getFullPath().append(file.getName()), true, null);
            CaseSensitivityTest.assertTrue((String)"1.2.1", (boolean)this.isCaseSensitive);
        }
        catch (CoreException e) {
            CaseSensitivityTest.assertTrue((String)("1.2.2." + e.getMessage()), (!this.isCaseSensitive ? 1 : 0) != 0);
        }
        try {
            file.move(destinationProject.getFullPath().append(file.getName()), true, null);
            CaseSensitivityTest.assertTrue((String)"1.3", (boolean)false);
        }
        catch (CoreException coreException) {}
    }

    public void testCopyAndMoveFolderBecomeProject() {
        IProject sourceProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IProject blockingProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[1];
        IFolder folder = sourceProject.getFolder(blockingProject.getName().toUpperCase());
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            folder.move(Path.ROOT.append(folder.getName()), true, null);
            CaseSensitivityTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            folder.copy(Path.ROOT.append(folder.getName()), true, null);
            CaseSensitivityTest.fail((String)"1.2");
        }
        catch (CoreException coreException) {}
    }

    public void testCopyAndMoveProjectBecomeFolder() {
        IProject sourceProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IProject destinationProject = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[1];
        IFile file = destinationProject.getFile(sourceProject.getName().toUpperCase());
        try {
            file.create(this.getRandomContents(), true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            sourceProject.move(destinationProject.getFullPath().append(sourceProject.getName()), true, null);
            CaseSensitivityTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            sourceProject.copy(destinationProject.getFullPath().append(sourceProject.getName()), true, null);
            CaseSensitivityTest.fail((String)"1.2");
        }
        catch (CoreException coreException) {}
    }

    public void testRefreshLocalFolder1() {
        String name = "test31415";
        IProject project = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IFolder folder = project.getFolder(name.toUpperCase());
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
        }
        IFolder herringRouge = project.getFolder(name);
        folder.getLocation().toFile().delete();
        File dir = herringRouge.getLocation().toFile();
        dir.mkdir();
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.2", (Throwable)e);
        }
        CaseSensitivityTest.assertTrue((String)"2.0", (!folder.exists() ? 1 : 0) != 0);
        CaseSensitivityTest.assertTrue((String)"2.1", (boolean)herringRouge.exists());
    }

    public void testRefreshLocalFile1() {
        String name = "test31415";
        IProject project = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IFile file = project.getFile(name.toUpperCase());
        try {
            file.create(this.getRandomContents(), true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
        }
        IFile herringRouge = project.getFile(name);
        this.ensureDoesNotExistInFileSystem((IResource)file);
        this.ensureExistsInFileSystem(herringRouge);
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"3.0", (Throwable)e);
        }
        CaseSensitivityTest.assertTrue((String)"4.0", (!file.exists() ? 1 : 0) != 0);
        CaseSensitivityTest.assertTrue((String)"4.1", (boolean)herringRouge.exists());
    }

    public void testRefreshLocalFolder2() {
        String name = "test31415";
        IProject project = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IFolder folder = project.getFolder(name.toUpperCase());
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
        }
        IFile herringRouge = project.getFile(name);
        this.ensureDoesNotExistInFileSystem((IResource)folder);
        this.ensureExistsInFileSystem(herringRouge);
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"3.0", (Throwable)e);
        }
        CaseSensitivityTest.assertTrue((String)"4.0", (!folder.exists() ? 1 : 0) != 0);
        CaseSensitivityTest.assertTrue((String)"4.1", (boolean)herringRouge.exists());
    }

    public void testRefreshLocalFile2() {
        String name = "test31415";
        IProject project = CaseSensitivityTest.getWorkspace().getRoot().getProjects()[0];
        IFile file = project.getFile(name.toUpperCase());
        try {
            file.create(this.getRandomContents(), true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
        }
        IFolder herringRouge = project.getFolder(name);
        File localFile = file.getLocation().toFile();
        localFile.delete();
        CaseSensitivityTest.assertTrue((String)"2.0", (!localFile.exists() ? 1 : 0) != 0);
        File dir = herringRouge.getLocation().toFile();
        dir.mkdir();
        CaseSensitivityTest.assertTrue((String)"2.1", (boolean)dir.exists());
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"3.0", (Throwable)e);
        }
        CaseSensitivityTest.assertTrue((String)"4.0", (!file.exists() ? 1 : 0) != 0);
        CaseSensitivityTest.assertTrue((String)"4.1", (boolean)herringRouge.exists());
    }

    public void testDeleteResources() {
        String name = "test31415";
        IProject project = CaseSensitivityTest.getWorkspace().getRoot().getProject(name);
        try {
            project.create(null);
            project.open(null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"1.1", (Throwable)e);
        }
        IFolder folder = project.getFolder(name);
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"2.1", (Throwable)e);
        }
        IFile file = folder.getFile(name);
        try {
            file.create(this.getRandomContents(), true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"3.1", (Throwable)e);
        }
        File localFile = file.getLocation().toFile();
        localFile.delete();
        CaseSensitivityTest.assertTrue((String)"4.0", (!localFile.exists() ? 1 : 0) != 0);
        localFile = new File(file.getLocation().removeLastSegments(1).toString(), name.toUpperCase());
        try {
            localFile.createNewFile();
        }
        catch (IOException e) {
            CaseSensitivityTest.fail((String)"4.1", (Throwable)e);
        }
        CaseSensitivityTest.assertTrue((String)"4.2", (boolean)localFile.exists());
        try {
            file.delete(true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"5.0", (Throwable)e);
        }
        localFile.delete();
        CaseSensitivityTest.assertTrue((String)"6.0", (!localFile.exists() ? 1 : 0) != 0);
        File localFolder = folder.getLocation().toFile();
        localFolder.delete();
        CaseSensitivityTest.assertTrue((String)"7.0", (!localFolder.exists() ? 1 : 0) != 0);
        localFolder = new File(folder.getLocation().removeLastSegments(1).toString(), name.toUpperCase());
        localFolder.mkdir();
        CaseSensitivityTest.assertTrue((String)"7.1", (boolean)localFolder.exists());
        try {
            folder.delete(true, null);
        }
        catch (CoreException e) {
            CaseSensitivityTest.fail((String)"8.0", (Throwable)e);
        }
    }
}

