/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class SafeChunkyInputOutputStreamTest
extends LocalStoreTest {
    protected File temp;
    private List<SafeChunkyOutputStream> streams;
    private File target;

    public SafeChunkyInputOutputStreamTest() {
    }

    public SafeChunkyInputOutputStreamTest(String name) {
        super(name);
    }

    protected boolean compare(byte[] source, byte[] target1) {
        SafeChunkyInputOutputStreamTest.assertEquals((int)source.length, (int)target1.length);
        int i = 0;
        while (i < target1.length) {
            SafeChunkyInputOutputStreamTest.assertEquals((byte)source[i], (byte)target1[i]);
            ++i;
        }
        return true;
    }

    protected byte[] merge(byte[] b1, byte[] b2) {
        byte[] result = new byte[b1.length + b2.length];
        int i = 0;
        while (i < b1.length) {
            result[i] = b1[i];
            ++i;
        }
        i = 0;
        while (i < b2.length) {
            result[b1.length + i] = b2[i];
            ++i;
        }
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.streams = new ArrayList<SafeChunkyOutputStream>();
        IPath location = this.getRandomLocation();
        this.temp = location.append("temp").toFile();
        this.temp.mkdirs();
        SafeChunkyInputOutputStreamTest.assertTrue((String)"could not create temp directory", (boolean)this.temp.isDirectory());
        this.target = new File(this.temp, "target");
    }

    public static Test suite() {
        return new TestSuite(SafeChunkyInputOutputStreamTest.class);
    }

    @Override
    protected void tearDown() throws Exception {
        for (SafeChunkyOutputStream stream : this.streams) {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
        this.ensureDoesNotExistInFileSystem(this.temp.getParentFile());
        super.tearDown();
    }

    public void testBufferLimit() throws Exception {
        Workspace.clear((File)this.target);
        SafeChunkyInputOutputStreamTest.assertTrue((!this.target.exists() ? 1 : 0) != 0);
        int bufferSize = 10024;
        byte[] chunk = this.getBigContents(bufferSize);
        Throwable throwable = null;
        Object var4_6 = null;
        try (SafeChunkyOutputStream output = new SafeChunkyOutputStream(this.target);){
            output.write(chunk);
            output.succeed();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try (SafeChunkyInputStream input = new SafeChunkyInputStream(this.target);){
            byte[] read = new byte[chunk.length];
            SafeChunkyInputOutputStreamTest.assertEquals((int)chunk.length, (int)input.read(read));
            SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk, read));
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Workspace.clear((File)this.target);
    }

    public void testFailure() throws Exception {
        Workspace.clear((File)this.target);
        SafeChunkyInputOutputStreamTest.assertTrue((!this.target.exists() ? 1 : 0) != 0);
        byte[] fakeEnd = new byte[ILocalStoreConstants.END_CHUNK.length];
        System.arraycopy(ILocalStoreConstants.END_CHUNK, 0, fakeEnd, 0, ILocalStoreConstants.END_CHUNK.length);
        fakeEnd[fakeEnd.length - 1] = 86;
        byte[] chunk1 = this.getRandomString().getBytes();
        byte[] chunk2 = this.getRandomString().getBytes();
        byte[] chunk3 = this.getRandomString().getBytes();
        byte[] chunk4 = this.getRandomString().getBytes();
        byte[] chunk5 = this.getRandomString().getBytes();
        byte[] chunk6 = this.getRandomString().getBytes();
        try (SafeChunkyOutputStream output = new SafeChunkyOutputStream(this.target);){
            output.write(chunk1);
            output.succeed();
            this.doNothing(output);
            output = new SafeChunkyOutputStream(this.target);
            output.write(chunk2);
            output.write(ILocalStoreConstants.BEGIN_CHUNK);
            output.succeed();
            this.doNothing(output);
            output = new SafeChunkyOutputStream(this.target);
            output.write(chunk3);
            output.succeed();
            this.doNothing(output);
            output = new SafeChunkyOutputStream(this.target);
            output.write(chunk4);
            output.write(ILocalStoreConstants.END_CHUNK);
            output.succeed();
            this.doNothing(output);
            output = new SafeChunkyOutputStream(this.target);
            output.write(chunk5);
            output.succeed();
            output.write(fakeEnd);
            output.write(chunk6);
            output.succeed();
        }
        Throwable throwable = null;
        Object var10_12 = null;
        try (SafeChunkyInputStream input = new SafeChunkyInputStream(this.target);){
            byte[] read1 = new byte[chunk1.length];
            byte[] read3 = new byte[chunk3.length];
            byte[] read4 = new byte[chunk4.length];
            byte[] read5 = new byte[chunk5.length];
            byte[] read6 = new byte[fakeEnd.length + chunk6.length];
            SafeChunkyInputOutputStreamTest.assertEquals((int)chunk1.length, (int)input.read(read1));
            SafeChunkyInputOutputStreamTest.assertEquals((int)chunk3.length, (int)input.read(read3));
            SafeChunkyInputOutputStreamTest.assertEquals((int)chunk4.length, (int)input.read(read4));
            SafeChunkyInputOutputStreamTest.assertEquals((int)chunk5.length, (int)input.read(read5));
            SafeChunkyInputOutputStreamTest.assertEquals((int)(fakeEnd.length + chunk6.length), (int)input.read(read6));
            SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk1, read1));
            SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk3, read3));
            SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk4, read4));
            SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk5, read5));
            byte[] expected = this.merge(fakeEnd, chunk6);
            SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(expected, read6));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void doNothing(SafeChunkyOutputStream output) {
        this.streams.add(output);
    }

    public void testAlmostEmpty() throws Exception {
        Workspace.clear((File)this.target);
        SafeChunkyInputOutputStreamTest.assertTrue((!this.target.exists() ? 1 : 0) != 0);
        Throwable throwable = null;
        Object var2_4 = null;
        try (SafeChunkyOutputStream output = new SafeChunkyOutputStream(this.target);){
            output.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        try {
            throwable = null;
            var2_4 = null;
            try (DataInputStream input = new DataInputStream((InputStream)new SafeChunkyInputStream(this.target));){
                input.readUTF();
                SafeChunkyInputOutputStreamTest.fail((String)"Should throw EOFException");
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (EOFException eOFException) {}
    }

    public void testSimple() throws Exception {
        Workspace.clear((File)this.target);
        SafeChunkyInputOutputStreamTest.assertTrue((!this.target.exists() ? 1 : 0) != 0);
        byte[] chunk1 = this.getRandomString().getBytes();
        byte[] chunk2 = this.getRandomString().getBytes();
        byte[] chunk3 = this.getRandomString().getBytes();
        byte[] chunk4 = this.getRandomString().getBytes();
        byte[] chunk5 = this.getRandomString().getBytes();
        Throwable throwable = null;
        Object var7_9 = null;
        try (SafeChunkyOutputStream output = new SafeChunkyOutputStream(this.target);){
            output.write(chunk1);
            output.succeed();
            output.write(chunk2);
            output.succeed();
            output.write(chunk3);
            output.succeed();
            output.write(chunk4);
            output.succeed();
            output.write(chunk5);
            output.succeed();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        try {
            throwable = null;
            var7_9 = null;
            try (SafeChunkyInputStream input = new SafeChunkyInputStream(this.target);){
                byte[] read1 = new byte[chunk1.length];
                byte[] read2 = new byte[chunk2.length];
                byte[] read3 = new byte[chunk3.length];
                byte[] read4 = new byte[chunk4.length];
                byte[] read5 = new byte[chunk5.length];
                SafeChunkyInputOutputStreamTest.assertEquals((int)chunk1.length, (int)input.read(read1));
                SafeChunkyInputOutputStreamTest.assertEquals((int)chunk2.length, (int)input.read(read2));
                SafeChunkyInputOutputStreamTest.assertEquals((int)chunk3.length, (int)input.read(read3));
                SafeChunkyInputOutputStreamTest.assertEquals((int)chunk4.length, (int)input.read(read4));
                SafeChunkyInputOutputStreamTest.assertEquals((int)chunk5.length, (int)input.read(read5));
                SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk1, read1));
                SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk2, read2));
                SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk3, read3));
                SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk4, read4));
                SafeChunkyInputOutputStreamTest.assertTrue((boolean)this.compare(chunk5, read5));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            Workspace.clear((File)this.target);
        }
    }
}

