/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTree;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;
import org.eclipse.core.tests.internal.localstore.Test342968FileSystem;

public class UnifiedTreeTest
extends LocalStoreTest {
    protected static int limit = 10;

    public UnifiedTreeTest() {
    }

    public UnifiedTreeTest(String name) {
        super(name);
    }

    protected void createFiles(IFileStore folder, Hashtable<String, String> set) throws Exception {
        int i = 0;
        while (i < limit) {
            IFileStore child = folder.getChild("fsFile" + i);
            OutputStream out = null;
            try {
                out = child.openOutputStream(0, null);
                out.write("contents".getBytes());
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            set.put(child.toString(), "");
            ++i;
        }
    }

    protected void createFiles(IContainer target, Hashtable<String, String> set) throws CoreException {
        Workspace workspace = (Workspace)UnifiedTreeTest.getWorkspace();
        IWorkspaceRunnable operation = monitor -> {
            int i = 0;
            while (i < limit) {
                IFile child = target.getFile((IPath)new Path("wbFile" + i));
                workspace.createResource((IResource)child, false);
                String location = child.getLocation().toOSString();
                set.put(location, "");
                ++i;
            }
        };
        workspace.run(operation, null);
    }

    protected void createResourcesInFileSystem(IFileStore folder, Hashtable<String, String> set) throws Exception {
        this.createFiles(folder, set);
        int i = 0;
        while (i < limit) {
            IFileStore child = folder.getChild("fsFolder" + i);
            child.mkdir(0, null);
            set.put(child.toString(), "");
            if (i < limit / 2) {
                this.createFiles(child, set);
            }
            ++i;
        }
    }

    protected void createResourcesInWorkspace(IContainer target, Hashtable<String, String> set) throws CoreException {
        this.createFiles(target, set);
        int i = 0;
        while (i < limit) {
            IFolder child = target.getFolder((IPath)new Path("wbFolder" + i));
            child.create(true, true, null);
            String location = child.getLocation().toOSString();
            set.put(location, "");
            if (i < limit / 2) {
                this.createFiles((IContainer)child, set);
            }
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(UnifiedTreeTest.class);
    }

    public void testTraverseMechanismInFolder() throws Throwable {
        IProject project = this.projects[0];
        IFolder folder = project.getFolder("root");
        folder.create(true, true, null);
        Hashtable<String, String> set = new Hashtable<String, String>();
        this.createResourcesInWorkspace((IContainer)folder, set);
        this.createResourcesInFileSystem(((Resource)folder).getStore(), set);
        IUnifiedTreeVisitor visitor = node -> {
            IResource resource = node.getResource();
            IFileStore store = ((Resource)resource).getStore();
            if (node.existsInFileSystem()) {
                UnifiedTreeTest.assertEquals((String)"1.0", (String)store.fetchInfo().getName(), (String)node.getLocalName());
            }
            UnifiedTreeTest.assertEquals((String)"1.1", (Object)store, (Object)node.getStore());
            set.remove(resource.getLocation().toOSString());
            return true;
        };
        UnifiedTree tree = new UnifiedTree((IResource)folder);
        tree.accept(visitor);
        UnifiedTreeTest.assertTrue((String)"2.0", (boolean)set.isEmpty());
    }

    public void testTraverseMechanismInFolderSkippingSomeChildren() throws Throwable {
        IProject project = this.projects[0];
        IFolder folder = project.getFolder("root");
        folder.create(true, true, null);
        Hashtable<String, String> set = new Hashtable<String, String>();
        this.createResourcesInWorkspace((IContainer)folder, set);
        this.createResourcesInFileSystem(((Resource)folder).getStore(), set);
        IUnifiedTreeVisitor visitor = node -> {
            IResource resource = node.getResource();
            IFileStore store = ((Resource)resource).getStore();
            String key = store.fetchInfo().getName();
            if (node.existsInFileSystem()) {
                UnifiedTreeTest.assertEquals((String)"1.0", (String)key, (String)node.getLocalName());
            }
            UnifiedTreeTest.assertEquals((String)"1.1", (Object)store, (Object)node.getStore());
            node.getChildren();
            if (resource.getName().startsWith("fsFolder")) {
                return false;
            }
            set.remove(resource.getLocation().toOSString());
            return true;
        };
        int initialSize = set.size();
        UnifiedTree tree = new UnifiedTree((IResource)folder);
        tree.accept(visitor);
        UnifiedTreeTest.assertTrue((String)"2.0", (!set.isEmpty() ? 1 : 0) != 0);
        UnifiedTreeTest.assertTrue((String)"2.1", (set.size() != initialSize ? 1 : 0) != 0);
    }

    public void testTraverseMechanismInProject() throws Throwable {
        IProject project = this.projects[0];
        Hashtable<String, String> set = new Hashtable<String, String>();
        this.createResourcesInWorkspace((IContainer)project, set);
        this.createResourcesInFileSystem(((Resource)project).getStore(), set);
        IUnifiedTreeVisitor visitor = node -> {
            IResource resource = node.getResource();
            IFileStore store = ((Resource)resource).getStore();
            if (node.existsInFileSystem()) {
                UnifiedTreeTest.assertEquals((String)"1.0", (String)store.fetchInfo().getName(), (String)node.getLocalName());
            }
            UnifiedTreeTest.assertEquals((String)"1.1", (Object)store, (Object)node.getStore());
            set.remove(resource.getLocation().toOSString());
            return true;
        };
        UnifiedTree tree = new UnifiedTree((IResource)project);
        tree.accept(visitor);
        UnifiedTreeTest.assertTrue((String)"2.0", (boolean)set.isEmpty());
    }

    public void test342968() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        this.ensureExistsInWorkspace((IResource)project, true);
        project.open(this.getMonitor());
        IProjectDescription description = project.getDescription();
        URI projectLocation = Test342968FileSystem.getTestUriFor(EFS.getLocalFileSystem().fromLocalFile(new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), "test")).toURI());
        description.setLocationURI(projectLocation);
        project.delete(false, false, null);
        project.create(description, 0, null);
        project.open(this.getMonitor());
        UnifiedTreeTest.assertTrue((boolean)project.getLocationURI().equals(projectLocation));
        IFolder link = project.getFolder("link");
        File file = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), "link");
        file.mkdir();
        link.createLink(EFS.getLocalFileSystem().fromLocalFile(file).toURI(), 0, null);
        IFile rf = link.getFile("fileTest342968.txt");
        rf.create((InputStream)new ByteArrayInputStream("test342968".getBytes()), false, null);
        UnifiedTreeTest.assertTrue((String)"1.0", (boolean)rf.exists());
        project.refreshLocal(2, null);
        UnifiedTreeTest.assertTrue((String)"2.0", (boolean)rf.exists());
    }

    public void test368376() throws CoreException, IOException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        String filePath = "a/b/c/file.txt";
        File javaFile = new File(project.getLocation().toFile(), filePath);
        UnifiedTreeTest.assertTrue((boolean)javaFile.getParentFile().mkdirs());
        UnifiedTreeTest.assertTrue((boolean)javaFile.createNewFile());
        IFolder folder = project.getFolder("a");
        IFile file = project.getFile(filePath);
        UnifiedTreeTest.assertFalse((boolean)folder.exists());
        UnifiedTreeTest.assertFalse((boolean)file.exists());
        file.refreshLocal(2, this.getMonitor());
        UnifiedTreeTest.assertTrue((boolean)folder.exists());
        UnifiedTreeTest.assertTrue((boolean)file.exists());
        UnifiedTreeTest.assertTrue((boolean)folder.isSynchronized(2));
        project.delete(true, this.getMonitor());
    }
}

