/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.IPathConstants;
import org.eclipse.core.tests.internal.watson.TestUtil;
import org.eclipse.core.tests.internal.watson.WatsonTest;

public abstract class ElementTreeSerializationTest
extends WatsonTest
implements IPathConstants {
    protected ElementTree fTree;
    String root = System.getProperty("java.io.tmpdir");
    protected File tempFile = new File(String.valueOf(this.root) + "/temp/TestFlattening");
    WriterThread writerThread = new WriterThread();
    ReaderThread readerThread = new ReaderThread();
    protected IPath fSubtreePath;
    protected int fDepth;

    public ElementTreeSerializationTest() {
        super(null);
    }

    public ElementTreeSerializationTest(String name) {
        super(name);
    }

    protected void doExhaustiveTests() {
        IPath[] paths = TestUtil.getTreePaths();
        int[] depths = this.getTreeDepths();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            int[] nArray = depths;
            int n3 = depths.length;
            int n4 = 0;
            while (n4 < n3) {
                int depth = nArray[n4];
                this.doTest(path, depth);
                ++n4;
            }
            ++n2;
        }
    }

    public Object doFileTest() {
        DataInputStream dis;
        FileInputStream fis;
        ElementTreeReader reader;
        Object newTree;
        block26: {
            IElementInfoFlattener fac = this.getFlattener();
            newTree = null;
            ElementTreeWriter writer = new ElementTreeWriter(fac);
            reader = new ElementTreeReader(fac);
            FileOutputStream fos = null;
            fis = null;
            DataOutputStream dos = null;
            dis = null;
            try {
                File dir = this.tempFile.getParentFile();
                dir.mkdirs();
                fos = new FileOutputStream(this.tempFile);
                dos = new DataOutputStream(fos);
            }
            catch (IOException e) {
                e.printStackTrace();
                ElementTreeSerializationTest.assertTrue((String)"Unable to open ouput file", (boolean)false);
            }
            try {
                try {
                    this.doWrite(writer, dos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ElementTreeSerializationTest.assertTrue((String)"Error writing tree to file", (boolean)false);
                    try {
                        dos.flush();
                        fos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        ElementTreeSerializationTest.assertTrue((String)"Unable to close output file!", (boolean)false);
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                try {
                    dos.flush();
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ElementTreeSerializationTest.assertTrue((String)"Unable to close output file!", (boolean)false);
                }
                throw throwable;
            }
            try {
                dos.flush();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                ElementTreeSerializationTest.assertTrue((String)"Unable to close output file!", (boolean)false);
            }
        }
        try {
            fis = new FileInputStream(this.tempFile);
            dis = new DataInputStream(fis);
        }
        catch (IOException e) {
            e.printStackTrace();
            ElementTreeSerializationTest.assertTrue((String)"Unable to open input file", (boolean)false);
        }
        try {
            try {
                newTree = this.doRead(reader, dis);
            }
            catch (IOException e) {
                e.printStackTrace();
                ElementTreeSerializationTest.assertTrue((String)"Error reading tree from file", (boolean)false);
                try {
                    fis.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    ElementTreeSerializationTest.assertTrue((String)"Unable to close input file!", (boolean)false);
                }
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                ElementTreeSerializationTest.assertTrue((String)"Unable to close input file!", (boolean)false);
            }
        }
        return newTree;
    }

    public Object doPipeTest() {
        IElementInfoFlattener fac = this.getFlattener();
        Object refried = null;
        ElementTreeWriter w = new ElementTreeWriter(fac);
        ElementTreeReader r = new ElementTreeReader(fac);
        try {
            PipedOutputStream pout = new PipedOutputStream();
            PipedInputStream pin = new PipedInputStream(pout);
            DataOutputStream oos = new DataOutputStream(pout);
            DataInputStream ois = new DataInputStream(pin);
            this.writerThread.setStream(oos);
            this.readerThread.setStream(ois);
            this.writerThread.setWriter(w);
            this.readerThread.setReader(r);
            Thread thread1 = new Thread(this.writerThread);
            Thread thread2 = new Thread(this.readerThread);
            thread1.start();
            thread2.start();
            while (thread2.isAlive()) {
                try {
                    thread2.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            refried = this.readerThread.getReconstitutedObject();
            ois.close();
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            ElementTreeSerializationTest.assertTrue((String)"Unable to open stream:", (boolean)false);
        }
        return refried;
    }

    public abstract Object doRead(ElementTreeReader var1, DataInputStream var2) throws IOException;

    public abstract void doTest(IPath var1, int var2);

    public abstract void doWrite(ElementTreeWriter var1, DataOutputStream var2) throws IOException;

    public IElementInfoFlattener getFlattener() {
        return new IElementInfoFlattener(){

            public void writeElement(IPath path, Object data, DataOutput output) throws IOException {
                if (data == null) {
                    output.writeUTF("null");
                } else {
                    output.writeUTF((String)data);
                }
            }

            public Object readElement(IPath path, DataInput input) throws IOException {
                String data = input.readUTF();
                if ("null".equals(data)) {
                    return null;
                }
                return data;
            }
        };
    }

    protected int[] getTreeDepths() {
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        return nArray;
    }

    protected void setUp() throws Exception {
        this.fTree = TestUtil.createTestElementTree();
        this.fSubtreePath = solution;
        this.fDepth = -1;
    }

    protected void tearDown() throws Exception {
        this.tempFile.delete();
    }

    class ReaderThread
    implements Runnable {
        DataInputStream fDataInputStream;
        ElementTreeReader fReader;
        Object fRefried;

        ReaderThread() {
        }

        public void setStream(DataInputStream stream) {
            this.fDataInputStream = stream;
        }

        public void setReader(ElementTreeReader reader) {
            this.fReader = reader;
        }

        public Object getReconstitutedObject() {
            return this.fRefried;
        }

        @Override
        public void run() {
            try {
                this.fRefried = ElementTreeSerializationTest.this.doRead(this.fReader, this.fDataInputStream);
            }
            catch (IOException e) {
                ElementTreeSerializationTest.assertTrue((String)"Error reading delta", (boolean)false);
                e.printStackTrace();
            }
        }
    }

    class WriterThread
    implements Runnable {
        DataOutputStream fDataOutputStream;
        ElementTreeWriter fWriter;

        WriterThread() {
        }

        public void setStream(DataOutputStream stream) {
            this.fDataOutputStream = stream;
        }

        public void setWriter(ElementTreeWriter writer) {
            this.fWriter = writer;
        }

        @Override
        public void run() {
            try {
                ElementTreeSerializationTest.this.doWrite(this.fWriter, this.fDataOutputStream);
            }
            catch (IOException e) {
                ElementTreeSerializationTest.assertTrue((String)"Error writing delta", (boolean)false);
                e.printStackTrace();
            }
        }
    }
}

