/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.ResourceVisitorVerifier;

public class HiddenResourceTest
extends ResourceTest {
    public HiddenResourceTest() {
    }

    public HiddenResourceTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(HiddenResourceTest.class);
    }

    public void testRefreshLocal() {
        IWorkspaceRoot root = HiddenResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        this.ensureExistsInWorkspace(resources, true);
        ResourceDeltaVerifier listener = new ResourceDeltaVerifier();
        listener.addExpectedChange((IResource)subFile, 4, 256);
        HiddenResourceTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            this.setHidden("3.0", (IResource)folder, true, 0);
            this.ensureOutOfSync(subFile);
            try {
                project.refreshLocal(2, this.getMonitor());
                HiddenResourceTest.assertTrue((String)listener.getMessage(), (boolean)listener.isDeltaValid());
            }
            catch (CoreException e) {
                HiddenResourceTest.fail((String)"3.1", (Throwable)e);
            }
        }
        finally {
            HiddenResourceTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testFindMember() {
        IWorkspaceRoot root = HiddenResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        this.ensureExistsInWorkspace(resources, true);
        HiddenResourceTest.assertEquals((String)"1.0", (Object)project, (Object)root.findMember(project.getFullPath()));
        HiddenResourceTest.assertEquals((String)"1.1", (Object)folder, (Object)root.findMember(folder.getFullPath()));
        HiddenResourceTest.assertEquals((String)"1.2", (Object)file, (Object)root.findMember(file.getFullPath()));
        HiddenResourceTest.assertEquals((String)"1.3", (Object)subFile, (Object)root.findMember(subFile.getFullPath()));
        this.setHidden("2.0", (IResource)folder, true, 0);
        HiddenResourceTest.assertEquals((String)"2.1", (Object)project, (Object)root.findMember(project.getFullPath()));
        HiddenResourceTest.assertEquals((String)"2.2", (Object)folder, (Object)root.findMember(folder.getFullPath()));
        HiddenResourceTest.assertEquals((String)"2.3", (Object)file, (Object)root.findMember(file.getFullPath()));
        HiddenResourceTest.assertEquals((String)"2.4", (Object)subFile, (Object)root.findMember(subFile.getFullPath()));
        this.setHidden("3.0", (IResource)project, true, 2);
        HiddenResourceTest.assertEquals((String)"3.1", (Object)project, (Object)root.findMember(project.getFullPath()));
        HiddenResourceTest.assertEquals((String)"3.2", (Object)folder, (Object)root.findMember(folder.getFullPath()));
        HiddenResourceTest.assertEquals((String)"3.3", (Object)file, (Object)root.findMember(file.getFullPath()));
        HiddenResourceTest.assertEquals((String)"3.4", (Object)subFile, (Object)root.findMember(subFile.getFullPath()));
    }

    public void testMembers() {
        IProject project = HiddenResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        IResource[] members = null;
        this.ensureExistsInWorkspace(resources, true);
        this.assertHidden("1.0", (IResource)project, false, 2);
        try {
            members = project.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.0", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"2.1", (int)3, (int)members.length);
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.2", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"2.3", (int)1, (int)members.length);
        this.setHidden("3.0", (IResource)project, true, 2);
        this.assertHidden("3.1", (IResource)project, true, 2);
        this.assertHidden("4.0", (IResource)project, true, 2);
        try {
            members = project.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"5.0", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"5.1", (int)0, (int)members.length);
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"5.2", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"5.3", (int)0, (int)members.length);
        this.setHidden("6.0", (IResource)project, false, 2);
        this.assertHidden("6.1", (IResource)project, false, 2);
        try {
            members = project.members(0);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"7.0", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"7.1", (int)3, (int)members.length);
        try {
            members = project.members(8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"7.2", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"7.3", (int)3, (int)members.length);
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"7.4", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"7.5", (int)1, (int)members.length);
        this.setHidden("8.0", (IResource)folder, true, 0);
        try {
            members = project.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"8.1", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"8.2", (int)2, (int)members.length);
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"8.3", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"8.4", (int)1, (int)members.length);
        try {
            members = project.members(0);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"8.5", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"8.6", (int)2, (int)members.length);
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"8.7", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"8.8", (int)1, (int)members.length);
        try {
            members = project.members(8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"8.9", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"8.10", (int)3, (int)members.length);
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"8.11", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"8.12", (int)1, (int)members.length);
        this.setHidden("9.0", (IResource)project, true, 2);
        this.assertHidden("9.1", (IResource)project, true, 2);
        try {
            members = project.members(0);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"9.2", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"9.3", (int)0, (int)members.length);
        try {
            members = folder.members(0);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"9.4", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"9.5", (int)0, (int)members.length);
        try {
            members = project.members(8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"9.6", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"9.7", (int)3, (int)members.length);
        try {
            members = folder.members(8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"9.8", (Throwable)e);
        }
        HiddenResourceTest.assertEquals((String)"9.9", (int)1, (int)members.length);
    }

    public void testAccept() {
        IProject project = HiddenResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        this.ensureExistsInWorkspace(resources, true);
        IFile description = project.getFile(".project");
        ResourceVisitorVerifier visitor = new ResourceVisitorVerifier();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        try {
            project.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.0", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("1.1." + visitor.getMessage()), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        try {
            project.accept((IResourceVisitor)visitor, 2, 0);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.2", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("1.3." + visitor.getMessage()), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        try {
            project.accept((IResourceVisitor)visitor, 2, 8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.4", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("1.5." + visitor.getMessage()), (boolean)visitor.isValid());
        this.setHidden("2.0", (IResource)folder, true, 0);
        visitor.reset();
        visitor.addExpected((IResource)project);
        visitor.addExpected((IResource)file);
        visitor.addExpected((IResource)description);
        try {
            project.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.1", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("2.2." + visitor.getMessage()), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected((IResource)project);
        visitor.addExpected((IResource)file);
        visitor.addExpected((IResource)description);
        try {
            project.accept((IResourceVisitor)visitor, 2, 0);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.3", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("2.4." + visitor.getMessage()), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        try {
            project.accept((IResourceVisitor)visitor, 2, 8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.5", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("2.6." + visitor.getMessage()), (boolean)visitor.isValid());
        visitor.reset();
        try {
            folder.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.7", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("2.8." + visitor.getMessage()), (boolean)visitor.isValid());
        visitor.reset();
        try {
            folder.accept((IResourceVisitor)visitor, 2, 0);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.9", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("2.10." + visitor.getMessage()), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected((IResource)folder);
        visitor.addExpected((IResource)subFile);
        try {
            folder.accept((IResourceVisitor)visitor, 2, 8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.11", (Throwable)e);
        }
        HiddenResourceTest.assertTrue((String)("2.11." + visitor.getMessage()), (boolean)visitor.isValid());
    }

    public void testCopy() {
        IWorkspaceRoot root = HiddenResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        this.ensureExistsInWorkspace(resources, true);
        IProject destProject = root.getProject("MyOtherProject");
        IFolder destFolder = destProject.getFolder(folder.getName());
        IFile destFile = destProject.getFile(file.getName());
        IFile destSubFile = destFolder.getFile(subFile.getName());
        IResource[] destResources = new IResource[]{destProject, destFolder, destFile, destSubFile};
        this.ensureDoesNotExistInWorkspace(destResources);
        this.setHidden("1.0", (IResource)folder, true, 0);
        int flags = 1;
        try {
            project.copy(destProject.getFullPath(), flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.1", (Throwable)e);
        }
        this.assertExistsInWorkspace("1.2", resources);
        this.assertExistsInWorkspace("1.3", destResources);
        this.ensureDoesNotExistInWorkspace(destResources);
        this.ensureExistsInWorkspace(resources, true);
        this.ensureExistsInWorkspace((IResource)destProject, true);
        this.setHidden("2.0", (IResource)folder, true, 0);
        try {
            folder.copy(destFolder.getFullPath(), flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.1", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.2", new IResource[]{folder, subFile});
        this.assertExistsInWorkspace("2.3", new IResource[]{destFolder, destSubFile});
        this.ensureDoesNotExistInWorkspace(destResources);
        this.ensureExistsInWorkspace(resources, true);
        this.setHidden("3.0", (IResource)project, true, 2);
        try {
            project.copy(destProject.getFullPath(), flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"3.1", (Throwable)e);
        }
        this.assertExistsInWorkspace("3.2", resources);
        this.assertExistsInWorkspace("3.3", destResources);
        this.ensureDoesNotExistInWorkspace(destResources);
        this.ensureExistsInWorkspace(resources, true);
        this.ensureExistsInWorkspace((IResource)destProject, true);
        this.setHidden("4.0", (IResource)project, true, 2);
        try {
            folder.copy(destFolder.getFullPath(), flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"4.1", (Throwable)e);
        }
        this.assertExistsInWorkspace("4.2", new IResource[]{folder, subFile});
        this.assertExistsInWorkspace("4.3", new IResource[]{destFolder, destSubFile});
    }

    public void testMove() {
        IWorkspaceRoot root = HiddenResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        this.ensureExistsInWorkspace(resources, true);
        IProject destProject = root.getProject("MyOtherProject");
        IFolder destFolder = destProject.getFolder(folder.getName());
        IFile destFile = destProject.getFile(file.getName());
        IFile destSubFile = destFolder.getFile(subFile.getName());
        IResource[] destResources = new IResource[]{destProject, destFolder, destFile, destSubFile};
        this.ensureDoesNotExistInWorkspace(destResources);
        this.setHidden("1.0", (IResource)folder, true, 0);
        int flags = 1;
        try {
            project.move(destProject.getFullPath(), flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.1", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("1.2", resources);
        this.assertExistsInWorkspace("1.3", destResources);
        this.ensureDoesNotExistInWorkspace(destResources);
        this.ensureExistsInWorkspace(resources, true);
        this.ensureExistsInWorkspace((IResource)destProject, true);
        this.setHidden("2.0", (IResource)folder, true, 0);
        try {
            folder.move(destFolder.getFullPath(), flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.1", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("2.2", new IResource[]{folder, subFile});
        this.assertExistsInWorkspace("2.3", new IResource[]{destFolder, destSubFile});
        this.ensureDoesNotExistInWorkspace(destResources);
        this.ensureExistsInWorkspace(resources, true);
        this.setHidden("3.0", (IResource)project, true, 2);
        try {
            project.move(destProject.getFullPath(), flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"3.1", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("3.2", resources);
        this.assertExistsInWorkspace("3.3", destResources);
        this.ensureDoesNotExistInWorkspace(destResources);
        this.ensureExistsInWorkspace(resources, true);
        this.ensureExistsInWorkspace((IResource)destProject, true);
        this.setHidden("4.0", (IResource)project, true, 2);
        try {
            folder.move(destFolder.getFullPath(), flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"4.1", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("4.2", new IResource[]{folder, subFile});
        this.assertExistsInWorkspace("4.3", new IResource[]{destFolder, destSubFile});
    }

    public void testDelete() {
        IWorkspaceRoot root = HiddenResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        this.ensureExistsInWorkspace(resources, true);
        int flags = 5;
        try {
            project.delete(flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.0", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("1.1", resources);
        this.ensureExistsInWorkspace(resources, true);
        try {
            file.delete(flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("1.3", (IResource)file);
        this.assertExistsInWorkspace("1.4", new IResource[]{project, folder, subFile});
        this.ensureExistsInWorkspace(resources, true);
        try {
            folder.delete(flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.5", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("1.6", new IResource[]{folder, subFile});
        this.assertExistsInWorkspace("1.7", new IResource[]{project, file});
        this.ensureExistsInWorkspace(resources, true);
        this.setHidden("2.0", (IResource)folder, true, 0);
        try {
            project.delete(flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.1", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("2.2", resources);
        this.ensureExistsInWorkspace(resources, true);
        this.setHidden("2.3", (IResource)folder, true, 0);
        try {
            folder.delete(flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"2.4", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("2.5", new IResource[]{folder, subFile});
        this.assertExistsInWorkspace("2.6", new IResource[]{project, file});
        this.ensureExistsInWorkspace(resources, true);
        this.setHidden("3.0", (IResource)project, true, 2);
        try {
            project.delete(flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"3.1", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("3.2", resources);
        this.ensureExistsInWorkspace(resources, true);
        this.setHidden("3.3", (IResource)project, true, 2);
        try {
            file.delete(flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"3.4", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("3.5", (IResource)file);
        this.assertExistsInWorkspace("3.6", new IResource[]{project, folder, subFile});
        this.ensureExistsInWorkspace(resources, true);
        this.setHidden("3.7", (IResource)project, true, 2);
        try {
            folder.delete(flags, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"3.8", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("3.9", new IResource[]{folder, subFile});
        this.assertExistsInWorkspace("3.10", new IResource[]{project, file});
    }

    public void testDeltas() {
        IWorkspaceRunnable body;
        IWorkspaceRoot root = HiddenResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IFile description = project.getFile(".project");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceDeltaVerifier listener = new ResourceDeltaVerifier();
        HiddenResourceTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            body = monitor -> this.ensureExistsInWorkspace(resources, true);
            try {
                listener.addExpectedChange(resources, 1, 0);
                listener.addExpectedChange((IResource)project, 1, 16384);
                listener.addExpectedChange((IResource)description, 1, 0);
                HiddenResourceTest.getWorkspace().run(body, this.getMonitor());
                this.waitForBuild();
                HiddenResourceTest.assertTrue((String)("1.0." + listener.getMessage()), (boolean)listener.isDeltaValid());
                this.ensureDoesNotExistInWorkspace(resources);
            }
            catch (CoreException e) {
                HiddenResourceTest.fail((String)"1.1", (Throwable)e);
            }
        }
        finally {
            HiddenResourceTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
        HiddenResourceTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            body = monitor -> {
                this.ensureExistsInWorkspace(resources, true);
                this.setHidden("2.0", (IResource)folder, true, 0);
            };
            try {
                listener.reset();
                listener.addExpectedChange(resources, 1, 0);
                listener.addExpectedChange((IResource)project, 1, 16384);
                listener.addExpectedChange((IResource)description, 1, 0);
                HiddenResourceTest.getWorkspace().run(body, this.getMonitor());
                HiddenResourceTest.assertTrue((String)("2.1." + listener.getMessage()), (boolean)listener.isDeltaValid());
                this.ensureDoesNotExistInWorkspace(resources);
            }
            catch (CoreException e) {
                HiddenResourceTest.fail((String)"2.2", (Throwable)e);
            }
        }
        finally {
            HiddenResourceTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
        HiddenResourceTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            body = monitor -> {
                this.ensureExistsInWorkspace(resources, true);
                this.setHidden("3.0", (IResource)project, true, 2);
            };
            try {
                listener.reset();
                listener.addExpectedChange(resources, 1, 0);
                listener.addExpectedChange((IResource)project, 1, 16384);
                listener.addExpectedChange((IResource)description, 1, 0);
                HiddenResourceTest.getWorkspace().run(body, this.getMonitor());
                HiddenResourceTest.assertTrue((String)("3.1." + listener.getMessage()), (boolean)listener.isDeltaValid());
                this.ensureDoesNotExistInWorkspace(resources);
            }
            catch (CoreException e) {
                HiddenResourceTest.fail((String)"3.2", (Throwable)e);
            }
        }
        finally {
            HiddenResourceTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testExists() {
        IProject project = HiddenResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        this.ensureExistsInWorkspace(resources, true);
        this.assertExistsInWorkspace("1.0", resources);
        this.setHidden("2.0", (IResource)folder, true, 0);
        this.assertHidden("2.1", (IResource)folder, true, 0);
        this.assertExistsInWorkspace("2.2", resources);
        this.setHidden("3.0", (IResource)project, true, 2);
        this.assertHidden("3.1", (IResource)project, true, 2);
        this.assertExistsInWorkspace("3.2", resources);
    }

    public void testSetGet() {
        IResource resource;
        IResource resource2;
        IResource resource3;
        IResource[] resources;
        IProject project = HiddenResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] iResourceArray = resources = new IResource[]{project, folder, file, subFile};
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            resource3 = iResourceArray[n2];
            try {
                resource3.setHidden(true);
                HiddenResourceTest.fail((String)("0.0." + resource3.getFullPath()));
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        this.ensureExistsInWorkspace(resources, true);
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = resource2 = iResourceArray[n2];
            HiddenResourceTest.assertTrue((String)("1.0: " + resource.getFullPath()), (!resource.isHidden() ? 1 : 0) != 0);
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource3 = iResourceArray[n2];
            try {
                resource3.setHidden(true);
            }
            catch (CoreException e) {
                HiddenResourceTest.fail((String)("2.0: " + resource3.getFullPath()), (Throwable)e);
            }
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = resource2 = iResourceArray[n2];
            switch (resource.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    HiddenResourceTest.assertTrue((String)("3.0: " + resource.getFullPath()), (boolean)resource.isHidden());
                    break;
                }
                case 8: {
                    HiddenResourceTest.assertTrue((String)("3.1: " + resource.getFullPath()), (!resource.isHidden() ? 1 : 0) != 0);
                }
            }
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource3 = iResourceArray[n2];
            try {
                resource3.setHidden(false);
            }
            catch (CoreException e) {
                HiddenResourceTest.fail((String)("4.0: " + resource3.getFullPath()), (Throwable)e);
            }
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = resource2 = iResourceArray[n2];
            HiddenResourceTest.assertTrue((String)("5.0: " + resource.getFullPath()), (!resource.isHidden() ? 1 : 0) != 0);
            ++n2;
        }
    }

    public void testCreateHiddenResources() {
        IProject project = HiddenResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            folder.create(4096, true, this.getMonitor());
            file.create(this.getRandomContents(), 4096, this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"1.0", (Throwable)e);
        }
        this.assertHidden("2.0", (IResource)project, false, 0);
        this.assertHidden("3.0", (IResource)folder, true, 0);
        this.assertHidden("4.0", (IResource)file, true, 0);
        IProject project2 = HiddenResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        try {
            project2.create(null, 4096, this.getMonitor());
            project2.open(this.getMonitor());
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)"5.0", (Throwable)e);
        }
        this.assertHidden("6.0", (IResource)project2, true, 0);
    }

    protected void assertHidden(String message, IResource root, boolean value, int depth) {
        IResourceVisitor visitor = resource -> {
            boolean expected = false;
            if (resource.getType() == 4 || resource.getType() == 1 || resource.getType() == 2) {
                expected = value;
            }
            HiddenResourceTest.assertEquals((String)(String.valueOf(message) + resource.getFullPath()), (boolean)expected, (boolean)resource.isHidden());
            return true;
        };
        try {
            root.accept(visitor, depth, 8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)(String.valueOf(message) + "resource.accept"), (Throwable)e);
        }
    }

    protected void setHidden(String message, IResource root, boolean value, int depth) {
        IResourceVisitor visitor = resource -> {
            try {
                resource.setHidden(value);
            }
            catch (CoreException e) {
                HiddenResourceTest.fail((String)(String.valueOf(message) + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            root.accept(visitor, depth, 8);
        }
        catch (CoreException e) {
            HiddenResourceTest.fail((String)(String.valueOf(message) + "resource.accept"), (Throwable)e);
        }
    }
}

