/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.TestPerformer;

public class IFileTest
extends ResourceTest {
    public static final String DOES_NOT_EXIST = "DoesNotExistFile";
    public static final String EXISTING = "ExistingFile";
    public static final String LOCAL_ONLY = "LocalOnlyFile";
    public static final String OUT_OF_SYNC = "OutOfSyncFile";
    protected static final IProgressMonitor[] PROGRESS_MONITORS;
    protected static final Boolean[] TRUE_AND_FALSE;
    public static final String WORKSPACE_ONLY = "WorkspaceOnlyFile";
    ArrayList<IFile> allFiles = new ArrayList();
    ArrayList<IFile> existingFiles = new ArrayList();
    ArrayList<IFile> localOnlyFiles = new ArrayList();
    ArrayList<IFile> nonExistingFiles = new ArrayList();
    ArrayList<IFile> outOfSyncFiles = new ArrayList();
    IProject[] projects = null;
    ArrayList<IFile> workspaceOnlyFiles = new ArrayList();

    static {
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[2];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        PROGRESS_MONITORS = iProgressMonitorArray;
        TRUE_AND_FALSE = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    }

    public static Test suite() {
        return new TestSuite(IFileTest.class);
    }

    public IFileTest() {
    }

    public IFileTest(String name) {
        super(name);
    }

    public boolean existsAndOpen(IContainer container) {
        if (!container.exists()) {
            return false;
        }
        if (container instanceof IFolder) {
            return true;
        }
        if (container instanceof IProject) {
            return ((IProject)container).isOpen();
        }
        IFileTest.fail((String)"Should not get here in FileTest.existsAndOpen");
        return false;
    }

    protected void generateInterestingFiles() throws CoreException {
        IProject[] interestingProjects;
        IProject[] iProjectArray = interestingProjects = this.interestingProjects();
        int n = interestingProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.generateInterestingFiles((IContainer)project);
            this.generateInterestingFiles((IContainer)project.getFolder("NonExistentFolder"));
            if (project.exists() && project.isOpen()) {
                IFolder folder = project.getFolder("ExistingFolder");
                folder.create(true, true, this.getMonitor());
                this.generateInterestingFiles((IContainer)folder);
            }
            ++n2;
        }
    }

    public void generateInterestingFiles(IContainer container) {
        IFile file = container.getFile((IPath)new Path(DOES_NOT_EXIST));
        this.nonExistingFiles.add(file);
        this.allFiles.add(file);
        file = container.getFile((IPath)new Path(LOCAL_ONLY));
        this.localOnlyFiles.add(file);
        this.allFiles.add(file);
        if (this.existsAndOpen(container)) {
            file = container.getFile((IPath)new Path(EXISTING));
            this.existingFiles.add(file);
            this.allFiles.add(file);
            file = container.getFile((IPath)new Path(WORKSPACE_ONLY));
            this.workspaceOnlyFiles.add(file);
            this.allFiles.add(file);
            file = container.getFile((IPath)new Path(OUT_OF_SYNC));
            this.outOfSyncFiles.add(file);
            this.allFiles.add(file);
        }
    }

    public IFile[] interestingFiles() {
        this.refreshFiles();
        IFile[] result = new IFile[this.allFiles.size()];
        this.allFiles.toArray(result);
        return result;
    }

    public IProject[] interestingProjects() throws CoreException {
        if (this.projects == null) {
            this.projects = new IProject[3];
            IProject openProject = IFileTest.getWorkspace().getRoot().getProject("OpenProject");
            openProject.create(this.getMonitor());
            openProject.open(this.getMonitor());
            this.projects[0] = openProject;
            IProject closedProject = IFileTest.getWorkspace().getRoot().getProject("ClosedProject");
            closedProject.create(this.getMonitor());
            this.projects[1] = closedProject;
            this.projects[2] = IFileTest.getWorkspace().getRoot().getProject("NonExistentProject");
        }
        return this.projects;
    }

    public InputStream[] interestingStreams() {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        ByteArrayInputStream bis = new ByteArrayInputStream(new byte[0]);
        streams.add(bis);
        streams.add(this.getRandomContents());
        bis = new ByteArrayInputStream(new byte[10000]);
        streams.add(bis);
        InputStream[] results = new InputStream[streams.size()];
        streams.toArray(results);
        return results;
    }

    public boolean outOfSync(IFile file) {
        return file.getName().equals(OUT_OF_SYNC) || file.getName().equals(WORKSPACE_ONLY);
    }

    public void refreshFile(IFile file) {
        if (file.getName().equals(LOCAL_ONLY)) {
            this.ensureDoesNotExistInWorkspace((IResource)file);
            if (file.getProject().exists()) {
                this.ensureExistsInFileSystem(file);
            }
            return;
        }
        if (file.getName().equals(WORKSPACE_ONLY)) {
            this.ensureExistsInWorkspace((IResource)file, true);
            this.ensureDoesNotExistInFileSystem((IResource)file);
            return;
        }
        if (file.getName().equals(DOES_NOT_EXIST)) {
            this.ensureDoesNotExistInWorkspace((IResource)file);
            if (file.getProject().exists()) {
                this.ensureDoesNotExistInFileSystem((IResource)file);
            }
            return;
        }
        if (file.getName().equals(EXISTING)) {
            this.ensureExistsInWorkspace((IResource)file, true);
            return;
        }
        if (file.getName().equals(OUT_OF_SYNC)) {
            this.ensureExistsInWorkspace((IResource)file, true);
            this.ensureOutOfSync(file);
            return;
        }
    }

    public void refreshFiles() {
        for (IFile file : this.allFiles) {
            this.refreshFile(file);
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.generateInterestingFiles();
        }
        catch (CoreException e) {
            IFileTest.fail((String)"Failed in setup for FileTest", (Throwable)e);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        IFileTest.getWorkspace().getRoot().refreshLocal(2, null);
        this.ensureDoesNotExistInWorkspace((IResource)IFileTest.getWorkspace().getRoot());
        super.tearDown();
    }

    public void testAppendContents() {
        IFile target = this.projects[0].getFile("file1");
        try {
            target.create(this.getContents("abc"), false, null);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            target.appendContents(this.getContents("def"), false, false, null);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"2.0", (Throwable)e);
        }
        InputStream content = null;
        try {
            content = target.getContents(false);
            IFileTest.assertTrue((String)"3.0", (boolean)this.compareContent(content, this.getContents("abcdef")));
        }
        catch (CoreException e) {
            IFileTest.fail((String)"3.1", (Throwable)e);
        }
    }

    public void testAppendContents2() {
        IFile file = this.projects[0].getFile("file1");
        this.ensureDoesNotExistInWorkspace((IResource)file);
        try {
            file.create(null, false, this.getMonitor());
            IFileTest.assertTrue((String)"1.0", (!file.isLocal(0) ? 1 : 0) != 0);
            IFileTest.assertTrue((String)"1.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
            this.ensureExistsInFileSystem(file);
            IFileTest.assertTrue((String)"1.2", (!file.isLocal(0) ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.3", (Throwable)e);
        }
        try {
            file.appendContents(this.getRandomContents(), 1, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.4", (Throwable)e);
        }
        IFileTest.assertTrue((String)"1.5", (boolean)file.isLocal(0));
        IFileTest.assertTrue((String)"1.6", (boolean)file.getLocation().toFile().exists());
        this.ensureDoesNotExistInWorkspace((IResource)file);
        try {
            file.create(null, false, this.getMonitor());
            IFileTest.assertTrue((String)"2.0", (!file.isLocal(0) ? 1 : 0) != 0);
            IFileTest.assertTrue((String)"2.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"2.2", (Throwable)e);
        }
        try {
            file.appendContents(this.getRandomContents(), 1, this.getMonitor());
            IFileTest.fail((String)"2.3");
        }
        catch (CoreException coreException) {}
        IFileTest.assertTrue((String)"2.4", (!file.isLocal(0) ? 1 : 0) != 0);
        this.ensureDoesNotExistInWorkspace((IResource)file);
        try {
            file.create(null, false, this.getMonitor());
            IFileTest.assertTrue((String)"3.0", (!file.isLocal(0) ? 1 : 0) != 0);
            IFileTest.assertTrue((String)"3.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
            this.ensureExistsInFileSystem(file);
            IFileTest.assertTrue((String)"3.2", (!file.isLocal(0) ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"3.3", (Throwable)e);
        }
        try {
            file.appendContents(this.getRandomContents(), 0, this.getMonitor());
            IFileTest.fail((String)"3.4");
        }
        catch (CoreException coreException) {}
        IFileTest.assertTrue((String)"3.5", (!file.isLocal(0) ? 1 : 0) != 0);
        this.ensureDoesNotExistInWorkspace((IResource)file);
        try {
            file.create(null, false, this.getMonitor());
            IFileTest.assertTrue((String)"4.0", (!file.isLocal(0) ? 1 : 0) != 0);
            IFileTest.assertTrue((String)"4.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"4.2", (Throwable)e);
        }
        try {
            file.appendContents(this.getRandomContents(), 0, this.getMonitor());
            IFileTest.fail((String)"4.3");
        }
        catch (CoreException coreException) {}
        IFileTest.assertTrue((String)"4.4", (!file.isLocal(0) ? 1 : 0) != 0);
        this.ensureDoesNotExistInWorkspace((IResource)file);
    }

    public void testCreate() {
        Object[][] inputs = new Object[][]{this.interestingFiles(), this.interestingStreams(), TRUE_AND_FALSE, PROGRESS_MONITORS};
        new TestPerformer("IFileTest.testCreate"){

            @Override
            public void cleanUp(Object[] args, int count) {
                IFile file = (IFile)args[0];
                IFileTest.this.refreshFile(file);
            }

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                InputStream stream = (InputStream)args[1];
                boolean force = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                file.create(stream, force, monitor);
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                boolean fileExistsInFS;
                IFile file = (IFile)args[0];
                IPath fileLocation = file.getLocation();
                boolean force = (Boolean)args[2];
                boolean fileExistsInWS = file.exists();
                boolean bl = fileExistsInFS = fileLocation != null && fileLocation.toFile().exists();
                if (!file.getParent().isAccessible()) {
                    return true;
                }
                if (force && !fileExistsInWS) {
                    return false;
                }
                return fileExistsInWS || fileExistsInFS;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile file = (IFile)args[0];
                return file.exists();
            }
        }.performTest(inputs);
    }

    public void testCreateDerived() {
        IFile derived = this.projects[0].getFile("derived.txt");
        this.ensureExistsInWorkspace((IResource)this.projects[0], true);
        this.ensureDoesNotExistInWorkspace((IResource)derived);
        try {
            derived.create(this.getRandomContents(), 1024, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"0.99", (Throwable)e);
        }
        IFileTest.assertTrue((String)"1.0", (boolean)derived.isDerived());
        IFileTest.assertTrue((String)"1.1", (!derived.isTeamPrivateMember() ? 1 : 0) != 0);
        try {
            derived.delete(false, this.getMonitor());
            derived.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.99", (Throwable)e);
        }
        IFileTest.assertTrue((String)"2.0", (!derived.isDerived() ? 1 : 0) != 0);
        IFileTest.assertTrue((String)"2.1", (!derived.isTeamPrivateMember() ? 1 : 0) != 0);
    }

    public void testDeltaOnCreateDerived() {
        IFile derived = this.projects[0].getFile("derived.txt");
        this.ensureExistsInWorkspace((IResource)this.projects[0], true);
        ResourceDeltaVerifier verifier = new ResourceDeltaVerifier();
        IFileTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier, 1);
        verifier.addExpectedChange((IResource)derived, 1, 0);
        try {
            derived.create(this.getRandomContents(), 1025, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.0", (Throwable)e);
        }
        IFileTest.assertTrue((String)"2.0", (boolean)verifier.isDeltaValid());
    }

    public void testCreateDerivedTeamPrivate() {
        IFile teamPrivate = this.projects[0].getFile("teamPrivateDerived.txt");
        this.ensureExistsInWorkspace((IResource)this.projects[0], true);
        this.ensureDoesNotExistInWorkspace((IResource)teamPrivate);
        try {
            teamPrivate.create(this.getRandomContents(), 3072, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"0.99", (Throwable)e);
        }
        IFileTest.assertTrue((String)"1.0", (boolean)teamPrivate.isTeamPrivateMember());
        IFileTest.assertTrue((String)"1.1", (boolean)teamPrivate.isDerived());
        try {
            teamPrivate.delete(false, this.getMonitor());
            teamPrivate.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.99", (Throwable)e);
        }
        IFileTest.assertTrue((String)"2.0", (!teamPrivate.isTeamPrivateMember() ? 1 : 0) != 0);
        IFileTest.assertTrue((String)"2.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
    }

    public void testCreateTeamPrivate() {
        IFile teamPrivate = this.projects[0].getFile("teamPrivate.txt");
        this.ensureExistsInWorkspace((IResource)this.projects[0], true);
        this.ensureDoesNotExistInWorkspace((IResource)teamPrivate);
        try {
            teamPrivate.create(this.getRandomContents(), 2048, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"0.99", (Throwable)e);
        }
        IFileTest.assertTrue((String)"1.0", (boolean)teamPrivate.isTeamPrivateMember());
        IFileTest.assertTrue((String)"1.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
        try {
            teamPrivate.delete(false, this.getMonitor());
            teamPrivate.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.99", (Throwable)e);
        }
        IFileTest.assertTrue((String)"2.0", (!teamPrivate.isTeamPrivateMember() ? 1 : 0) != 0);
        IFileTest.assertTrue((String)"2.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
    }

    public void testFileCreation() {
        IFile target = this.projects[0].getFile("file1");
        IFileTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        try {
            target.create(null, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.1", (Throwable)e);
        }
        IFileTest.assertTrue((String)"1.2", (boolean)target.exists());
        target = this.projects[0].getFile("file2");
        IFileTest.assertTrue((String)"2.0", (!target.exists() ? 1 : 0) != 0);
        String contents = "";
        try {
            target.create(this.getContents(contents), true, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"2.1", (Throwable)e);
        }
        IFileTest.assertTrue((String)"2.2", (boolean)target.exists());
        InputStream stream = null;
        try {
            stream = target.getContents(false);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"2.3", (Throwable)e);
        }
        try {
            IFileTest.assertTrue((String)"2.4", (stream.available() == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            IFileTest.fail((String)"2.5", (Throwable)e);
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            IFileTest.fail((String)"2.55", (Throwable)e);
        }
        try {
            IFileTest.assertTrue((String)"2.6", (boolean)this.compareContent(target.getContents(false), this.getContents(contents)));
        }
        catch (CoreException e) {
            IFileTest.fail((String)"2.7", (Throwable)e);
        }
        target = this.projects[0].getFile("file3");
        IFileTest.assertTrue((String)"3.0", (!target.exists() ? 1 : 0) != 0);
        contents = this.getRandomString();
        try {
            target.create(this.getContents(contents), true, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"3.1", (Throwable)e);
        }
        IFileTest.assertTrue((String)"3.2", (boolean)target.exists());
        try {
            IFileTest.assertTrue((String)"3.2", (boolean)this.compareContent(target.getContents(false), this.getContents(contents)));
        }
        catch (CoreException e) {
            IFileTest.fail((String)"3.3", (Throwable)e);
        }
        IFolder folder = this.projects[0].getFolder("folder1");
        try {
            folder.create(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"4.0", (Throwable)e);
        }
        IFileTest.assertTrue((String)"4.1", (boolean)folder.exists());
        target = this.projects[0].getFile("folder1");
        try {
            target.create(null, true, this.getMonitor());
            IFileTest.fail((String)"4.2");
        }
        catch (CoreException coreException) {}
        IFileTest.assertTrue((String)"4.3", (boolean)folder.exists());
        IFileTest.assertTrue((String)"4.4", (!target.exists() ? 1 : 0) != 0);
        folder = this.projects[0].getFolder("folder2");
        IFileTest.assertTrue((String)"5.0", (!folder.exists() ? 1 : 0) != 0);
        target = folder.getFile("file4");
        try {
            target.create(null, true, this.getMonitor());
            IFileTest.fail((String)"5.1");
        }
        catch (CoreException coreException) {}
        IFileTest.assertTrue((String)"5.2", (!folder.exists() ? 1 : 0) != 0);
        IFileTest.assertTrue((String)"5.3", (!target.exists() ? 1 : 0) != 0);
        target = this.projects[0].getFile("file2");
        this.ensureDoesNotExistInWorkspace((IResource)target);
        this.ensureDoesNotExistInFileSystem((IResource)target);
        InputStream content = new InputStream(){

            @Override
            public int read() throws IOException {
                throw new IOException();
            }
        };
        try {
            target.create(content, false, this.getMonitor());
            IFileTest.fail((String)"6.1");
        }
        catch (CoreException coreException) {}
        this.assertDoesNotExistInWorkspace("6.2", (IResource)target);
        this.assertDoesNotExistInFileSystem("6.3", (IResource)target);
        folder = this.projects[0].getFolder("folder1");
        try {
            folder.delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"7.0", (Throwable)e);
        }
        IFile file = this.projects[0].getFile("file1");
        try {
            file.delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"7.1", (Throwable)e);
        }
        file = this.projects[0].getFile("file2");
        try {
            file.delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"7.2", (Throwable)e);
        }
        file = this.projects[0].getFile("file3");
        try {
            file.delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"7.3", (Throwable)e);
        }
    }

    public void testFileCreation_Bug107188() {
        IFile target = this.projects[0].getFile("file1");
        this.ensureDoesNotExistInWorkspace((IResource)target);
        this.ensureDoesNotExistInFileSystem((IResource)target);
        InputStream content = new InputStream(){

            @Override
            public int read() {
                throw new OperationCanceledException();
            }
        };
        try {
            target.create(content, false, this.getMonitor());
            IFileTest.fail((String)"1.0");
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (CoreException coreException) {
            IFileTest.fail((String)"2.0");
        }
        this.assertDoesNotExistInWorkspace("3.0", (IResource)target);
        this.assertDoesNotExistInFileSystem("4.0", (IResource)target);
    }

    public void testFileDeletion() throws Throwable {
        IFile target = this.projects[0].getFile("file1");
        target.create(null, true, this.getMonitor());
        IFileTest.assertTrue((String)"1.0", (boolean)target.exists());
        target.delete(true, this.getMonitor());
        IFileTest.assertTrue((String)"1.1", (!target.exists() ? 1 : 0) != 0);
    }

    public void testFileEmptyDeletion() throws Throwable {
        IFile target = this.projects[0].getFile("file1");
        target.create(this.getContents(""), true, this.getMonitor());
        IFileTest.assertTrue((String)"1.0", (boolean)target.exists());
        target.delete(true, this.getMonitor());
        IFileTest.assertTrue((String)"1.1", (!target.exists() ? 1 : 0) != 0);
    }

    public void testFileInFolderCreation() {
        IFolder folder = this.projects[0].getFolder("folder1");
        try {
            folder.create(false, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.0", (Throwable)e);
        }
        IFile target = folder.getFile("file1");
        try {
            target.create(this.getRandomContents(), true, this.getMonitor());
            IFileTest.assertTrue((String)"1.1", (boolean)target.exists());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.2", (Throwable)e);
        }
    }

    public void testFileInFolderCreation1() throws Throwable {
        IFolder folder = this.projects[0].getFolder("folder1");
        folder.create(false, true, null);
        IFile target = folder.getFile("file1");
        target.create(this.getRandomContents(), true, this.getMonitor());
        IFileTest.assertTrue((String)"1.0", (boolean)target.exists());
    }

    public void testFileInFolderCreation2() {
        IFolder folder = this.projects[0].getFolder("folder1");
        try {
            folder.create(false, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.0", (Throwable)e);
        }
        IFile target = folder.getFile("file1");
        try {
            target.create(this.getRandomContents(), true, this.getMonitor());
            IFileTest.assertTrue((String)"1.1", (boolean)target.exists());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.2", (Throwable)e);
        }
    }

    public void testFileMove() throws Throwable {
        IFile target = this.projects[0].getFile("file1");
        target.create(this.getRandomContents(), true, this.getMonitor());
        IFile destination = this.projects[0].getFile("file2");
        target.move(destination.getFullPath(), true, this.getMonitor());
        IFileTest.assertTrue((String)"1.0", (boolean)destination.exists());
        IFileTest.assertTrue((String)"1.1", (!target.exists() ? 1 : 0) != 0);
    }

    public void testFileOverFolder() throws Throwable {
        IFolder existing = this.projects[0].getFolder("ExistingFolder");
        IFile target = this.projects[0].getFile("ExistingFolder");
        try {
            target.create(null, true, this.getMonitor());
            IFileTest.fail((String)"Should not be able to create file over folder");
        }
        catch (CoreException coreException) {
            IFileTest.assertTrue((String)"1.1", (boolean)existing.exists());
            return;
        }
    }

    public void testGetContents() {
        Object[][] inputs = new Object[][]{this.interestingFiles()};
        new TestPerformer("IFileTest.testGetContents"){

            @Override
            public void cleanUp(Object[] args, int count) {
                IFile file = (IFile)args[0];
                IFileTest.this.refreshFile(file);
            }

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                return file.getContents(false);
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFile file = (IFile)args[0];
                if (!file.exists()) {
                    return true;
                }
                return IFileTest.this.outOfSync(file);
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile file = (IFile)args[0];
                InputStream contents = (InputStream)result;
                boolean returnVal = file.exists() && contents != null;
                contents.close();
                return returnVal;
            }
        }.performTest(inputs);
    }

    public void testGetContents2() throws IOException {
        IFile target = this.projects[0].getFile("file1");
        String testString = this.getRandomString();
        try {
            target.create(null, false, null);
            target.setContents(this.getContents(testString), true, false, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"0.0", (Throwable)e);
        }
        this.ensureOutOfSync(target);
        InputStream content = null;
        try {
            try {
                content = target.getContents(false);
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
            IFileTest.fail((String)"1.0");
        }
        catch (CoreException e) {
            IFileTest.assertEquals((String)"1.1", (int)274, (int)e.getStatus().getCode());
        }
        try {
            try {
                content = target.getContents(true);
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        catch (CoreException e) {
            IFileTest.fail((String)"2.1", (Throwable)e);
        }
        try {
            try {
                content = target.getContents(false);
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
            IFileTest.fail((String)"3.0");
        }
        catch (CoreException e) {
            IFileTest.assertEquals((String)"3.1", (int)274, (int)e.getStatus().getCode());
        }
        content = new InputStream(){

            @Override
            public int read() throws IOException {
                throw new IOException();
            }
        };
        try {
            target.setContents(content, 0, this.getMonitor());
            IFileTest.fail((String)"4.1");
        }
        catch (CoreException coreException) {}
        this.assertExistsInWorkspace("4.2", (IResource)target);
        this.assertExistsInFileSystem("4.3", (IResource)target);
    }

    public void testInvalidFileNames() {
        IFile file;
        IProject project = this.projects[0];
        String[] names = new String[]{"", "/"};
        int i = 0;
        while (i < names.length) {
            try {
                project.getFile(names[i]);
                IFileTest.fail((String)("0.1." + i));
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
        names = new String[]{};
        names = IFileTest.isWindows() ? new String[]{"a  ", "foo::bar", "prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "AUX", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|"} : new String[]{};
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            file = project.getFile(Path.fromPortableString((String)name));
            IFileTest.assertTrue((String)("1.0 " + name), (!file.exists() ? 1 : 0) != 0);
            try {
                file.create(this.getRandomContents(), true, this.getMonitor());
                IFileTest.fail((String)("1.1 " + name));
            }
            catch (CoreException coreException) {}
            IFileTest.assertTrue((String)("1.2 " + name), (!file.exists() ? 1 : 0) != 0);
            ++n2;
        }
        names = IFileTest.isWindows() ? new String[]{"  a", "hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";", "clock$.class"} : new String[]{"  a", "a  ", "foo:bar", "prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|", "hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"};
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            file = project.getFile(name);
            IFileTest.assertTrue((String)("2.0 " + name), (!file.exists() ? 1 : 0) != 0);
            try {
                file.create(this.getRandomContents(), true, this.getMonitor());
            }
            catch (CoreException e) {
                IFileTest.fail((String)("2.1 " + name), (Throwable)e);
            }
            IFileTest.assertTrue((String)("2.2 " + name), (boolean)file.exists());
            ++n2;
        }
    }

    public void testSetContents1() {
        Object[][] inputs = new Object[][]{this.interestingFiles(), this.interestingStreams(), TRUE_AND_FALSE, PROGRESS_MONITORS};
        new TestPerformer("IFileTest.testSetContents1"){

            @Override
            public void cleanUp(Object[] args, int count) {
                IFileTest.this.waitForRefresh();
                IFile file = (IFile)args[0];
                IFileTest.this.refreshFile(file);
            }

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                InputStream stream = (InputStream)args[1];
                boolean force = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                file.setContents(stream, force, false, monitor);
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFile file = (IFile)args[0];
                boolean force = (Boolean)args[2];
                if (!file.exists()) {
                    return true;
                }
                return !force && IFileTest.this.outOfSync(file);
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile file = (IFile)args[0];
                return file.exists();
            }
        }.performTest(inputs);
    }

    public void testSetContents2() {
        block15: {
            IFile target = this.projects[0].getFile("file1");
            try {
                target.create(null, false, null);
            }
            catch (CoreException e) {
                IFileTest.fail((String)"0.0", (Throwable)e);
            }
            String testString = this.getRandomString();
            try {
                target.setContents(this.getContents(testString), true, false, this.getMonitor());
            }
            catch (CoreException e) {
                IFileTest.fail((String)"1.0", (Throwable)e);
            }
            InputStream content = null;
            try {
                try {
                    content = target.getContents(false);
                    IFileTest.assertTrue((String)"get not equal set", (boolean)this.compareContent(content, this.getContents(testString)));
                }
                catch (CoreException e) {
                    IFileTest.fail((String)"2.0", (Throwable)e);
                    try {
                        content.close();
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    content.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void testSetGetFolderPersistentProperty() throws Throwable {
        IFile target = IFileTest.getWorkspace().getRoot().getFile((IPath)new Path("/Project/File.txt"));
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        this.ensureDoesNotExistInWorkspace((IResource)target);
        try {
            target.getPersistentProperty(name);
            IFileTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            target.setPersistentProperty(name, value);
            IFileTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        this.ensureExistsInWorkspace((IResource)target, true);
        target.setPersistentProperty(name, value);
        IFileTest.assertTrue((String)"2.0", (boolean)target.getPersistentProperty(name).equals(value));
        name = new QualifiedName("itp-test", "testNonProperty");
        IFileTest.assertNull((String)"2.1", (Object)target.getPersistentProperty(name));
        name = new QualifiedName(null, "foo");
        try {
            target.setPersistentProperty(name, value);
            IFileTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
    }
}

