/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;

public class IFolderTest
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(IFolderTest.class);
    }

    public IFolderTest() {
    }

    public IFolderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        IFolderTest.getWorkspace().getRoot().refreshLocal(2, null);
        this.ensureDoesNotExistInWorkspace((IResource)IFolderTest.getWorkspace().getRoot());
        super.tearDown();
    }

    public void testChangeCase() {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IFolder before = project.getFolder("folder");
        IFolder after = project.getFolder("Folder");
        IFile beforeFile = before.getFile("file");
        IFile afterFile = after.getFile("file");
        this.ensureExistsInWorkspace((IResource)before, true);
        try {
            beforeFile.create(this.getRandomContents(), false, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"0.99", (Throwable)e);
        }
        this.assertExistsInWorkspace("1.0", (IResource)before);
        this.assertExistsInWorkspace("1.1", (IResource)beforeFile);
        this.assertDoesNotExistInWorkspace("1.2", (IResource)after);
        this.assertDoesNotExistInWorkspace("1.3", (IResource)afterFile);
        try {
            before.move(after.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"1.99", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("1.2", (IResource)before);
        this.assertDoesNotExistInWorkspace("1.3", (IResource)beforeFile);
        this.assertExistsInWorkspace("1.0", (IResource)after);
        this.assertExistsInWorkspace("1.1", (IResource)afterFile);
    }

    public void testCopyMissingFolder() {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IFolder before = project.getFolder("OldFolder");
        IFolder after = project.getFolder("NewFolder");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace((IResource)before, true);
        this.ensureDoesNotExistInFileSystem((IResource)before);
        try {
            before.copy(after.getFullPath(), 1, this.getMonitor());
            IFolderTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        IFolderTest.assertTrue((String)"1.1", (!before.exists() ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"1.2", (!after.exists() ? 1 : 0) != 0);
    }

    public void testCreateDerived() {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IFolder derived = project.getFolder("derived");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureDoesNotExistInWorkspace((IResource)derived);
        try {
            derived.create(1024, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"0.99", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"1.0", (boolean)derived.isDerived());
        IFolderTest.assertTrue((String)"1.1", (!derived.isTeamPrivateMember() ? 1 : 0) != 0);
        try {
            derived.delete(false, this.getMonitor());
            derived.create(0, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"1.99", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"2.0", (!derived.isDerived() ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"2.1", (!derived.isTeamPrivateMember() ? 1 : 0) != 0);
    }

    public void testDeltaOnCreateDerived() {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IFolder derived = project.getFolder("derived");
        this.ensureExistsInWorkspace((IResource)project, true);
        ResourceDeltaVerifier verifier = new ResourceDeltaVerifier();
        IFolderTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier, 1);
        verifier.addExpectedChange((IResource)derived, 1, 0);
        try {
            derived.create(1025, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"1.0", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"2.0", (boolean)verifier.isDeltaValid());
    }

    public void testCreateDerivedTeamPrivate() {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IFolder teamPrivate = project.getFolder("teamPrivate");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureDoesNotExistInWorkspace((IResource)teamPrivate);
        try {
            teamPrivate.create(3072, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"0.99", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"1.0", (boolean)teamPrivate.isTeamPrivateMember());
        IFolderTest.assertTrue((String)"1.1", (boolean)teamPrivate.isDerived());
        try {
            teamPrivate.delete(false, this.getMonitor());
            teamPrivate.create(0, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"1.99", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"2.0", (!teamPrivate.isTeamPrivateMember() ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"2.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
    }

    public void testCreateTeamPrivate() {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IFolder teamPrivate = project.getFolder("teamPrivate");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureDoesNotExistInWorkspace((IResource)teamPrivate);
        try {
            teamPrivate.create(2048, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"0.99", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"1.0", (boolean)teamPrivate.isTeamPrivateMember());
        IFolderTest.assertTrue((String)"1.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
        try {
            teamPrivate.delete(false, this.getMonitor());
            teamPrivate.create(0, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"1.99", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"2.0", (!teamPrivate.isTeamPrivateMember() ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"2.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
    }

    public void testFolderCreation() throws Exception {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        IFolder target = project.getFolder("Folder1");
        try {
            IFolderTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
            target.create(true, true, this.getMonitor());
            IFolderTest.assertTrue((String)"1.1", (boolean)target.exists());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"1.2", (Throwable)e);
        }
        IFolder nestedTarget = target.getFolder("Folder2");
        try {
            IFolderTest.assertTrue((String)"2.0", (!nestedTarget.exists() ? 1 : 0) != 0);
            nestedTarget.create(true, true, this.getMonitor());
            IFolderTest.assertTrue((String)"2.1", (boolean)nestedTarget.exists());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"2.2", (Throwable)e);
        }
        try {
            IFolderTest.assertTrue((String)"3.0", (boolean)target.exists());
            target.create(true, true, this.getMonitor());
            IFolderTest.fail((String)"3.1");
        }
        catch (CoreException coreException) {
            IFolderTest.assertTrue((String)"3.2", (boolean)target.exists());
        }
        IFile file = target.getFile("File1");
        target = target.getFolder("File1");
        try {
            file.create(this.getRandomContents(), true, this.getMonitor());
            IFolderTest.assertTrue((String)"4.0", (boolean)file.exists());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"4.1", (Throwable)e);
        }
        try {
            target.create(true, true, this.getMonitor());
            IFolderTest.fail((String)"5.0");
        }
        catch (CoreException coreException) {
            IFolderTest.assertTrue((String)"5.1", (boolean)file.exists());
            IFolderTest.assertTrue((String)"5.2", (!target.exists() ? 1 : 0) != 0);
        }
        try {
            target = IFolderTest.getWorkspace().getRoot().getFolder((IPath)new Path("/Folder3"));
            IFolderTest.fail((String)"6.0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        file = project.getFile("File2");
        try {
            file.create(null, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"7.0", (Throwable)e);
        }
        target = project.getFolder("File2/Folder4");
        try {
            IFolderTest.assertTrue((String)"7.1", (!target.exists() ? 1 : 0) != 0);
            target.create(true, true, this.getMonitor());
            IFolderTest.fail((String)"7.2");
        }
        catch (CoreException coreException) {
            IFolderTest.assertTrue((String)"7.3", (boolean)file.exists());
            IFolderTest.assertTrue((String)"7.4", (!target.exists() ? 1 : 0) != 0);
        }
        IFolder folder = project.getFolder("Folder5");
        target = folder.getFolder("Folder6");
        try {
            IFolderTest.assertTrue((String)"8.0", (!folder.exists() ? 1 : 0) != 0);
            target.create(true, true, this.getMonitor());
            IFolderTest.fail((String)"8.1");
        }
        catch (CoreException coreException) {
            IFolderTest.assertTrue((String)"8.2", (!folder.exists() ? 1 : 0) != 0);
            IFolderTest.assertTrue((String)"8.3", (!target.exists() ? 1 : 0) != 0);
        }
    }

    public void testFolderDeletion() throws Throwable {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IResource[] before = this.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        this.ensureExistsInWorkspace(before, true);
        this.assertExistsInWorkspace(before);
        project.getFolder("c").delete(true, this.getMonitor());
        this.assertDoesNotExistInWorkspace("1.0", before);
    }

    public void testFolderMove() throws Throwable {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IResource[] before = this.buildResources((IContainer)project, new String[]{"b/", "b/b/", "b/x", "b/b/y", "b/b/z"});
        IResource[] after = this.buildResources((IContainer)project, new String[]{"a/", "a/b/", "a/x", "a/b/y", "a/b/z"});
        this.ensureExistsInWorkspace(before, true);
        String content = this.getRandomString();
        IFile file = project.getFile((IPath)new Path("b/b/z"));
        file.setContents(this.getContents(content), true, false, this.getMonitor());
        this.assertExistsInWorkspace("1.0", before);
        project.getFolder("b").move(project.getFullPath().append("a"), true, this.getMonitor());
        this.assertDoesNotExistInWorkspace("2.0", before);
        this.assertExistsInWorkspace(after);
        file = project.getFile((IPath)new Path("a/b/z"));
        IFolderTest.assertTrue((String)"2.1", (boolean)this.compareContent(this.getContents(content), file.getContents(false)));
    }

    public void testFolderOverFile() throws Throwable {
        Path path = new Path("/Project/File");
        IFile existing = IFolderTest.getWorkspace().getRoot().getFile((IPath)path);
        this.ensureExistsInWorkspace((IResource)existing, true);
        IFolder target = IFolderTest.getWorkspace().getRoot().getFolder((IPath)path);
        try {
            target.create(true, true, this.getMonitor());
            IFolderTest.fail((String)"1.0 Should not be able to create folder over a file");
        }
        catch (CoreException coreException) {
            IFolderTest.assertTrue((String)"2.0", (boolean)existing.exists());
        }
    }

    public void testInvalidFolderNames() {
        IFolder folder;
        String name;
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        String[] names = new String[]{};
        names = IFolderTest.isWindows() ? new String[]{"prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "AUX", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|"} : new String[]{};
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            folder = project.getFolder(name);
            IFolderTest.assertTrue((String)("1.0 " + name), (!folder.exists() ? 1 : 0) != 0);
            try {
                folder.create(true, true, this.getMonitor());
                IFolderTest.fail((String)("1.1 " + name));
            }
            catch (CoreException coreException) {}
            IFolderTest.assertTrue((String)("1.2 " + name), (!folder.exists() ? 1 : 0) != 0);
            ++n2;
        }
        names = IFolderTest.isWindows() ? new String[]{"hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"} : new String[]{"prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|", "hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"};
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            folder = project.getFolder(name);
            IFolderTest.assertTrue((String)("2.0 " + name), (!folder.exists() ? 1 : 0) != 0);
            try {
                folder.create(true, true, this.getMonitor());
            }
            catch (CoreException e) {
                IFolderTest.fail((String)("2.1 " + name), (Throwable)e);
            }
            IFolderTest.assertTrue((String)("2.2 " + name), (boolean)folder.exists());
            ++n2;
        }
    }

    public void testLeafFolderMove() throws Exception {
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IFolder source = project.getFolder("Folder1");
        this.ensureExistsInWorkspace((IResource)source, true);
        IFolder dest = project.getFolder("Folder2");
        source.move(dest.getFullPath(), true, this.getMonitor());
        this.assertExistsInWorkspace("1.0", (IResource)dest);
        this.assertDoesNotExistInWorkspace("1.1", (IResource)source);
    }

    public void testReadOnlyFolderCopy() throws Exception {
        if (!this.isReadOnlySupported()) {
            return;
        }
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("Project");
        IFolder source = project.getFolder("Folder1");
        this.ensureExistsInWorkspace((IResource)source, true);
        source.setReadOnly(true);
        IFolder dest = project.getFolder("Folder2");
        source.copy(dest.getFullPath(), true, this.getMonitor());
        this.assertExistsInWorkspace("1.0", (IResource)dest);
        this.assertExistsInWorkspace("1.1", (IResource)source);
        IFolderTest.assertTrue((String)"1.2", (boolean)dest.isReadOnly());
        source.setReadOnly(false);
        dest.setReadOnly(false);
    }

    public void testSetGetFolderPersistentProperty() throws Throwable {
        IFolder target = IFolderTest.getWorkspace().getRoot().getFolder((IPath)new Path("/Project/Folder"));
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        this.ensureDoesNotExistInWorkspace((IResource)target);
        try {
            target.getPersistentProperty(name);
            IFolderTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            target.setPersistentProperty(name, value);
            IFolderTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        this.ensureExistsInWorkspace((IResource)target, true);
        target.setPersistentProperty(name, value);
        IFolderTest.assertTrue((String)"2.0", (boolean)target.getPersistentProperty(name).equals(value));
        name = new QualifiedName("itp-test", "testNonProperty");
        IFolderTest.assertNull((String)"2.1", (Object)target.getPersistentProperty(name));
    }
}

