/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTest;

public class IPathVariableTest
extends ResourceTest {
    IPathVariableManager manager = null;
    IProject project = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project = IPathVariableTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            this.project.create(this.getMonitor());
            this.project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"1.3", (Throwable)e);
        }
        IPathVariableTest.assertTrue((String)"1.4", (boolean)this.project.exists());
        this.manager = this.project.getPathVariableManager();
    }

    public IPathVariableTest() {
    }

    public IPathVariableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(IPathVariableTest.class);
    }

    public void testGetPathVariableNames() {
        String[] names = null;
        try {
            this.manager.setValue("one", this.getRandomLocation());
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"1.0", (Throwable)e);
        }
        names = this.manager.getPathVariableNames();
        List<String> list = Arrays.asList(names);
        IPathVariableTest.assertTrue((String)"1.2", (boolean)list.contains("one"));
        try {
            this.manager.setValue("two", (IPath)Path.ROOT);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"2.0", (Throwable)e);
        }
        names = this.manager.getPathVariableNames();
        list = Arrays.asList(names);
        IPathVariableTest.assertTrue((String)"2.2", (boolean)list.contains("one"));
        IPathVariableTest.assertTrue((String)"2.3", (boolean)list.contains("two"));
        try {
            this.manager.setValue("one", null);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        names = this.manager.getPathVariableNames();
        list = Arrays.asList(names);
        IPathVariableTest.assertTrue((String)"3.2", (boolean)list.contains("two"));
        IPathVariableTest.assertTrue((String)"3.3", (!list.contains("one") ? 1 : 0) != 0);
        try {
            this.manager.setValue("two", null);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"4.0", (Throwable)e);
        }
        names = this.manager.getPathVariableNames();
        list = Arrays.asList(names);
        IPathVariableTest.assertTrue((String)"4.2", (!list.contains("two") ? 1 : 0) != 0);
        IPathVariableTest.assertTrue((String)"4.3", (!list.contains("one") ? 1 : 0) != 0);
    }

    public void testGetSetValue() {
        boolean WINDOWS = File.separatorChar == '\\';
        Path pathOne = WINDOWS ? new Path("C:\\testGetSetValue") : new Path("/testGetSetValue");
        Path pathTwo = new Path("/blort/backup");
        pathTwo = new Path(pathTwo.toFile().getAbsolutePath());
        Path pathOneEdit = WINDOWS ? new Path("D:/foobar") : new Path("/foobar");
        IPathVariableTest.assertNull((String)"0.0", (Object)this.manager.getValue("one"));
        try {
            this.manager.setValue("one", (IPath)pathOne);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"1.0", (Throwable)e);
        }
        IPath value = this.manager.getValue("one");
        IPathVariableTest.assertNotNull((String)"1.1", (Object)value);
        IPathVariableTest.assertEquals((String)"1.2", (Object)pathOne, (Object)value);
        try {
            this.manager.setValue("two", (IPath)pathTwo);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"2.0", (Throwable)e);
        }
        value = this.manager.getValue("two");
        IPathVariableTest.assertNotNull((String)"2.1", (Object)value);
        IPathVariableTest.assertEquals((String)"2.2", (Object)pathTwo, (Object)value);
        try {
            this.manager.setValue("one", (IPath)pathOneEdit);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        value = this.manager.getValue("one");
        IPathVariableTest.assertNotNull((String)"3.1", (Object)value);
        IPathVariableTest.assertTrue((String)"3.2", (boolean)pathOneEdit.equals((Object)value));
        try {
            this.manager.setValue("one", null);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"4.0", (Throwable)e);
        }
        IPathVariableTest.assertNull((String)"4.1", (Object)this.manager.getValue("one"));
        try {
            this.manager.setValue("ECLIPSE$HOME", (IPath)Path.ROOT);
            IPathVariableTest.fail((String)"5.0 Accepted invalid variable name in setValue()");
        }
        catch (CoreException coreException) {}
        try {
            this.manager.setValue("one", (IPath)new Path("foo/bar"));
        }
        catch (CoreException coreException) {
            IPathVariableTest.fail((String)"5.0 Did not Accepted invalid variable value in setValue()");
        }
        if (WINDOWS) {
            String invalidPathString = "C:/a/\\::/b";
            IPath invalidPath = Path.fromPortableString((String)invalidPathString);
            IPathVariableTest.assertTrue((String)"6.0", (boolean)invalidPath.isAbsolute());
            IPathVariableTest.assertTrue((String)"6.1", (!Path.EMPTY.isValidPath(invalidPathString) ? 1 : 0) != 0);
            IPathVariableTest.assertTrue((String)"6.2", (boolean)this.manager.validateValue(invalidPath).isOK());
            try {
                this.manager.setValue("one", invalidPath);
            }
            catch (CoreException coreException) {
                IPathVariableTest.fail((String)"6.3 Fail to accept invalid variable value in setValue()");
            }
        }
    }

    public void testIsDefined() {
        IPathVariableTest.assertTrue((String)"0.0", (!this.manager.isDefined("one") ? 1 : 0) != 0);
        try {
            this.manager.setValue("one", (IPath)Path.ROOT);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"1.0", (Throwable)e);
        }
        IPathVariableTest.assertTrue((String)"1.1", (boolean)this.manager.isDefined("one"));
        try {
            this.manager.setValue("one", null);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"2.0", (Throwable)e);
        }
        IPathVariableTest.assertTrue((String)"2.1", (!this.manager.isDefined("one") ? 1 : 0) != 0);
    }

    public void testResolvePathWithMacro() {
        boolean WINDOWS = File.separatorChar == '\\';
        Path pathOne = WINDOWS ? new Path("c:/testGetSetValue/foo") : new Path("/testGetSetValue/foo");
        Path pathTwo = WINDOWS ? new Path("c:/tmp/backup") : new Path("/tmp/backup");
        pathTwo = new Path(pathTwo.toFile().getAbsolutePath());
        try {
            this.manager.setValue("one", (IPath)pathOne);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"0.1", (Throwable)e);
        }
        try {
            this.manager.setValue("two", (IPath)pathTwo);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"0.2", (Throwable)e);
        }
        try {
            this.manager.setValue("three", Path.fromOSString((String)"${two}/extra"));
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"0.3", (Throwable)e);
        }
        Path path = new Path("three/bar");
        IPath expected = new Path("/tmp/backup/extra/bar").setDevice(WINDOWS ? "c:" : null);
        IPath actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"1.0", (Object)expected, (Object)actual);
    }

    public void testProjectLoc() {
        Path path = new Path("${PROJECT_LOC}/bar");
        IPath projectLocation = this.project.getLocation();
        IPath expected = projectLocation.append("bar");
        IPath actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"1.0", (Object)expected, (Object)actual);
    }

    public void testEclipseHome() {
        Path path = new Path("${ECLIPSE_HOME}/bar");
        IPath expected = new Path(Platform.getInstallLocation().getURL().getPath()).append("bar");
        IPath actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"1.0", (Object)expected, (Object)actual);
    }

    public void testWorkspaceLocation() {
        Path path = new Path("${WORKSPACE_LOC}/bar");
        IPath expected = this.project.getWorkspace().getRoot().getLocation().append("bar");
        IPath actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"1.0", (Object)expected, (Object)actual);
    }

    public void testGetVariableRelativePathLocation() {
        IPath path = this.project.getWorkspace().getRoot().getLocation().append("bar");
        path = new Path(Platform.getInstallLocation().getURL().getPath()).append("bar");
        Path expected = new Path("ECLIPSE_HOME/bar");
        IPath actual = this.getVariableRelativePathLocation(this.project, path);
        IPathVariableTest.assertEquals((String)"2.0", (Object)expected, (Object)actual);
        path = this.project.getLocation().append("bar");
        expected = new Path("PROJECT_LOC/bar");
        actual = this.getVariableRelativePathLocation(this.project, path);
        IPathVariableTest.assertEquals((String)"3.0", (Object)expected, (Object)actual);
        actual = this.getVariableRelativePathLocation(this.project, (IPath)new Path("/nonExistentPath/foo"));
        IPathVariableTest.assertEquals((String)"4.0", null, (Object)actual);
    }

    private IPath getVariableRelativePathLocation(IProject project, IPath location) {
        URI variableRelativePathLocation = project.getPathVariableManager().getVariableRelativePathLocation(URIUtil.toURI((IPath)location));
        if (variableRelativePathLocation != null) {
            return URIUtil.toPath((URI)variableRelativePathLocation);
        }
        return null;
    }

    public void testResolvePath() {
        boolean WINDOWS = File.separatorChar == '\\';
        Path pathOne = WINDOWS ? new Path("C:/testGetSetValue/foo") : new Path("/testGetSetValue/foo");
        Path pathTwo = new Path("/blort/backup");
        pathTwo = new Path(pathTwo.toFile().getAbsolutePath());
        try {
            this.manager.setValue("one", (IPath)pathOne);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"0.1", (Throwable)e);
        }
        try {
            this.manager.setValue("two", (IPath)pathTwo);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"0.2", (Throwable)e);
        }
        Path path = new Path("one/bar");
        IPath expected = new Path("/testGetSetValue/foo/bar").setDevice(WINDOWS ? "C:" : null);
        IPath actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"1.0", (Object)expected, (Object)actual);
        path = new Path("two/myworld");
        expected = new Path("/blort/backup/myworld");
        expected = new Path(expected.toFile().getAbsolutePath());
        actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"2.0", (Object)expected, (Object)actual);
        path = new Path("three/nothere");
        expected = path;
        actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"3.0", (Object)expected, (Object)actual);
        path = new Path("/one").setDevice(WINDOWS ? "C:" : null);
        expected = path;
        actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"4.0", (Object)expected, (Object)actual);
        if (WINDOWS) {
            path = new Path("C:two");
            expected = path;
            actual = this.manager.resolvePath((IPath)path);
            IPathVariableTest.assertEquals((String)"5.0", (Object)expected, (Object)actual);
        }
        path = new Path("/one");
        expected = path;
        actual = this.manager.resolvePath((IPath)path);
        IPathVariableTest.assertEquals((String)"6.0", (Object)expected, (Object)actual);
        if (WINDOWS) {
            path = new Path("one");
            expected = FileUtil.canonicalPath((IPath)pathOne);
            actual = this.manager.resolvePath((IPath)path);
            IPathVariableTest.assertEquals((String)"7.0", (Object)expected, (Object)actual);
        }
        path = null;
        IPathVariableTest.assertNull((String)"7.0", (Object)this.manager.resolvePath((IPath)path));
    }

    private IPath convertToRelative(IPathVariableManager manager, IPath path, boolean force, String variableHint) throws CoreException {
        return URIUtil.toPath((URI)manager.convertToRelative(URIUtil.toURI((IPath)path), force, variableHint));
    }

    public void testConvertToRelative() {
        boolean WINDOWS = File.separatorChar == '\\';
        Path pathOne = WINDOWS ? new Path("c:/foo/bar") : new Path("/foo/bar");
        Path pathTwo = WINDOWS ? new Path("c:/foo/other") : new Path("/foo/other");
        Path pathThree = WINDOWS ? new Path("c:/random/other/subpath") : new Path("/random/other/subpath");
        Path file = WINDOWS ? new Path("c:/foo/other/file.txt") : new Path("/foo/other/file.txt");
        try {
            this.manager.setValue("ONE", (IPath)pathOne);
            this.manager.setValue("THREE", (IPath)pathThree);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"0.1", (Throwable)e);
        }
        IPath actual = null;
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, false, "ONE");
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"0.2", (Throwable)e);
        }
        Path expected = file;
        IPathVariableTest.assertEquals((String)"1.0", (Object)expected, (Object)actual);
        try {
            this.manager.setValue("TWO", (IPath)pathTwo);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, false, "ONE");
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        expected = file;
        IPathVariableTest.assertEquals((String)"2.0", (Object)expected, (Object)actual);
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, false, "TWO");
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"2.1", (Throwable)e);
        }
        expected = new Path("TWO/file.txt");
        IPathVariableTest.assertEquals((String)"3.0", (Object)expected, (Object)actual);
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, true, "ONE");
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"3.1", (Throwable)e);
        }
        expected = new Path("PARENT-1-ONE/other/file.txt");
        IPathVariableTest.assertEquals((String)"4.0", (Object)expected, (Object)actual);
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, true, "ONE");
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"4.3", (Throwable)e);
        }
        expected = new Path("PARENT-1-ONE/other/file.txt");
        IPathVariableTest.assertEquals((String)"5.0", (Object)expected, (Object)actual);
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, true, "TWO");
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"5.4", (Throwable)e);
        }
        expected = new Path("TWO/file.txt");
        IPathVariableTest.assertEquals((String)"6.0", (Object)expected, (Object)actual);
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, true, "TWO");
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"6.1", (Throwable)e);
        }
        expected = new Path("TWO/file.txt");
        IPathVariableTest.assertEquals((String)"7.0", (Object)expected, (Object)actual);
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, false, null);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"7.1", (Throwable)e);
        }
        expected = new Path("TWO/file.txt");
        IPathVariableTest.assertEquals((String)"8.0", (Object)expected, (Object)actual);
        try {
            this.manager.setValue("TWO", null);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"8.1", (Throwable)e);
        }
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, false, null);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"8.2", (Throwable)e);
        }
        expected = file;
        IPathVariableTest.assertEquals((String)"9.0", (Object)expected, (Object)actual);
        try {
            actual = this.convertToRelative(this.manager, (IPath)file, true, null);
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"9.1", (Throwable)e);
        }
        expected = new Path("PARENT-1-ONE/other/file.txt");
        IPathVariableTest.assertEquals((String)"10.0", (Object)expected, (Object)actual);
    }

    public void testValidateName() {
        IPathVariableTest.assertTrue((String)"0.0", (boolean)this.manager.validateName("ECLIPSEHOME").isOK());
        IPathVariableTest.assertTrue((String)"0.1", (boolean)this.manager.validateName("ECLIPSE_HOME").isOK());
        IPathVariableTest.assertTrue((String)"0.2", (boolean)this.manager.validateName("ECLIPSE_HOME_1").isOK());
        IPathVariableTest.assertTrue((String)"0.3", (boolean)this.manager.validateName("_").isOK());
        IPathVariableTest.assertTrue((String)"1.0", (!this.manager.validateName("1FOO").isOK() ? 1 : 0) != 0);
        IPathVariableTest.assertTrue((String)"1.1", (!this.manager.validateName("FOO%BAR").isOK() ? 1 : 0) != 0);
        IPathVariableTest.assertTrue((String)"1.2", (!this.manager.validateName("FOO$BAR").isOK() ? 1 : 0) != 0);
        IPathVariableTest.assertTrue((String)"1.3", (!this.manager.validateName(" FOO").isOK() ? 1 : 0) != 0);
        IPathVariableTest.assertTrue((String)"1.4", (!this.manager.validateName("FOO ").isOK() ? 1 : 0) != 0);
    }

    public void testEmptyURIResolution() {
        Path path = new Path(new String());
        URI uri = URIUtil.toURI((IPath)path);
        try {
            this.manager.resolveURI(uri);
        }
        catch (Throwable e) {
            IPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        try {
            IPathVariableTest.getWorkspace().getPathVariableManager().resolveURI(uri);
        }
        catch (Throwable e) {
            IPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
    }

    public void testListeners() {
        PathVariableChangeVerifier listener = new PathVariableChangeVerifier();
        this.manager.addChangeListener((IPathVariableChangeListener)listener);
        Path pathOne = new Path("/blort/foobar");
        pathOne = new Path(pathOne.toFile().getAbsolutePath());
        IPath pathOneEdit = pathOne.append("myworld");
        try {
            try {
                this.manager.setValue("one", (IPath)pathOne);
            }
            catch (CoreException e) {
                IPathVariableTest.fail((String)"1.0", (Throwable)e);
            }
            listener.addExpectedEvent(2, "one", (IPath)pathOne);
            try {
                listener.verify();
            }
            catch (PathVariableChangeVerifier.VerificationFailedException e) {
                IPathVariableTest.fail((String)"1.1", (Throwable)e);
            }
            listener.reset();
            try {
                this.manager.setValue("one", pathOneEdit);
            }
            catch (CoreException e) {
                IPathVariableTest.fail((String)"2.0", (Throwable)e);
            }
            listener.addExpectedEvent(1, "one", pathOneEdit);
            try {
                listener.verify();
            }
            catch (PathVariableChangeVerifier.VerificationFailedException e) {
                IPathVariableTest.fail((String)"2.1", (Throwable)e);
            }
            listener.reset();
            try {
                this.manager.setValue("one", null);
            }
            catch (CoreException e) {
                IPathVariableTest.fail((String)"3.0", (Throwable)e);
            }
            listener.addExpectedEvent(3, "one", null);
            try {
                listener.verify();
            }
            catch (PathVariableChangeVerifier.VerificationFailedException e) {
                IPathVariableTest.fail((String)"3.1", (Throwable)e);
            }
        }
        finally {
            this.manager.removeChangeListener((IPathVariableChangeListener)listener);
        }
    }

    boolean contains(Object[] array, Object obj) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element.equals(obj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void tearDown() throws Exception {
        String[] names;
        super.tearDown();
        String[] stringArray = names = this.manager.getPathVariableNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.manager.setValue(name, null);
            ++n2;
        }
    }

    @Override
    protected void cleanup() throws CoreException {
        this.project.delete(true, this.getMonitor());
        super.cleanup();
    }

    public void testLinkExistInProjectDescriptionButNotInWorkspace() {
        String[] varNames;
        String dorProjectContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>ExistingProject</name><comment></comment><projects></projects><buildSpec></buildSpec><natures></natures><variableList><variable>\t\t<name>PROJ_UP</name>\t\t<value>$%7BPARENT-1-PROJECT_LOC%7D</value>\t</variable>\t</variableList></projectDescription>";
        IProject existingProject = IPathVariableTest.getWorkspace().getRoot().getProject("ExistingProject");
        this.ensureExistsInWorkspace(new IResource[]{existingProject}, true);
        try {
            existingProject.close(this.getMonitor());
            ProjectInfo info = (ProjectInfo)((Project)existingProject).getResourceInfo(false, false);
            info.clear(16);
            String dotProjectPath = existingProject.getLocation().append(".project").toOSString();
            FileWriter fstream = new FileWriter(dotProjectPath);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(dorProjectContent);
            out.close();
            existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            IPathVariableTest.fail((String)"1.99", (Throwable)e);
        }
        catch (IOException e) {
            IPathVariableTest.fail((String)"1.99", (Throwable)e);
        }
        IPathVariableManager pathVariableManager = existingProject.getPathVariableManager();
        String[] stringArray = varNames = pathVariableManager.getPathVariableNames();
        int n = varNames.length;
        int n2 = 0;
        while (n2 < n) {
            String varName = stringArray[n2];
            try {
                pathVariableManager.getURIValue(varName);
            }
            catch (Exception e) {
                IPathVariableTest.fail((String)"3.99", (Throwable)e);
            }
            ++n2;
        }
    }

    public void testDiscoverLocationOfInvalidFile() {
        Path filep = new Path("someFile");
        IPath invalidChild = filep.append("invalidChild");
        IFile f = this.project.getFile((IPath)filep);
        this.ensureExistsInWorkspace((IResource)f, true);
        IFile invalidFile = this.project.getFile(invalidChild);
        invalidFile.getLocationURI();
    }

    class PathVariableChangeVerifier
    implements IPathVariableChangeListener {
        List<Event> expected = new ArrayList<Event>();
        List<Event> actual = new ArrayList<Event>();

        PathVariableChangeVerifier() {
        }

        void addExpectedEvent(int type, String name, IPath value) {
            this.expected.add(new Event(type, name, value));
        }

        void verify() throws VerificationFailedException {
            if (this.expected.size() != this.actual.size()) {
                String message = "Expected size: " + this.expected.size() + " does not equal actual size: " + this.actual.size() + "\n";
                message = String.valueOf(message) + this.dump();
                throw new VerificationFailedException(message);
            }
            for (Event event : this.expected) {
                if (this.actual.contains(event)) continue;
                String message = "Expected and actual results differ.\n";
                message = String.valueOf(message) + this.dump();
                throw new VerificationFailedException(message);
            }
        }

        void reset() {
            this.expected = new ArrayList<Event>();
            this.actual = new ArrayList<Event>();
        }

        public void pathVariableChanged(IPathVariableChangeEvent event) {
            this.actual.add(new Event(event.getType(), event.getVariableName(), event.getValue()));
        }

        String dump() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Expected:\n");
            for (Event event : this.expected) {
                buffer.append("\t" + event + "\n");
            }
            buffer.append("Actual:\n");
            for (Event event : this.actual) {
                buffer.append("\t" + event + "\n");
            }
            return buffer.toString();
        }

        class Event {
            int type;
            String name;
            IPath value;

            Event(int type, String name, IPath value) {
                this.type = type;
                this.name = name;
                this.value = value;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Event)) {
                    return false;
                }
                Event that = (Event)obj;
                if (this.type != that.type || !this.name.equals(that.name)) {
                    return false;
                }
                return this.value == null ? that.value == null : this.value.equals((Object)that.value);
            }

            public String toString() {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Event(");
                buffer.append("type: ");
                buffer.append(this.stringForType(this.type));
                buffer.append(" name: ");
                buffer.append(this.name);
                buffer.append(" value: ");
                buffer.append(this.value);
                buffer.append(")");
                return buffer.toString();
            }

            String stringForType(int typeValue) {
                switch (typeValue) {
                    case 2: {
                        return "CREATED";
                    }
                    case 1: {
                        return "CHANGED";
                    }
                    case 3: {
                        return "DELETED";
                    }
                }
                return "UNKNOWN";
            }
        }

        class VerificationFailedException
        extends Exception {
            private static final long serialVersionUID = 1L;

            VerificationFailedException(String message) {
                super(message);
            }
        }
    }
}

