/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;

public class IResourceChangeListenerTest
extends ResourceTest {
    protected static final String VERIFIER_NAME = "TestListener";
    IFile file1;
    IFile file2;
    IFile file3;
    IFolder folder1;
    IFolder folder2;
    IFolder folder3;
    IProject project1;
    IFile project1MetaData;
    IProject project2;
    IFile project2MetaData;
    ResourceDeltaVerifier verifier;

    public static Test suite() {
        return new TestSuite(IResourceChangeListenerTest.class);
    }

    public IResourceChangeListenerTest() {
    }

    public IResourceChangeListenerTest(String name) {
        super(name);
    }

    public void _testBenchMark_1GBYQEZ() {
        IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.verifier);
        try {
            IResourceChangeListenerTest.getWorkspace().getRoot().delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceChangeListenerTest.fail((String)"0.0", (Throwable)e);
        }
        IResourceChangeListener listener = new IResourceChangeListener(){
            public int fCounter;

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    System.out.println("Start");
                    int i = 0;
                    while (i < 10) {
                        this.fCounter = 0;
                        long start = System.currentTimeMillis();
                        IResourceDelta delta = event.getDelta();
                        delta.accept(delta2 -> {
                            ++this.fCounter;
                            return true;
                        });
                        long end = System.currentTimeMillis();
                        System.out.println("    Number of deltas: " + this.fCounter + ". Time needed: " + (end - start));
                        ++i;
                    }
                    System.out.println("End");
                }
                catch (CoreException e) {
                    IResourceChangeListenerTest.fail((String)"1.0", (Throwable)e);
                }
            }
        };
        IResourceChangeListenerTest.getWorkspace().addResourceChangeListener(listener);
        IWorkspaceRunnable body = monitor -> {
            IProject project = IResourceChangeListenerTest.getWorkspace().getRoot().getProject("Test");
            IProjectDescription description = IResourceChangeListenerTest.getWorkspace().newProjectDescription(project.getName());
            IPath root = IResourceChangeListenerTest.getWorkspace().getRoot().getLocation();
            IPath contents = root.append("temp/testing");
            description.setLocation(contents);
            project.create(description, this.getMonitor());
            project.open(this.getMonitor());
            project.refreshLocal(2, this.getMonitor());
        };
        try {
            IResourceChangeListenerTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceChangeListenerTest.fail((String)"2.0", (Throwable)e);
        }
        body = monitor -> {
            IResourceVisitor visitor = resource -> {
                resource.touch(this.getMonitor());
                return true;
            };
            IResourceChangeListenerTest.getWorkspace().getRoot().accept(visitor);
        };
        try {
            IResourceChangeListenerTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceChangeListenerTest.fail((String)"3.0", (Throwable)e);
        }
        IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener(listener);
    }

    public void assertDelta() {
        IResourceChangeListenerTest.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
    }

    void assertNotDeltaIncludes(String message, IResourceDelta delta, IResource[] resources) {
        try {
            IResourceDelta[] children;
            IResource deltaResource = delta.getResource();
            int i = 0;
            while (i < resources.length) {
                IResourceChangeListenerTest.assertTrue((String)message, (!deltaResource.equals((Object)resources[i]) ? 1 : 0) != 0);
                ++i;
            }
            IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta element = iResourceDeltaArray[n2];
                this.assertNotDeltaIncludes(message, element, resources);
                ++n2;
            }
        }
        catch (RuntimeException e) {
            IResourceChangeListenerTest.fail((String)message, (Throwable)e);
        }
    }

    void assertNotDeltaVisits(String message, IResourceDelta delta, IResource[] resources) {
        try {
            delta.accept(delta2 -> {
                IResource deltaResource = delta2.getResource();
                int i = 0;
                while (i < resources.length) {
                    IResourceChangeListenerTest.assertTrue((String)message, (!deltaResource.equals((Object)resources[i]) ? 1 : 0) != 0);
                    ++i;
                }
                return true;
            });
        }
        catch (CoreException e) {
            IResourceChangeListenerTest.fail((String)message, (Throwable)e);
        }
        catch (RuntimeException e) {
            IResourceChangeListenerTest.fail((String)message, (Throwable)e);
        }
    }

    protected void handleCoreException(CoreException e) {
        IResourceChangeListenerTest.fail((String)"IResourceChangeListenerTest", (Throwable)e);
    }

    protected void setAutoBuilding(boolean value) {
        IWorkspace workspace = IResourceChangeListenerTest.getWorkspace();
        if (workspace.isAutoBuilding() == value) {
            return;
        }
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(value);
        try {
            workspace.setDescription(desc);
        }
        catch (CoreException e) {
            IResourceChangeListenerTest.fail((String)"failed to set workspace description", (Throwable)e);
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project1 = IResourceChangeListenerTest.getWorkspace().getRoot().getProject("Project1");
        this.project2 = IResourceChangeListenerTest.getWorkspace().getRoot().getProject("Project2");
        this.folder1 = this.project1.getFolder("Folder1");
        this.folder2 = this.folder1.getFolder("Folder2");
        this.folder3 = this.folder1.getFolder("File1");
        this.file1 = this.folder1.getFile("File1");
        this.file2 = this.folder1.getFile("File2");
        this.file3 = this.folder2.getFile("File1");
        this.project1MetaData = this.project1.getFile(".project");
        this.project2MetaData = this.project2.getFile(".project");
        IWorkspaceRunnable body = monitor -> {
            this.project1.create(this.getMonitor());
            this.project1.open(this.getMonitor());
            this.folder1.create(true, true, this.getMonitor());
            this.file1.create(this.getRandomContents(), true, this.getMonitor());
        };
        this.verifier = new ResourceDeltaVerifier();
        IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier, 1);
        try {
            IResourceChangeListenerTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceChangeListenerTest.fail((String)"1.0", (Throwable)e);
        }
        this.waitForBuild();
        this.waitForRefresh();
        this.verifier.reset();
    }

    @Override
    protected void tearDown() throws Exception {
        IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.verifier);
        super.tearDown();
        this.ensureDoesNotExistInWorkspace((IResource)IResourceChangeListenerTest.getWorkspace().getRoot());
    }

    public void test_1GDK9OG() {
        IResourceChangeListener listener = event -> {
            try {
                IWorkspaceRunnable body = monitor -> {
                    IResourceDeltaVisitor visitor = delta -> {
                        IResource resource = delta.getResource();
                        resource.touch(this.getMonitor());
                        resource.createMarker("org.eclipse.core.resources.problemmarker");
                        return true;
                    };
                    event.getDelta().accept(visitor);
                };
                IResourceChangeListenerTest.getWorkspace().run(body, this.getMonitor());
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"1.0", (Throwable)e);
            }
        };
        IResourceChangeListenerTest.getWorkspace().addResourceChangeListener(listener, 16);
        try {
            try {
                IWorkspaceRunnable body = new IWorkspaceRunnable(){
                    final IResourceVisitor visitor = resource -> {
                        resource.touch(IResourceChangeListenerTest.this.getMonitor());
                        return true;
                    };

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IResourceChangeListenerTest.getWorkspace().getRoot().accept(this.visitor);
                    }
                };
                IResourceChangeListenerTest.getWorkspace().run(body, this.getMonitor());
                try {
                    Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"2.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener(listener);
            }
        }
        finally {
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    public void testAddAndRemoveFile() {
        try {
            this.verifier.reset();
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and deleting", 100);
                try {
                    this.file2.create(this.getRandomContents(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file2.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            IResourceChangeListenerTest.assertTrue((String)"Unexpected notification on no change", (!this.verifier.hasBeenNotified() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddAndRemoveFolder() {
        try {
            this.verifier.reset();
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and deleting", 100);
                try {
                    this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.folder2.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            IResourceChangeListenerTest.assertTrue((String)"Unexpected notification on no change", (!this.verifier.hasBeenNotified() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.file2, 1, 0);
            this.file2.create(this.getRandomContents(), true, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddFileAndFolder() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file3, 1, 0);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating folder and file", 100);
                try {
                    this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file3.create(this.getRandomContents(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddFolder() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
            this.folder2.create(true, true, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddProject() {
        try {
            this.verifier.addExpectedChange((IResource)this.project2, 1, 0);
            this.verifier.addExpectedChange((IResource)this.project2MetaData, 1, 0);
            this.project2.create(this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testBug45996() {
        IResourceChangeListener listener = event -> {
            boolean failed = false;
            try {
                IWorkspaceRunnable body = monitor -> {
                    IResourceDeltaVisitor visitor = delta -> {
                        IResource resource = delta.getResource();
                        resource.touch(this.getMonitor());
                        resource.createMarker("org.eclipse.core.resources.problemmarker");
                        return true;
                    };
                    event.getDelta().accept(visitor);
                };
                IResourceChangeListenerTest.getWorkspace().run(body, this.getMonitor());
            }
            catch (CoreException coreException) {
                failed = true;
            }
            IResourceChangeListenerTest.assertTrue((String)"1.0", (boolean)failed);
        };
        IResourceChangeListenerTest.getWorkspace().addResourceChangeListener(listener, 1);
        try {
            try {
                IWorkspaceRunnable body = new IWorkspaceRunnable(){
                    final IResourceVisitor visitor = resource -> {
                        resource.touch(IResourceChangeListenerTest.this.getMonitor());
                        return true;
                    };

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IResourceChangeListenerTest.getWorkspace().getRoot().accept(this.visitor);
                    }
                };
                IResourceChangeListenerTest.getWorkspace().run(body, this.getMonitor());
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"2.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener(listener);
            }
        }
        finally {
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    public void testBuildKind() {
        SimpleListener preBuild = new SimpleListener();
        SimpleListener postBuild = new SimpleListener();
        SimpleListener postChange = new SimpleListener();
        IWorkspace workspace = IResourceChangeListenerTest.getWorkspace();
        try {
            try {
                this.setAutoBuilding(false);
                workspace.addResourceChangeListener((IResourceChangeListener)preBuild, 8);
                workspace.addResourceChangeListener((IResourceChangeListener)postBuild, 16);
                workspace.addResourceChangeListener((IResourceChangeListener)postChange, 1);
                int[] triggers = new int[]{10, 6, 15};
                int i = 0;
                while (i < triggers.length) {
                    int trigger = triggers[i];
                    workspace.run(monitor -> {
                        this.file1.touch(null);
                        workspace.build(trigger, monitor);
                    }, this.getMonitor());
                    IResourceChangeListenerTest.assertEquals((String)("1.0." + i), (Object)workspace, (Object)preBuild.source);
                    IResourceChangeListenerTest.assertEquals((String)("1.1." + i), (Object)workspace, (Object)postBuild.source);
                    IResourceChangeListenerTest.assertEquals((String)("1.2." + i), (Object)workspace, (Object)postChange.source);
                    IResourceChangeListenerTest.assertEquals((String)("1.3." + i), (int)trigger, (int)preBuild.trigger);
                    IResourceChangeListenerTest.assertEquals((String)("1.4." + i), (int)trigger, (int)postBuild.trigger);
                    IResourceChangeListenerTest.assertEquals((String)("1.5." + i), (int)0, (int)postChange.trigger);
                    workspace.run(monitor -> {
                        this.file1.touch(null);
                        this.project1.build(trigger, this.getMonitor());
                    }, this.getMonitor());
                    IResourceChangeListenerTest.assertEquals((String)("2.0." + i), (Object)this.project1, (Object)preBuild.source);
                    IResourceChangeListenerTest.assertEquals((String)("2.2." + i), (Object)this.project1, (Object)postBuild.source);
                    IResourceChangeListenerTest.assertEquals((String)("2.2." + i), (Object)workspace, (Object)postChange.source);
                    IResourceChangeListenerTest.assertEquals((String)("2.3." + i), (int)trigger, (int)preBuild.trigger);
                    IResourceChangeListenerTest.assertEquals((String)("2.4." + i), (int)trigger, (int)postBuild.trigger);
                    IResourceChangeListenerTest.assertEquals((String)("2.5." + i), (int)0, (int)postChange.trigger);
                    ++i;
                }
                this.setAutoBuilding(true);
                this.file1.touch(null);
                this.waitForBuild();
                int trigger = 9;
                IResourceChangeListenerTest.assertEquals((String)"1.0", (Object)workspace, (Object)preBuild.source);
                IResourceChangeListenerTest.assertEquals((String)"1.1", (Object)workspace, (Object)postBuild.source);
                IResourceChangeListenerTest.assertEquals((String)"1.2", (Object)workspace, (Object)postChange.source);
                IResourceChangeListenerTest.assertEquals((String)"1.3", (int)trigger, (int)preBuild.trigger);
                IResourceChangeListenerTest.assertEquals((String)"1.4", (int)trigger, (int)postBuild.trigger);
                IResourceChangeListenerTest.assertEquals((String)"1.5", (int)0, (int)postChange.trigger);
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"4.99", (Throwable)e);
                workspace.removeResourceChangeListener((IResourceChangeListener)preBuild);
                workspace.removeResourceChangeListener((IResourceChangeListener)postBuild);
                workspace.removeResourceChangeListener((IResourceChangeListener)postChange);
                this.setAutoBuilding(true);
            }
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)preBuild);
            workspace.removeResourceChangeListener((IResourceChangeListener)postBuild);
            workspace.removeResourceChangeListener((IResourceChangeListener)postChange);
            this.setAutoBuilding(true);
        }
    }

    public void testChangeFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, 4, 256);
            this.file1.setContents(this.getRandomContents(), true, false, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testChangeFileToFolder() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, 4, 295168);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Deleting and Creating", 100);
                try {
                    this.file1.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.folder3.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testChangeFolderToFile() {
        try {
            this.verifier.reset();
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                this.file1.delete(true, this.getMonitor());
                this.folder3.create(true, true, this.getMonitor());
            }, null);
            this.verifier.addExpectedChange((IResource)this.file1, 4, 295168);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Deleting and Creating", 100);
                try {
                    this.folder3.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.create(this.getRandomContents(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testChangeProject() {
        try {
            this.verifier.reset();
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                this.project2.create(this.getMonitor());
                this.project2.open(this.getMonitor());
            }, null);
            IProjectDescription desc = this.project2.getDescription();
            desc.setReferencedProjects(new IProject[]{this.project1});
            this.verifier.addExpectedChange((IResource)this.project2, 4, 524288);
            this.verifier.addExpectedChange((IResource)this.project2MetaData, 4, 256);
            this.project2.setDescription(desc, 1, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testCopyChangeFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file3, 1, 0, null, null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and moving", 150);
                try {
                    this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.copy(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file3.setContents(this.getRandomContents(), 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testCopyFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file3, 1, 0, null, null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and moving", 100);
                try {
                    this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.copy(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testCloseOpenReplaceFile() {
        try {
            this.verifier.reset();
            IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier);
            this.verifier.addExpectedChange((IResource)this.file1, 4, 262400);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Deleting and Creating", 100);
                try {
                    this.file1.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.create(this.getRandomContents(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testDeleteInPostBuildListener() {
        IResourceChangeListener listener = event -> {
            try {
                event.getDelta().accept(delta -> {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1) {
                        ((IFile)resource).delete(true, true, null);
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"1.0", (Throwable)e);
            }
        };
        IResourceChangeListenerTest.getWorkspace().addResourceChangeListener(listener, 16);
        try {
            try {
                IResourceChangeListenerTest.getWorkspace().run(monitor -> IResourceChangeListenerTest.getWorkspace().getRoot().accept(resource -> {
                    resource.touch(this.getMonitor());
                    return true;
                }), this.getMonitor());
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"2.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener(listener);
            }
        }
        finally {
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    public void testDeleteMoveFile() {
        try {
            this.verifier.reset();
            this.file2.create(this.getRandomContents(), 0, this.getMonitor());
            this.verifier.reset();
            int flags = 266496;
            this.verifier.addExpectedChange((IResource)this.file1, 4, flags, this.file2.getFullPath(), null);
            this.verifier.addExpectedChange((IResource)this.file2, 2, 8192, null, this.file1.getFullPath());
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("deleting and moving", 100);
                try {
                    this.file1.delete(0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file2.move(this.file1.getFullPath(), 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteProject() throws CoreException {
        this.verifier.reset();
        IMarker marker = this.project1.createMarker("org.eclipse.core.resources.taskmarker");
        class Listener1
        implements IResourceChangeListener {
            public boolean done = false;
            private final /* synthetic */ IMarker val$marker;

            Listener1(IMarker iMarker) {
                this.val$marker = iMarker;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resourceChanged(IResourceChangeEvent event) {
                this.done = true;
                IMarkerDelta[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.taskmarker", false);
                IResourceChangeListenerTest.assertEquals((String)"1.0", (int)1, (int)deltas.length);
                IResourceChangeListenerTest.assertEquals((String)"1.1", (long)this.val$marker.getId(), (long)deltas[0].getId());
                IResourceChangeListenerTest.assertEquals((String)"1.2", (int)2, (int)deltas[0].getKind());
                Listener1 listener1 = this;
                synchronized (listener1) {
                    this.notifyAll();
                }
            }
        }
        Listener1 listener = new Listener1(marker);
        try {
            IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
            this.project1.delete(true, false, this.getMonitor());
            Listener1 listener1 = listener;
            synchronized (listener1) {
                int i = 0;
                while (!listener.done) {
                    try {
                        listener.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    IResourceChangeListenerTest.assertTrue((String)"2.0", (++i < 60 ? 1 : 0) != 0);
                }
            }
        }
        finally {
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testDeleteFolderDuringRefresh() throws CoreException {
        this.project1 = IResourceChangeListenerTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        this.project1.create(this.getMonitor());
        this.project1.open(this.getMonitor());
        this.project2 = IResourceChangeListenerTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        this.project2.create(this.getMonitor());
        this.project2.open(this.getMonitor());
        IResourceChangeListenerTest.assertTrue((String)"1.0", (boolean)this.project1.isOpen());
        IResourceChangeListenerTest.assertTrue((String)"2.0", (boolean)this.project2.isOpen());
        IFolder f = this.project1.getFolder(this.getUniqueString());
        f.create(true, true, this.getMonitor());
        class Listener1
        implements IResourceChangeListener {
            public boolean wasPerformed = false;
            private final /* synthetic */ IFolder val$f;

            Listener1(IFolder iFolder) {
                this.val$f = iFolder;
            }

            public void resourceChanged(IResourceChangeEvent event) {
                new Job("deleteFolder"){

                    public boolean belongsTo(Object family) {
                        return family == ResourcesPlugin.FAMILY_MANUAL_REFRESH;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            val$f.delete(true, IResourceChangeListenerTest.this.getMonitor());
                            wasPerformed = true;
                        }
                        catch (Exception e) {
                            IResourceChangeListenerTest.fail((String)"3.0", (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        Listener1 listener1 = new Listener1(f);
        try {
            try {
                IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener1, 32);
                this.project2.refreshLocal(2, this.getMonitor());
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
                IResourceChangeListenerTest.assertTrue((String)"4.0", (boolean)listener1.wasPerformed);
                this.assertDoesNotExistInWorkspace("5.0", (IResource)f);
            }
            catch (InterruptedException e) {
                IResourceChangeListenerTest.fail((String)"6.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"7.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
            }
        }
        finally {
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
        }
    }

    public void testRefreshOtherProjectDuringRefresh() throws Exception {
        IProject p = IResourceChangeListenerTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        p.create(null);
        p.open(null);
        this.project1 = IResourceChangeListenerTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        this.project1.create(null);
        this.project1.open(null);
        IResourceChangeListenerTest.assertTrue((String)"1.0", (boolean)p.isOpen());
        IResourceChangeListenerTest.assertTrue((String)"2.0", (boolean)this.project1.isOpen());
        class Listener1
        implements IResourceChangeListener {
            public boolean wasPerformed = false;
            private final /* synthetic */ IProject val$p;

            Listener1(IProject iProject) {
                this.val$p = iProject;
            }

            public void resourceChanged(final IResourceChangeEvent event) {
                new Job("refreshProject"){

                    public boolean belongsTo(Object family) {
                        return family == ResourcesPlugin.FAMILY_MANUAL_REFRESH;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            if (event.getResource() != val$p) {
                                val$p.refreshLocal(2, null);
                            }
                            wasPerformed = true;
                        }
                        catch (Exception e) {
                            IResourceChangeListenerTest.fail((String)"3.0", (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        Listener1 listener1 = new Listener1(p);
        class Listener2
        implements IResourceChangeListener {
            private final /* synthetic */ IProject val$p;

            Listener2(IProject iProject) {
                this.val$p = iProject;
            }

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    if (event.getResource() != this.val$p) {
                        this.val$p.refreshLocal(2, null);
                    }
                    IResourceChangeListenerTest.fail((String)"4.0");
                }
                catch (Exception exception) {}
            }
        }
        Listener2 listener2 = new Listener2(p);
        try {
            try {
                IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener1, 32);
                IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener2, 32);
                this.project1.refreshLocal(2, this.getMonitor());
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
                IResourceChangeListenerTest.assertTrue((String)"5.0", (boolean)listener1.wasPerformed);
            }
            catch (InterruptedException e) {
                IResourceChangeListenerTest.fail((String)"6.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener2);
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"7.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener2);
            }
        }
        finally {
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener2);
        }
    }

    public void testPreRefreshNotification() throws Exception {
        IWorkspaceRoot root = IResourceChangeListenerTest.getWorkspace().getRoot();
        this.project1 = root.getProject(this.getUniqueString());
        this.project1.create(null);
        this.project1.open(null);
        IResourceChangeListenerTest.assertTrue((String)"1.0", (boolean)this.project1.isOpen());
        class Listener1
        implements IResourceChangeListener {
            public boolean wasPerformed = false;
            public Object eventSource;
            public Object eventResource;

            Listener1() {
            }

            public void resourceChanged(IResourceChangeEvent event) {
                this.wasPerformed = true;
                this.eventSource = event.getSource();
                this.eventResource = event.getResource();
            }
        }
        Listener1 listener1 = new Listener1();
        try {
            try {
                IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener1, 32);
                root.refreshLocal(2, this.getMonitor());
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
                IResourceChangeListenerTest.assertTrue((String)"2.0", (boolean)listener1.wasPerformed);
                IResourceChangeListenerTest.assertEquals((String)"3.0", (Object)IResourceChangeListenerTest.getWorkspace(), (Object)listener1.eventSource);
                IResourceChangeListenerTest.assertEquals((String)"4.0", null, (Object)listener1.eventResource);
                this.project1.refreshLocal(2, this.getMonitor());
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
                IResourceChangeListenerTest.assertTrue((String)"5.0", (boolean)listener1.wasPerformed);
                IResourceChangeListenerTest.assertEquals((String)"6.0", (Object)this.project1, (Object)listener1.eventSource);
                IResourceChangeListenerTest.assertEquals((String)"7.0", (Object)this.project1, (Object)listener1.eventResource);
            }
            catch (InterruptedException e) {
                IResourceChangeListenerTest.fail((String)"8.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
            }
            catch (CoreException e) {
                IResourceChangeListenerTest.fail((String)"9.0", (Throwable)e);
                IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
            }
        }
        finally {
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
        }
    }

    public void testHiddenPhantomChanges() {
        IWorkspace workspace = IResourceChangeListenerTest.getWorkspace();
        IFolder phantomFolder = this.project1.getFolder("PhantomFolder");
        IFile phantomFile = this.folder1.getFile("PhantomFile");
        IResource[] phantomResources = new IResource[]{phantomFolder, phantomFile};
        QualifiedName partner = new QualifiedName("Test", "Infected");
        IResourceChangeListener listener = event -> {
            this.assertNotDeltaIncludes("1.0", event.getDelta(), phantomResources);
            this.assertNotDeltaVisits("1.1", event.getDelta(), phantomResources);
        };
        workspace.addResourceChangeListener(listener);
        workspace.getSynchronizer().add(partner);
        this.ensureDoesNotExistInWorkspace(phantomResources);
        try {
            try {
                workspace.run(monitor -> workspace.getSynchronizer().setSyncInfo(partner, (IResource)phantomFolder, new byte[]{1}), this.getMonitor());
                IFile fileInFolder = phantomFolder.getFile("FileInPrivateFolder");
                workspace.getSynchronizer().setSyncInfo(partner, (IResource)fileInFolder, new byte[]{1});
                workspace.getSynchronizer().setSyncInfo(partner, (IResource)fileInFolder, new byte[]{2});
                workspace.getSynchronizer().flushSyncInfo(partner, (IResource)fileInFolder, 2);
                workspace.run(monitor -> {
                    phantomFolder.delete(0, this.getMonitor());
                    this.file1.setContents(this.getRandomContents(), 0, this.getMonitor());
                }, this.getMonitor());
                workspace.run(monitor -> workspace.getSynchronizer().setSyncInfo(partner, (IResource)phantomFile, new byte[]{2}), this.getMonitor());
                workspace.getSynchronizer().setSyncInfo(partner, (IResource)phantomFile, new byte[]{3});
                workspace.getSynchronizer().flushSyncInfo(partner, (IResource)phantomFile, 2);
            }
            catch (CoreException e) {
                this.handleCoreException(e);
                workspace.removeResourceChangeListener(listener);
            }
        }
        finally {
            workspace.removeResourceChangeListener(listener);
        }
    }

    public void testHiddenTeamPrivateChanges() {
        IWorkspace workspace = IResourceChangeListenerTest.getWorkspace();
        IFolder teamPrivateFolder = this.project1.getFolder("TeamPrivateFolder");
        IFile teamPrivateFile = this.folder1.getFile("TeamPrivateFile");
        IResource[] privateResources = new IResource[]{teamPrivateFolder, teamPrivateFile};
        IResourceChangeListener listener = event -> {
            this.assertNotDeltaIncludes("1.0", event.getDelta(), privateResources);
            this.assertNotDeltaVisits("1.1", event.getDelta(), privateResources);
        };
        workspace.addResourceChangeListener(listener);
        try {
            try {
                workspace.run(monitor -> {
                    teamPrivateFolder.create(true, true, this.getMonitor());
                    teamPrivateFolder.setTeamPrivateMember(true);
                }, this.getMonitor());
                IFile fileInFolder = teamPrivateFolder.getFile("FileInPrivateFolder");
                fileInFolder.create(this.getRandomContents(), true, this.getMonitor());
                fileInFolder.setContents(this.getRandomContents(), 0, this.getMonitor());
                fileInFolder.delete(0, this.getMonitor());
                workspace.run(monitor -> {
                    teamPrivateFolder.delete(0, this.getMonitor());
                    this.file1.setContents(this.getRandomContents(), 0, this.getMonitor());
                }, this.getMonitor());
                workspace.run(monitor -> {
                    teamPrivateFile.create(this.getRandomContents(), true, this.getMonitor());
                    teamPrivateFile.setTeamPrivateMember(true);
                }, this.getMonitor());
                teamPrivateFile.setContents(this.getRandomContents(), 0, this.getMonitor());
                teamPrivateFile.delete(0, this.getMonitor());
            }
            catch (CoreException e) {
                this.handleCoreException(e);
                workspace.removeResourceChangeListener(listener);
            }
        }
        finally {
            workspace.removeResourceChangeListener(listener);
        }
    }

    public void testModifyMoveFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.file3, 1, 4352, this.file1.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and moving", 100);
                try {
                    this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.setContents(this.getRandomContents(), 0, this.getMonitor());
                    this.file1.move(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.file3, 1, 4096, this.file1.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and moving", 100);
                try {
                    this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.move(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveFileAddMarker() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.file3, 1, 135168, this.file1.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and moving", 100);
                try {
                    this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.move(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file3.createMarker("org.eclipse.core.resources.taskmarker");
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveFileDeleteFolder() {
        try {
            this.file1.delete(0, null);
            this.file2.create(this.getRandomContents(), 0, null);
            this.folder3.create(0, true, null);
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)this.file2, 2, 8192, null, this.file1.getFullPath());
            int flags = 299264;
            this.verifier.addExpectedChange((IResource)this.file1, 4, flags, this.file2.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Deleting and moving", 100);
                try {
                    this.folder3.delete(1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file2.move(this.file1.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveFileDeleteSourceParent() {
        try {
            this.file1.delete(0, null);
            this.create((IResource)this.file3, true);
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)this.folder2, 2, 0, null, null);
            this.verifier.addExpectedChange((IResource)this.file1, 1, 4096, this.file3.getFullPath(), null);
            this.verifier.addExpectedChange((IResource)this.file3, 2, 8192, null, this.file1.getFullPath());
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and moving", 100);
                try {
                    this.file3.move(this.file1.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.folder2.delete(0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveModifyFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.file3, 1, 4352, this.file1.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and moving", 100);
                try {
                    this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.move(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file3.setContents(this.getRandomContents(), 0, this.getMonitor());
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveMoveFile() {
        this.file2 = this.project1.getFile("File2");
        this.file3 = this.project1.getFile("File3");
        try {
            this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.file3, 1, 4096, this.file1.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("moving and moving file", 100);
                try {
                    this.file1.move(this.file2.getFullPath(), false, null);
                    this.file2.move(this.file3.getFullPath(), false, null);
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveMoveFolder() {
        this.folder2 = this.project1.getFolder("Folder2");
        this.folder3 = this.project1.getFolder("Folder3");
        this.file3 = this.folder3.getFile(this.file1.getName());
        try {
            this.verifier.addExpectedChange((IResource)this.folder1, 2, 8192, null, this.folder3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.folder3, 1, 4096, this.folder1.getFullPath(), null);
            this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.file3, 1, 4096, this.file1.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("moving and moving folder", 100);
                try {
                    this.folder1.move(this.folder2.getFullPath(), false, null);
                    this.folder2.move(this.folder3.getFullPath(), false, null);
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveProject1() {
        try {
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)this.project1, 2, 8192, null, this.project2.getFullPath());
            this.verifier.addExpectedChange((IResource)this.project1.getFile(".project"), 2, 8192, null, this.project2.getFile(".project").getFullPath());
            this.verifier.addExpectedChange((IResource)this.folder1, 2, 8192, null, this.project2.getFolder(this.folder1.getProjectRelativePath()).getFullPath());
            this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.project2.getFile(this.file1.getProjectRelativePath()).getFullPath());
            this.verifier.addExpectedChange((IResource)this.project2, 1, 544768, this.project1.getFullPath(), null);
            this.verifier.addExpectedChange((IResource)this.project2.getFile(".project"), 1, 4352, this.project1.getFile(".project").getFullPath(), null);
            this.verifier.addExpectedChange((IResource)this.project2.getFolder(this.folder1.getProjectRelativePath()), 1, 4096, this.folder1.getFullPath(), null);
            this.verifier.addExpectedChange((IResource)this.project2.getFile(this.file1.getProjectRelativePath()), 1, 4096, this.file1.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Creating and moving", 100);
                try {
                    this.project1.move(this.project2.getFullPath(), 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveProject2() {
        IPath path = this.getRandomLocation();
        try {
            try {
                this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
                IResourceChangeListenerTest.getWorkspace().run(m -> {
                    m.beginTask("Creating and moving", 100);
                    try {
                        IProjectDescription desc = this.project1.getDescription();
                        desc.setLocation(path);
                        this.project1.move(desc, 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    }
                    finally {
                        m.done();
                    }
                }, this.getMonitor());
                this.assertDelta();
            }
            catch (CoreException e) {
                this.handleCoreException(e);
                Workspace.clear((File)path.toFile());
            }
        }
        finally {
            Workspace.clear((File)path.toFile());
        }
    }

    public void testMulti() {
        class Listener1
        implements IResourceChangeListener {
            public boolean done = false;

            Listener1() {
            }

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceChangeListenerTest.assertEquals((String)"1.0", (int)1, (int)event.getType());
                this.done = true;
            }
        }
        Listener1 listener1 = new Listener1();
        class Listener2
        extends Listener1
        implements IResourceChangeListener {
            Listener2() {
            }

            @Override
            public void resourceChanged(IResourceChangeEvent event) {
                IResourceChangeListenerTest.assertEquals((String)"2.0", (int)16, (int)event.getType());
                this.done = true;
            }
        }
        Listener2 listener2 = new Listener2();
        IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener1, 1);
        IResourceChangeListenerTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener2, 16);
        try {
            try {
                this.project1.touch(this.getMonitor());
            }
            catch (CoreException e) {
                this.handleCoreException(e);
            }
            int i = 0;
            while (!listener1.done || !listener2.done) {
                IResourceChangeListenerTest.assertTrue((String)"3.0", (++i < 600 ? 1 : 0) != 0);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
            IResourceChangeListenerTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener2);
        }
    }

    public void testProjectDescriptionComment() {
        try {
            this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
            this.verifier.addExpectedChange((IResource)this.project1MetaData, 4, 256);
            IProjectDescription description = this.project1.getDescription();
            description.setComment("new comment");
            this.project1.setDescription(description, 0, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testProjectDescriptionDynamicRefs() {
        try {
            this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
            IProjectDescription description = this.project1.getDescription();
            description.setDynamicReferences(new IProject[]{this.project2});
            this.project1.setDescription(description, 0, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testProjectDescriptionNatures() {
        try {
            this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
            this.verifier.addExpectedChange((IResource)this.project1MetaData, 4, 256);
            IProjectDescription description = this.project1.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
            this.project1.setDescription(description, 0, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testProjectDescriptionStaticRefs() {
        try {
            this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
            this.verifier.addExpectedChange((IResource)this.project1MetaData, 4, 256);
            IProjectDescription description = this.project1.getDescription();
            description.setReferencedProjects(new IProject[]{this.project2});
            this.project1.setDescription(description, 0, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testRemoveFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, 2, 0);
            this.file1.delete(true, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testRemoveFileAndFolder() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder1, 2, 0);
            this.verifier.addExpectedChange((IResource)this.file1, 2, 0);
            this.folder1.delete(true, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testReplaceFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, 4, 262400);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("Deleting and Creating", 100);
                try {
                    this.file1.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file1.create(this.getRandomContents(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testReplaceFolderWithFolder() {
        try {
            this.folder2 = this.project1.getFolder("Folder2");
            this.folder3 = this.project1.getFolder("Folder3");
            this.verifier.reset();
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                this.file1.delete(false, null);
                this.folder2.create(false, true, null);
            }, null);
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)this.folder1, 2, 8192, null, this.folder2.getFullPath());
            int flags = 274688;
            this.verifier.addExpectedChange((IResource)this.folder2, 4, flags, this.folder1.getFullPath(), this.folder3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.folder3, 1, 4096, this.folder2.getFullPath(), null);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("replace folder with folder", 100);
                try {
                    this.folder2.move(this.folder3.getFullPath(), false, null);
                    this.folder1.move(this.folder2.getFullPath(), false, null);
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testSetLocal() {
        try {
            this.verifier.reset();
            this.file1.setLocal(true, 2, this.getMonitor());
            IResourceChangeListenerTest.assertTrue((String)"Unexpected notification on no change", (!this.verifier.hasBeenNotified() ? 1 : 0) != 0);
            this.verifier.reset();
            this.file1.setLocal(false, 2, this.getMonitor());
            IResourceChangeListenerTest.assertTrue((String)"Unexpected notification on no change", (!this.verifier.hasBeenNotified() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testSwapFiles() {
        try {
            this.file1 = this.project1.getFile("File1");
            this.file2 = this.project1.getFile("File2");
            this.file3 = this.project1.getFile("File3");
            this.verifier.reset();
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                this.file1.create((InputStream)new ByteArrayInputStream(new byte[]{65}), false, null);
                this.file2.create((InputStream)new ByteArrayInputStream(new byte[]{67}), false, null);
            }, null);
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)this.file1, 4, 274688, this.file2.getFullPath(), this.file2.getFullPath());
            this.verifier.addExpectedChange((IResource)this.file2, 4, 274688, this.file1.getFullPath(), this.file1.getFullPath());
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("swap files", 100);
                try {
                    this.file1.move(this.file3.getFullPath(), false, null);
                    this.file2.move(this.file1.getFullPath(), false, null);
                    this.file3.move(this.file2.getFullPath(), false, null);
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testSwapFolders() {
        try {
            this.verifier.reset();
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                this.folder2 = this.project1.getFolder("Folder2");
                this.folder3 = this.project1.getFolder("Folder3");
                this.file1.delete(false, null);
                this.folder2.create(false, true, null);
            }, null);
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)this.folder1, 4, 274688, this.folder2.getFullPath(), this.folder2.getFullPath());
            this.verifier.addExpectedChange((IResource)this.folder2, 4, 274688, this.folder1.getFullPath(), this.folder1.getFullPath());
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("swap folders", 100);
                try {
                    this.folder1.move(this.folder3.getFullPath(), false, null);
                    this.folder2.move(this.folder1.getFullPath(), false, null);
                    this.folder3.move(this.folder2.getFullPath(), false, null);
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testTeamPrivateChanges() {
        IWorkspace workspace = IResourceChangeListenerTest.getWorkspace();
        IFolder teamPrivateFolder = this.project1.getFolder("TeamPrivateFolder");
        IFile teamPrivateFile = this.folder1.getFile("TeamPrivateFile");
        try {
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)teamPrivateFolder, 1, 0);
            workspace.run(monitor -> {
                teamPrivateFolder.create(true, true, this.getMonitor());
                teamPrivateFolder.setTeamPrivateMember(true);
            }, this.getMonitor());
            this.assertDelta();
            this.verifier.reset();
            IFile fileInFolder = teamPrivateFolder.getFile("FileInPrivateFolder");
            this.verifier.addExpectedChange((IResource)fileInFolder, 1, 0);
            fileInFolder.create(this.getRandomContents(), true, this.getMonitor());
            this.assertDelta();
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)fileInFolder, 4, 256);
            fileInFolder.setContents(this.getRandomContents(), 0, this.getMonitor());
            this.assertDelta();
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)fileInFolder, 2, 0);
            fileInFolder.delete(0, this.getMonitor());
            this.assertDelta();
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)teamPrivateFolder, 2, 0);
            this.verifier.addExpectedChange((IResource)this.file1, 4, 256);
            workspace.run(monitor -> {
                teamPrivateFolder.delete(0, this.getMonitor());
                this.file1.setContents(this.getRandomContents(), 0, this.getMonitor());
            }, this.getMonitor());
            this.assertDelta();
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)teamPrivateFile, 1, 0);
            workspace.run(monitor -> {
                teamPrivateFile.create(this.getRandomContents(), true, this.getMonitor());
                teamPrivateFile.setTeamPrivateMember(true);
            }, this.getMonitor());
            this.assertDelta();
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)teamPrivateFile, 4, 256);
            teamPrivateFile.setContents(this.getRandomContents(), 0, this.getMonitor());
            this.assertDelta();
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)teamPrivateFile, 2, 0);
            teamPrivateFile.delete(0, this.getMonitor());
            this.assertDelta();
            this.verifier.reset();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testTwoFileChanges() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, 4, 256);
            this.verifier.addExpectedChange((IResource)this.file2, 1, 0);
            IResourceChangeListenerTest.getWorkspace().run(m -> {
                m.beginTask("setting contents and creating", 100);
                try {
                    this.file1.setContents(this.getRandomContents(), true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                    this.file2.create(this.getRandomContents(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                }
                finally {
                    m.done();
                }
            }, this.getMonitor());
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testRemoveAndCreateUnderlyingFileForLinkedResource() {
        IPath path = this.getTempDir().addTrailingSeparator().append(this.getUniqueString());
        try {
            try {
                try {
                    path.toFile().createNewFile();
                }
                catch (IOException e) {
                    IResourceChangeListenerTest.fail((String)"1.0", (Throwable)e);
                }
                IFile linkedFile = this.project1.getFile(this.getUniqueString());
                linkedFile.createLink(path, 0, this.getMonitor());
                this.verifier.addExpectedChange((IResource)linkedFile, 4, 0x200000);
                path.toFile().delete();
                this.project1.refreshLocal(2, this.getMonitor());
                this.assertDelta();
                this.verifier.addExpectedChange((IResource)linkedFile, 4, 0x200100);
                try {
                    path.toFile().createNewFile();
                }
                catch (IOException e) {
                    IResourceChangeListenerTest.fail((String)"2.0", (Throwable)e);
                }
                this.project1.refreshLocal(2, this.getMonitor());
                this.assertDelta();
            }
            catch (CoreException e) {
                this.handleCoreException(e);
                if (path.toFile().exists()) {
                    path.toFile().delete();
                }
            }
        }
        finally {
            if (path.toFile().exists()) {
                path.toFile().delete();
            }
        }
    }

    public void testRemoveAndCreateUnderlyingFolderForLinkedResource() {
        IPath path = this.getTempDir().addTrailingSeparator().append(this.getUniqueString());
        try {
            try {
                path.toFile().mkdir();
                IFolder linkedFolder = this.project1.getFolder(this.getUniqueString());
                linkedFolder.createLink(path, 0, this.getMonitor());
                this.verifier.addExpectedChange((IResource)linkedFolder, 4, 0x200000);
                path.toFile().delete();
                this.project1.refreshLocal(2, this.getMonitor());
                this.assertDelta();
                this.verifier.addExpectedChange((IResource)linkedFolder, 4, 0x200000);
                path.toFile().mkdir();
                this.project1.refreshLocal(2, this.getMonitor());
                this.assertDelta();
            }
            catch (CoreException e) {
                this.handleCoreException(e);
                if (path.toFile().exists()) {
                    path.toFile().delete();
                }
            }
        }
        finally {
            if (path.toFile().exists()) {
                path.toFile().delete();
            }
        }
    }

    public void testBug228354() {
        IPath path = this.getTempDir().addTrailingSeparator().append(this.getUniqueString());
        try {
            try {
                path.toFile().mkdir();
                IFolder linkedFolder = this.project1.getFolder(this.getUniqueString());
                linkedFolder.createLink(path, 0, this.getMonitor());
                IFolder regularFolder = this.project1.getFolder(this.getUniqueString());
                regularFolder.create(true, true, this.getMonitor());
                this.verifier.addExpectedChange((IResource)regularFolder, 2, 0);
                regularFolder.delete(true, this.getMonitor());
                this.assertDelta();
            }
            catch (CoreException e) {
                this.handleCoreException(e);
                if (path.toFile().exists()) {
                    path.toFile().delete();
                }
            }
        }
        finally {
            if (path.toFile().exists()) {
                path.toFile().delete();
            }
        }
    }

    class SimpleListener
    implements IResourceChangeListener {
        Object source;
        int trigger;

        SimpleListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            this.source = event.getSource();
            this.trigger = event.getBuildKind();
        }
    }
}

