/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.harness.CancelingProgressMonitor;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.TestPerformer;

public class LinkedResourceTest
extends ResourceTest {
    protected String childName = "File.txt";
    protected IProject closedProject;
    protected IFile existingFileInExistingProject;
    protected IFolder existingFolderInExistingFolder;
    protected IFolder existingFolderInExistingProject;
    protected IProject existingProject;
    protected IProject existingProjectInSubDirectory;
    protected IPath localFile;
    protected IPath localFolder;
    protected IFile nonExistingFileInExistingFolder;
    protected IFile nonExistingFileInExistingProject;
    protected IFile nonExistingFileInOtherExistingProject;
    protected IFolder nonExistingFolderInExistingFolder;
    protected IFolder nonExistingFolderInExistingProject;
    protected IFolder nonExistingFolderInNonExistingFolder;
    protected IFolder nonExistingFolderInNonExistingProject;
    protected IFolder nonExistingFolderInOtherExistingProject;
    protected IPath nonExistingLocation;
    protected IProject nonExistingProject;
    protected IProject otherExistingProject;

    public static Test suite() {
        return new TestSuite(LinkedResourceTest.class);
    }

    public LinkedResourceTest() {
    }

    public LinkedResourceTest(String name) {
        super(name);
    }

    protected void doCleanup() throws Exception {
        this.ensureExistsInWorkspace(new IResource[]{this.existingProject, this.otherExistingProject, this.closedProject, this.existingFolderInExistingProject, this.existingFolderInExistingFolder, this.existingFileInExistingProject}, true);
        this.closedProject.close(this.getMonitor());
        this.ensureDoesNotExistInWorkspace(new IResource[]{this.nonExistingProject, this.nonExistingFolderInExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInOtherExistingProject, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFileInExistingFolder});
        this.ensureDoesNotExistInFileSystem(this.resolve(this.nonExistingLocation).toFile());
        this.resolve(this.localFolder).toFile().mkdirs();
        this.createFileInFileSystem(this.resolve(this.localFile), this.getRandomContents());
    }

    private byte[] getFileContents(IFile file) throws CoreException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.transferData(new BufferedInputStream(file.getContents()), bout);
        return bout.toByteArray();
    }

    protected IPath resolve(IPath path) {
        return path;
    }

    protected URI resolve(URI uri) {
        return uri;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.existingProject = LinkedResourceTest.getWorkspace().getRoot().getProject("ExistingProject");
        this.existingProjectInSubDirectory = LinkedResourceTest.getWorkspace().getRoot().getProject("ExistingProjectInSubDirectory");
        this.otherExistingProject = LinkedResourceTest.getWorkspace().getRoot().getProject("OtherExistingProject");
        this.closedProject = LinkedResourceTest.getWorkspace().getRoot().getProject("ClosedProject");
        this.existingFolderInExistingProject = this.existingProject.getFolder("existingFolderInExistingProject");
        this.existingFolderInExistingFolder = this.existingFolderInExistingProject.getFolder("existingFolderInExistingFolder");
        this.nonExistingFolderInExistingProject = this.existingProject.getFolder("nonExistingFolderInExistingProject");
        this.nonExistingFolderInOtherExistingProject = this.otherExistingProject.getFolder("nonExistingFolderInOtherExistingProject");
        this.nonExistingFolderInNonExistingFolder = this.nonExistingFolderInExistingProject.getFolder("nonExistingFolderInNonExistingFolder");
        this.nonExistingFolderInExistingFolder = this.existingFolderInExistingProject.getFolder("nonExistingFolderInExistingFolder");
        this.nonExistingProject = LinkedResourceTest.getWorkspace().getRoot().getProject("NonProject");
        this.nonExistingFolderInNonExistingProject = this.nonExistingProject.getFolder("nonExistingFolderInNonExistingProject");
        this.existingFileInExistingProject = this.existingProject.getFile("existingFileInExistingProject");
        this.nonExistingFileInExistingProject = this.existingProject.getFile("nonExistingFileInExistingProject");
        this.nonExistingFileInOtherExistingProject = this.otherExistingProject.getFile("nonExistingFileInOtherExistingProject");
        this.nonExistingFileInExistingFolder = this.existingFolderInExistingProject.getFile("nonExistingFileInExistingFolder");
        this.localFolder = this.getRandomLocation();
        this.nonExistingLocation = this.getRandomLocation();
        this.localFile = this.localFolder.append(this.childName);
        this.doCleanup();
        if (!this.existingProjectInSubDirectory.exists()) {
            IProjectDescription desc = LinkedResourceTest.getWorkspace().newProjectDescription(this.existingProjectInSubDirectory.getName());
            File dir = this.existingProject.getLocation().toFile();
            dir = dir.getParentFile();
            dir = new File(dir + File.separator + "sub" + File.separator + "dir" + File.separator + "more" + File.separator + "proj");
            dir.mkdirs();
            desc.setLocation(Path.fromOSString((String)dir.getAbsolutePath()));
            this.existingProjectInSubDirectory.create(desc, this.getMonitor());
        }
        if (!this.existingProjectInSubDirectory.isOpen()) {
            this.existingProjectInSubDirectory.open(this.getMonitor());
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Workspace.clear((File)this.resolve(this.localFolder).toFile());
        Workspace.clear((File)this.resolve(this.nonExistingLocation).toFile());
    }

    public void testAllowMissingLocal() {
        IPath location = this.getRandomLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        try {
            folder.createLink(location, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            folder.createLink(location, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.1", (Throwable)e);
        }
        LinkedResourceTest.assertEquals((String)"1.2", (Object)this.resolve(location), (Object)folder.getLocation());
        LinkedResourceTest.assertTrue((String)"1.3", (!this.resolve(location).toFile().exists() ? 1 : 0) != 0);
        try {
            LinkedResourceTest.assertEquals((String)"1.4", (int)0, (int)folder.members().length);
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.5", (Throwable)e);
        }
        try {
            folder.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.6", (Throwable)e);
        }
        location = LinkedResourceTest.isWindows() ? new Path("b:\\does\\not\\exist") : new Path("/dev/null/does/not/exist");
        location = FileUtil.canonicalPath((IPath)location);
        try {
            folder.createLink(location, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"2.1");
        }
        catch (CoreException coreException) {}
        try {
            folder.createLink(location, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"2.2", (Throwable)e);
        }
        LinkedResourceTest.assertEquals((String)"2.3", (Object)location, (Object)folder.getLocation());
        LinkedResourceTest.assertTrue((String)"2.4", (!location.toFile().exists() ? 1 : 0) != 0);
        try {
            folder.getFile("abc.txt").create(this.getRandomContents(), 0, this.getMonitor());
            LinkedResourceTest.fail((String)"2.5");
        }
        catch (CoreException coreException) {}
    }

    public void testBlockedFolder() {
        this.ensureExistsInFileSystem((IResource)this.nonExistingFolderInExistingProject);
        IFile blockedFile = this.nonExistingFolderInExistingProject.getFile("BlockedFile");
        this.createFileInFileSystem(blockedFile.getLocation(), this.getRandomContents());
        try {
            this.nonExistingFolderInExistingProject.createLink(this.localFolder, 0, this.getMonitor());
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.1", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"1.2", (!blockedFile.exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"1.3", (boolean)this.nonExistingFolderInExistingProject.exists());
        LinkedResourceTest.assertTrue((String)"1.4", (boolean)this.nonExistingFolderInExistingProject.getFile(this.childName).exists());
        LinkedResourceTest.assertEquals((String)"1.5", (Object)this.nonExistingFolderInExistingProject.getLocation(), (Object)this.resolve(this.localFolder));
        try {
            this.nonExistingFolderInExistingProject.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"2.0", (!blockedFile.exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.1", (!this.nonExistingFolderInExistingProject.exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.2", (!this.nonExistingFolderInExistingProject.getFile(this.childName).exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertEquals((String)"2.3", (Object)this.nonExistingFolderInExistingProject.getLocation(), (Object)this.existingProject.getLocation().append(this.nonExistingFolderInExistingProject.getName()));
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"2.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"3.0", (boolean)blockedFile.exists());
        LinkedResourceTest.assertTrue((String)"3.1", (boolean)this.nonExistingFolderInExistingProject.exists());
        LinkedResourceTest.assertTrue((String)"3.2", (!this.nonExistingFolderInExistingProject.getFile(this.childName).exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertEquals((String)"3.3", (Object)this.nonExistingFolderInExistingProject.getLocation(), (Object)this.existingProject.getLocation().append(this.nonExistingFolderInExistingProject.getName()));
        try {
            this.nonExistingFolderInExistingProject.createLink(this.localFolder, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"3.4");
        }
        catch (CoreException coreException) {}
    }

    public void testChangeLinkGender() {
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile file = folder.getProject().getFile(folder.getProjectRelativePath());
        IPath resolvedLocation = this.resolve(this.localFolder);
        try {
            folder.createLink(this.localFolder, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        this.ensureDoesNotExistInFileSystem(resolvedLocation.toFile());
        this.createFileInFileSystem(resolvedLocation, this.getRandomContents());
        try {
            folder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"2.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"3.0", (!folder.exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"3.1", (boolean)file.exists());
        LinkedResourceTest.assertTrue((String)"3.2", (boolean)file.isLinked());
        LinkedResourceTest.assertEquals((String)"3.3", (Object)resolvedLocation, (Object)file.getLocation());
        this.ensureDoesNotExistInFileSystem(resolvedLocation.toFile());
        resolvedLocation.toFile().mkdirs();
        try {
            folder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"3.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"4.0", (boolean)folder.exists());
        LinkedResourceTest.assertTrue((String)"4.1", (!file.exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"4.2", (boolean)folder.isLinked());
        LinkedResourceTest.assertEquals((String)"4.3", (Object)resolvedLocation, (Object)folder.getLocation());
    }

    public void testCopyFile() {
        IResource[] sources = new IResource[]{this.nonExistingFileInExistingProject, this.nonExistingFileInExistingFolder};
        IResource[] destinationResources = new IResource[]{this.existingProject, this.closedProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFileInExistingFolder};
        Boolean[] deepCopy = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{sources, destinationResources, deepCopy, monitors};
        new TestPerformer("LinkedResourceTest.testCopyFile"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    LinkedResourceTest.fail((String)("invocation " + count + " failed to cleanup"), (Throwable)e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                try {
                    source.createLink(LinkedResourceTest.this.localFile, 0, null);
                    source.copy(destination.getFullPath(), isDeep ? 0 : 32, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                if (source.equals((Object)destination)) {
                    return true;
                }
                IContainer parent = destination.getParent();
                if (!isDeep && parent == null) {
                    return true;
                }
                if (!parent.isAccessible()) {
                    return true;
                }
                return destination.exists();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (!destination.exists()) {
                    return false;
                }
                if (isDeep) {
                    if (destination.isLinked()) {
                        return false;
                    }
                    if (source.getLocation().equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!destination.getProject().getLocation().isPrefixOf(destination.getLocation())) {
                        return false;
                    }
                } else {
                    if (!destination.isLinked()) {
                        return false;
                    }
                    if (!source.getLocation().equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!source.getRawLocation().equals((Object)destination.getRawLocation())) {
                        return false;
                    }
                    if (!source.getLocationURI().equals(destination.getLocationURI())) {
                        return false;
                    }
                }
                return true;
            }
        }.performTest(inputs);
    }

    public void testCopyFolder() {
        IFolder[] sources = new IFolder[]{this.nonExistingFolderInExistingProject, this.nonExistingFolderInExistingFolder};
        IResource[] destinations = new IResource[]{this.existingProject, this.closedProject, this.nonExistingProject, this.existingFolderInExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingFolderInExistingFolder};
        Boolean[] deepCopy = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{sources, destinations, deepCopy, monitors};
        new TestPerformer("LinkedResourceTest.testCopyFolder"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    LinkedResourceTest.fail((String)("invocation " + count + " failed to cleanup"), (Throwable)e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                try {
                    source.createLink(LinkedResourceTest.this.localFolder, 0, null);
                    source.copy(destination.getFullPath(), isDeep ? 0 : 32, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                IContainer parent = destination.getParent();
                if (destination.getType() == 4) {
                    return true;
                }
                if (source.equals((Object)destination)) {
                    return true;
                }
                if (!isDeep && parent == null) {
                    return true;
                }
                if (!parent.isAccessible()) {
                    return true;
                }
                return destination.exists();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (!destination.exists()) {
                    return false;
                }
                if (isDeep) {
                    if (destination.isLinked()) {
                        return false;
                    }
                    if (source.getLocation().equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!destination.getProject().getLocation().isPrefixOf(destination.getLocation())) {
                        return false;
                    }
                } else {
                    if (!destination.isLinked()) {
                        return false;
                    }
                    if (!source.getLocation().equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!source.getLocationURI().equals(destination.getLocationURI())) {
                        return false;
                    }
                    if (!source.getRawLocation().equals((Object)destination.getRawLocation())) {
                        return false;
                    }
                }
                return true;
            }
        }.performTest(inputs);
    }

    public void testCopyMissingFile() {
        IPath location = this.getRandomLocation();
        IFile linkedFile = this.nonExistingFileInExistingProject;
        try {
            linkedFile.createLink(location, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IFile dest = this.existingProject.getFile("FailedCopyDest");
        try {
            linkedFile.copy(dest.getFullPath(), 0, this.getMonitor());
            LinkedResourceTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        LinkedResourceTest.assertTrue((String)"2.1", (!dest.exists() ? 1 : 0) != 0);
        try {
            linkedFile.copy(dest.getFullPath(), 1, this.getMonitor());
            LinkedResourceTest.fail((String)"2.2");
        }
        catch (CoreException coreException) {}
        LinkedResourceTest.assertTrue((String)"2.3", (!dest.exists() ? 1 : 0) != 0);
    }

    public void testCopyMissingFolder() {
        IPath location = this.getRandomLocation();
        IFolder linkedFolder = this.nonExistingFolderInExistingProject;
        try {
            linkedFolder.createLink(location, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IFolder dest = this.existingProject.getFolder("FailedCopyDest");
        try {
            linkedFolder.copy(dest.getFullPath(), 0, this.getMonitor());
            LinkedResourceTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        LinkedResourceTest.assertTrue((String)"2.1", (!dest.exists() ? 1 : 0) != 0);
        try {
            linkedFolder.copy(dest.getFullPath(), 1, this.getMonitor());
            LinkedResourceTest.fail((String)"2.2");
        }
        catch (CoreException coreException) {}
        LinkedResourceTest.assertTrue((String)"2.3", (!dest.exists() ? 1 : 0) != 0);
    }

    public void testCopyProjectWithLinks() {
        IPath fileLocation = this.getRandomLocation();
        IFile linkedFile = this.nonExistingFileInExistingProject;
        IFolder linkedFolder = this.nonExistingFolderInExistingProject;
        try {
            int i;
            IResource[] srcChildren;
            try {
                this.createFileInFileSystem(this.resolve(fileLocation), this.getRandomContents());
                linkedFolder.createLink(this.localFolder, 0, this.getMonitor());
                linkedFile.createLink(fileLocation, 0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"1.0", (Throwable)e);
            }
            IProject destination = LinkedResourceTest.getWorkspace().getRoot().getProject("CopyTargetProject");
            try {
                this.existingProject.copy(destination.getFullPath(), 32, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"2.0", (Throwable)e);
            }
            IFile newFile = destination.getFile(linkedFile.getProjectRelativePath());
            LinkedResourceTest.assertTrue((String)"3.0", (boolean)newFile.isLinked());
            LinkedResourceTest.assertEquals((String)"3.1", (Object)linkedFile.getLocation(), (Object)newFile.getLocation());
            IFolder newFolder = destination.getFolder(linkedFolder.getProjectRelativePath());
            LinkedResourceTest.assertTrue((String)"4.0", (boolean)newFolder.isLinked());
            LinkedResourceTest.assertEquals((String)"4.1", (Object)linkedFolder.getLocation(), (Object)newFolder.getLocation());
            try {
                destination.delete(0, this.getMonitor());
                this.existingProject.copy(destination.getFullPath(), 0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"5.0", (Throwable)e);
            }
            LinkedResourceTest.assertTrue((String)"5.1", (!newFile.isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertEquals((String)"5.2", (Object)destination.getLocation().append(newFile.getProjectRelativePath()), (Object)newFile.getLocation());
            LinkedResourceTest.assertTrue((String)"5.3", (!newFolder.isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertEquals((String)"5.4", (Object)destination.getLocation().append(newFolder.getProjectRelativePath()), (Object)newFolder.getLocation());
            try {
                destination.delete(0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"5.99", (Throwable)e);
            }
            LinkedResourceTest.assertTrue((String)"6.0", (boolean)this.resolve(fileLocation).toFile().delete());
            try {
                this.existingProject.copy(destination.getFullPath(), 0, this.getMonitor());
                LinkedResourceTest.fail((String)"6.1");
            }
            catch (CoreException coreException) {}
            LinkedResourceTest.assertTrue((String)"6.2", (boolean)destination.exists());
            LinkedResourceTest.assertTrue((String)"6.2.1", (!destination.getFile(linkedFile.getName()).exists() ? 1 : 0) != 0);
            try {
                srcChildren = this.existingProject.members();
                i = 0;
                while (i < srcChildren.length) {
                    if (!srcChildren[i].equals((Object)linkedFile)) {
                        LinkedResourceTest.assertNotNull((String)("6.3." + i), (Object)destination.findMember(srcChildren[i].getProjectRelativePath()));
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"6.4", (Throwable)e);
            }
            try {
                destination.delete(0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"6.5", (Throwable)e);
            }
            try {
                this.existingProject.copy(destination.getFullPath(), 1, this.getMonitor());
                LinkedResourceTest.fail((String)"6.6");
            }
            catch (CoreException coreException) {}
            LinkedResourceTest.assertTrue((String)"6.7", (boolean)destination.exists());
            LinkedResourceTest.assertTrue((String)"6.7.1", (!destination.getFile(linkedFile.getName()).exists() ? 1 : 0) != 0);
            try {
                srcChildren = this.existingProject.members();
                i = 0;
                while (i < srcChildren.length) {
                    if (!srcChildren[i].equals((Object)linkedFile)) {
                        LinkedResourceTest.assertNotNull((String)("6.8." + i), (Object)destination.findMember(srcChildren[i].getProjectRelativePath()));
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"6.99", (Throwable)e);
            }
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testCreateFolderInBackground() throws CoreException {
        IFileStore rootStore = this.getTempStore();
        rootStore.mkdir(0, this.getMonitor());
        IFileStore childStore = rootStore.getChild("file.txt");
        this.createFileInFileSystem(childStore);
        IFolder link = this.nonExistingFolderInExistingProject;
        link.createLink(rootStore.toURI(), 128, this.getMonitor());
        this.waitForRefresh();
        IFile linkChild = link.getFile(childStore.getName());
        LinkedResourceTest.assertTrue((String)"1.0", (boolean)link.exists());
        LinkedResourceTest.assertTrue((String)"1.1", (boolean)link.isSynchronized(2));
        LinkedResourceTest.assertTrue((String)"1.2", (boolean)linkChild.exists());
        LinkedResourceTest.assertTrue((String)"1.3", (boolean)linkChild.isSynchronized(2));
    }

    public void testCreateLinkCaseVariant() {
        block3: {
            IFolder link = this.nonExistingFolderInExistingProject;
            IFolder variant = link.getParent().getFolder((IPath)new Path(link.getName().toUpperCase()));
            this.ensureExistsInWorkspace((IResource)variant, true);
            try {
                link.createLink(this.localFolder, 0, this.getMonitor());
                if (!LinkedResourceTest.isCaseSensitive((IResource)variant)) {
                    LinkedResourceTest.fail((String)"1.0");
                }
            }
            catch (CoreException e) {
                if (!LinkedResourceTest.isCaseSensitive((IResource)variant)) break block3;
                LinkedResourceTest.fail((String)"1.1", (Throwable)e);
            }
        }
    }

    public void testCreateLinkInDotProject() {
        IFile dotProject = this.existingProject.getFile(".project");
        IFile link = this.nonExistingFileInExistingProject;
        byte[] oldContents = null;
        try {
            link.createLink(this.localFile, 0, this.getMonitor());
            oldContents = this.getFileContents(dotProject);
            link.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        byte[] finalContents = oldContents;
        try {
            LinkedResourceTest.getWorkspace().run(monitor -> dotProject.setContents((InputStream)new ByteArrayInputStream(finalContents), 0, this.getMonitor()), LinkedResourceTest.getWorkspace().getRuleFactory().modifyRule((IResource)dotProject), 0, this.getMonitor());
        }
        catch (CoreException e1) {
            LinkedResourceTest.fail((String)"2.99", (Throwable)e1);
        }
    }

    public void testCreateProjectWithDeepLinks() {
        IProject project = this.existingProject;
        IFolder parent = this.existingFolderInExistingProject;
        IFolder folder = this.nonExistingFolderInExistingFolder;
        try {
            folder.createLink(this.localFolder, 0, this.getMonitor());
            project.delete(8, this.getMonitor());
            project.create(this.getMonitor());
            project.open(128, this.getMonitor());
            LinkedResourceTest.assertTrue((String)"1.0", (boolean)folder.exists());
            LinkedResourceTest.assertTrue((String)"1.1", (boolean)parent.exists());
            LinkedResourceTest.assertTrue((String)"1.2", (boolean)parent.isLocal(2));
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testCreateHiddenLinkedResources() {
        IFolder folder = this.existingProject.getFolder("folder");
        IFile file = this.existingProject.getFile("file.txt");
        try {
            folder.createLink(this.localFolder, 4096, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            file.createLink(this.localFile, 4096, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"2.0", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"3.0", (boolean)folder.isHidden());
        LinkedResourceTest.assertTrue((String)"4.0", (boolean)file.isHidden());
    }

    public void testDeepMoveProjectWithLinks() {
        IPath fileLocation = this.getRandomLocation();
        IFile file = this.nonExistingFileInExistingProject;
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile childFile = folder.getFile(this.childName);
        IResource[] oldResources = new IResource[]{file, folder, this.existingProject, childFile};
        try {
            try {
                this.createFileInFileSystem(this.resolve(fileLocation));
                folder.createLink(this.localFolder, 0, this.getMonitor());
                file.createLink(fileLocation, 0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"1.0", (Throwable)e);
            }
            IProject destination = LinkedResourceTest.getWorkspace().getRoot().getProject("MoveTargetProject");
            IFile newFile = destination.getFile(file.getProjectRelativePath());
            IFolder newFolder = destination.getFolder(folder.getProjectRelativePath());
            IFile newChildFile = newFolder.getFile(this.childName);
            IResource[] newResources = new IResource[]{destination, newFile, newFolder, newChildFile};
            this.assertDoesNotExistInWorkspace("2.0", (IResource)destination);
            try {
                this.existingProject.move(destination.getFullPath(), 0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"2.1", (Throwable)e);
            }
            this.assertExistsInWorkspace("3.0", newResources);
            this.assertDoesNotExistInWorkspace("3.1", oldResources);
            LinkedResourceTest.assertTrue((String)"3.2", (boolean)this.existingProject.isSynchronized(2));
            LinkedResourceTest.assertTrue((String)"3.3", (boolean)destination.isSynchronized(2));
            LinkedResourceTest.assertTrue((String)"3.4", (!newFile.isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertEquals((String)"3.5", (Object)destination.getLocation().append(newFile.getProjectRelativePath()), (Object)newFile.getLocation());
            LinkedResourceTest.assertTrue((String)"3.6", (!newFolder.isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertEquals((String)"3.7", (Object)destination.getLocation().append(newFolder.getProjectRelativePath()), (Object)newFolder.getLocation());
            LinkedResourceTest.assertTrue((String)"3.8", (boolean)destination.isSynchronized(2));
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testDeleteLinkParent() {
        IFolder link = this.nonExistingFolderInExistingFolder;
        IFolder linkParent = this.existingFolderInExistingProject;
        IFile linkChild = link.getFile("child.txt");
        IFileStore childStore = null;
        try {
            link.createLink(this.localFolder, 0, this.getMonitor());
            this.ensureExistsInWorkspace((IResource)linkChild, true);
            childStore = EFS.getStore((URI)linkChild.getLocationURI());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"1.0", (boolean)linkParent.exists());
        LinkedResourceTest.assertTrue((String)"1.1", (boolean)link.exists());
        LinkedResourceTest.assertTrue((String)"1.2", (boolean)linkChild.exists());
        try {
            linkParent.delete(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"2.0", (!linkParent.exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.1", (!link.exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.2", (!linkChild.exists() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.3", (boolean)childStore.fetchInfo().exists());
    }

    public void testDeleteProjectWithLinks() {
        IFolder link = this.nonExistingFolderInExistingProject;
        try {
            link.createLink(this.localFolder, 0, this.getMonitor());
            this.existingProject.delete(8, this.getMonitor());
            this.existingProject.create(this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"1.0", (!link.exists() ? 1 : 0) != 0);
        try {
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"2.0", (boolean)link.exists());
        LinkedResourceTest.assertTrue((String)"2.1", (boolean)link.isLinked());
        LinkedResourceTest.assertEquals((String)"2.2", (Object)this.resolve(this.localFolder), (Object)link.getLocation());
    }

    public void testDeleteLink_Bug351823() throws CoreException {
        IProject project = this.existingProject;
        IFile link = project.getFile(this.getUniqueString());
        link.createLink(this.localFile, 0, this.getMonitor());
        IFile descriptionFile = project.getFile(".project");
        ResourceAttributes attrs = descriptionFile.getResourceAttributes();
        attrs.setReadOnly(true);
        descriptionFile.setResourceAttributes(attrs);
        try {
            try {
                link.delete(false, this.getMonitor());
                LinkedResourceTest.fail((String)"1.0");
            }
            catch (CoreException coreException) {}
            LinkedResourceTest.assertTrue((String)"2.0", (boolean)link.exists());
            LinkedResourceTest.assertTrue((String)"3.0", (boolean)link.isLinked());
            HashMap links = ((Project)project).internalGetDescription().getLinks();
            LinkedResourceTest.assertNotNull((String)"4.0", (Object)links);
            LinkedResourceTest.assertEquals((String)"5.0", (int)1, (int)links.size());
            LinkDescription linkDesc = (LinkDescription)links.values().iterator().next();
            LinkedResourceTest.assertEquals((String)"6.0", (Object)link.getProjectRelativePath(), (Object)linkDesc.getProjectRelativePath());
            try {
                link.delete(false, this.getMonitor());
                LinkedResourceTest.fail((String)"7.0");
            }
            catch (CoreException coreException) {}
        }
        finally {
            attrs = descriptionFile.getResourceAttributes();
            attrs.setReadOnly(false);
            descriptionFile.setResourceAttributes(attrs);
        }
    }

    public void testDeleteFolderWithLinks() {
        IProject project = this.existingProject;
        IFolder folder = this.existingFolderInExistingProject;
        IFile file1 = folder.getFile(this.getUniqueString());
        IFile file2 = project.getFile(this.getUniqueString());
        try {
            file1.createLink(this.localFile, 0, this.getMonitor());
            file2.createLink(this.localFile, 0, this.getMonitor());
            HashMap links = ((Project)project).internalGetDescription().getLinks();
            LinkDescription linkDescription1 = (LinkDescription)links.get(file1.getProjectRelativePath());
            LinkedResourceTest.assertNotNull((String)"1.0", (Object)linkDescription1);
            LinkedResourceTest.assertEquals((String)"1.1", (Object)URIUtil.toURI((IPath)this.localFile), (Object)linkDescription1.getLocationURI());
            LinkDescription linkDescription2 = (LinkDescription)links.get(file2.getProjectRelativePath());
            LinkedResourceTest.assertNotNull((String)"2.0", (Object)linkDescription2);
            LinkedResourceTest.assertEquals((String)"2.1", (Object)URIUtil.toURI((IPath)this.localFile), (Object)linkDescription2.getLocationURI());
            folder.delete(true, this.getMonitor());
            links = ((Project)project).internalGetDescription().getLinks();
            linkDescription1 = (LinkDescription)links.get(file1.getProjectRelativePath());
            LinkedResourceTest.assertNull((String)"3.0", (Object)linkDescription1);
            linkDescription2 = (LinkDescription)links.get(file2.getProjectRelativePath());
            LinkedResourceTest.assertNotNull((String)"4.0", (Object)linkDescription2);
            LinkedResourceTest.assertEquals((String)"4.1", (Object)URIUtil.toURI((IPath)this.localFile), (Object)linkDescription2.getLocationURI());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"5.0", (Throwable)e);
        }
    }

    public void testFindFilesForLocationCaseVariant() {
        if (!LinkedResourceTest.isWindows()) {
            return;
        }
        IFolder link = this.nonExistingFolderInExistingProject;
        IPath localLocation = this.resolve(this.localFolder);
        IPath upperCase = localLocation.setDevice(localLocation.getDevice().toUpperCase());
        IPath lowerCase = localLocation.setDevice(localLocation.getDevice().toLowerCase());
        try {
            link.createLink(upperCase, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IPath lowerCaseFilePath = lowerCase.append("file.txt");
        IFile[] files = LinkedResourceTest.getWorkspace().getRoot().findFilesForLocation(lowerCaseFilePath);
        LinkedResourceTest.assertEquals((String)"1.0", (int)1, (int)files.length);
    }

    public void testIsLinked() {
        IResource[] toTest = new IResource[]{this.closedProject, this.existingFileInExistingProject, this.existingFolderInExistingFolder, this.existingFolderInExistingProject, this.existingProject, this.nonExistingFileInExistingFolder, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingProject, this.otherExistingProject};
        int i = 0;
        while (i < toTest.length) {
            LinkedResourceTest.assertTrue((String)("1.0 " + toTest[i]), (!toTest[i].isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)("1.1 " + toTest[i]), (!toTest[i].isLinked(0) ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)("1.2 " + toTest[i]), (!toTest[i].isLinked(512) ? 1 : 0) != 0);
            ++i;
        }
        IFolder link = this.nonExistingFolderInExistingProject;
        try {
            link.createLink(this.localFolder, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IFile child = link.getFile(this.childName);
        LinkedResourceTest.assertTrue((String)"2.0", (boolean)child.exists());
        LinkedResourceTest.assertTrue((String)"2.1", (boolean)link.isLinked());
        LinkedResourceTest.assertTrue((String)"2.2", (boolean)link.isLinked(0));
        LinkedResourceTest.assertTrue((String)"2.3", (boolean)link.isLinked(512));
        LinkedResourceTest.assertTrue((String)"2.1", (!child.isLinked() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.2", (!child.isLinked(0) ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.3", (boolean)child.isLinked(512));
    }

    public void testsetLinkLocation() {
        IResource[] toTest = new IResource[]{this.closedProject, this.existingFileInExistingProject, this.existingFolderInExistingFolder, this.existingFolderInExistingProject, this.existingProject, this.nonExistingFileInExistingFolder, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingProject, this.otherExistingProject};
        int i = 0;
        while (i < toTest.length) {
            LinkedResourceTest.assertTrue((String)("1.0 " + toTest[i]), (!toTest[i].isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)("1.1 " + toTest[i]), (!toTest[i].isLinked(0) ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)("1.2 " + toTest[i]), (!toTest[i].isLinked(512) ? 1 : 0) != 0);
            ++i;
        }
        IFolder link = this.nonExistingFolderInExistingProject;
        try {
            link.createLink(this.localFolder, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IFile child = link.getFile(this.childName);
        LinkedResourceTest.assertTrue((String)"2.0", (boolean)child.exists());
        LinkedResourceTest.assertTrue((String)"2.1", (boolean)link.isLinked());
        LinkedResourceTest.assertTrue((String)"2.2", (boolean)link.isLinked(0));
        LinkedResourceTest.assertTrue((String)"2.3", (boolean)link.isLinked(512));
        LinkedResourceTest.assertTrue((String)"2.1", (!child.isLinked() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.2", (!child.isLinked(0) ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.3", (boolean)child.isLinked(512));
        try {
            link.createLink(this.existingFileInExistingProject.getLocationURI(), 256, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"2.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"3.1", (boolean)link.isLinked());
        LinkedResourceTest.assertTrue((String)"3.2", (boolean)link.isLinked(0));
        LinkedResourceTest.assertTrue((String)"3.3", (boolean)link.isLinked(512));
        LinkedResourceTest.assertTrue((String)"3.4", (boolean)link.getLocation().equals((Object)this.existingFileInExistingProject.getLocation()));
    }

    public void testSetLinkLocationSwapLinkedResource() {
        IPath parentLoc = this.existingFolderInExistingProject.getLocation();
        IPath childLoc = this.existingFolderInExistingFolder.getLocation();
        try {
            this.nonExistingFolderInExistingProject.createLink(parentLoc, 0, this.getMonitor());
            this.nonExistingFolderInOtherExistingProject.createLink(childLoc, 0, this.getMonitor());
            this.create((IResource)this.nonExistingFolderInOtherExistingProject.getFile("foo"), true);
            LinkedResourceTest.assertTrue((String)"2.0", (this.existingFolderInExistingFolder.members().length == 1 ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)"3.0", (boolean)this.existingFolderInExistingFolder.members()[0].getName().equals("foo"));
            LinkedResourceTest.assertTrue((String)"2.0", (this.nonExistingFolderInOtherExistingProject.members().length == 1 ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)"3.0", (boolean)this.nonExistingFolderInOtherExistingProject.members()[0].getName().equals("foo"));
            LinkedResourceTest.assertTrue((String)"4.0", (this.nonExistingFolderInExistingProject.members().length == 1 ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)"5.0", (boolean)this.nonExistingFolderInExistingProject.members()[0].getName().equals(this.existingFolderInExistingFolder.getName()));
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            this.nonExistingFolderInExistingProject.createLink(childLoc, 256, this.getMonitor());
            this.nonExistingFolderInOtherExistingProject.createLink(parentLoc, 256, this.getMonitor());
            LinkedResourceTest.assertTrue((String)"2.0", (this.existingFolderInExistingFolder.members().length == 1 ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)"3.0", (boolean)this.existingFolderInExistingFolder.members()[0].getName().equals("foo"));
            LinkedResourceTest.assertTrue((boolean)this.nonExistingFolderInExistingProject.getLocation().equals((Object)childLoc));
            LinkedResourceTest.assertTrue((String)"2.0", (this.nonExistingFolderInExistingProject.members().length == 1 ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)"3.0", (boolean)this.nonExistingFolderInExistingProject.members()[0].getName().equals("foo"));
            LinkedResourceTest.assertTrue((String)"4.0", (this.nonExistingFolderInOtherExistingProject.members().length == 1 ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)"5.0", (boolean)this.nonExistingFolderInOtherExistingProject.members()[0].getName().equals(this.existingFolderInExistingFolder.getName()));
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
    }

    public void testsetLinkLocationPath() {
        IResource[] toTest = new IResource[]{this.closedProject, this.existingFileInExistingProject, this.existingFolderInExistingFolder, this.existingFolderInExistingProject, this.existingProject, this.nonExistingFileInExistingFolder, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingProject, this.otherExistingProject};
        int i = 0;
        while (i < toTest.length) {
            LinkedResourceTest.assertTrue((String)("1.0 " + toTest[i]), (!toTest[i].isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)("1.1 " + toTest[i]), (!toTest[i].isLinked(0) ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)("1.2 " + toTest[i]), (!toTest[i].isLinked(512) ? 1 : 0) != 0);
            ++i;
        }
        IFolder link = this.nonExistingFolderInExistingProject;
        try {
            link.createLink(this.localFolder, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IFile child = link.getFile(this.childName);
        LinkedResourceTest.assertTrue((String)"2.0", (boolean)child.exists());
        LinkedResourceTest.assertTrue((String)"2.1", (boolean)link.isLinked());
        LinkedResourceTest.assertTrue((String)"2.2", (boolean)link.isLinked(0));
        LinkedResourceTest.assertTrue((String)"2.3", (boolean)link.isLinked(512));
        LinkedResourceTest.assertTrue((String)"2.1", (!child.isLinked() ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.2", (!child.isLinked(0) ? 1 : 0) != 0);
        LinkedResourceTest.assertTrue((String)"2.3", (boolean)child.isLinked(512));
        try {
            link.createLink(this.existingFileInExistingProject.getLocation(), 256, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"2.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"3.1", (boolean)link.isLinked());
        LinkedResourceTest.assertTrue((String)"3.2", (boolean)link.isLinked(0));
        LinkedResourceTest.assertTrue((String)"3.3", (boolean)link.isLinked(512));
        LinkedResourceTest.assertTrue((String)"3.4", (boolean)link.getLocation().equals((Object)this.existingFileInExistingProject.getLocation()));
    }

    public void testLinkedFileInLinkedFolder() {
        IProject project = this.existingProject;
        IFolder top = project.getFolder("topFolder");
        IFolder linkedFolder = top.getFolder("linkedFolder");
        IFolder subFolder = linkedFolder.getFolder("subFolder");
        IFile linkedFile = subFolder.getFile("Link.txt");
        IFileStore folderStore = this.getTempStore();
        IFileStore subFolderStore = folderStore.getChild(subFolder.getName());
        IFileStore fileStore = this.getTempStore();
        IPath folderLocation = URIUtil.toPath((URI)folderStore.toURI());
        IPath fileLocation = URIUtil.toPath((URI)fileStore.toURI());
        try {
            subFolderStore.mkdir(0, this.getMonitor());
            fileStore.openOutputStream(0, this.getMonitor()).close();
            this.ensureExistsInWorkspace((IResource)top, true);
            linkedFolder.createLink(folderStore.toURI(), 0, this.getMonitor());
            linkedFile.createLink(fileStore.toURI(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"4.99", (Throwable)e);
        }
        catch (IOException e) {
            LinkedResourceTest.fail((String)"4.99", (Throwable)e);
        }
        LinkedResourceTest.assertEquals((String)"1.0", (Object)folderLocation, (Object)linkedFolder.getLocation());
        LinkedResourceTest.assertEquals((String)"1.1", (Object)folderLocation.append(subFolder.getName()), (Object)subFolder.getLocation());
        LinkedResourceTest.assertEquals((String)"1.2", (Object)fileLocation, (Object)linkedFile.getLocation());
        LinkedResourceTest.assertEquals((String)"1.0", (Object)folderStore.toURI(), (Object)linkedFolder.getLocationURI());
        LinkedResourceTest.assertEquals((String)"1.1", (Object)subFolderStore.toURI(), (Object)subFolder.getLocationURI());
        LinkedResourceTest.assertEquals((String)"1.2", (Object)fileStore.toURI(), (Object)linkedFile.getLocationURI());
    }

    public void testLinkFile() {
        IResource[] interestingResources = new IResource[]{this.existingFileInExistingProject, this.nonExistingFileInExistingProject, this.nonExistingFileInExistingFolder};
        IPath[] interestingLocations = new IPath[]{this.localFile, this.localFolder, this.nonExistingLocation};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{interestingResources, interestingLocations, monitors};
        new TestPerformer("LinkedResourceTest.testLinkFile"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    LinkedResourceTest.fail((String)("invocation " + count + " failed to cleanup"), (Throwable)e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                try {
                    file.createLink(location, 0, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IResource resource = (IResource)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                if (resource.exists()) {
                    return true;
                }
                IPath resolvedLocation = LinkedResourceTest.this.resolve(location);
                if (!resolvedLocation.toFile().exists()) {
                    return true;
                }
                if (LinkedResourceTest.getWorkspace().getRoot().findMember(resource.getFullPath()) != null) {
                    return true;
                }
                if (!resource.getParent().isAccessible()) {
                    return true;
                }
                if (!LinkedResourceTest.getWorkspace().validateName(resource.getName(), 2).isOK()) {
                    return true;
                }
                return resolvedLocation.toFile().isDirectory();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile resource = (IFile)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                IPath resolvedLocation = LinkedResourceTest.this.resolve(location);
                if (!resource.exists() || !resolvedLocation.toFile().exists()) {
                    return false;
                }
                if (!resource.getLocation().equals((Object)resolvedLocation)) {
                    return false;
                }
                return resource.isSynchronized(2);
            }
        }.performTest(inputs);
    }

    public void testLinkFolder() {
        IResource[] interestingResources = new IResource[]{this.existingFolderInExistingProject, this.existingFolderInExistingFolder, this.nonExistingFolderInExistingProject, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFolderInExistingFolder};
        IPath[] interestingLocations = new IPath[]{this.localFile, this.localFolder, this.nonExistingLocation};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{interestingResources, interestingLocations, monitors};
        new TestPerformer("LinkedResourceTest.testLinkFolder"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    LinkedResourceTest.fail((String)("invocation " + count + " failed to cleanup"), (Throwable)e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFolder folder = (IFolder)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                try {
                    folder.createLink(location, 0, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IResource resource = (IResource)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                if (resource.exists()) {
                    return true;
                }
                if (!LinkedResourceTest.this.resolve(location).toFile().exists()) {
                    return true;
                }
                if (LinkedResourceTest.getWorkspace().getRoot().findMember(resource.getFullPath()) != null) {
                    return true;
                }
                if (!resource.getParent().isAccessible()) {
                    return true;
                }
                if (!LinkedResourceTest.getWorkspace().validateName(resource.getName(), 2).isOK()) {
                    return true;
                }
                return LinkedResourceTest.this.resolve(location).toFile().isFile();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFolder resource = (IFolder)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                IPath resolvedLocation = LinkedResourceTest.this.resolve(location);
                if (!resource.exists() || !resolvedLocation.toFile().exists()) {
                    return false;
                }
                if (!resource.getLocation().equals((Object)resolvedLocation)) {
                    return false;
                }
                return resource.getFile(LinkedResourceTest.this.childName).exists();
            }
        }.performTest(inputs);
    }

    public void testValidateEmptyLinkLocation() {
        IFolder folder = this.nonExistingFolderInExistingProject;
        Path newLocation = new Path("");
        URI newLocationURI = URIUtil.toURI((IPath)newLocation);
        try {
            IStatus linkedResourceStatus = LinkedResourceTest.getWorkspace().validateLinkLocation((IResource)folder, (IPath)newLocation);
            LinkedResourceTest.assertEquals((String)"1.0", (int)4, (int)linkedResourceStatus.getSeverity());
            linkedResourceStatus = LinkedResourceTest.getWorkspace().validateLinkLocationURI((IResource)folder, newLocationURI);
            LinkedResourceTest.assertEquals((String)"1.1", (int)4, (int)linkedResourceStatus.getSeverity());
        }
        catch (Exception e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testLocationWithColon() {
        if (LinkedResourceTest.isWindows()) {
            return;
        }
        IFolder folder = this.nonExistingFolderInExistingProject;
        try {
            Path location = new Path("c:/temp");
            folder.createLink((IPath)location, 16, this.getMonitor());
            LinkedResourceTest.assertEquals((String)"1.0", (Object)location, (Object)folder.getRawLocation());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testModificationStamp() {
        IPath location = this.getRandomLocation();
        IFile linkedFile = this.nonExistingFileInExistingProject;
        try {
            try {
                linkedFile.createLink(location, 16, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"1.99", (Throwable)e);
            }
            LinkedResourceTest.assertEquals((String)"1.0", (long)-1L, (long)linkedFile.getModificationStamp());
            try {
                this.resolve(location).toFile().createNewFile();
                linkedFile.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"2.91", (Throwable)e);
            }
            catch (IOException e) {
                LinkedResourceTest.fail((String)"2.92", (Throwable)e);
            }
            LinkedResourceTest.assertTrue((String)"2.0", (linkedFile.getModificationStamp() >= 0L ? 1 : 0) != 0);
            this.ensureDoesNotExistInFileSystem(this.resolve(location).toFile());
            try {
                linkedFile.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"3.99", (Throwable)e);
            }
            LinkedResourceTest.assertEquals((String)"4.0", (long)-1L, (long)linkedFile.getModificationStamp());
        }
        finally {
            Workspace.clear((File)this.resolve(location).toFile());
        }
    }

    public void testMoveFile() {
        IResource[] sources = new IResource[]{this.nonExistingFileInExistingProject, this.nonExistingFileInExistingFolder};
        IResource[] destinations = new IResource[]{this.existingProject, this.closedProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFileInExistingFolder};
        Boolean[] deepCopy = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{sources, destinations, deepCopy, monitors};
        new TestPerformer("LinkedResourceTest.testMoveFile"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    LinkedResourceTest.fail((String)("invocation " + count + " failed to cleanup"), (Throwable)e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                try {
                    source.createLink(LinkedResourceTest.this.localFile, 0, null);
                    source.move(destination.getFullPath(), isDeep ? 0 : 32, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                IContainer parent = destination.getParent();
                if (!isDeep && parent == null) {
                    return true;
                }
                if (!parent.isAccessible()) {
                    return true;
                }
                if (source.equals((Object)destination)) {
                    return true;
                }
                if (source.getType() != destination.getType()) {
                    return true;
                }
                return destination.exists();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                IPath sourceLocation = LinkedResourceTest.this.resolve(LinkedResourceTest.this.localFile);
                URI sourceLocationURI = URIUtil.toURI((IPath)sourceLocation);
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (!destination.exists()) {
                    return false;
                }
                if (isDeep) {
                    if (destination.isLinked()) {
                        return false;
                    }
                    if (LinkedResourceTest.this.resolve(LinkedResourceTest.this.localFile).equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!destination.getProject().getLocation().isPrefixOf(destination.getLocation())) {
                        return false;
                    }
                } else {
                    if (!destination.isLinked()) {
                        return false;
                    }
                    if (!sourceLocation.equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!sourceLocationURI.equals(destination.getLocationURI())) {
                        return false;
                    }
                }
                return true;
            }
        }.performTest(inputs);
    }

    public void testMoveFolder() {
        IResource[] sourceResources = new IResource[]{this.nonExistingFolderInExistingProject, this.nonExistingFolderInExistingFolder};
        IResource[] destinationResources = new IResource[]{this.existingProject, this.closedProject, this.nonExistingProject, this.existingFolderInExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingFolderInExistingFolder};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{sourceResources, destinationResources, monitors};
        new TestPerformer("LinkedResourceTest.testMoveFolder"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    LinkedResourceTest.fail((String)("invocation " + count + " failed to cleanup"), (Throwable)e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                try {
                    source.createLink(LinkedResourceTest.this.localFolder, 0, null);
                    source.move(destination.getFullPath(), 32, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                IContainer parent = destination.getParent();
                if (parent == null) {
                    return true;
                }
                if (source.equals((Object)destination)) {
                    return true;
                }
                if (source.getType() != destination.getType()) {
                    return true;
                }
                if (!parent.isAccessible()) {
                    return true;
                }
                return destination.exists();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IResource destination = (IResource)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (!destination.exists()) {
                    return false;
                }
                if (!destination.isLinked()) {
                    return false;
                }
                return LinkedResourceTest.this.resolve(LinkedResourceTest.this.localFolder).equals((Object)destination.getLocation());
            }
        }.performTest(inputs);
    }

    public void testMoveMissingFile() {
        IPath location = this.getRandomLocation();
        IFile linkedFile = this.nonExistingFileInExistingProject;
        try {
            linkedFile.createLink(location, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IFile dest = this.existingProject.getFile("FailedMoveDest");
        try {
            linkedFile.move(dest.getFullPath(), 0, this.getMonitor());
            LinkedResourceTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        LinkedResourceTest.assertTrue((String)"2.1", (!dest.exists() ? 1 : 0) != 0);
        try {
            linkedFile.move(dest.getFullPath(), 1, this.getMonitor());
            LinkedResourceTest.fail((String)"2.2");
        }
        catch (CoreException coreException) {}
        LinkedResourceTest.assertTrue((String)"2.3", (!dest.exists() ? 1 : 0) != 0);
    }

    public void testMoveMissingFolder() {
        IPath location = this.getRandomLocation();
        IFolder linkedFolder = this.nonExistingFolderInExistingProject;
        try {
            linkedFolder.createLink(location, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IFolder dest = this.existingProject.getFolder("FailedMoveDest");
        try {
            linkedFolder.move(dest.getFullPath(), 0, this.getMonitor());
            LinkedResourceTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        LinkedResourceTest.assertTrue((String)"2.1", (!dest.exists() ? 1 : 0) != 0);
        try {
            linkedFolder.move(dest.getFullPath(), 1, this.getMonitor());
            LinkedResourceTest.fail((String)"2.2");
        }
        catch (CoreException coreException) {}
        LinkedResourceTest.assertTrue((String)"2.3", (!dest.exists() ? 1 : 0) != 0);
    }

    public void testMoveProjectWithLinks() {
        IPath fileLocation = this.getRandomLocation();
        IFile file = this.nonExistingFileInExistingProject;
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile childFile = folder.getFile(this.childName);
        IResource[] oldResources = new IResource[]{file, folder, this.existingProject, childFile};
        try {
            try {
                this.createFileInFileSystem(this.resolve(fileLocation));
                folder.createLink(this.localFolder, 0, this.getMonitor());
                file.createLink(fileLocation, 0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"1.0", (Throwable)e);
            }
            IProject destination = LinkedResourceTest.getWorkspace().getRoot().getProject("MoveTargetProject");
            IFile newFile = destination.getFile(file.getProjectRelativePath());
            IFolder newFolder = destination.getFolder(folder.getProjectRelativePath());
            IFile newChildFile = newFolder.getFile(this.childName);
            IResource[] newResources = new IResource[]{destination, newFile, newFolder, newChildFile};
            this.assertDoesNotExistInWorkspace("2.0", (IResource)destination);
            try {
                this.existingProject.move(destination.getFullPath(), 32, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"2.1", (Throwable)e);
            }
            this.assertExistsInWorkspace("3.0", newResources);
            this.assertDoesNotExistInWorkspace("3.1", oldResources);
            LinkedResourceTest.assertTrue((String)"3.2", (boolean)newFile.isLinked());
            LinkedResourceTest.assertEquals((String)"3.3", (Object)this.resolve(fileLocation), (Object)newFile.getLocation());
            LinkedResourceTest.assertTrue((String)"3.4", (boolean)newFolder.isLinked());
            LinkedResourceTest.assertEquals((String)"3.5", (Object)this.resolve(this.localFolder), (Object)newFolder.getLocation());
            LinkedResourceTest.assertTrue((String)"3.6", (boolean)destination.isSynchronized(2));
            try {
                destination.move(this.existingProject.getFullPath(), 0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"5.0", (Throwable)e);
            }
            this.assertExistsInWorkspace("5.1", oldResources);
            this.assertDoesNotExistInWorkspace("5.2", newResources);
            LinkedResourceTest.assertTrue((String)"5.3", (!file.isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertTrue((String)"5.4", (!folder.isLinked() ? 1 : 0) != 0);
            LinkedResourceTest.assertEquals((String)"5.5", (Object)this.existingProject.getLocation().append(file.getProjectRelativePath()), (Object)file.getLocation());
            LinkedResourceTest.assertEquals((String)"5.6", (Object)this.existingProject.getLocation().append(folder.getProjectRelativePath()), (Object)folder.getLocation());
            LinkedResourceTest.assertTrue((String)"5.7", (boolean)this.existingProject.isSynchronized(2));
            LinkedResourceTest.assertTrue((String)"5.8", (boolean)destination.isSynchronized(2));
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testMoveProjectWithLinks2() {
        IPath fileLocation = this.getRandomLocation();
        IFile linkedFile = this.existingProject.getFile("(test)");
        try {
            try {
                this.createFileInFileSystem(this.resolve(fileLocation), this.getRandomContents());
                linkedFile.createLink(fileLocation, 0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"1.0", (Throwable)e);
            }
            IProject destination = LinkedResourceTest.getWorkspace().getRoot().getProject("CopyTargetProject");
            try {
                this.existingProject.move(destination.getFullPath(), 32, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"2.0", (Throwable)e);
            }
            IFile newFile = destination.getFile(linkedFile.getProjectRelativePath());
            LinkedResourceTest.assertTrue((String)"3.0", (boolean)newFile.isLinked());
            LinkedResourceTest.assertEquals((String)"3.1", (Object)this.resolve(fileLocation), (Object)newFile.getLocation());
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testMoveFolderWithLinks() {
        IFolder folderWithLinks = this.existingProject.getFolder(this.getUniqueString());
        try {
            folderWithLinks.create(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
        IPath fileLocation = this.getRandomLocation();
        try {
            this.createFileInFileSystem(this.resolve(fileLocation), this.getRandomContents());
            IFile linkedFile = folderWithLinks.getFile(this.getUniqueString());
            try {
                linkedFile.createLink(fileLocation, 0, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"2.0", (Throwable)e);
            }
            String string = this.readStringInFileSystem(this.existingProject.getFile(".project"));
            LinkedResourceTest.assertTrue((String)"3.0", (string.indexOf(linkedFile.getProjectRelativePath().toString()) != -1 ? 1 : 0) != 0);
            try {
                folderWithLinks.move(this.otherExistingProject.getFolder(this.getUniqueString()).getFullPath(), 48, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"4.0", (Throwable)e);
            }
            LinkedResourceTest.assertFalse((String)"5.0", (boolean)folderWithLinks.exists());
            LinkedResourceTest.assertFalse((String)"6.0", (boolean)linkedFile.exists());
            HashMap links = null;
            try {
                links = ((ProjectDescription)this.existingProject.getDescription()).getLinks();
            }
            catch (CoreException e) {
                LinkedResourceTest.fail((String)"7.0", (Throwable)e);
            }
            LinkedResourceTest.assertNull((String)"8.0", (Object)links);
            string = this.readStringInFileSystem(this.existingProject.getFile(".project"));
            LinkedResourceTest.assertEquals((String)"9.0", (int)-1, (int)string.indexOf(linkedFile.getProjectRelativePath().toString()));
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testNatureVeto() {
        IProjectDescription description;
        try {
            description = this.existingProject.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
            this.existingProject.setDescription(description, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            this.nonExistingFolderInExistingProject.createLink(this.localFolder, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            this.nonExistingFileInExistingProject.createLink(this.localFile, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"1.2");
        }
        catch (CoreException coreException) {}
        try {
            this.existingProject.delete(1, this.getMonitor());
            this.existingProject.create(this.getMonitor());
            this.existingProject.open(this.getMonitor());
            this.nonExistingFolderInExistingProject.createLink(this.localFolder, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            description = this.existingProject.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
            this.existingProject.setDescription(description, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
    }

    public void testNestedLink() {
        IFileStore store1 = this.getTempStore();
        IFileStore store2 = this.getTempStore();
        URI location1 = store1.toURI();
        URI location2 = store2.toURI();
        IFolder link = this.existingProject.getFolder("aA");
        IFolder linkChild = link.getFolder("b");
        try {
            store1.mkdir(0, this.getMonitor());
            store2.mkdir(0, this.getMonitor());
            link.createLink(location1, 0, this.getMonitor());
            linkChild.createLink(location2, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"1.0", (boolean)link.exists());
        LinkedResourceTest.assertTrue((String)"1.1", (boolean)link.isLinked());
        LinkedResourceTest.assertTrue((String)"1.2", (boolean)linkChild.exists());
        LinkedResourceTest.assertTrue((String)"1.3", (boolean)linkChild.isLinked());
        LinkedResourceTest.assertEquals((String)"1.4", (Object)location1, (Object)link.getLocationURI());
        LinkedResourceTest.assertEquals((String)"1.5", (Object)location2, (Object)linkChild.getLocationURI());
        try {
            this.existingProject.delete(8, this.getMonitor());
            this.existingProject.create(this.getMonitor());
            this.existingProject.open(0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"2.0", (boolean)link.exists());
        LinkedResourceTest.assertTrue((String)"2.1", (boolean)link.isLinked());
        LinkedResourceTest.assertTrue((String)"2.2", (boolean)linkChild.exists());
        LinkedResourceTest.assertTrue((String)"2.3", (boolean)linkChild.isLinked());
        LinkedResourceTest.assertEquals((String)"2.4", (Object)location1, (Object)link.getLocationURI());
        LinkedResourceTest.assertEquals((String)"2.5", (Object)location2, (Object)linkChild.getLocationURI());
    }

    public void testRefreshDeepLink() {
        IFolder link = this.nonExistingFolderInExistingFolder;
        IPath linkLocation = this.localFolder;
        IPath localChild = linkLocation.append("Child");
        IFile linkChild = link.getFile(localChild.lastSegment());
        this.createFileInFileSystem(this.resolve(localChild));
        try {
            link.createLink(linkLocation, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"1.0", (boolean)link.exists());
        LinkedResourceTest.assertTrue((String)"1.1", (boolean)linkChild.exists());
        try {
            IProject project = link.getProject();
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.99", (Throwable)e);
        }
        LinkedResourceTest.assertTrue((String)"2.0", (boolean)link.exists());
        LinkedResourceTest.assertTrue((String)"2.1", (boolean)linkChild.exists());
    }

    public void testLinkedFolderWithOverlappingLocation_Bug293935_() {
        IWorkspace workspace = LinkedResourceTest.getWorkspace();
        IPath projectLocation = this.existingProject.getLocation();
        IFolder folderByIPath = this.existingProject.getFolder("overlappingLinkedFolderByIPath");
        LinkedResourceTest.assertTrue((String)"1.1", (!workspace.validateLinkLocation((IResource)folderByIPath, projectLocation).isOK() ? 1 : 0) != 0);
        try {
            folderByIPath.createLink(projectLocation, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"1.2");
        }
        catch (CoreException coreException) {}
        URI projectLocationURI = this.existingProject.getLocationURI();
        IFolder folderByURI = this.existingProject.getFolder("overlappingLinkedFolderByURI");
        LinkedResourceTest.assertTrue((String)"2.1", (!workspace.validateLinkLocationURI((IResource)folderByURI, projectLocationURI).isOK() ? 1 : 0) != 0);
        try {
            folderByURI.createLink(projectLocationURI, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"2.2");
        }
        catch (CoreException coreException) {}
        IPath projectLocationWithoutDevice = projectLocation.setDevice(null);
        IFolder folderByUnixLikeIPath = this.existingProject.getFolder("overlappingLinkedFolderByUnixLikeIPath");
        LinkedResourceTest.assertTrue((String)"3.1", (!workspace.validateLinkLocation((IResource)folderByUnixLikeIPath, projectLocationWithoutDevice).isOK() ? 1 : 0) != 0);
        try {
            folderByUnixLikeIPath.createLink(projectLocationWithoutDevice, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"3.2");
        }
        catch (CoreException coreException) {}
        URI projectLocationURIWithoutDevice = URIUtil.toURI((String)projectLocationWithoutDevice.toString());
        IFolder folderByUnixLikeURI = this.existingProject.getFolder("overlappingLinkedFolderByUnixLikeURI");
        LinkedResourceTest.assertTrue((String)"4.1", (!workspace.validateLinkLocationURI((IResource)folderByUnixLikeURI, projectLocationURIWithoutDevice).isOK() ? 1 : 0) != 0);
        try {
            folderByUnixLikeURI.createLink(projectLocationURIWithoutDevice, 0, this.getMonitor());
            LinkedResourceTest.fail((String)"4.2");
        }
        catch (CoreException coreException) {}
    }

    public void testLinkedFolderWithSymlink_Bug338010() {
        if (!this.canCreateSymLinks()) {
            return;
        }
        IPath baseLocation = this.getRandomLocation();
        IPath resolvedBaseLocation = this.resolve(baseLocation);
        this.deleteOnTearDown(resolvedBaseLocation);
        IPath symlinkTarget = resolvedBaseLocation.append("dir1/target");
        symlinkTarget.toFile().mkdirs();
        this.createSymLink(resolvedBaseLocation.toFile(), "symlink", symlinkTarget.toOSString(), true);
        IPath linkChildLocation = baseLocation.append("symlink/dir2");
        IPath resolvedLinkChildLocation = this.resolve(linkChildLocation);
        File linkChild = resolvedLinkChildLocation.toFile();
        linkChild.mkdir();
        LinkedResourceTest.assertTrue((String)("Could not create link at location: " + linkChild), (boolean)linkChild.exists());
        IFolder folder = this.nonExistingFolderInExistingProject;
        try {
            folder.createLink(linkChildLocation, 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceTest.fail((String)"1.1", (Throwable)e);
        }
        LinkedResourceTest.assertEquals((String)"1.2", (Object)resolvedLinkChildLocation, (Object)folder.getLocation());
    }

    public void testDeleteLinkTarget_Bug507084() throws Exception {
        if (!this.canCreateSymLinks()) {
            return;
        }
        IPath baseLocation = this.getRandomLocation();
        IPath resolvedBaseLocation = this.resolve(baseLocation);
        this.deleteOnTearDown(resolvedBaseLocation);
        IPath symlinkTarget = resolvedBaseLocation.append("dir1/A");
        symlinkTarget.append("B/C").toFile().mkdirs();
        IPath linkParentDir = resolvedBaseLocation.append("dir2");
        linkParentDir.toFile().mkdirs();
        this.createSymLink(linkParentDir.toFile(), "symlink", symlinkTarget.toOSString(), true);
        IFolder folder = this.nonExistingFolderInExistingProject;
        IPath symLink = linkParentDir.append("symlink");
        folder.createLink(symLink, 0, this.getMonitor());
        LinkedResourceTest.assertTrue((String)"1.1", (boolean)folder.exists());
        LinkedResourceTest.assertTrue((String)"1.2", (boolean)folder.getFolder("B/C").exists());
        LinkedResourceTest.assertEquals((String)"1.3", (Object)symLink, (Object)folder.getLocation());
        symLink.toFile().delete();
        linkParentDir.toFile().delete();
        LinkedResourceTest.assertFalse((String)"2.1", (boolean)linkParentDir.toFile().exists());
        folder.getParent().refreshLocal(2, this.getMonitor());
        LinkedResourceTest.assertTrue((String)"3.1", (boolean)folder.exists());
        LinkedResourceTest.assertFalse((String)"3.2", (boolean)folder.getFolder("B").exists());
        LinkedResourceTest.assertFalse((String)"3.3", (boolean)folder.getFolder("B/C").exists());
    }
}

